/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CheckReturnValue;
import ai.h2o.com.google.protobuf.CodedOutputStream;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.LazyStringList;
import ai.h2o.com.google.protobuf.MapEntryLite;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.Schema;
import ai.h2o.com.google.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@CheckReturnValue
final class CodedOutputStreamWriter
implements Writer {
    private final CodedOutputStream output;

    public static CodedOutputStreamWriter forCodedOutput(CodedOutputStream output) {
        if (output.wrapper != null) {
            return output.wrapper;
        }
        return new CodedOutputStreamWriter(output);
    }

    private CodedOutputStreamWriter(CodedOutputStream output) {
        this.output = Internal.checkNotNull(output, "output");
        this.output.wrapper = this;
    }

    @Override
    public final Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.ASCENDING;
    }

    public final int getTotalBytesWritten() {
        return this.output.getTotalBytesWritten();
    }

    @Override
    public final void writeSFixed32(int fieldNumber, int value) throws IOException {
        this.output.writeSFixed32(fieldNumber, value);
    }

    @Override
    public final void writeInt64(int fieldNumber, long value) throws IOException {
        this.output.writeInt64(fieldNumber, value);
    }

    @Override
    public final void writeSFixed64(int fieldNumber, long value) throws IOException {
        this.output.writeSFixed64(fieldNumber, value);
    }

    @Override
    public final void writeFloat(int fieldNumber, float value) throws IOException {
        this.output.writeFloat(fieldNumber, value);
    }

    @Override
    public final void writeDouble(int fieldNumber, double value) throws IOException {
        this.output.writeDouble(fieldNumber, value);
    }

    @Override
    public final void writeEnum(int fieldNumber, int value) throws IOException {
        this.output.writeEnum(fieldNumber, value);
    }

    @Override
    public final void writeUInt64(int fieldNumber, long value) throws IOException {
        this.output.writeUInt64(fieldNumber, value);
    }

    @Override
    public final void writeInt32(int fieldNumber, int value) throws IOException {
        this.output.writeInt32(fieldNumber, value);
    }

    @Override
    public final void writeFixed64(int fieldNumber, long value) throws IOException {
        this.output.writeFixed64(fieldNumber, value);
    }

    @Override
    public final void writeFixed32(int fieldNumber, int value) throws IOException {
        this.output.writeFixed32(fieldNumber, value);
    }

    @Override
    public final void writeBool(int fieldNumber, boolean value) throws IOException {
        this.output.writeBool(fieldNumber, value);
    }

    @Override
    public final void writeString(int fieldNumber, String value) throws IOException {
        this.output.writeString(fieldNumber, value);
    }

    @Override
    public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
        this.output.writeBytes(fieldNumber, value);
    }

    @Override
    public final void writeUInt32(int fieldNumber, int value) throws IOException {
        this.output.writeUInt32(fieldNumber, value);
    }

    @Override
    public final void writeSInt32(int fieldNumber, int value) throws IOException {
        this.output.writeSInt32(fieldNumber, value);
    }

    @Override
    public final void writeSInt64(int fieldNumber, long value) throws IOException {
        this.output.writeSInt64(fieldNumber, value);
    }

    @Override
    public final void writeMessage(int fieldNumber, Object value) throws IOException {
        this.output.writeMessage(fieldNumber, (MessageLite)value);
    }

    @Override
    public final void writeMessage(int fieldNumber, Object value, Schema schema) throws IOException {
        this.output.writeMessage(fieldNumber, (MessageLite)value, schema);
    }

    @Override
    @Deprecated
    public final void writeGroup(int fieldNumber, Object value) throws IOException {
        this.output.writeGroup(fieldNumber, (MessageLite)value);
    }

    @Override
    public final void writeGroup(int fieldNumber, Object value, Schema schema) throws IOException {
        this.output.writeGroup(fieldNumber, (MessageLite)value, schema);
    }

    @Override
    @Deprecated
    public final void writeStartGroup(int fieldNumber) throws IOException {
        this.output.writeTag(fieldNumber, 3);
    }

    @Override
    @Deprecated
    public final void writeEndGroup(int fieldNumber) throws IOException {
        this.output.writeTag(fieldNumber, 4);
    }

    @Override
    public final void writeMessageSetItem(int fieldNumber, Object value) throws IOException {
        if (value instanceof ByteString) {
            this.output.writeRawMessageSetExtension(fieldNumber, (ByteString)value);
            return;
        }
        this.output.writeMessageSetExtension(fieldNumber, (MessageLite)value);
    }

    @Override
    public final void writeInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeInt32SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeInt32NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeInt32(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeFixed32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeFixed32SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeFixed32NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeFixed32(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeInt64SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeInt64NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeInt64(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeUInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeUInt64SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeUInt64NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeUInt64(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeFixed64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeFixed64SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeFixed64NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeFixed64(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeFloatList(int fieldNumber, List<Float> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeFloatSizeNoTag(value.get(n2).floatValue());
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeFloatNoTag(value.get(n2).floatValue());
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeFloat(fieldNumber, value.get(i2).floatValue());
        }
    }

    @Override
    public final void writeDoubleList(int fieldNumber, List<Double> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeDoubleSizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeDoubleNoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeDouble(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeEnumList(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeEnumSizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeEnumNoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeEnum(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeBoolList(int fieldNumber, List<Boolean> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeBoolSizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeBoolNoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeBool(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeStringList(int fieldNumber, List<String> value) throws IOException {
        if (value instanceof LazyStringList) {
            LazyStringList lazyStringList = (LazyStringList)value;
            for (int i2 = 0; i2 < value.size(); ++i2) {
                this.writeLazyString(fieldNumber, lazyStringList.getRaw(i2));
            }
            return;
        }
        for (int i3 = 0; i3 < value.size(); ++i3) {
            this.output.writeString(fieldNumber, value.get(i3));
        }
    }

    private void writeLazyString(int fieldNumber, Object value) throws IOException {
        if (value instanceof String) {
            this.output.writeString(fieldNumber, (String)value);
            return;
        }
        this.output.writeBytes(fieldNumber, (ByteString)value);
    }

    @Override
    public final void writeBytesList(int fieldNumber, List<ByteString> value) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeBytes(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeUInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeUInt32SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeUInt32NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeUInt32(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeSFixed32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeSFixed32SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeSFixed32NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeSFixed32(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeSFixed64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeSFixed64SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeSFixed64NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeSFixed64(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeSInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeSInt32SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeSInt32NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeSInt32(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeSInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int n2;
            this.output.writeTag(fieldNumber, 2);
            int n3 = 0;
            for (n2 = 0; n2 < value.size(); ++n2) {
                n3 += CodedOutputStream.computeSInt64SizeNoTag(value.get(n2));
            }
            this.output.writeUInt32NoTag(n3);
            for (n2 = 0; n2 < value.size(); ++n2) {
                this.output.writeSInt64NoTag(value.get(n2));
            }
            return;
        }
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeSInt64(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeMessageList(int fieldNumber, List<?> value) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.writeMessage(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeMessageList(int fieldNumber, List<?> value, Schema schema) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.writeMessage(fieldNumber, value.get(i2), schema);
        }
    }

    @Override
    @Deprecated
    public final void writeGroupList(int fieldNumber, List<?> value) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.writeGroup(fieldNumber, value.get(i2));
        }
    }

    @Override
    public final void writeGroupList(int fieldNumber, List<?> value, Schema schema) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.writeGroup(fieldNumber, value.get(i2), schema);
        }
    }

    @Override
    public final <K, V> void writeMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        if (this.output.isSerializationDeterministic()) {
            this.writeDeterministicMap(fieldNumber, metadata, map);
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue()));
            MapEntryLite.writeTo(this.output, metadata, entry.getKey(), entry.getValue());
        }
    }

    private <K, V> void writeDeterministicMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map) throws IOException {
        switch (metadata.keyType) {
            case BOOL: {
                V v2 = map.get(Boolean.FALSE);
                if (v2 != null) {
                    this.writeDeterministicBooleanMapEntry(fieldNumber, false, v2, metadata);
                }
                if ((v2 = map.get(Boolean.TRUE)) == null) break;
                this.writeDeterministicBooleanMapEntry(fieldNumber, true, v2, metadata);
                return;
            }
            case FIXED32: 
            case INT32: 
            case SFIXED32: 
            case SINT32: 
            case UINT32: {
                this.writeDeterministicIntegerMap(fieldNumber, metadata, map);
                return;
            }
            case FIXED64: 
            case INT64: 
            case SFIXED64: 
            case SINT64: 
            case UINT64: {
                this.writeDeterministicLongMap(fieldNumber, metadata, map);
                return;
            }
            case STRING: {
                this.writeDeterministicStringMap(fieldNumber, metadata, map);
                return;
            }
            default: {
                throw new IllegalArgumentException("does not support key type: " + (Object)((Object)metadata.keyType));
            }
        }
    }

    private <V> void writeDeterministicBooleanMapEntry(int fieldNumber, boolean key, V value, MapEntryLite.Metadata<Boolean, V> metadata) throws IOException {
        this.output.writeTag(fieldNumber, 2);
        this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, key, value));
        MapEntryLite.writeTo(this.output, metadata, key, value);
    }

    private <V> void writeDeterministicIntegerMap(int fieldNumber, MapEntryLite.Metadata<Integer, V> metadata, Map<Integer, V> map) throws IOException {
        int n2;
        int[] nArray = new int[map.size()];
        int n3 = 0;
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            n2 = object.next();
            nArray[n3++] = n2;
        }
        Arrays.sort(nArray);
        object = nArray;
        n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = object[i2];
            V v2 = map.get((int)object2);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (int)object2, v2));
            MapEntryLite.writeTo(this.output, metadata, (int)object2, v2);
        }
    }

    private <V> void writeDeterministicLongMap(int fieldNumber, MapEntryLite.Metadata<Long, V> metadata, Map<Long, V> map) throws IOException {
        long[] lArray = new long[map.size()];
        int n2 = 0;
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            long l2 = object.next();
            lArray[n2++] = l2;
        }
        Arrays.sort(lArray);
        object = lArray;
        int n3 = lArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object2 = object[i2];
            V v2 = map.get((long)object2);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (long)object2, v2));
            MapEntryLite.writeTo(this.output, metadata, (long)object2, v2);
        }
    }

    private <V> void writeDeterministicStringMap(int fieldNumber, MapEntryLite.Metadata<String, V> metadata, Map<String, V> map) throws IOException {
        Object[] objectArray = new String[map.size()];
        int n2 = 0;
        for (String string : map.keySet()) {
            objectArray[n2++] = string;
        }
        Arrays.sort(objectArray);
        Object[] objectArray2 = objectArray;
        int n3 = objectArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectArray2[i2];
            V v2 = map.get(object);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, object, v2));
            MapEntryLite.writeTo(this.output, metadata, object, v2);
        }
    }
}

