/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.CodedOutputStream;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.LazyField;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.MessageLiteOrBuilder;
import ai.h2o.com.google.protobuf.SmallSortedMap;
import ai.h2o.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class FieldSet<T extends FieldDescriptorLite<T>> {
    private static final int DEFAULT_FIELD_MAP_ARRAY_SIZE = 16;
    private final SmallSortedMap<T, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean dummy) {
        this(SmallSortedMap.newFieldMap(0));
        this.makeImmutable();
    }

    private FieldSet(SmallSortedMap<T, Object> fields) {
        this.fields = fields;
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet<T>();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public static <T extends FieldDescriptorLite<T>> Builder<T> newBuilder() {
        return new Builder();
    }

    final boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public final void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public final boolean isImmutable() {
        return this.isImmutable;
    }

    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof FieldSet)) {
            return false;
        }
        FieldSet fieldSet = (FieldSet)o2;
        return this.fields.equals(fieldSet.fields);
    }

    public final int hashCode() {
        return this.fields.hashCode();
    }

    public final FieldSet<T> clone() {
        FieldSet<FieldDescriptorLite> fieldSet = FieldSet.newFieldSet();
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            fieldSet.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            fieldSet.setField((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        fieldSet.hasLazyField = this.hasLazyField;
        return fieldSet;
    }

    public final void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    public final Map<T, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap<T, Object> smallSortedMap = FieldSet.cloneAllFieldsMap(this.fields, false);
            if (this.fields.isImmutable()) {
                smallSortedMap.makeImmutable();
            }
            return smallSortedMap;
        }
        if (this.fields.isImmutable()) {
            return this.fields;
        }
        return Collections.unmodifiableMap(this.fields);
    }

    private static <T extends FieldDescriptorLite<T>> SmallSortedMap<T, Object> cloneAllFieldsMap(SmallSortedMap<T, Object> fields, boolean copyList) {
        SmallSortedMap smallSortedMap = SmallSortedMap.newFieldMap(16);
        for (int i2 = 0; i2 < fields.getNumArrayEntries(); ++i2) {
            FieldSet.cloneFieldEntry(smallSortedMap, fields.getArrayEntryAt(i2), copyList);
        }
        for (Map.Entry<T, Object> entry : fields.getOverflowEntries()) {
            FieldSet.cloneFieldEntry(smallSortedMap, entry, copyList);
        }
        return smallSortedMap;
    }

    private static <T extends FieldDescriptorLite<T>> void cloneFieldEntry(Map<T, Object> map, Map.Entry<T, Object> entry, boolean copyList) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            map.put(fieldDescriptorLite, ((LazyField)object).getValue());
            return;
        }
        if (copyList && object instanceof List) {
            map.put(fieldDescriptorLite, new ArrayList((List)object));
            return;
        }
        map.put(fieldDescriptorLite, object);
    }

    public final Iterator<Map.Entry<T, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    final Iterator<Map.Entry<T, Object>> descendingIterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.descendingEntrySet().iterator());
        }
        return this.fields.descendingEntrySet().iterator();
    }

    public final boolean hasField(T descriptor) {
        if (descriptor.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(descriptor) != null;
    }

    public final Object getField(T descriptor) {
        Object object = this.fields.get(descriptor);
        if (object instanceof LazyField) {
            return ((LazyField)object).getValue();
        }
        return object;
    }

    public final void setField(T descriptor, Object value) {
        if (descriptor.isRepeated()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(value);
            for (Object e2 : arrayList) {
                this.verifyType(descriptor, e2);
            }
            value = arrayList;
        } else {
            this.verifyType(descriptor, value);
        }
        if (value instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(descriptor, (Object)value);
    }

    public final void clearField(T descriptor) {
        this.fields.remove(descriptor);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    public final int getRepeatedFieldCount(T descriptor) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(descriptor);
        if (object == null) {
            return 0;
        }
        return ((List)object).size();
    }

    public final Object getRepeatedField(T descriptor, int index) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(descriptor);
        if (object == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)object).get(index);
    }

    public final void setRepeatedField(T descriptor, int index, Object value) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object object = this.getField(descriptor);
        if (object == null) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyType(descriptor, value);
        ((List)object).set(index, value);
    }

    public final void addRepeatedField(T descriptor, Object value) {
        ArrayList<Object> arrayList;
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        this.verifyType(descriptor, value);
        Object object = this.getField(descriptor);
        if (object == null) {
            arrayList = new ArrayList<Object>();
            this.fields.put(descriptor, (Object)arrayList);
        } else {
            arrayList = (ArrayList<Object>)object;
        }
        arrayList.add(value);
    }

    private void verifyType(T descriptor, Object value) {
        if (!FieldSet.isValidType(descriptor.getLiteType(), value)) {
            throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), descriptor.getLiteType().getJavaType(), value.getClass().getName()}));
        }
    }

    private static boolean isValidType(WireFormat.FieldType type, Object value) {
        Internal.checkNotNull(value);
        switch (type.getJavaType()) {
            case INT: {
                return value instanceof Integer;
            }
            case LONG: {
                return value instanceof Long;
            }
            case FLOAT: {
                return value instanceof Float;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case STRING: {
                return value instanceof String;
            }
            case BYTE_STRING: {
                return value instanceof ByteString || value instanceof byte[];
            }
            case ENUM: {
                return value instanceof Integer || value instanceof Internal.EnumLite;
            }
            case MESSAGE: {
                return value instanceof MessageLite || value instanceof LazyField;
            }
        }
        return false;
    }

    public final boolean isInitialized() {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i2))) continue;
            return false;
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            if (FieldSet.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private static <T extends FieldDescriptorLite<T>> boolean isInitialized(Map.Entry<T, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (fieldDescriptorLite.isRepeated()) {
                for (Object e2 : (List)entry.getValue()) {
                    if (FieldSet.isMessageFieldValueInitialized(e2)) continue;
                    return false;
                }
            } else {
                return FieldSet.isMessageFieldValueInitialized(entry.getValue());
            }
        }
        return true;
    }

    private static boolean isMessageFieldValueInitialized(Object value) {
        if (value instanceof MessageLiteOrBuilder) {
            return ((MessageLiteOrBuilder)value).isInitialized();
        }
        if (value instanceof LazyField) {
            return true;
        }
        throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type, boolean isPacked) {
        if (isPacked) {
            return 2;
        }
        return type.getWireType();
    }

    public final void mergeFrom(FieldSet<T> other) {
        for (int i2 = 0; i2 < other.fields.getNumArrayEntries(); ++i2) {
            this.mergeFromField(other.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<T, Object> entry : other.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private static Object cloneIfMutable(Object value) {
        if (value instanceof byte[]) {
            byte[] byArray = (byte[])value;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void mergeFromField(Map.Entry<T, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (object instanceof LazyField) {
            object = ((LazyField)object).getValue();
        }
        if (fieldDescriptorLite.isRepeated()) {
            ArrayList arrayList = this.getField(fieldDescriptorLite);
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            Iterator iterator = ((List)object).iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.fields.put((T)fieldDescriptorLite, (Object)arrayList);
                    return;
                }
                Object e2 = iterator.next();
                ((List)arrayList).add(FieldSet.cloneIfMutable(e2));
            }
        }
        if (fieldDescriptorLite.getLiteJavaType() != WireFormat.JavaType.MESSAGE) {
            this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
            return;
        }
        Object object2 = this.getField(fieldDescriptorLite);
        if (object2 == null) {
            this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
            return;
        }
        object2 = fieldDescriptorLite.internalMergeFrom(((MessageLite)object2).toBuilder(), (MessageLite)object).build();
        this.fields.put((T)fieldDescriptorLite, object2);
    }

    public static Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type, boolean checkUtf8) throws IOException {
        if (checkUtf8) {
            return WireFormat.readPrimitiveField(input, type, WireFormat.Utf8Validation.STRICT);
        }
        return WireFormat.readPrimitiveField(input, type, WireFormat.Utf8Validation.LOOSE);
    }

    public final void writeTo(CodedOutputStream output) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output);
        }
    }

    public final void writeMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            FieldSet fieldSet = this;
            fieldSet.writeMessageSetTo(fieldSet.fields.getArrayEntryAt(i2), output);
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, output);
        }
    }

    private void writeMessageSetTo(Map.Entry<T, Object> entry, CodedOutputStream output) throws IOException {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            Object object = entry.getValue();
            if (object instanceof LazyField) {
                object = ((LazyField)object).getValue();
            }
            output.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
            return;
        }
        FieldSet.writeField(fieldDescriptorLite, entry.getValue(), output);
    }

    static void writeElement(CodedOutputStream output, WireFormat.FieldType type, int number, Object value) throws IOException {
        if (type == WireFormat.FieldType.GROUP) {
            output.writeGroup(number, (MessageLite)value);
            return;
        }
        output.writeTag(number, FieldSet.getWireFormatForFieldType(type, false));
        FieldSet.writeElementNoTag(output, type, value);
    }

    static void writeElementNoTag(CodedOutputStream output, WireFormat.FieldType type, Object value) throws IOException {
        switch (type) {
            case DOUBLE: {
                output.writeDoubleNoTag((Double)value);
                return;
            }
            case FLOAT: {
                output.writeFloatNoTag(((Float)value).floatValue());
                return;
            }
            case INT64: {
                output.writeInt64NoTag((Long)value);
                return;
            }
            case UINT64: {
                output.writeUInt64NoTag((Long)value);
                return;
            }
            case INT32: {
                output.writeInt32NoTag((Integer)value);
                return;
            }
            case FIXED64: {
                output.writeFixed64NoTag((Long)value);
                return;
            }
            case FIXED32: {
                output.writeFixed32NoTag((Integer)value);
                return;
            }
            case BOOL: {
                output.writeBoolNoTag((Boolean)value);
                return;
            }
            case GROUP: {
                output.writeGroupNoTag((MessageLite)value);
                return;
            }
            case MESSAGE: {
                output.writeMessageNoTag((MessageLite)value);
                return;
            }
            case STRING: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    return;
                }
                output.writeStringNoTag((String)value);
                return;
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    return;
                }
                output.writeByteArrayNoTag((byte[])value);
                return;
            }
            case UINT32: {
                output.writeUInt32NoTag((Integer)value);
                return;
            }
            case SFIXED32: {
                output.writeSFixed32NoTag((Integer)value);
                return;
            }
            case SFIXED64: {
                output.writeSFixed64NoTag((Long)value);
                return;
            }
            case SINT32: {
                output.writeSInt32NoTag((Integer)value);
                return;
            }
            case SINT64: {
                output.writeSInt64NoTag((Long)value);
                return;
            }
            case ENUM: {
                if (value instanceof Internal.EnumLite) {
                    output.writeEnumNoTag(((Internal.EnumLite)value).getNumber());
                    return;
                }
                output.writeEnumNoTag((Integer)value);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeField(FieldDescriptorLite<?> descriptor, Object value, CodedOutputStream output) throws IOException {
        WireFormat.FieldType fieldType = descriptor.getLiteType();
        int n2 = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            List list = (List)value;
            if (descriptor.isPacked()) {
                output.writeTag(n2, 2);
                int n3 = 0;
                for (Object e2 : list) {
                    n3 += FieldSet.computeElementSizeNoTag(fieldType, e2);
                }
                output.writeUInt32NoTag(n3);
                for (Object e2 : list) {
                    FieldSet.writeElementNoTag(output, fieldType, e2);
                }
                return;
            } else {
                Iterator iterator = list.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    Object e3 = iterator.next();
                    FieldSet.writeElement(output, fieldType, n2, e3);
                }
            }
        }
        if (value instanceof LazyField) {
            FieldSet.writeElement(output, fieldType, n2, ((LazyField)value).getValue());
            return;
        }
        FieldSet.writeElement(output, fieldType, n2, value);
    }

    public final int getSerializedSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<T, Object> entry = this.fields.getArrayEntryAt(i2);
            n2 += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            n2 += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return n2;
    }

    public final int getMessageSetSerializedSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            FieldSet fieldSet = this;
            n2 += fieldSet.getMessageSetSerializedSize(fieldSet.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
            n2 += this.getMessageSetSerializedSize(entry);
        }
        return n2;
    }

    private int getMessageSetSerializedSize(Map.Entry<T, Object> entry) {
        FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
        Object object = entry.getValue();
        if (fieldDescriptorLite.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !fieldDescriptorLite.isRepeated() && !fieldDescriptorLite.isPacked()) {
            if (object instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)object);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)object);
        }
        return FieldSet.computeFieldSize(fieldDescriptorLite, object);
    }

    static int computeElementSize(WireFormat.FieldType type, int number, Object value) {
        int n2 = CodedOutputStream.computeTagSize(number);
        if (type == WireFormat.FieldType.GROUP) {
            n2 <<= 1;
        }
        return n2 + FieldSet.computeElementSizeNoTag(type, value);
    }

    static int computeElementSizeNoTag(WireFormat.FieldType type, Object value) {
        switch (type) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)value);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)value).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)value);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)value);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)value);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value);
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value);
            }
            case STRING: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeStringSizeNoTag((String)value);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)value);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)value);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value);
            }
            case MESSAGE: {
                if (value instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value);
            }
            case ENUM: {
                if (value instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)value);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> descriptor, Object value) {
        WireFormat.FieldType fieldType = descriptor.getLiteType();
        int n2 = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            if (descriptor.isPacked()) {
                int n3 = 0;
                for (Object e2 : (List)value) {
                    n3 += FieldSet.computeElementSizeNoTag(fieldType, e2);
                }
                return n3 + CodedOutputStream.computeTagSize(n2) + CodedOutputStream.computeUInt32SizeNoTag(n3);
            }
            int n4 = 0;
            for (Object e3 : (List)value) {
                n4 += FieldSet.computeElementSize(fieldType, n2, e3);
            }
            return n4;
        }
        return FieldSet.computeElementSize(fieldType, n2, value);
    }

    static final class Builder<T extends FieldDescriptorLite<T>> {
        private SmallSortedMap<T, Object> fields;
        private boolean hasLazyField;
        private boolean isMutable;
        private boolean hasNestedBuilders;

        private Builder() {
            this(SmallSortedMap.newFieldMap(16));
        }

        private Builder(SmallSortedMap<T, Object> fields) {
            this.fields = fields;
            this.isMutable = true;
        }

        public final FieldSet<T> build() {
            if (this.fields.isEmpty()) {
                return FieldSet.emptySet();
            }
            this.isMutable = false;
            SmallSortedMap smallSortedMap = this.fields;
            if (this.hasNestedBuilders) {
                smallSortedMap = FieldSet.cloneAllFieldsMap(this.fields, false);
                Builder.replaceBuilders(smallSortedMap);
            }
            FieldSet fieldSet = new FieldSet(smallSortedMap);
            fieldSet.hasLazyField = this.hasLazyField;
            return fieldSet;
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(SmallSortedMap<T, Object> fieldMap) {
            for (int i2 = 0; i2 < fieldMap.getNumArrayEntries(); ++i2) {
                Builder.replaceBuilders(fieldMap.getArrayEntryAt(i2));
            }
            for (Map.Entry<T, Object> entry : fieldMap.getOverflowEntries()) {
                Builder.replaceBuilders(entry);
            }
        }

        private static <T extends FieldDescriptorLite<T>> void replaceBuilders(Map.Entry<T, Object> entry) {
            Map.Entry<T, Object> entry2 = entry;
            entry2.setValue(Builder.replaceBuilders((FieldDescriptorLite)entry2.getKey(), entry.getValue()));
        }

        private static <T extends FieldDescriptorLite<T>> Object replaceBuilders(T descriptor, Object value) {
            if (value == null) {
                return value;
            }
            if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
                if (descriptor.isRepeated()) {
                    if (!(value instanceof List)) {
                        throw new IllegalStateException("Repeated field should contains a List but actually contains type: " + value.getClass());
                    }
                    ArrayList<Object> arrayList = (ArrayList<Object>)value;
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        Object e2 = arrayList.get(i2);
                        Object object = Builder.replaceBuilder(e2);
                        if (object == e2) continue;
                        if (arrayList == value) {
                            arrayList = new ArrayList<Object>(arrayList);
                        }
                        arrayList.set(i2, object);
                    }
                    return arrayList;
                }
                return Builder.replaceBuilder(value);
            }
            return value;
        }

        private static Object replaceBuilder(Object value) {
            if (value instanceof MessageLite.Builder) {
                return ((MessageLite.Builder)value).build();
            }
            return value;
        }

        public static <T extends FieldDescriptorLite<T>> Builder<T> fromFieldSet(FieldSet<T> fieldSet) {
            Builder<T> builder = new Builder<T>(FieldSet.cloneAllFieldsMap(((FieldSet)fieldSet).fields, true));
            new Builder<T>(FieldSet.cloneAllFieldsMap(((FieldSet)fieldSet).fields, true)).hasLazyField = ((FieldSet)fieldSet).hasLazyField;
            return builder;
        }

        public final Map<T, Object> getAllFields() {
            if (this.hasLazyField) {
                SmallSortedMap smallSortedMap = FieldSet.cloneAllFieldsMap(this.fields, false);
                if (this.fields.isImmutable()) {
                    smallSortedMap.makeImmutable();
                } else {
                    Builder.replaceBuilders(smallSortedMap);
                }
                return smallSortedMap;
            }
            if (this.fields.isImmutable()) {
                return this.fields;
            }
            return Collections.unmodifiableMap(this.fields);
        }

        public final boolean hasField(T descriptor) {
            if (descriptor.isRepeated()) {
                throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
            }
            return this.fields.get(descriptor) != null;
        }

        public final Object getField(T descriptor) {
            Object object = this.getFieldAllowBuilders(descriptor);
            return Builder.replaceBuilders(descriptor, object);
        }

        final Object getFieldAllowBuilders(T descriptor) {
            Object object = this.fields.get(descriptor);
            if (object instanceof LazyField) {
                return ((LazyField)object).getValue();
            }
            return object;
        }

        private void ensureIsMutable() {
            if (!this.isMutable) {
                this.fields = FieldSet.cloneAllFieldsMap(this.fields, true);
                this.isMutable = true;
            }
        }

        public final void setField(T descriptor, Object value) {
            this.ensureIsMutable();
            if (descriptor.isRepeated()) {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
                ArrayList arrayList = new ArrayList(value);
                for (Object e2 : arrayList) {
                    this.verifyType(descriptor, e2);
                    this.hasNestedBuilders = this.hasNestedBuilders || e2 instanceof MessageLite.Builder;
                }
                value = arrayList;
            } else {
                this.verifyType(descriptor, value);
            }
            if (value instanceof LazyField) {
                this.hasLazyField = true;
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value instanceof MessageLite.Builder;
            this.fields.put(descriptor, (Object)value);
        }

        public final void clearField(T descriptor) {
            this.ensureIsMutable();
            this.fields.remove(descriptor);
            if (this.fields.isEmpty()) {
                this.hasLazyField = false;
            }
        }

        public final int getRepeatedFieldCount(T descriptor) {
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedFieldCount() can only be called on repeated fields.");
            }
            Object object = this.getFieldAllowBuilders(descriptor);
            if (object == null) {
                return 0;
            }
            return ((List)object).size();
        }

        public final Object getRepeatedField(T descriptor, int index) {
            if (this.hasNestedBuilders) {
                this.ensureIsMutable();
            }
            Object object = this.getRepeatedFieldAllowBuilders(descriptor, index);
            return Builder.replaceBuilder(object);
        }

        final Object getRepeatedFieldAllowBuilders(T descriptor, int index) {
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            Object object = this.getFieldAllowBuilders(descriptor);
            if (object == null) {
                throw new IndexOutOfBoundsException();
            }
            return ((List)object).get(index);
        }

        public final void setRepeatedField(T descriptor, int index, Object value) {
            this.ensureIsMutable();
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value instanceof MessageLite.Builder;
            Object object = this.getFieldAllowBuilders(descriptor);
            if (object == null) {
                throw new IndexOutOfBoundsException();
            }
            this.verifyType(descriptor, value);
            ((List)object).set(index, value);
        }

        public final void addRepeatedField(T descriptor, Object value) {
            ArrayList<Object> arrayList;
            this.ensureIsMutable();
            if (!descriptor.isRepeated()) {
                throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
            }
            this.hasNestedBuilders = this.hasNestedBuilders || value instanceof MessageLite.Builder;
            this.verifyType(descriptor, value);
            Object object = this.getFieldAllowBuilders(descriptor);
            if (object == null) {
                arrayList = new ArrayList<Object>();
                this.fields.put(descriptor, (Object)arrayList);
            } else {
                arrayList = (ArrayList<Object>)object;
            }
            arrayList.add(value);
        }

        private void verifyType(T descriptor, Object value) {
            if (!FieldSet.isValidType(descriptor.getLiteType(), value)) {
                if (descriptor.getLiteType().getJavaType() == WireFormat.JavaType.MESSAGE && value instanceof MessageLite.Builder) {
                    return;
                }
                throw new IllegalArgumentException(String.format("Wrong object type used with protocol message reflection.\nField number: %d, field java type: %s, value type: %s\n", new Object[]{descriptor.getNumber(), descriptor.getLiteType().getJavaType(), value.getClass().getName()}));
            }
        }

        public final boolean isInitialized() {
            for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
                if (FieldSet.isInitialized(this.fields.getArrayEntryAt(i2))) continue;
                return false;
            }
            for (Map.Entry<T, Object> entry : this.fields.getOverflowEntries()) {
                if (FieldSet.isInitialized(entry)) continue;
                return false;
            }
            return true;
        }

        public final void mergeFrom(FieldSet<T> other) {
            this.ensureIsMutable();
            for (int i2 = 0; i2 < ((FieldSet)other).fields.getNumArrayEntries(); ++i2) {
                this.mergeFromField(((FieldSet)other).fields.getArrayEntryAt(i2));
            }
            for (Map.Entry entry : ((FieldSet)other).fields.getOverflowEntries()) {
                this.mergeFromField(entry);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void mergeFromField(Map.Entry<T, Object> entry) {
            FieldDescriptorLite fieldDescriptorLite = (FieldDescriptorLite)entry.getKey();
            Object object = entry.getValue();
            if (object instanceof LazyField) {
                object = ((LazyField)object).getValue();
            }
            if (fieldDescriptorLite.isRepeated()) {
                ArrayList<Object> arrayList = (ArrayList<Object>)this.getFieldAllowBuilders(fieldDescriptorLite);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    this.fields.put((T)fieldDescriptorLite, (Object)arrayList);
                }
                Iterator iterator = ((List)object).iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    arrayList.add(FieldSet.cloneIfMutable(e2));
                }
                return;
            }
            if (fieldDescriptorLite.getLiteJavaType() != WireFormat.JavaType.MESSAGE) {
                this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
                return;
            }
            Object object2 = this.getFieldAllowBuilders(fieldDescriptorLite);
            if (object2 == null) {
                this.fields.put((T)fieldDescriptorLite, FieldSet.cloneIfMutable(object));
                return;
            }
            if (object2 instanceof MessageLite.Builder) {
                fieldDescriptorLite.internalMergeFrom((MessageLite.Builder)object2, (MessageLite)object);
                return;
            }
            object2 = fieldDescriptorLite.internalMergeFrom(((MessageLite)object2).toBuilder(), (MessageLite)object).build();
            this.fields.put((T)fieldDescriptorLite, object2);
        }
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

