/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.GeneratedMessageLite;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.TextFormatEscaper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

final class MessageLiteToString {
    private static final String LIST_SUFFIX = "List";
    private static final String BUILDER_LIST_SUFFIX = "OrBuilderList";
    private static final String MAP_SUFFIX = "Map";
    private static final String BYTES_SUFFIX = "Bytes";

    private MessageLiteToString() {
    }

    static String toString(MessageLite messageLite, String commentString) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# ").append(commentString);
        MessageLiteToString.reflectivePrintWithIndent(messageLite, stringBuilder, 0);
        return stringBuilder.toString();
    }

    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder buffer, int indent) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        HashMap<String, Method> hashMap2 = new HashMap<String, Method>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Method object2 : messageLite.getClass().getDeclaredMethods()) {
            hashMap2.put(object2.getName(), object2);
            if (object2.getParameterTypes().length != 0) continue;
            hashMap.put(object2.getName(), object2);
            if (!object2.getName().startsWith("get")) continue;
            treeSet.add(object2.getName());
        }
        for (String string : treeSet) {
            boolean bl;
            Method method;
            Object object;
            String string2 = string.startsWith("get") ? string.substring(3) : string;
            if (string2.endsWith(LIST_SUFFIX) && !string2.endsWith(BUILDER_LIST_SUFFIX) && !string2.equals(LIST_SUFFIX)) {
                String string3 = string2.substring(0, 1).toLowerCase() + string2.substring(1, string2.length() - 4);
                object = (Method)hashMap.get(string);
                if (object != null && ((Method)object).getReturnType().equals(List.class)) {
                    MessageLiteToString.printField(buffer, indent, MessageLiteToString.camelCaseToSnakeCase(string3), GeneratedMessageLite.invokeOrDie((Method)object, messageLite, new Object[0]));
                    continue;
                }
            }
            if (string2.endsWith(MAP_SUFFIX) && !string2.equals(MAP_SUFFIX)) {
                String string4 = string2.substring(0, 1).toLowerCase() + string2.substring(1, string2.length() - 3);
                object = (Method)hashMap.get(string);
                if (object != null && ((Method)object).getReturnType().equals(Map.class) && !((AccessibleObject)object).isAnnotationPresent(Deprecated.class) && Modifier.isPublic(((Method)object).getModifiers())) {
                    MessageLiteToString.printField(buffer, indent, MessageLiteToString.camelCaseToSnakeCase(string4), GeneratedMessageLite.invokeOrDie((Method)object, messageLite, new Object[0]));
                    continue;
                }
            }
            if ((method = (Method)hashMap2.get("set" + string2)) == null || string2.endsWith(BYTES_SUFFIX) && hashMap.containsKey("get" + string2.substring(0, string2.length() - 5))) continue;
            object = string2.substring(0, 1).toLowerCase() + string2.substring(1);
            Method method2 = (Method)hashMap.get("get" + string2);
            Method method3 = (Method)hashMap.get("has" + string2);
            if (method2 == null) continue;
            Object object2 = GeneratedMessageLite.invokeOrDie(method2, messageLite, new Object[0]);
            boolean bl2 = method3 == null ? !MessageLiteToString.isDefaultValue(object2) : (bl = ((Boolean)GeneratedMessageLite.invokeOrDie(method3, messageLite, new Object[0])).booleanValue());
            if (!bl2) continue;
            MessageLiteToString.printField(buffer, indent, MessageLiteToString.camelCaseToSnakeCase((String)object), object2);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage) {
            Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iterator = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                MessageLiteToString.printField(buffer, indent, "[" + ((GeneratedMessageLite.ExtensionDescriptor)entry.getKey()).getNumber() + "]", entry.getValue());
            }
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            ((GeneratedMessageLite)messageLite).unknownFields.printWithIndent(buffer, indent);
        }
    }

    private static boolean isDefaultValue(Object o2) {
        if (o2 instanceof Boolean) {
            return (Boolean)o2 == false;
        }
        if (o2 instanceof Integer) {
            return (Integer)o2 == 0;
        }
        if (o2 instanceof Float) {
            return Float.floatToRawIntBits(((Float)o2).floatValue()) == 0;
        }
        if (o2 instanceof Double) {
            return Double.doubleToRawLongBits((Double)o2) == 0L;
        }
        if (o2 instanceof String) {
            return o2.equals("");
        }
        if (o2 instanceof ByteString) {
            return o2.equals(ByteString.EMPTY);
        }
        if (o2 instanceof MessageLite) {
            Object object = o2;
            return object == ((MessageLite)object).getDefaultInstanceForType();
        }
        if (o2 instanceof Enum) {
            return ((Enum)o2).ordinal() == 0;
        }
        return false;
    }

    static final void printField(StringBuilder buffer, int indent, String name, Object object) {
        int n2;
        if (object instanceof List) {
            List list = (List)object;
            for (Object e2 : list) {
                MessageLiteToString.printField(buffer, indent, name, e2);
            }
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                MessageLiteToString.printField(buffer, indent, name, entry);
            }
            return;
        }
        buffer.append('\n');
        for (n2 = 0; n2 < indent; ++n2) {
            buffer.append(' ');
        }
        buffer.append(name);
        if (object instanceof String) {
            buffer.append(": \"").append(TextFormatEscaper.escapeText((String)object)).append('\"');
            return;
        }
        if (object instanceof ByteString) {
            buffer.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)object)).append('\"');
            return;
        }
        if (object instanceof GeneratedMessageLite) {
            buffer.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)object, buffer, indent + 2);
            buffer.append("\n");
            for (n2 = 0; n2 < indent; ++n2) {
                buffer.append(' ');
            }
            buffer.append("}");
            return;
        }
        if (object instanceof Map.Entry) {
            buffer.append(" {");
            Map.Entry entry = (Map.Entry)object;
            MessageLiteToString.printField(buffer, indent + 2, "key", entry.getKey());
            MessageLiteToString.printField(buffer, indent + 2, "value", entry.getValue());
            buffer.append("\n");
            for (int i2 = 0; i2 < indent; ++i2) {
                buffer.append(' ');
            }
            buffer.append("}");
            return;
        }
        buffer.append(": ").append(object);
    }

    private static final String camelCaseToSnakeCase(String camelCase) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < camelCase.length(); ++i2) {
            char c2 = camelCase.charAt(i2);
            if (Character.isUpperCase(c2)) {
                stringBuilder.append("_");
            }
            stringBuilder.append(Character.toLowerCase(c2));
        }
        return stringBuilder.toString();
    }
}

