/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtClassType;
import ai.h2o.javassist.CtMember;
import ai.h2o.javassist.CtNewWrappedMethod;
import ai.h2o.javassist.CtPrimitiveType;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.AccessFlag;
import ai.h2o.javassist.bytecode.AnnotationsAttribute;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.FieldInfo;
import ai.h2o.javassist.bytecode.SignatureAttribute;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.Javac;
import ai.h2o.javassist.compiler.SymbolTable;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.DoubleConst;
import ai.h2o.javassist.compiler.ast.IntConst;
import ai.h2o.javassist.compiler.ast.StringL;
import java.util.List;

public class CtField
extends CtMember {
    static final String javaLangString = "java.lang.String";
    protected FieldInfo fieldInfo;

    public CtField(CtClass type, String name, CtClass declaring) throws CannotCompileException {
        this(Descriptor.of(type), name, declaring);
    }

    public CtField(CtField src, CtClass declaring) throws CannotCompileException {
        this(src.fieldInfo.getDescriptor(), src.fieldInfo.getName(), declaring);
        FieldInfo fieldInfo = this.fieldInfo;
        fieldInfo.setAccessFlags(src.fieldInfo.getAccessFlags());
        ConstPool constPool = fieldInfo.getConstPool();
        List<AttributeInfo> list = src.fieldInfo.getAttributes();
        for (AttributeInfo attributeInfo : list) {
            fieldInfo.addAttribute(attributeInfo.copy(constPool, null));
        }
    }

    private CtField(String typeDesc, String name, CtClass clazz) throws CannotCompileException {
        super(clazz);
        ClassFile classFile = clazz.getClassFile2();
        if (classFile == null) {
            throw new CannotCompileException("bad declaring class: " + clazz.getName());
        }
        this.fieldInfo = new FieldInfo(classFile.getConstPool(), name, typeDesc);
    }

    CtField(FieldInfo fi, CtClass clazz) {
        super(clazz);
        this.fieldInfo = fi;
    }

    @Override
    public String toString() {
        return this.getDeclaringClass().getName() + "." + this.getName() + ":" + this.fieldInfo.getDescriptor();
    }

    @Override
    protected void extendToString(StringBuffer buffer) {
        buffer.append(' ');
        buffer.append(this.getName());
        buffer.append(' ');
        buffer.append(this.fieldInfo.getDescriptor());
    }

    protected ASTree getInitAST() {
        return null;
    }

    Initializer getInit() {
        ASTree aSTree = this.getInitAST();
        if (aSTree == null) {
            return null;
        }
        return Initializer.byExpr(aSTree);
    }

    public static CtField make(String src, CtClass declaring) throws CannotCompileException {
        Javac javac = new Javac(declaring);
        try {
            CtMember ctMember = javac.compile(src);
            if (ctMember instanceof CtField) {
                return (CtField)ctMember;
            }
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        throw new CannotCompileException("not a field");
    }

    public FieldInfo getFieldInfo() {
        this.declaringClass.checkModify();
        return this.fieldInfo;
    }

    public FieldInfo getFieldInfo2() {
        return this.fieldInfo;
    }

    @Override
    public CtClass getDeclaringClass() {
        return super.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.fieldInfo.getName();
    }

    public void setName(String newName) {
        this.declaringClass.checkModify();
        this.fieldInfo.setName(newName);
    }

    @Override
    public int getModifiers() {
        return AccessFlag.toModifier(this.fieldInfo.getAccessFlags());
    }

    @Override
    public void setModifiers(int mod) {
        this.declaringClass.checkModify();
        this.fieldInfo.setAccessFlags(AccessFlag.of(mod));
    }

    @Override
    public boolean hasAnnotation(String typeName) {
        FieldInfo fieldInfo = this.getFieldInfo2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.hasAnnotationType(typeName, this.getDeclaringClass().getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    @Override
    public Object getAnnotation(Class<?> clz) throws ClassNotFoundException {
        FieldInfo fieldInfo = this.getFieldInfo2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.getAnnotationType(clz, this.getDeclaringClass().getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    @Override
    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    @Override
    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unexpected exception", classNotFoundException);
        }
    }

    private Object[] getAnnotations(boolean ignoreNotFound) throws ClassNotFoundException {
        FieldInfo fieldInfo = this.getFieldInfo2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType(ignoreNotFound, this.getDeclaringClass().getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    @Override
    public String getSignature() {
        return this.fieldInfo.getDescriptor();
    }

    @Override
    public String getGenericSignature() {
        SignatureAttribute signatureAttribute = (SignatureAttribute)this.fieldInfo.getAttribute("Signature");
        if (signatureAttribute == null) {
            return null;
        }
        return signatureAttribute.getSignature();
    }

    @Override
    public void setGenericSignature(String sig) {
        this.declaringClass.checkModify();
        this.fieldInfo.addAttribute(new SignatureAttribute(this.fieldInfo.getConstPool(), sig));
    }

    public CtClass getType() throws NotFoundException {
        return Descriptor.toCtClass(this.fieldInfo.getDescriptor(), this.declaringClass.getClassPool());
    }

    public void setType(CtClass clazz) {
        this.declaringClass.checkModify();
        this.fieldInfo.setDescriptor(Descriptor.of(clazz));
    }

    public Object getConstantValue() {
        int n2 = this.fieldInfo.getConstantValue();
        if (n2 == 0) {
            return null;
        }
        ConstPool constPool = this.fieldInfo.getConstPool();
        switch (constPool.getTag(n2)) {
            case 5: {
                return constPool.getLongInfo(n2);
            }
            case 4: {
                return Float.valueOf(constPool.getFloatInfo(n2));
            }
            case 6: {
                return constPool.getDoubleInfo(n2);
            }
            case 3: {
                int n3 = constPool.getIntegerInfo(n2);
                if ("Z".equals(this.fieldInfo.getDescriptor())) {
                    return n3 != 0;
                }
                return n3;
            }
            case 8: {
                return constPool.getStringInfo(n2);
            }
        }
        throw new RuntimeException("bad tag: " + constPool.getTag(n2) + " at " + n2);
    }

    @Override
    public byte[] getAttribute(String name) {
        AttributeInfo attributeInfo = this.fieldInfo.getAttribute(name);
        if (attributeInfo == null) {
            return null;
        }
        return attributeInfo.get();
    }

    @Override
    public void setAttribute(String name, byte[] data) {
        this.declaringClass.checkModify();
        this.fieldInfo.addAttribute(new AttributeInfo(this.fieldInfo.getConstPool(), name, data));
    }

    static class MultiArrayInitializer
    extends Initializer {
        CtClass type;
        int[] dim;

        MultiArrayInitializer(CtClass t2, int[] d2) {
            this.type = t2;
            this.dim = d2;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            if (desc.charAt(0) != '[') {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code.addAload(0);
            int n2 = code.addMultiNewarray(type, this.dim);
            code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
            return n2 + 1;
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            int n2 = code.addMultiNewarray(type, this.dim);
            code.addPutstatic(Bytecode.THIS, name, Descriptor.of(type));
            return n2;
        }
    }

    static class ArrayInitializer
    extends Initializer {
        CtClass type;
        int size;

        ArrayInitializer(CtClass t2, int s2) {
            this.type = t2;
            this.size = s2;
        }

        private void addNewarray(Bytecode code) {
            if (this.type.isPrimitive()) {
                code.addNewarray(((CtPrimitiveType)this.type).getArrayType(), this.size);
                return;
            }
            code.addAnewarray(this.type, this.size);
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code.addAload(0);
            this.addNewarray(code);
            code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
            return 2;
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            this.addNewarray(code);
            code.addPutstatic(Bytecode.THIS, name, Descriptor.of(type));
            return 1;
        }
    }

    static class StringInitializer
    extends Initializer {
        String value;

        StringInitializer(String v2) {
            this.value = v2;
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code.addAload(0);
            code.addLdc(this.value);
            code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
            return 2;
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            code.addLdc(this.value);
            code.addPutstatic(Bytecode.THIS, name, Descriptor.of(type));
            return 1;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            if (type.getName().equals(CtField.javaLangString)) {
                return cp.addStringInfo(this.value);
            }
            return 0;
        }
    }

    static class DoubleInitializer
    extends Initializer {
        double value;

        DoubleInitializer(double v2) {
            this.value = v2;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            if (!desc.equals("D")) {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code.addAload(0);
            code.addLdc2w(this.value);
            code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
            return 3;
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            code.addLdc2w(this.value);
            code.addPutstatic(Bytecode.THIS, name, Descriptor.of(type));
            return 2;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            if (type == CtClass.doubleType) {
                return cp.addDoubleInfo(this.value);
            }
            return 0;
        }
    }

    static class FloatInitializer
    extends Initializer {
        float value;

        FloatInitializer(float v2) {
            this.value = v2;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            if (!desc.equals("F")) {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code.addAload(0);
            code.addFconst(this.value);
            code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
            return 3;
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            code.addFconst(this.value);
            code.addPutstatic(Bytecode.THIS, name, Descriptor.of(type));
            return 2;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            if (type == CtClass.floatType) {
                return cp.addFloatInfo(this.value);
            }
            return 0;
        }
    }

    static class LongInitializer
    extends Initializer {
        long value;

        LongInitializer(long v2) {
            this.value = v2;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            if (!desc.equals("J")) {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code.addAload(0);
            code.addLdc2w(this.value);
            code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
            return 3;
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            code.addLdc2w(this.value);
            code.addPutstatic(Bytecode.THIS, name, Descriptor.of(type));
            return 2;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            if (type == CtClass.longType) {
                return cp.addLongInfo(this.value);
            }
            return 0;
        }
    }

    static class IntInitializer
    extends Initializer {
        int value;

        IntInitializer(int v2) {
            this.value = v2;
        }

        @Override
        void check(String desc) throws CannotCompileException {
            char c2 = desc.charAt(0);
            if (c2 != 'I' && c2 != 'S' && c2 != 'B' && c2 != 'C' && c2 != 'Z') {
                throw new CannotCompileException("type mismatch");
            }
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code.addAload(0);
            code.addIconst(this.value);
            code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
            return 2;
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            code.addIconst(this.value);
            code.addPutstatic(Bytecode.THIS, name, Descriptor.of(type));
            return 1;
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            return cp.addIntegerInfo(this.value);
        }
    }

    static class MethodInitializer
    extends NewInitializer {
        String methodName;

        MethodInitializer() {
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code.addAload(0);
            code.addAload(0);
            int n2 = this.stringParams == null ? 2 : this.compileStringParameter(code) + 2;
            if (this.withConstructorParams) {
                n2 += CtNewWrappedMethod.compileParameterList(code, parameters, 1);
            }
            String string = Descriptor.of(type);
            String string2 = this.getDescriptor() + string;
            code.addInvokestatic(this.objectType, this.methodName, string2);
            code.addPutfield(Bytecode.THIS, name, string);
            return n2;
        }

        private String getDescriptor() {
            if (this.stringParams == null) {
                if (this.withConstructorParams) {
                    return "(Ljava/lang/Object;[Ljava/lang/Object;)";
                }
                return "(Ljava/lang/Object;)";
            }
            if (this.withConstructorParams) {
                return "(Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/Object;)";
            }
            return "(Ljava/lang/Object;[Ljava/lang/String;)";
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            String string;
            int n2 = 1;
            if (this.stringParams == null) {
                string = "()";
            } else {
                string = "([Ljava/lang/String;)";
                n2 = 1 + this.compileStringParameter(code);
            }
            String string2 = Descriptor.of(type);
            code.addInvokestatic(this.objectType, this.methodName, string + string2);
            code.addPutstatic(Bytecode.THIS, name, string2);
            return n2;
        }
    }

    static class NewInitializer
    extends Initializer {
        CtClass objectType;
        String[] stringParams;
        boolean withConstructorParams;

        NewInitializer() {
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            code.addAload(0);
            code.addNew(this.objectType);
            code.add(89);
            code.addAload(0);
            int n2 = this.stringParams == null ? 4 : this.compileStringParameter(code) + 4;
            if (this.withConstructorParams) {
                n2 += CtNewWrappedMethod.compileParameterList(code, parameters, 1);
            }
            code.addInvokespecial(this.objectType, "<init>", this.getDescriptor());
            code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
            return n2;
        }

        private String getDescriptor() {
            if (this.stringParams == null) {
                if (this.withConstructorParams) {
                    return "(Ljava/lang/Object;[Ljava/lang/Object;)V";
                }
                return "(Ljava/lang/Object;)V";
            }
            if (this.withConstructorParams) {
                return "(Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/Object;)V";
            }
            return "(Ljava/lang/Object;[Ljava/lang/String;)V";
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            String string;
            code.addNew(this.objectType);
            code.add(89);
            int n2 = 2;
            if (this.stringParams == null) {
                string = "()V";
            } else {
                string = "([Ljava/lang/String;)V";
                n2 = 2 + this.compileStringParameter(code);
            }
            code.addInvokespecial(this.objectType, "<init>", string);
            code.addPutstatic(Bytecode.THIS, name, Descriptor.of(type));
            return n2;
        }

        protected final int compileStringParameter(Bytecode code) throws CannotCompileException {
            int n2 = this.stringParams.length;
            code.addIconst(n2);
            code.addAnewarray(CtField.javaLangString);
            for (int i2 = 0; i2 < n2; ++i2) {
                code.add(89);
                code.addIconst(i2);
                code.addLdc(this.stringParams[i2]);
                code.add(83);
            }
            return 4;
        }
    }

    static class ParamInitializer
    extends Initializer {
        int nthParam;

        ParamInitializer() {
        }

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            if (parameters != null && this.nthParam < parameters.length) {
                code.addAload(0);
                int n2 = ParamInitializer.nthParamToLocal(this.nthParam, parameters, false);
                int n3 = code.addLoad(n2, type) + 1;
                code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
                return n3;
            }
            return 0;
        }

        static int nthParamToLocal(int nth, CtClass[] params, boolean isStatic) {
            CtClass ctClass = CtClass.longType;
            CtClass ctClass2 = CtClass.doubleType;
            int n2 = isStatic ? 0 : 1;
            for (int i2 = 0; i2 < nth; ++i2) {
                CtClass ctClass3 = params[i2];
                if (ctClass3 == ctClass || ctClass3 == ctClass2) {
                    n2 += 2;
                    continue;
                }
                ++n2;
            }
            return n2;
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            return 0;
        }
    }

    static class PtreeInitializer
    extends CodeInitializer0 {
        private ASTree expression;

        PtreeInitializer(ASTree expr) {
            this.expression = expr;
        }

        @Override
        void compileExpr(Javac drv) throws CompileError {
            drv.compileExpr(this.expression);
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            return this.getConstantValue2(cp, type, this.expression);
        }
    }

    static class CodeInitializer
    extends CodeInitializer0 {
        private String expression;

        CodeInitializer(String expr) {
            this.expression = expr;
        }

        @Override
        void compileExpr(Javac drv) throws CompileError {
            drv.compileExpr(this.expression);
        }

        @Override
        int getConstantValue(ConstPool cp, CtClass type) {
            try {
                ASTree aSTree = Javac.parseExpr(this.expression, new SymbolTable());
                return this.getConstantValue2(cp, type, aSTree);
            }
            catch (CompileError compileError) {
                return 0;
            }
        }
    }

    static abstract class CodeInitializer0
    extends Initializer {
        CodeInitializer0() {
        }

        abstract void compileExpr(Javac var1) throws CompileError;

        @Override
        int compile(CtClass type, String name, Bytecode code, CtClass[] parameters, Javac drv) throws CannotCompileException {
            try {
                code.addAload(0);
                this.compileExpr(drv);
                code.addPutfield(Bytecode.THIS, name, Descriptor.of(type));
                return code.getMaxStack();
            }
            catch (CompileError compileError) {
                throw new CannotCompileException(compileError);
            }
        }

        @Override
        int compileIfStatic(CtClass type, String name, Bytecode code, Javac drv) throws CannotCompileException {
            try {
                this.compileExpr(drv);
                code.addPutstatic(Bytecode.THIS, name, Descriptor.of(type));
                return code.getMaxStack();
            }
            catch (CompileError compileError) {
                throw new CannotCompileException(compileError);
            }
        }

        int getConstantValue2(ConstPool cp, CtClass type, ASTree tree) {
            if (type.isPrimitive()) {
                if (tree instanceof IntConst) {
                    long l2 = ((IntConst)tree).get();
                    if (type == CtClass.doubleType) {
                        return cp.addDoubleInfo(l2);
                    }
                    if (type == CtClass.floatType) {
                        return cp.addFloatInfo(l2);
                    }
                    if (type == CtClass.longType) {
                        return cp.addLongInfo(l2);
                    }
                    if (type != CtClass.voidType) {
                        return cp.addIntegerInfo((int)l2);
                    }
                } else if (tree instanceof DoubleConst) {
                    double d2 = ((DoubleConst)tree).get();
                    if (type == CtClass.floatType) {
                        return cp.addFloatInfo((float)d2);
                    }
                    if (type == CtClass.doubleType) {
                        return cp.addDoubleInfo(d2);
                    }
                }
            } else if (tree instanceof StringL && type.getName().equals(CtField.javaLangString)) {
                return cp.addStringInfo(((StringL)tree).get());
            }
            return 0;
        }
    }

    public static abstract class Initializer {
        public static Initializer constant(int i2) {
            return new IntInitializer(i2);
        }

        public static Initializer constant(boolean b2) {
            return new IntInitializer(b2 ? 1 : 0);
        }

        public static Initializer constant(long l2) {
            return new LongInitializer(l2);
        }

        public static Initializer constant(float l2) {
            return new FloatInitializer(l2);
        }

        public static Initializer constant(double d2) {
            return new DoubleInitializer(d2);
        }

        public static Initializer constant(String s2) {
            return new StringInitializer(s2);
        }

        public static Initializer byParameter(int nth) {
            ParamInitializer paramInitializer = new ParamInitializer();
            new ParamInitializer().nthParam = nth;
            return paramInitializer;
        }

        public static Initializer byNew(CtClass objectType) {
            NewInitializer newInitializer = new NewInitializer();
            new NewInitializer().objectType = objectType;
            newInitializer.stringParams = null;
            newInitializer.withConstructorParams = false;
            return newInitializer;
        }

        public static Initializer byNew(CtClass objectType, String[] stringParams) {
            NewInitializer newInitializer = new NewInitializer();
            new NewInitializer().objectType = objectType;
            newInitializer.stringParams = stringParams;
            newInitializer.withConstructorParams = false;
            return newInitializer;
        }

        public static Initializer byNewWithParams(CtClass objectType) {
            NewInitializer newInitializer = new NewInitializer();
            new NewInitializer().objectType = objectType;
            newInitializer.stringParams = null;
            newInitializer.withConstructorParams = true;
            return newInitializer;
        }

        public static Initializer byNewWithParams(CtClass objectType, String[] stringParams) {
            NewInitializer newInitializer = new NewInitializer();
            new NewInitializer().objectType = objectType;
            newInitializer.stringParams = stringParams;
            newInitializer.withConstructorParams = true;
            return newInitializer;
        }

        public static Initializer byCall(CtClass methodClass, String methodName) {
            MethodInitializer methodInitializer = new MethodInitializer();
            new MethodInitializer().objectType = methodClass;
            methodInitializer.methodName = methodName;
            methodInitializer.stringParams = null;
            methodInitializer.withConstructorParams = false;
            return methodInitializer;
        }

        public static Initializer byCall(CtClass methodClass, String methodName, String[] stringParams) {
            MethodInitializer methodInitializer = new MethodInitializer();
            new MethodInitializer().objectType = methodClass;
            methodInitializer.methodName = methodName;
            methodInitializer.stringParams = stringParams;
            methodInitializer.withConstructorParams = false;
            return methodInitializer;
        }

        public static Initializer byCallWithParams(CtClass methodClass, String methodName) {
            MethodInitializer methodInitializer = new MethodInitializer();
            new MethodInitializer().objectType = methodClass;
            methodInitializer.methodName = methodName;
            methodInitializer.stringParams = null;
            methodInitializer.withConstructorParams = true;
            return methodInitializer;
        }

        public static Initializer byCallWithParams(CtClass methodClass, String methodName, String[] stringParams) {
            MethodInitializer methodInitializer = new MethodInitializer();
            new MethodInitializer().objectType = methodClass;
            methodInitializer.methodName = methodName;
            methodInitializer.stringParams = stringParams;
            methodInitializer.withConstructorParams = true;
            return methodInitializer;
        }

        public static Initializer byNewArray(CtClass type, int size) throws NotFoundException {
            return new ArrayInitializer(type.getComponentType(), size);
        }

        public static Initializer byNewArray(CtClass type, int[] sizes) {
            return new MultiArrayInitializer(type, sizes);
        }

        public static Initializer byExpr(String source) {
            return new CodeInitializer(source);
        }

        static Initializer byExpr(ASTree source) {
            return new PtreeInitializer(source);
        }

        void check(String desc) throws CannotCompileException {
        }

        abstract int compile(CtClass var1, String var2, Bytecode var3, CtClass[] var4, Javac var5) throws CannotCompileException;

        abstract int compileIfStatic(CtClass var1, String var2, Bytecode var3, Javac var4) throws CannotCompileException;

        int getConstantValue(ConstPool cp, CtClass type) {
            return 0;
        }
    }
}

