/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassMap;
import ai.h2o.javassist.CtBehavior;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtNewMethod;
import ai.h2o.javassist.CtNewWrappedMethod;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.MethodInfo;

public final class CtMethod
extends CtBehavior {
    protected String cachedStringRep = null;

    CtMethod(MethodInfo minfo, CtClass declaring) {
        super(declaring, minfo);
    }

    public CtMethod(CtClass returnType, String mname, CtClass[] parameters, CtClass declaring) {
        this(null, declaring);
        ConstPool constPool = declaring.getClassFile2().getConstPool();
        String string = Descriptor.ofMethod(returnType, parameters);
        this.methodInfo = new MethodInfo(constPool, mname, string);
        this.setModifiers(1025);
    }

    public CtMethod(CtMethod src, CtClass declaring, ClassMap map) throws CannotCompileException {
        this(null, declaring);
        this.copy(src, false, map);
    }

    public static CtMethod make(String src, CtClass declaring) throws CannotCompileException {
        return CtNewMethod.make(src, declaring);
    }

    public static CtMethod make(MethodInfo minfo, CtClass declaring) throws CannotCompileException {
        if (declaring.getClassFile2().getConstPool() != minfo.getConstPool()) {
            throw new CannotCompileException("bad declaring class");
        }
        return new CtMethod(minfo, declaring);
    }

    public final int hashCode() {
        return this.getStringRep().hashCode();
    }

    @Override
    final void nameReplaced() {
        this.cachedStringRep = null;
    }

    final String getStringRep() {
        if (this.cachedStringRep == null) {
            this.cachedStringRep = this.methodInfo.getName() + Descriptor.getParamDescriptor(this.methodInfo.getDescriptor());
        }
        return this.cachedStringRep;
    }

    public final boolean equals(Object obj) {
        return obj != null && obj instanceof CtMethod && ((CtMethod)obj).getStringRep().equals(this.getStringRep());
    }

    @Override
    public final String getLongName() {
        return this.getDeclaringClass().getName() + "." + this.getName() + Descriptor.toString(this.getSignature());
    }

    @Override
    public final String getName() {
        return this.methodInfo.getName();
    }

    public final void setName(String newname) {
        this.declaringClass.checkModify();
        this.methodInfo.setName(newname);
    }

    public final CtClass getReturnType() throws NotFoundException {
        return this.getReturnType0();
    }

    @Override
    public final boolean isEmpty() {
        CodeAttribute codeAttribute = this.getMethodInfo2().getCodeAttribute();
        if (codeAttribute == null) {
            return (this.getModifiers() & 0x400) != 0;
        }
        CodeIterator codeIterator = codeAttribute.iterator();
        try {
            if (codeIterator.hasNext()) {
                CodeIterator codeIterator2 = codeIterator;
                if (codeIterator2.byteAt(codeIterator2.next()) == 177 && !codeIterator.hasNext()) {
                    return true;
                }
            }
            return false;
        }
        catch (BadBytecode badBytecode) {
            return false;
        }
    }

    public final void setBody(CtMethod src, ClassMap map) throws CannotCompileException {
        CtMethod.setBody0(src.declaringClass, src.methodInfo, this.declaringClass, this.methodInfo, map);
    }

    public final void setWrappedBody(CtMethod mbody, ConstParameter constParam) throws CannotCompileException {
        CtClass ctClass;
        CtClass[] ctClassArray;
        this.declaringClass.checkModify();
        CtClass ctClass2 = this.getDeclaringClass();
        try {
            ctClassArray = this.getParameterTypes();
            ctClass = this.getReturnType();
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        CtClass ctClass3 = ctClass2;
        Bytecode bytecode = CtNewWrappedMethod.makeBody(ctClass3, ctClass3.getClassFile2(), mbody, ctClassArray, ctClass, constParam);
        CodeAttribute codeAttribute = bytecode.toCodeAttribute();
        this.methodInfo.setCodeAttribute(codeAttribute);
        this.methodInfo.setAccessFlags(this.methodInfo.getAccessFlags() & 0xFFFFFBFF);
    }

    static class StringConstParameter
    extends ConstParameter {
        String param;

        StringConstParameter(String s2) {
            this.param = s2;
        }

        @Override
        int compile(Bytecode code) throws CannotCompileException {
            code.addLdc(this.param);
            return 1;
        }

        @Override
        String descriptor() {
            return "([Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;";
        }

        @Override
        String constDescriptor() {
            return "([Ljava/lang/Object;Ljava/lang/String;)V";
        }
    }

    static class LongConstParameter
    extends ConstParameter {
        long param;

        LongConstParameter(long l2) {
            this.param = l2;
        }

        @Override
        int compile(Bytecode code) throws CannotCompileException {
            code.addLconst(this.param);
            return 2;
        }

        @Override
        String descriptor() {
            return "([Ljava/lang/Object;J)Ljava/lang/Object;";
        }

        @Override
        String constDescriptor() {
            return "([Ljava/lang/Object;J)V";
        }
    }

    static class IntConstParameter
    extends ConstParameter {
        int param;

        IntConstParameter(int i2) {
            this.param = i2;
        }

        @Override
        int compile(Bytecode code) throws CannotCompileException {
            code.addIconst(this.param);
            return 1;
        }

        @Override
        String descriptor() {
            return "([Ljava/lang/Object;I)Ljava/lang/Object;";
        }

        @Override
        String constDescriptor() {
            return "([Ljava/lang/Object;I)V";
        }
    }

    public static class ConstParameter {
        public static ConstParameter integer(int i2) {
            return new IntConstParameter(i2);
        }

        public static ConstParameter integer(long i2) {
            return new LongConstParameter(i2);
        }

        public static ConstParameter string(String s2) {
            return new StringConstParameter(s2);
        }

        ConstParameter() {
        }

        int compile(Bytecode code) throws CannotCompileException {
            return 0;
        }

        String descriptor() {
            return ConstParameter.defaultDescriptor();
        }

        static String defaultDescriptor() {
            return "([Ljava/lang/Object;)Ljava/lang/Object;";
        }

        String constDescriptor() {
            return ConstParameter.defaultConstDescriptor();
        }

        static String defaultConstDescriptor() {
            return "([Ljava/lang/Object;)V";
        }
    }
}

