/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.ClassPath;
import ai.h2o.javassist.ClassPoolTail;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URLClassPath
implements ClassPath {
    protected String hostname;
    protected int port;
    protected String directory;
    protected String packageName;

    public URLClassPath(String host, int port, String directory, String packageName) {
        this.hostname = host;
        this.port = port;
        this.directory = directory;
        this.packageName = packageName;
    }

    public String toString() {
        return this.hostname + ":" + this.port + this.directory;
    }

    @Override
    public InputStream openClassfile(String classname) {
        try {
            URLConnection uRLConnection = this.openClassfile0(classname);
            if (uRLConnection != null) {
                return uRLConnection.getInputStream();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private URLConnection openClassfile0(String classname) throws IOException {
        if (this.packageName == null || classname.startsWith(this.packageName)) {
            String string = this.directory + classname.replace('.', '/') + ".class";
            return URLClassPath.fetchClass0(this.hostname, this.port, string);
        }
        return null;
    }

    @Override
    public URL find(String classname) {
        try {
            URLConnection uRLConnection = this.openClassfile0(classname);
            InputStream inputStream = uRLConnection.getInputStream();
            if (inputStream != null) {
                inputStream.close();
                return uRLConnection.getURL();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static byte[] fetchClass(String host, int port, String directory, String classname) throws IOException {
        byte[] byArray;
        URLConnection uRLConnection = URLClassPath.fetchClass0(host, port, directory + classname.replace('.', '/') + ".class");
        int n2 = uRLConnection.getContentLength();
        try (InputStream inputStream = uRLConnection.getInputStream();){
            if (n2 <= 0) {
                byArray = ClassPoolTail.readStream(inputStream);
            } else {
                int n3;
                byArray = new byte[n2];
                int n4 = 0;
                do {
                    if ((n3 = inputStream.read(byArray, n4, n2 - n4)) >= 0) continue;
                    throw new IOException("the stream was closed: " + classname);
                } while ((n4 += n3) < n2);
            }
        }
        return byArray;
    }

    private static URLConnection fetchClass0(String host, int port, String filename) throws IOException {
        URL uRL;
        try {
            uRL = new URL("http", host, port, filename);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("invalid URL?");
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        return uRLConnection;
    }
}

