/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.ExceptionTable;
import ai.h2o.javassist.bytecode.Opcode;

class CodeAnalyzer
implements Opcode {
    private ConstPool constPool;
    private CodeAttribute codeAttr;

    public CodeAnalyzer(CodeAttribute ca) {
        this.codeAttr = ca;
        this.constPool = ca.getConstPool();
    }

    public int computeMaxStack() throws BadBytecode {
        int n2;
        boolean bl;
        CodeIterator codeIterator = this.codeAttr.iterator();
        int n3 = codeIterator.getCodeLength();
        int[] nArray = new int[n3];
        this.constPool = this.codeAttr.getConstPool();
        this.initStack(nArray, this.codeAttr);
        do {
            bl = false;
            for (n2 = 0; n2 < n3; ++n2) {
                if (nArray[n2] >= 0) continue;
                bl = true;
                this.visitBytecode(codeIterator, nArray, n2);
            }
        } while (bl);
        n2 = 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] <= n2) continue;
            n2 = nArray[i2];
        }
        return n2 - 1;
    }

    private void initStack(int[] stack, CodeAttribute ca) {
        stack[0] = -1;
        ExceptionTable exceptionTable = ca.getExceptionTable();
        if (exceptionTable != null) {
            int n2 = exceptionTable.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                stack[exceptionTable.handlerPc((int)i2)] = -2;
            }
        }
    }

    private void visitBytecode(CodeIterator ci, int[] stack, int index) throws BadBytecode {
        int n2 = stack.length;
        ci.move(index);
        int n3 = -stack[index];
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = -1;
        while (ci.hasNext()) {
            index = ci.next();
            stack[index] = n3;
            int n4 = ci.byteAt(index);
            n3 = this.visitInst(n4, ci, index, n3);
            if (n3 <= 0) {
                throw new BadBytecode("stack underflow at " + index);
            }
            if (this.processBranch(n4, ci, index, n2, stack, n3, nArray2) || CodeAnalyzer.isEnd(n4)) break;
            if (n4 != 168 && n4 != 201) continue;
            --n3;
        }
    }

    private boolean processBranch(int opcode, CodeIterator ci, int index, int codeLength, int[] stack, int stackDepth, int[] jsrDepth) throws BadBytecode {
        if (153 <= opcode && opcode <= 166 || opcode == 198 || opcode == 199) {
            int n2 = index + ci.s16bitAt(index + 1);
            this.checkTarget(index, n2, codeLength, stack, stackDepth);
        } else {
            switch (opcode) {
                case 167: {
                    int n3 = index + ci.s16bitAt(index + 1);
                    this.checkTarget(index, n3, codeLength, stack, stackDepth);
                    return true;
                }
                case 200: {
                    int n4 = index + ci.s32bitAt(index + 1);
                    this.checkTarget(index, n4, codeLength, stack, stackDepth);
                    return true;
                }
                case 168: 
                case 201: {
                    int n5 = opcode == 168 ? index + ci.s16bitAt(index + 1) : index + ci.s32bitAt(index + 1);
                    this.checkTarget(index, n5, codeLength, stack, stackDepth);
                    if (jsrDepth[0] < 0) {
                        jsrDepth[0] = stackDepth;
                        return false;
                    }
                    if (stackDepth == jsrDepth[0]) {
                        return false;
                    }
                    throw new BadBytecode("sorry, cannot compute this data flow due to JSR: " + stackDepth + "," + jsrDepth[0]);
                }
                case 169: {
                    if (jsrDepth[0] < 0) {
                        jsrDepth[0] = stackDepth + 1;
                        return false;
                    }
                    if (stackDepth + 1 == jsrDepth[0]) {
                        return true;
                    }
                    throw new BadBytecode("sorry, cannot compute this data flow due to RET: " + stackDepth + "," + jsrDepth[0]);
                }
                case 170: 
                case 171: {
                    int n6 = (index & 0xFFFFFFFC) + 4;
                    int n7 = index + ci.s32bitAt(n6);
                    this.checkTarget(index, n7, codeLength, stack, stackDepth);
                    if (opcode == 171) {
                        int n8 = ci.s32bitAt(n6 + 4);
                        n6 += 12;
                        for (int i2 = 0; i2 < n8; ++i2) {
                            n7 = index + ci.s32bitAt(n6);
                            this.checkTarget(index, n7, codeLength, stack, stackDepth);
                            n6 += 8;
                        }
                    } else {
                        int n9 = ci.s32bitAt(n6 + 4);
                        int n10 = ci.s32bitAt(n6 + 8);
                        int n11 = n10 - n9 + 1;
                        n6 += 12;
                        for (int i3 = 0; i3 < n11; ++i3) {
                            n7 = index + ci.s32bitAt(n6);
                            this.checkTarget(index, n7, codeLength, stack, stackDepth);
                            n6 += 4;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void checkTarget(int opIndex, int target, int codeLength, int[] stack, int stackDepth) throws BadBytecode {
        if (target < 0 || codeLength <= target) {
            throw new BadBytecode("bad branch offset at " + opIndex);
        }
        int n2 = stack[target];
        if (n2 == 0) {
            stack[target] = -stackDepth;
            return;
        }
        if (n2 != stackDepth && n2 != -stackDepth) {
            throw new BadBytecode("verification error (" + stackDepth + "," + n2 + ") at " + opIndex);
        }
    }

    private static boolean isEnd(int opcode) {
        return 172 <= opcode && opcode <= 177 || opcode == 191;
    }

    private int visitInst(int op, CodeIterator ci, int index, int stack) throws BadBytecode {
        switch (op) {
            case 180: {
                stack += this.getFieldSize(ci, index) - 1;
                break;
            }
            case 181: {
                stack -= this.getFieldSize(ci, index) + 1;
                break;
            }
            case 178: {
                stack += this.getFieldSize(ci, index);
                break;
            }
            case 179: {
                stack -= this.getFieldSize(ci, index);
                break;
            }
            case 182: 
            case 183: {
                String string = this.constPool.getMethodrefType(ci.u16bitAt(index + 1));
                stack += Descriptor.dataSize(string) - 1;
                break;
            }
            case 184: {
                String string = this.constPool.getMethodrefType(ci.u16bitAt(index + 1));
                stack += Descriptor.dataSize(string);
                break;
            }
            case 185: {
                String string = this.constPool.getInterfaceMethodrefType(ci.u16bitAt(index + 1));
                stack += Descriptor.dataSize(string) - 1;
                break;
            }
            case 186: {
                String string = this.constPool.getInvokeDynamicType(ci.u16bitAt(index + 1));
                stack += Descriptor.dataSize(string);
                break;
            }
            case 191: {
                stack = 1;
                break;
            }
            case 197: {
                stack += 1 - ci.byteAt(index + 3);
                break;
            }
            case 196: {
                op = ci.byteAt(index + 1);
            }
            default: {
                stack += STACK_GROW[op];
            }
        }
        return stack;
    }

    private int getFieldSize(CodeIterator ci, int index) {
        String string = this.constPool.getFieldrefType(ci.u16bitAt(index + 1));
        return Descriptor.dataSize(string);
    }
}

