/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.AnnotationsAttribute;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.annotation.Annotation;
import ai.h2o.javassist.bytecode.annotation.AnnotationsWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ParameterAnnotationsAttribute
extends AttributeInfo {
    public static final String visibleTag = "RuntimeVisibleParameterAnnotations";
    public static final String invisibleTag = "RuntimeInvisibleParameterAnnotations";

    public ParameterAnnotationsAttribute(ConstPool cp, String attrname, byte[] info) {
        super(cp, attrname, info);
    }

    public ParameterAnnotationsAttribute(ConstPool cp, String attrname) {
        this(cp, attrname, new byte[]{0});
    }

    ParameterAnnotationsAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super(cp, n2, in);
    }

    public int numParameters() {
        return this.info[0] & 0xFF;
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        AnnotationsAttribute.Copier copier = new AnnotationsAttribute.Copier(this.info, this.constPool, newCp, classnames);
        try {
            copier.parameters();
            return new ParameterAnnotationsAttribute(newCp, this.getName(), copier.close());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Annotation[][] getAnnotations() {
        try {
            return new AnnotationsAttribute.Parser(this.info, this.constPool).parseParameters();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public void setAnnotations(Annotation[][] params) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AnnotationsWriter annotationsWriter = new AnnotationsWriter(byteArrayOutputStream, this.constPool);
        try {
            annotationsWriter.numParameters(params.length);
            Annotation[][] annotationArray = params;
            int n2 = params.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Annotation[] annotationArray2 = annotationArray[i2];
                annotationsWriter.numAnnotations(annotationArray2.length);
                for (int i3 = 0; i3 < annotationArray2.length; ++i3) {
                    annotationArray2[i3].write(annotationsWriter);
                }
            }
            annotationsWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.set(byteArrayOutputStream.toByteArray());
    }

    @Override
    void renameClass(String oldname, String newname) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(oldname, newname);
        this.renameClass(hashMap);
    }

    @Override
    void renameClass(Map<String, String> classnames) {
        AnnotationsAttribute.Renamer renamer = new AnnotationsAttribute.Renamer(this.info, this.getConstPool(), classnames);
        try {
            renamer.parameters();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    void getRefClasses(Map<String, String> classnames) {
        this.renameClass(classnames);
    }

    public String toString() {
        Annotation[][] annotationArray = this.getAnnotations();
        StringBuilder stringBuilder = new StringBuilder();
        Annotation[][] annotationArray2 = annotationArray;
        int n2 = annotationArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Annotation[] annotationArray3;
            Annotation[] annotationArray4 = annotationArray3 = annotationArray2[i2];
            int n3 = annotationArray3.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Annotation annotation = annotationArray4[i3];
                stringBuilder.append(annotation.toString()).append(" ");
            }
            stringBuilder.append(", ");
        }
        return stringBuilder.toString().replaceAll(" (?=,)|, $", "");
    }
}

