/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ConstPool;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;

public class StackMapTable
extends AttributeInfo {
    public static final String tag = "StackMapTable";
    public static final int TOP = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int LONG = 4;
    public static final int NULL = 5;
    public static final int THIS = 6;
    public static final int OBJECT = 7;
    public static final int UNINIT = 8;

    StackMapTable(ConstPool cp, byte[] newInfo) {
        super(cp, tag, newInfo);
    }

    StackMapTable(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super(cp, name_id, in);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) throws RuntimeCopyException {
        try {
            return new StackMapTable(newCp, new Copier(this.constPool, this.info, newCp, classnames).doit());
        }
        catch (BadBytecode badBytecode) {
            throw new RuntimeCopyException("bad bytecode. fatal?");
        }
    }

    @Override
    void write(DataOutputStream out) throws IOException {
        super.write(out);
    }

    public void insertLocal(int index, int tag, int classInfo) throws BadBytecode {
        byte[] byArray = new InsertLocal(this.get(), index, tag, classInfo).doit();
        this.set(byArray);
    }

    public static int typeTagOf(char descriptor) {
        switch (descriptor) {
            case 'D': {
                return 3;
            }
            case 'F': {
                return 2;
            }
            case 'J': {
                return 4;
            }
            case 'L': 
            case '[': {
                return 7;
            }
        }
        return 1;
    }

    public void println(PrintWriter w2) {
        Printer.print(this, w2);
    }

    public void println(PrintStream ps) {
        Printer.print(this, new PrintWriter(ps, true));
    }

    void shiftPc(int where, int gapSize, boolean exclusive) throws BadBytecode {
        new OffsetShifter(this, where, gapSize).parse();
        new Shifter(this, where, gapSize, exclusive).doit();
    }

    void shiftForSwitch(int where, int gapSize) throws BadBytecode {
        new SwitchShifter(this, where, gapSize).doit();
    }

    public void removeNew(int where) throws CannotCompileException {
        try {
            byte[] byArray = new NewRemover(this.get(), where).doit();
            this.set(byArray);
            return;
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException("bad stack map table", badBytecode);
        }
    }

    static class NewRemover
    extends SimpleCopy {
        int posOfNew;

        public NewRemover(byte[] data, int pos) {
            super(data);
            this.posOfNew = pos;
        }

        @Override
        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) {
            if (stackTag == 8 && stackData == this.posOfNew) {
                super.sameFrame(pos, offsetDelta);
                return;
            }
            super.sameLocals(pos, offsetDelta, stackTag, stackData);
        }

        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int n2 = stackTags.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (stackTags[i2] != 8 || stackData[i2] != this.posOfNew || stackTags[i2 + 1] != 8 || stackData[i2 + 1] != this.posOfNew) continue;
                int[] nArray = new int[++n2 - 2];
                int[] nArray2 = new int[n2 - 2];
                int n3 = 0;
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (i3 == i2) {
                        ++i3;
                        continue;
                    }
                    nArray[n3] = stackTags[i3];
                    nArray2[n3++] = stackData[i3];
                }
                stackTags = nArray;
                stackData = nArray2;
                break;
            }
            super.fullFrame(pos, offsetDelta, localTags, localData, stackTags, stackData);
        }
    }

    static class SwitchShifter
    extends Shifter {
        SwitchShifter(StackMapTable smt, int where, int gap) {
            super(smt, where, gap, false);
        }

        @Override
        void update(int pos, int offsetDelta, int base, int entry) {
            int n2;
            int n3;
            this.position = n3 + offsetDelta + ((n3 = this.position) == 0 ? 0 : 1);
            if (this.where == this.position) {
                n2 = offsetDelta - this.gap;
            } else if (this.where == n3) {
                n2 = offsetDelta + this.gap;
            } else {
                return;
            }
            if (offsetDelta < 64) {
                if (n2 < 64) {
                    this.info[pos] = (byte)(n2 + base);
                    return;
                }
                byte[] byArray = SwitchShifter.insertGap(this.info, pos, 2);
                byte[] byArray2 = byArray;
                byArray[pos] = (byte)entry;
                ByteArray.write16bit(n2, byArray2, pos + 1);
                this.updatedInfo = byArray2;
                return;
            }
            if (n2 < 64) {
                byte[] byArray = SwitchShifter.deleteGap(this.info, pos, 2);
                byte[] byArray3 = byArray;
                byArray[pos] = (byte)(n2 + base);
                this.updatedInfo = byArray3;
                return;
            }
            ByteArray.write16bit(n2, this.info, pos + 1);
        }

        static byte[] deleteGap(byte[] info, int where, int gap) {
            where += gap;
            int n2 = info.length;
            byte[] byArray = new byte[n2 - gap];
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = i2;
                byArray[n3 - (n3 < where ? 0 : gap)] = info[i2];
            }
            return byArray;
        }

        @Override
        void update(int pos, int offsetDelta) {
            int n2;
            int n3;
            this.position = n3 + offsetDelta + ((n3 = this.position) == 0 ? 0 : 1);
            if (this.where == this.position) {
                n2 = offsetDelta - this.gap;
            } else if (this.where == n3) {
                n2 = offsetDelta + this.gap;
            } else {
                return;
            }
            ByteArray.write16bit(n2, this.info, pos + 1);
        }
    }

    static class Shifter
    extends Walker {
        private StackMapTable stackMap;
        int where;
        int gap;
        int position;
        byte[] updatedInfo;
        boolean exclusive;

        public Shifter(StackMapTable smt, int where, int gap, boolean exclusive) {
            super(smt);
            this.stackMap = smt;
            this.where = where;
            this.gap = gap;
            this.position = 0;
            this.updatedInfo = null;
            this.exclusive = exclusive;
        }

        public void doit() throws BadBytecode {
            this.parse();
            if (this.updatedInfo != null) {
                this.stackMap.set(this.updatedInfo);
            }
        }

        @Override
        public void sameFrame(int pos, int offsetDelta) {
            this.update(pos, offsetDelta, 0, 251);
        }

        @Override
        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) {
            this.update(pos, offsetDelta, 64, 247);
        }

        void update(int pos, int offsetDelta, int base, int entry) {
            boolean bl;
            int n2;
            this.position = n2 + offsetDelta + ((n2 = this.position) == 0 ? 0 : 1);
            if (this.exclusive) {
                bl = n2 < this.where && this.where <= this.position;
            } else {
                boolean bl2 = bl = n2 <= this.where && this.where < this.position;
            }
            if (bl) {
                int n3 = offsetDelta + this.gap;
                this.position += this.gap;
                if (n3 < 64) {
                    this.info[pos] = (byte)(n3 + base);
                    return;
                }
                if (offsetDelta < 64) {
                    byte[] byArray = Shifter.insertGap(this.info, pos, 2);
                    byte[] byArray2 = byArray;
                    byArray[pos] = (byte)entry;
                    ByteArray.write16bit(n3, byArray2, pos + 1);
                    this.updatedInfo = byArray2;
                    return;
                }
                ByteArray.write16bit(n3, this.info, pos + 1);
            }
        }

        static byte[] insertGap(byte[] info, int where, int gap) {
            int n2 = info.length;
            byte[] byArray = new byte[n2 + gap];
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = i2;
                byArray[n3 + (n3 < where ? 0 : gap)] = info[i2];
            }
            return byArray;
        }

        @Override
        public void chopFrame(int pos, int offsetDelta, int k2) {
            this.update(pos, offsetDelta);
        }

        @Override
        public void appendFrame(int pos, int offsetDelta, int[] tags, int[] data) {
            this.update(pos, offsetDelta);
        }

        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            this.update(pos, offsetDelta);
        }

        void update(int pos, int offsetDelta) {
            boolean bl;
            int n2;
            this.position = n2 + offsetDelta + ((n2 = this.position) == 0 ? 0 : 1);
            if (this.exclusive) {
                bl = n2 < this.where && this.where <= this.position;
            } else {
                boolean bl2 = bl = n2 <= this.where && this.where < this.position;
            }
            if (bl) {
                int n3 = offsetDelta + this.gap;
                ByteArray.write16bit(n3, this.info, pos + 1);
                this.position += this.gap;
            }
        }
    }

    static class OffsetShifter
    extends Walker {
        int where;
        int gap;

        public OffsetShifter(StackMapTable smt, int where, int gap) {
            super(smt);
            this.where = where;
            this.gap = gap;
        }

        @Override
        public void objectOrUninitialized(int tag, int data, int pos) {
            if (tag == 8 && this.where <= data) {
                ByteArray.write16bit(data + this.gap, this.info, pos);
            }
        }
    }

    static class Printer
    extends Walker {
        private PrintWriter writer;
        private int offset;

        public static void print(StackMapTable smt, PrintWriter writer) {
            try {
                new Printer(smt.get(), writer).parse();
                return;
            }
            catch (BadBytecode badBytecode) {
                writer.println(badBytecode.getMessage());
                return;
            }
        }

        Printer(byte[] data, PrintWriter pw) {
            super(data);
            this.writer = pw;
            this.offset = -1;
        }

        @Override
        public void sameFrame(int pos, int offsetDelta) {
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " same frame: " + offsetDelta);
        }

        @Override
        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) {
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " same locals: " + offsetDelta);
            this.printTypeInfo(stackTag, stackData);
        }

        @Override
        public void chopFrame(int pos, int offsetDelta, int k2) {
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " chop frame: " + offsetDelta + ",    " + k2 + " last locals");
        }

        @Override
        public void appendFrame(int pos, int offsetDelta, int[] tags, int[] data) {
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " append frame: " + offsetDelta);
            for (int i2 = 0; i2 < tags.length; ++i2) {
                this.printTypeInfo(tags[i2], data[i2]);
            }
        }

        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int n2;
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " full frame: " + offsetDelta);
            this.writer.println("[locals]");
            for (n2 = 0; n2 < localTags.length; ++n2) {
                this.printTypeInfo(localTags[n2], localData[n2]);
            }
            this.writer.println("[stack]");
            for (n2 = 0; n2 < stackTags.length; ++n2) {
                this.printTypeInfo(stackTags[n2], stackData[n2]);
            }
        }

        private void printTypeInfo(int tag, int data) {
            String string = null;
            switch (tag) {
                case 0: {
                    string = "top";
                    break;
                }
                case 1: {
                    string = "integer";
                    break;
                }
                case 2: {
                    string = "float";
                    break;
                }
                case 3: {
                    string = "double";
                    break;
                }
                case 4: {
                    string = "long";
                    break;
                }
                case 5: {
                    string = "null";
                    break;
                }
                case 6: {
                    string = "this";
                    break;
                }
                case 7: {
                    string = "object (cpool_index " + data + ")";
                    break;
                }
                case 8: {
                    string = "uninitialized (offset " + data + ")";
                }
            }
            this.writer.print("    ");
            this.writer.println(string);
        }
    }

    public static class Writer {
        ByteArrayOutputStream output;
        int numOfEntries;

        public Writer(int size) {
            this.output = new ByteArrayOutputStream(size);
            this.numOfEntries = 0;
            this.output.write(0);
            this.output.write(0);
        }

        public byte[] toByteArray() {
            byte[] byArray = this.output.toByteArray();
            ByteArray.write16bit(this.numOfEntries, byArray, 0);
            return byArray;
        }

        public StackMapTable toStackMapTable(ConstPool cp) {
            return new StackMapTable(cp, this.toByteArray());
        }

        public void sameFrame(int offsetDelta) {
            ++this.numOfEntries;
            if (offsetDelta < 64) {
                this.output.write(offsetDelta);
                return;
            }
            this.output.write(251);
            this.write16(offsetDelta);
        }

        public void sameLocals(int offsetDelta, int tag, int data) {
            ++this.numOfEntries;
            if (offsetDelta < 64) {
                this.output.write(offsetDelta + 64);
            } else {
                this.output.write(247);
                this.write16(offsetDelta);
            }
            this.writeTypeInfo(tag, data);
        }

        public void chopFrame(int offsetDelta, int k2) {
            ++this.numOfEntries;
            this.output.write(251 - k2);
            this.write16(offsetDelta);
        }

        public void appendFrame(int offsetDelta, int[] tags, int[] data) {
            ++this.numOfEntries;
            int n2 = tags.length;
            this.output.write(n2 + 251);
            this.write16(offsetDelta);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.writeTypeInfo(tags[i2], data[i2]);
            }
        }

        public void fullFrame(int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int n2;
            ++this.numOfEntries;
            this.output.write(255);
            this.write16(offsetDelta);
            int n3 = localTags.length;
            this.write16(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.writeTypeInfo(localTags[n2], localData[n2]);
            }
            n3 = stackTags.length;
            this.write16(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                this.writeTypeInfo(stackTags[n2], stackData[n2]);
            }
        }

        private void writeTypeInfo(int tag, int data) {
            this.output.write(tag);
            if (tag == 7 || tag == 8) {
                this.write16(data);
            }
        }

        private void write16(int value) {
            this.output.write(value >>> 8 & 0xFF);
            this.output.write(value & 0xFF);
        }
    }

    static class InsertLocal
    extends SimpleCopy {
        private int varIndex;
        private int varTag;
        private int varData;

        public InsertLocal(byte[] data, int varIndex, int varTag, int varData) {
            super(data);
            this.varIndex = varIndex;
            this.varTag = varTag;
            this.varData = varData;
        }

        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int n2 = localTags.length;
            if (n2 < this.varIndex) {
                super.fullFrame(pos, offsetDelta, localTags, localData, stackTags, stackData);
                return;
            }
            int n3 = this.varTag == 4 || this.varTag == 3 ? 2 : 1;
            int[] nArray = new int[n2 + n3];
            int[] nArray2 = new int[n2 + n3];
            int n4 = this.varIndex;
            int n5 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (n5 == n4) {
                    n5 += n3;
                }
                nArray[n5] = localTags[i2];
                nArray2[n5++] = localData[i2];
            }
            nArray[n4] = this.varTag;
            nArray2[n4] = this.varData;
            if (n3 > 1) {
                nArray[n4 + 1] = 0;
                nArray2[n4 + 1] = 0;
            }
            super.fullFrame(pos, offsetDelta, nArray, nArray2, stackTags, stackData);
        }
    }

    static class Copier
    extends SimpleCopy {
        private ConstPool srcPool;
        private ConstPool destPool;
        private Map<String, String> classnames;

        public Copier(ConstPool src, byte[] data, ConstPool dest, Map<String, String> names) {
            super(data);
            this.srcPool = src;
            this.destPool = dest;
            this.classnames = names;
        }

        @Override
        protected int copyData(int tag, int data) {
            if (tag == 7) {
                return this.srcPool.copy(data, this.destPool, this.classnames);
            }
            return data;
        }

        @Override
        protected int[] copyData(int[] tags, int[] data) {
            int[] nArray = new int[data.length];
            for (int i2 = 0; i2 < data.length; ++i2) {
                nArray[i2] = tags[i2] == 7 ? this.srcPool.copy(data[i2], this.destPool, this.classnames) : data[i2];
            }
            return nArray;
        }
    }

    static class SimpleCopy
    extends Walker {
        private Writer writer;

        public SimpleCopy(byte[] data) {
            super(data);
            this.writer = new Writer(data.length);
        }

        public byte[] doit() throws BadBytecode {
            this.parse();
            return this.writer.toByteArray();
        }

        @Override
        public void sameFrame(int pos, int offsetDelta) {
            this.writer.sameFrame(offsetDelta);
        }

        @Override
        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) {
            this.writer.sameLocals(offsetDelta, stackTag, this.copyData(stackTag, stackData));
        }

        @Override
        public void chopFrame(int pos, int offsetDelta, int k2) {
            this.writer.chopFrame(offsetDelta, k2);
        }

        @Override
        public void appendFrame(int pos, int offsetDelta, int[] tags, int[] data) {
            this.writer.appendFrame(offsetDelta, tags, this.copyData(tags, data));
        }

        @Override
        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            this.writer.fullFrame(offsetDelta, localTags, this.copyData(localTags, localData), stackTags, this.copyData(stackTags, stackData));
        }

        protected int copyData(int tag, int data) {
            return data;
        }

        protected int[] copyData(int[] tags, int[] data) {
            return data;
        }
    }

    public static class Walker {
        byte[] info;
        int numOfEntries;

        public Walker(StackMapTable smt) {
            this(smt.get());
        }

        public Walker(byte[] data) {
            this.info = data;
            this.numOfEntries = ByteArray.readU16bit(data, 0);
        }

        public final int size() {
            return this.numOfEntries;
        }

        public void parse() throws BadBytecode {
            int n2 = this.numOfEntries;
            int n3 = 2;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = this.stackMapFrames(n3, i2);
            }
        }

        int stackMapFrames(int pos, int nth) throws BadBytecode {
            int n2 = this.info[pos] & 0xFF;
            if (n2 < 64) {
                this.sameFrame(pos, n2);
                ++pos;
            } else if (n2 < 128) {
                pos = this.sameLocals(pos, n2);
            } else {
                if (n2 < 247) {
                    throw new BadBytecode("bad frame_type in StackMapTable");
                }
                if (n2 == 247) {
                    pos = this.sameLocals(pos, n2);
                } else if (n2 < 251) {
                    int n3 = ByteArray.readU16bit(this.info, pos + 1);
                    this.chopFrame(pos, n3, 251 - n2);
                    pos += 3;
                } else if (n2 == 251) {
                    int n4 = ByteArray.readU16bit(this.info, pos + 1);
                    this.sameFrame(pos, n4);
                    pos += 3;
                } else {
                    pos = n2 < 255 ? this.appendFrame(pos, n2) : this.fullFrame(pos);
                }
            }
            return pos;
        }

        public void sameFrame(int pos, int offsetDelta) throws BadBytecode {
        }

        private int sameLocals(int pos, int type) throws BadBytecode {
            int n2;
            int n3 = pos;
            if (type < 128) {
                n2 = type - 64;
            } else {
                n2 = ByteArray.readU16bit(this.info, pos + 1);
                pos += 2;
            }
            int n4 = this.info[pos + 1] & 0xFF;
            int n5 = 0;
            if (n4 == 7 || n4 == 8) {
                n5 = ByteArray.readU16bit(this.info, pos + 2);
                this.objectOrUninitialized(n4, n5, pos + 2);
                pos += 2;
            }
            this.sameLocals(n3, n2, n4, n5);
            return pos + 2;
        }

        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) throws BadBytecode {
        }

        public void chopFrame(int pos, int offsetDelta, int k2) throws BadBytecode {
        }

        private int appendFrame(int pos, int type) throws BadBytecode {
            int n2 = type - 251;
            int n3 = ByteArray.readU16bit(this.info, pos + 1);
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int n4 = pos + 3;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5;
                nArray[i2] = n5 = this.info[n4] & 0xFF;
                if (n5 == 7 || n5 == 8) {
                    nArray2[i2] = ByteArray.readU16bit(this.info, n4 + 1);
                    this.objectOrUninitialized(n5, nArray2[i2], n4 + 1);
                    n4 += 3;
                    continue;
                }
                nArray2[i2] = 0;
                ++n4;
            }
            this.appendFrame(pos, n3, nArray, nArray2);
            return n4;
        }

        public void appendFrame(int pos, int offsetDelta, int[] tags, int[] data) throws BadBytecode {
        }

        private int fullFrame(int pos) throws BadBytecode {
            int n2 = ByteArray.readU16bit(this.info, pos + 1);
            int n3 = ByteArray.readU16bit(this.info, pos + 3);
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            int n4 = this.verifyTypeInfo(pos + 5, n3, nArray, nArray2);
            int n5 = ByteArray.readU16bit(this.info, n4);
            int[] nArray3 = new int[n5];
            int[] nArray4 = new int[n5];
            n4 = this.verifyTypeInfo(n4 + 2, n5, nArray3, nArray4);
            this.fullFrame(pos, n2, nArray, nArray2, nArray3, nArray4);
            return n4;
        }

        public void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) throws BadBytecode {
        }

        private int verifyTypeInfo(int pos, int n2, int[] tags, int[] data) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                tags[i2] = n3 = this.info[pos++] & 0xFF;
                if (n3 != 7 && n3 != 8) continue;
                data[i2] = ByteArray.readU16bit(this.info, pos);
                this.objectOrUninitialized(n3, data[i2], pos);
                pos += 2;
            }
            return pos;
        }

        public void objectOrUninitialized(int tag, int data, int pos) {
        }
    }

    public static class RuntimeCopyException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RuntimeCopyException(String s2) {
            super(s2);
        }
    }
}

