/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.AnnotationsAttribute;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.annotation.TypeAnnotationsWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TypeAnnotationsAttribute
extends AttributeInfo {
    public static final String visibleTag = "RuntimeVisibleTypeAnnotations";
    public static final String invisibleTag = "RuntimeInvisibleTypeAnnotations";

    public TypeAnnotationsAttribute(ConstPool cp, String attrname, byte[] info) {
        super(cp, attrname, info);
    }

    TypeAnnotationsAttribute(ConstPool cp, int n2, DataInputStream in) throws IOException {
        super(cp, n2, in);
    }

    public int numAnnotations() {
        return ByteArray.readU16bit(this.info, 0);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        Copier copier = new Copier(this.info, this.constPool, newCp, classnames);
        try {
            copier.annotationArray();
            return new TypeAnnotationsAttribute(newCp, this.getName(), copier.close());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    void renameClass(String oldname, String newname) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(oldname, newname);
        this.renameClass(hashMap);
    }

    @Override
    void renameClass(Map<String, String> classnames) {
        Renamer renamer = new Renamer(this.info, this.getConstPool(), classnames);
        try {
            renamer.annotationArray();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    void getRefClasses(Map<String, String> classnames) {
        this.renameClass(classnames);
    }

    static class SubCopier
    extends SubWalker {
        ConstPool srcPool;
        ConstPool destPool;
        Map<String, String> classnames;
        TypeAnnotationsWriter writer;

        SubCopier(byte[] attrInfo, ConstPool src, ConstPool dest, Map<String, String> map, TypeAnnotationsWriter w2) {
            super(attrInfo);
            this.srcPool = src;
            this.destPool = dest;
            this.classnames = map;
            this.writer = w2;
        }

        @Override
        void typeParameterTarget(int pos, int targetType, int typeParameterIndex) throws Exception {
            this.writer.typeParameterTarget(targetType, typeParameterIndex);
        }

        @Override
        void supertypeTarget(int pos, int superTypeIndex) throws Exception {
            this.writer.supertypeTarget(superTypeIndex);
        }

        @Override
        void typeParameterBoundTarget(int pos, int targetType, int typeParameterIndex, int boundIndex) throws Exception {
            this.writer.typeParameterBoundTarget(targetType, typeParameterIndex, boundIndex);
        }

        @Override
        void emptyTarget(int pos, int targetType) throws Exception {
            this.writer.emptyTarget(targetType);
        }

        @Override
        void formalParameterTarget(int pos, int formalParameterIndex) throws Exception {
            this.writer.formalParameterTarget(formalParameterIndex);
        }

        @Override
        void throwsTarget(int pos, int throwsTypeIndex) throws Exception {
            this.writer.throwsTarget(throwsTypeIndex);
        }

        @Override
        int localvarTarget(int pos, int targetType, int tableLength) throws Exception {
            this.writer.localVarTarget(targetType, tableLength);
            return super.localvarTarget(pos, targetType, tableLength);
        }

        @Override
        void localvarTarget(int pos, int targetType, int startPc, int length, int index) throws Exception {
            this.writer.localVarTargetTable(startPc, length, index);
        }

        @Override
        void catchTarget(int pos, int exceptionTableIndex) throws Exception {
            this.writer.catchTarget(exceptionTableIndex);
        }

        @Override
        void offsetTarget(int pos, int targetType, int offset) throws Exception {
            this.writer.offsetTarget(targetType, offset);
        }

        @Override
        void typeArgumentTarget(int pos, int targetType, int offset, int typeArgumentIndex) throws Exception {
            this.writer.typeArgumentTarget(targetType, offset, typeArgumentIndex);
        }

        @Override
        int typePath(int pos, int pathLength) throws Exception {
            this.writer.typePath(pathLength);
            return super.typePath(pos, pathLength);
        }

        @Override
        void typePath(int pos, int typePathKind, int typeArgumentIndex) throws Exception {
            this.writer.typePathPath(typePathKind, typeArgumentIndex);
        }
    }

    static class Copier
    extends AnnotationsAttribute.Copier {
        SubCopier sub;

        Copier(byte[] attrInfo, ConstPool src, ConstPool dest, Map<String, String> map) {
            super(attrInfo, src, dest, map, false);
            TypeAnnotationsWriter typeAnnotationsWriter = new TypeAnnotationsWriter(this.output, dest);
            this.writer = typeAnnotationsWriter;
            this.sub = new SubCopier(attrInfo, src, dest, map, typeAnnotationsWriter);
        }

        @Override
        int annotationArray(int pos, int num) throws Exception {
            this.writer.numAnnotations(num);
            for (int i2 = 0; i2 < num; ++i2) {
                int n2 = this.info[pos] & 0xFF;
                pos = this.sub.targetInfo(pos + 1, n2);
                pos = this.sub.typePath(pos);
                pos = this.annotation(pos);
            }
            return pos;
        }
    }

    static class Renamer
    extends AnnotationsAttribute.Renamer {
        SubWalker sub;

        Renamer(byte[] attrInfo, ConstPool cp, Map<String, String> map) {
            super(attrInfo, cp, map);
            this.sub = new SubWalker(attrInfo);
        }

        @Override
        int annotationArray(int pos, int num) throws Exception {
            for (int i2 = 0; i2 < num; ++i2) {
                int n2 = this.info[pos] & 0xFF;
                pos = this.sub.targetInfo(pos + 1, n2);
                pos = this.sub.typePath(pos);
                pos = this.annotation(pos);
            }
            return pos;
        }
    }

    static class SubWalker {
        byte[] info;

        SubWalker(byte[] attrInfo) {
            this.info = attrInfo;
        }

        final int targetInfo(int pos, int type) throws Exception {
            switch (type) {
                case 0: 
                case 1: {
                    int n2 = this.info[pos] & 0xFF;
                    this.typeParameterTarget(pos, type, n2);
                    return pos + 1;
                }
                case 16: {
                    int n3 = ByteArray.readU16bit(this.info, pos);
                    this.supertypeTarget(pos, n3);
                    return pos + 2;
                }
                case 17: 
                case 18: {
                    int n4 = this.info[pos] & 0xFF;
                    int n5 = this.info[pos + 1] & 0xFF;
                    this.typeParameterBoundTarget(pos, type, n4, n5);
                    return pos + 2;
                }
                case 19: 
                case 20: 
                case 21: {
                    this.emptyTarget(pos, type);
                    return pos;
                }
                case 22: {
                    int n6 = this.info[pos] & 0xFF;
                    this.formalParameterTarget(pos, n6);
                    return pos + 1;
                }
                case 23: {
                    int n7 = ByteArray.readU16bit(this.info, pos);
                    this.throwsTarget(pos, n7);
                    return pos + 2;
                }
                case 64: 
                case 65: {
                    int n8 = ByteArray.readU16bit(this.info, pos);
                    return this.localvarTarget(pos + 2, type, n8);
                }
                case 66: {
                    int n9 = ByteArray.readU16bit(this.info, pos);
                    this.catchTarget(pos, n9);
                    return pos + 2;
                }
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    int n10 = ByteArray.readU16bit(this.info, pos);
                    this.offsetTarget(pos, type, n10);
                    return pos + 2;
                }
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: {
                    int n11 = ByteArray.readU16bit(this.info, pos);
                    int n12 = this.info[pos + 2] & 0xFF;
                    this.typeArgumentTarget(pos, type, n11, n12);
                    return pos + 3;
                }
            }
            throw new RuntimeException("invalid target type: " + type);
        }

        void typeParameterTarget(int pos, int targetType, int typeParameterIndex) throws Exception {
        }

        void supertypeTarget(int pos, int superTypeIndex) throws Exception {
        }

        void typeParameterBoundTarget(int pos, int targetType, int typeParameterIndex, int boundIndex) throws Exception {
        }

        void emptyTarget(int pos, int targetType) throws Exception {
        }

        void formalParameterTarget(int pos, int formalParameterIndex) throws Exception {
        }

        void throwsTarget(int pos, int throwsTypeIndex) throws Exception {
        }

        int localvarTarget(int pos, int targetType, int tableLength) throws Exception {
            for (int i2 = 0; i2 < tableLength; ++i2) {
                int n2 = ByteArray.readU16bit(this.info, pos);
                int n3 = ByteArray.readU16bit(this.info, pos + 2);
                int n4 = ByteArray.readU16bit(this.info, pos + 4);
                this.localvarTarget(pos, targetType, n2, n3, n4);
                pos += 6;
            }
            return pos;
        }

        void localvarTarget(int pos, int targetType, int startPc, int length, int index) throws Exception {
        }

        void catchTarget(int pos, int exceptionTableIndex) throws Exception {
        }

        void offsetTarget(int pos, int targetType, int offset) throws Exception {
        }

        void typeArgumentTarget(int pos, int targetType, int offset, int typeArgumentIndex) throws Exception {
        }

        final int typePath(int pos) throws Exception {
            int n2 = this.info[pos++] & 0xFF;
            return this.typePath(pos, n2);
        }

        int typePath(int pos, int pathLength) throws Exception {
            for (int i2 = 0; i2 < pathLength; ++i2) {
                int n2 = this.info[pos] & 0xFF;
                int n3 = this.info[pos + 1] & 0xFF;
                this.typePath(pos, n2, n3);
                pos += 2;
            }
            return pos;
        }

        void typePath(int pos, int typePathKind, int typeArgumentIndex) throws Exception {
        }
    }

    static class TAWalker
    extends AnnotationsAttribute.Walker {
        SubWalker subWalker;

        TAWalker(byte[] attrInfo) {
            super(attrInfo);
            this.subWalker = new SubWalker(attrInfo);
        }

        @Override
        int annotationArray(int pos, int num) throws Exception {
            for (int i2 = 0; i2 < num; ++i2) {
                int n2 = this.info[pos] & 0xFF;
                pos = this.subWalker.targetInfo(pos + 1, n2);
                pos = this.subWalker.typePath(pos);
                pos = this.annotation(pos);
            }
            return pos;
        }
    }
}

