/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.analysis;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.ExceptionTable;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.bytecode.analysis.Executor;
import ai.h2o.javassist.bytecode.analysis.Frame;
import ai.h2o.javassist.bytecode.analysis.IntQueue;
import ai.h2o.javassist.bytecode.analysis.Subroutine;
import ai.h2o.javassist.bytecode.analysis.SubroutineScanner;
import ai.h2o.javassist.bytecode.analysis.Type;
import ai.h2o.javassist.bytecode.analysis.Util;

public class Analyzer
implements Opcode {
    private final SubroutineScanner scanner = new SubroutineScanner();
    private CtClass clazz;
    private ExceptionInfo[] exceptions;
    private Frame[] frames;
    private Subroutine[] subroutines;

    public Frame[] analyze(CtClass clazz, MethodInfo method) throws BadBytecode {
        this.clazz = clazz;
        CodeAttribute codeAttribute = method.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        int n2 = codeAttribute.getMaxLocals();
        int n3 = codeAttribute.getMaxStack();
        int n4 = codeAttribute.getCodeLength();
        CodeIterator codeIterator = codeAttribute.iterator();
        IntQueue intQueue = new IntQueue();
        this.exceptions = this.buildExceptionInfo(method);
        this.subroutines = this.scanner.scan(method);
        Executor executor = new Executor(clazz.getClassPool(), method.getConstPool());
        this.frames = new Frame[n4];
        this.frames[codeIterator.lookAhead()] = this.firstFrame(method, n2, n3);
        intQueue.add(codeIterator.next());
        while (!intQueue.isEmpty()) {
            this.analyzeNextEntry(method, codeIterator, intQueue, executor);
        }
        return this.frames;
    }

    public Frame[] analyze(CtMethod method) throws BadBytecode {
        return this.analyze(method.getDeclaringClass(), method.getMethodInfo2());
    }

    private void analyzeNextEntry(MethodInfo method, CodeIterator iter, IntQueue queue, Executor executor) throws BadBytecode {
        int n2 = queue.take();
        iter.move(n2);
        iter.next();
        Frame frame = this.frames[n2].copy();
        Subroutine subroutine = this.subroutines[n2];
        try {
            executor.execute(method, n2, iter, frame, subroutine);
        }
        catch (RuntimeException runtimeException) {
            throw new BadBytecode(runtimeException.getMessage() + "[pos = " + n2 + "]", (Throwable)runtimeException);
        }
        int n3 = iter.byteAt(n2);
        if (n3 == 170) {
            this.mergeTableSwitch(queue, n2, iter, frame);
        } else if (n3 == 171) {
            this.mergeLookupSwitch(queue, n2, iter, frame);
        } else if (n3 == 169) {
            this.mergeRet(queue, iter, n2, frame, subroutine);
        } else if (Util.isJumpInstruction(n3)) {
            int n4 = Util.getJumpTarget(n2, iter);
            if (Util.isJsr(n3)) {
                this.mergeJsr(queue, this.frames[n2], this.subroutines[n4], n2, this.lookAhead(iter, n2));
            } else if (!Util.isGoto(n3)) {
                this.merge(queue, frame, this.lookAhead(iter, n2));
            }
            this.merge(queue, frame, n4);
        } else if (n3 != 191 && !Util.isReturn(n3)) {
            this.merge(queue, frame, this.lookAhead(iter, n2));
        }
        this.mergeExceptionHandlers(queue, method, n2, frame);
    }

    private ExceptionInfo[] buildExceptionInfo(MethodInfo method) {
        ConstPool constPool = method.getConstPool();
        ClassPool classPool = this.clazz.getClassPool();
        ExceptionTable exceptionTable = method.getCodeAttribute().getExceptionTable();
        ExceptionInfo[] exceptionInfoArray = new ExceptionInfo[exceptionTable.size()];
        for (int i2 = 0; i2 < exceptionTable.size(); ++i2) {
            Type type;
            int n2 = exceptionTable.catchType(i2);
            try {
                type = n2 == 0 ? Type.THROWABLE : Type.get(classPool.get(constPool.getClassInfo(n2)));
            }
            catch (NotFoundException notFoundException) {
                throw new IllegalStateException(notFoundException.getMessage());
            }
            exceptionInfoArray[i2] = new ExceptionInfo(exceptionTable.startPc(i2), exceptionTable.endPc(i2), exceptionTable.handlerPc(i2), type);
        }
        return exceptionInfoArray;
    }

    private Frame firstFrame(MethodInfo method, int maxLocals, int maxStack) {
        CtClass[] ctClassArray;
        int n2 = 0;
        Frame frame = new Frame(maxLocals, maxStack);
        if ((method.getAccessFlags() & 8) == 0) {
            ++n2;
            frame.setLocal(0, Type.get(this.clazz));
        }
        try {
            ctClassArray = Descriptor.getParameterTypes(method.getDescriptor(), this.clazz.getClassPool());
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
        for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
            Type type = this.zeroExtend(Type.get(ctClassArray[i2]));
            frame.setLocal(n2++, type);
            if (type.getSize() != 2) continue;
            frame.setLocal(n2++, Type.TOP);
        }
        return frame;
    }

    private int getNext(CodeIterator iter, int of, int restore) throws BadBytecode {
        iter.move(of);
        iter.next();
        int n2 = iter.lookAhead();
        iter.move(restore);
        iter.next();
        return n2;
    }

    private int lookAhead(CodeIterator iter, int pos) throws BadBytecode {
        if (!iter.hasNext()) {
            throw new BadBytecode("Execution falls off end! [pos = " + pos + "]");
        }
        return iter.lookAhead();
    }

    private void merge(IntQueue queue, Frame frame, int target) {
        boolean bl;
        Frame frame2 = this.frames[target];
        if (frame2 == null) {
            this.frames[target] = frame.copy();
            bl = true;
        } else {
            bl = frame2.merge(frame);
        }
        if (bl) {
            queue.add(target);
        }
    }

    private void mergeExceptionHandlers(IntQueue queue, MethodInfo method, int pos, Frame frame) {
        for (int i2 = 0; i2 < this.exceptions.length; ++i2) {
            ExceptionInfo exceptionInfo = this.exceptions[i2];
            if (pos < exceptionInfo.start || pos >= exceptionInfo.end) continue;
            Frame frame2 = frame.copy();
            frame2.clearStack();
            frame2.push(exceptionInfo.type);
            this.merge(queue, frame2, exceptionInfo.handler);
        }
    }

    private void mergeJsr(IntQueue queue, Frame frame, Subroutine sub, int pos, int next) throws BadBytecode {
        if (sub == null) {
            throw new BadBytecode("No subroutine at jsr target! [pos = " + pos + "]");
        }
        Frame frame2 = this.frames[next];
        boolean bl = false;
        if (frame2 == null) {
            frame2 = this.frames[next] = frame.copy();
            bl = true;
        } else {
            for (int i2 = 0; i2 < frame.localsLength(); ++i2) {
                if (sub.isAccessed(i2)) continue;
                Type type = frame2.getLocal(i2);
                Type type2 = frame.getLocal(i2);
                if (type == null) {
                    frame2.setLocal(i2, type2);
                } else {
                    type2 = type.merge(type2);
                    frame2.setLocal(i2, type2);
                    if (type2.equals(type) && !type2.popChanged()) continue;
                }
                bl = true;
            }
        }
        if (!frame2.isJsrMerged()) {
            frame2.setJsrMerged(true);
            bl = true;
        }
        if (bl && frame2.isRetMerged()) {
            queue.add(next);
        }
    }

    private void mergeLookupSwitch(IntQueue queue, int pos, CodeIterator iter, Frame frame) throws BadBytecode {
        int n2 = (pos & 0xFFFFFFFC) + 4;
        this.merge(queue, frame, pos + iter.s32bitAt(n2));
        int n3 = iter.s32bitAt(n2 += 4);
        int n4 = (n3 << 3) + (n2 += 4);
        n2 += 4;
        while (n2 < n4) {
            int n5 = iter.s32bitAt(n2) + pos;
            this.merge(queue, frame, n5);
            n2 += 8;
        }
    }

    private void mergeRet(IntQueue queue, CodeIterator iter, int pos, Frame frame, Subroutine subroutine) throws BadBytecode {
        if (subroutine == null) {
            throw new BadBytecode("Ret on no subroutine! [pos = " + pos + "]");
        }
        for (int n2 : subroutine.callers()) {
            boolean bl;
            int n3 = this.getNext(iter, n2, pos);
            Frame frame2 = this.frames[n3];
            if (frame2 == null) {
                frame2 = this.frames[n3] = frame.copyStack();
                bl = true;
            } else {
                bl = frame2.mergeStack(frame);
            }
            for (int n4 : subroutine.accessed()) {
                Type type;
                Type type2 = frame2.getLocal(n4);
                if (type2 == (type = frame.getLocal(n4))) continue;
                frame2.setLocal(n4, type);
                bl = true;
            }
            if (!frame2.isRetMerged()) {
                frame2.setRetMerged(true);
                bl = true;
            }
            if (!bl || !frame2.isJsrMerged()) continue;
            queue.add(n3);
        }
    }

    private void mergeTableSwitch(IntQueue queue, int pos, CodeIterator iter, Frame frame) throws BadBytecode {
        int n2 = (pos & 0xFFFFFFFC) + 4;
        this.merge(queue, frame, pos + iter.s32bitAt(n2));
        int n3 = iter.s32bitAt(n2 += 4);
        int n4 = iter.s32bitAt(n2 += 4);
        int n5 = (n4 - n3 + 1 << 2) + (n2 += 4);
        while (n2 < n5) {
            int n6 = iter.s32bitAt(n2) + pos;
            this.merge(queue, frame, n6);
            n2 += 4;
        }
    }

    private Type zeroExtend(Type type) {
        if (type == Type.SHORT || type == Type.BYTE || type == Type.CHAR || type == Type.BOOLEAN) {
            return Type.INTEGER;
        }
        return type;
    }

    private static class ExceptionInfo {
        private int end;
        private int handler;
        private int start;
        private Type type;

        private ExceptionInfo(int start, int end, int handler, Type type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

