/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.stackmap;

import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.stackmap.BasicBlock;
import ai.h2o.javassist.bytecode.stackmap.TypeData;
import ai.h2o.javassist.bytecode.stackmap.TypeTag;

public class TypedBlock
extends BasicBlock {
    public int stackTop;
    public int numLocals;
    public TypeData[] localsTypes = null;
    public TypeData[] stackTypes;

    public static TypedBlock[] makeBlocks(MethodInfo minfo, CodeAttribute ca, boolean optimize) throws BadBytecode {
        TypedBlock[] typedBlockArray = (TypedBlock[])new Maker().make(minfo);
        if (optimize && typedBlockArray.length < 2 && (typedBlockArray.length == 0 || typedBlockArray[0].incoming == 0)) {
            return null;
        }
        ConstPool constPool = minfo.getConstPool();
        boolean bl = (minfo.getAccessFlags() & 8) != 0;
        typedBlockArray[0].initFirstBlock(ca.getMaxStack(), ca.getMaxLocals(), constPool.getClassName(), minfo.getDescriptor(), bl, minfo.isConstructor());
        return typedBlockArray;
    }

    protected TypedBlock(int pos) {
        super(pos);
    }

    @Override
    protected void toString2(StringBuffer sbuf) {
        super.toString2(sbuf);
        sbuf.append(",\n stack={");
        this.printTypes(sbuf, this.stackTop, this.stackTypes);
        sbuf.append("}, locals={");
        this.printTypes(sbuf, this.numLocals, this.localsTypes);
        sbuf.append('}');
    }

    private void printTypes(StringBuffer sbuf, int size, TypeData[] types) {
        if (types == null) {
            return;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            TypeData typeData;
            if (i2 > 0) {
                sbuf.append(", ");
            }
            sbuf.append((typeData = types[i2]) == null ? "<>" : typeData.toString());
        }
    }

    public boolean alreadySet() {
        return this.localsTypes != null;
    }

    public void setStackMap(int st, TypeData[] stack, int nl, TypeData[] locals) throws BadBytecode {
        this.stackTop = st;
        this.stackTypes = stack;
        this.numLocals = nl;
        this.localsTypes = locals;
    }

    public void resetNumLocals() {
        if (this.localsTypes != null) {
            int n2;
            for (n2 = this.localsTypes.length; !(n2 <= 0 || this.localsTypes[n2 - 1].isBasicType() != TypeTag.TOP || n2 > 1 && this.localsTypes[n2 - 2].is2WordType()); --n2) {
            }
            this.numLocals = n2;
        }
    }

    void initFirstBlock(int maxStack, int maxLocals, String className, String methodDesc, boolean isStatic, boolean isConstructor) throws BadBytecode {
        if (methodDesc.charAt(0) != '(') {
            throw new BadBytecode("no method descriptor: " + methodDesc);
        }
        this.stackTop = 0;
        this.stackTypes = TypeData.make(maxStack);
        TypeData[] typeDataArray = TypeData.make(maxLocals);
        if (isConstructor) {
            typeDataArray[0] = new TypeData.UninitThis(className);
        } else if (!isStatic) {
            typeDataArray[0] = new TypeData.ClassName(className);
        }
        int n2 = isStatic ? -1 : 0;
        int n3 = 1;
        try {
            while ((n3 = TypedBlock.descToTag(methodDesc, n3, ++n2, typeDataArray)) > 0) {
                if (!typeDataArray[n2].is2WordType()) continue;
                typeDataArray[++n2] = TypeTag.TOP;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new BadBytecode("bad method descriptor: " + methodDesc);
        }
        this.numLocals = n2;
        this.localsTypes = typeDataArray;
    }

    private static int descToTag(String desc, int i2, int n2, TypeData[] types) throws BadBytecode {
        int n3 = i2;
        int n4 = 0;
        char c2 = desc.charAt(i2);
        if (c2 == ')') {
            return 0;
        }
        while (c2 == '[') {
            ++n4;
            c2 = desc.charAt(++i2);
        }
        if (c2 == 'L') {
            int n5 = desc.indexOf(59, ++i2);
            types[n2] = n4 > 0 ? new TypeData.ClassName(desc.substring(n3, ++n5)) : new TypeData.ClassName(desc.substring(n3 + 1, ++n5 - 1).replace('/', '.'));
            return n5;
        }
        if (n4 > 0) {
            types[n2] = new TypeData.ClassName(desc.substring(n3, ++i2));
            return i2;
        }
        TypeData typeData = TypedBlock.toPrimitiveTag(c2);
        if (typeData == null) {
            throw new BadBytecode("bad method descriptor: " + desc);
        }
        types[n2] = typeData;
        return i2 + 1;
    }

    private static TypeData toPrimitiveTag(char c2) {
        switch (c2) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return TypeTag.INTEGER;
            }
            case 'J': {
                return TypeTag.LONG;
            }
            case 'F': {
                return TypeTag.FLOAT;
            }
            case 'D': {
                return TypeTag.DOUBLE;
            }
        }
        return null;
    }

    public static String getRetType(String desc) {
        int n2 = desc.indexOf(41);
        if (n2 < 0) {
            return "java.lang.Object";
        }
        char c2 = desc.charAt(n2 + 1);
        if (c2 == '[') {
            return desc.substring(n2 + 1);
        }
        if (c2 == 'L') {
            return desc.substring(n2 + 2, desc.length() - 1).replace('/', '.');
        }
        return "java.lang.Object";
    }

    public static class Maker
    extends BasicBlock.Maker {
        @Override
        protected BasicBlock makeBlock(int pos) {
            return new TypedBlock(pos);
        }

        @Override
        protected BasicBlock[] makeArray(int size) {
            return new TypedBlock[size];
        }
    }
}

