/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.AccessFlag;
import ai.h2o.javassist.bytecode.Bytecode;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.FieldInfo;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.compiler.AccessorMaker;
import ai.h2o.javassist.compiler.CodeGen;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.MemberResolver;
import ai.h2o.javassist.compiler.NoFieldException;
import ai.h2o.javassist.compiler.TypeChecker;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.ArrayInit;
import ai.h2o.javassist.compiler.ast.CallExpr;
import ai.h2o.javassist.compiler.ast.Declarator;
import ai.h2o.javassist.compiler.ast.Expr;
import ai.h2o.javassist.compiler.ast.Keyword;
import ai.h2o.javassist.compiler.ast.Member;
import ai.h2o.javassist.compiler.ast.MethodDecl;
import ai.h2o.javassist.compiler.ast.NewExpr;
import ai.h2o.javassist.compiler.ast.Pair;
import ai.h2o.javassist.compiler.ast.Stmnt;
import ai.h2o.javassist.compiler.ast.Symbol;
import java.util.ArrayList;
import java.util.List;

public class MemberCodeGen
extends CodeGen {
    protected MemberResolver resolver;
    protected CtClass thisClass;
    protected MethodInfo thisMethod;
    protected boolean resultStatic;

    public MemberCodeGen(Bytecode b2, CtClass cc, ClassPool cp) {
        super(b2);
        this.resolver = new MemberResolver(cp);
        this.thisClass = cc;
        this.thisMethod = null;
    }

    public int getMajorVersion() {
        ClassFile classFile = this.thisClass.getClassFile2();
        if (classFile == null) {
            return ClassFile.MAJOR_VERSION;
        }
        return classFile.getMajorVersion();
    }

    public void setThisMethod(CtMethod m2) {
        this.thisMethod = m2.getMethodInfo2();
        if (this.typeChecker != null) {
            this.typeChecker.setThisMethod(this.thisMethod);
        }
    }

    public CtClass getThisClass() {
        return this.thisClass;
    }

    @Override
    protected String getThisName() {
        return MemberResolver.javaToJvmName(this.thisClass.getName());
    }

    @Override
    protected String getSuperName() throws CompileError {
        return MemberResolver.javaToJvmName(MemberResolver.getSuperclass(this.thisClass).getName());
    }

    @Override
    protected void insertDefaultSuperCall() throws CompileError {
        this.bytecode.addAload(0);
        this.bytecode.addInvokespecial(MemberResolver.getSuperclass(this.thisClass), "<init>", "()V");
    }

    @Override
    protected void atTryStmnt(Stmnt st) throws CompileError {
        Bytecode bytecode = this.bytecode;
        Stmnt stmnt = (Stmnt)st.getLeft();
        if (stmnt == null) {
            return;
        }
        ASTList aSTList = (ASTList)st.getRight().getLeft();
        Stmnt stmnt2 = (Stmnt)st.getRight().getRight().getLeft();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        JsrHook jsrHook = null;
        if (stmnt2 != null) {
            jsrHook = new JsrHook(this);
        }
        int n2 = bytecode.currentPc();
        stmnt.accept(this);
        int n3 = bytecode.currentPc();
        if (n2 == n3) {
            throw new CompileError("empty try block");
        }
        boolean bl = !this.hasReturned;
        if (bl) {
            bytecode.addOpcode(167);
            arrayList.add(bytecode.currentPc());
            bytecode.addIndex(0);
        }
        int n4 = this.getMaxLocals();
        this.incMaxLocals(1);
        while (aSTList != null) {
            Pair pair = (Pair)aSTList.head();
            aSTList = aSTList.tail();
            Declarator declarator = (Declarator)pair.getLeft();
            Stmnt stmnt3 = (Stmnt)pair.getRight();
            declarator.setLocalVar(n4);
            CtClass ctClass = this.resolver.lookupClassByJvmName(declarator.getClassName());
            declarator.setClassName(MemberResolver.javaToJvmName(ctClass.getName()));
            bytecode.addExceptionHandler(n2, n3, bytecode.currentPc(), ctClass);
            bytecode.growStack(1);
            bytecode.addAstore(n4);
            this.hasReturned = false;
            if (stmnt3 != null) {
                stmnt3.accept(this);
            }
            if (this.hasReturned) continue;
            bytecode.addOpcode(167);
            arrayList.add(bytecode.currentPc());
            bytecode.addIndex(0);
            bl = true;
        }
        if (stmnt2 != null) {
            int n5;
            jsrHook.remove(this);
            int n6 = n5 = bytecode.currentPc();
            bytecode.addExceptionHandler(n2, n6, n6, 0);
            bytecode.growStack(1);
            bytecode.addAstore(n4);
            this.hasReturned = false;
            stmnt2.accept(this);
            if (!this.hasReturned) {
                bytecode.addAload(n4);
                bytecode.addOpcode(191);
            }
            this.addFinally(jsrHook.jsrList, stmnt2);
        }
        int n7 = bytecode.currentPc();
        this.patchGoto(arrayList, n7);
        boolean bl2 = this.hasReturned = !bl;
        if (stmnt2 != null && bl) {
            stmnt2.accept(this);
        }
    }

    private void addFinally(List<int[]> returnList, Stmnt finallyBlock) throws CompileError {
        Bytecode bytecode = this.bytecode;
        for (int[] nArray : returnList) {
            int n2 = nArray[0];
            bytecode.write16bit(n2, bytecode.currentPc() - n2 + 1);
            JsrHook2 jsrHook2 = new JsrHook2(this, nArray);
            finallyBlock.accept(this);
            jsrHook2.remove(this);
            if (this.hasReturned) continue;
            bytecode.addOpcode(167);
            bytecode.addIndex(n2 + 3 - bytecode.currentPc());
        }
    }

    @Override
    public void atNewExpr(NewExpr expr) throws CompileError {
        if (expr.isArray()) {
            this.atNewArrayExpr(expr);
            return;
        }
        CtClass ctClass = this.resolver.lookupClassByName(expr.getClassName());
        String string = ctClass.getName();
        ASTList aSTList = expr.getArguments();
        this.bytecode.addNew(string);
        this.bytecode.addOpcode(89);
        this.atMethodCallCore(ctClass, "<init>", aSTList, false, true, -1, null);
        this.exprType = 307;
        this.arrayDim = 0;
        this.className = MemberResolver.javaToJvmName(string);
    }

    public void atNewArrayExpr(NewExpr expr) throws CompileError {
        int n2 = expr.getArrayType();
        ASTList aSTList = expr.getArraySize();
        ASTList aSTList2 = expr.getClassName();
        ArrayInit arrayInit = expr.getInitializer();
        if (aSTList.length() > 1) {
            if (arrayInit != null) {
                throw new CompileError("sorry, multi-dimensional array initializer for new is not supported");
            }
            this.atMultiNewArray(n2, aSTList2, aSTList);
            return;
        }
        ASTree aSTree = aSTList.head();
        this.atNewArrayExpr2(n2, aSTree, Declarator.astToClassName(aSTList2, '/'), arrayInit);
    }

    private void atNewArrayExpr2(int type, ASTree sizeExpr, String jvmClassname, ArrayInit init) throws CompileError {
        int n2;
        String string;
        if (init == null) {
            if (sizeExpr == null) {
                throw new CompileError("no array size");
            }
            sizeExpr.accept(this);
        } else if (sizeExpr == null) {
            int n3 = init.length();
            this.bytecode.addIconst(n3);
        } else {
            throw new CompileError("unnecessary array size specified for new");
        }
        if (type == 307) {
            string = this.resolveClassName(jvmClassname);
            this.bytecode.addAnewarray(MemberResolver.jvmToJavaName(string));
        } else {
            string = null;
            n2 = 0;
            switch (type) {
                case 301: {
                    n2 = 4;
                    break;
                }
                case 306: {
                    n2 = 5;
                    break;
                }
                case 317: {
                    n2 = 6;
                    break;
                }
                case 312: {
                    n2 = 7;
                    break;
                }
                case 303: {
                    n2 = 8;
                    break;
                }
                case 334: {
                    n2 = 9;
                    break;
                }
                case 324: {
                    n2 = 10;
                    break;
                }
                case 326: {
                    n2 = 11;
                    break;
                }
                default: {
                    MemberCodeGen.badNewExpr();
                }
            }
            this.bytecode.addOpcode(188);
            this.bytecode.add(n2);
        }
        if (init != null) {
            n2 = init.length();
            ASTList aSTList = init;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.bytecode.addOpcode(89);
                this.bytecode.addIconst(i2);
                aSTList.head().accept(this);
                if (!MemberCodeGen.isRefType(type)) {
                    MemberCodeGen memberCodeGen = this;
                    memberCodeGen.atNumCastExpr(memberCodeGen.exprType, type);
                }
                this.bytecode.addOpcode(MemberCodeGen.getArrayWriteOp(type, 0));
                aSTList = aSTList.tail();
            }
        }
        this.exprType = type;
        this.arrayDim = 1;
        this.className = string;
    }

    private static void badNewExpr() throws CompileError {
        throw new CompileError("bad new expression");
    }

    @Override
    protected void atArrayVariableAssign(ArrayInit init, int varType, int varArray, String varClass) throws CompileError {
        this.atNewArrayExpr2(varType, null, varClass, init);
    }

    @Override
    public void atArrayInit(ArrayInit init) throws CompileError {
        throw new CompileError("array initializer is not supported");
    }

    protected void atMultiNewArray(int type, ASTList classname, ASTList size) throws CompileError {
        Object object;
        int n2 = size.length();
        int n3 = 0;
        while (size != null && (object = size.head()) != null) {
            ++n3;
            ((ASTree)object).accept(this);
            if (this.exprType != 324) {
                throw new CompileError("bad type for array size");
            }
            size = size.tail();
        }
        this.exprType = type;
        this.arrayDim = n2;
        if (type == 307) {
            this.className = this.resolveClassName(classname);
            object = MemberCodeGen.toJvmArrayName(this.className, n2);
        } else {
            object = MemberCodeGen.toJvmTypeName(type, n2);
        }
        this.bytecode.addMultiNewarray((String)object, n3);
    }

    @Override
    public void atCallExpr(CallExpr expr) throws CompileError {
        String string = null;
        CtClass ctClass = null;
        ASTree aSTree = expr.oprand1();
        ASTList aSTList = (ASTList)expr.oprand2();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        MemberResolver.Method method = expr.getMethod();
        if (aSTree instanceof Member) {
            string = ((Member)aSTree).get();
            ctClass = this.thisClass;
            if (this.inStaticMethod || method != null && method.isStatic()) {
                bl = true;
            } else {
                n2 = this.bytecode.currentPc();
                this.bytecode.addAload(0);
            }
        } else if (aSTree instanceof Keyword) {
            bl2 = true;
            string = "<init>";
            ctClass = this.thisClass;
            if (this.inStaticMethod) {
                throw new CompileError("a constructor cannot be static");
            }
            this.bytecode.addAload(0);
            if (((Keyword)aSTree).get() == 336) {
                ctClass = MemberResolver.getSuperclass(ctClass);
            }
        } else if (aSTree instanceof Expr) {
            Expr expr2 = (Expr)aSTree;
            string = ((Symbol)expr2.oprand2()).get();
            int n3 = expr2.getOperator();
            if (n3 == 35) {
                ctClass = this.resolver.lookupClass(((Symbol)expr2.oprand1()).get(), false);
                bl = true;
            } else if (n3 == 46) {
                ASTree aSTree2 = expr2.oprand1();
                String string2 = TypeChecker.isDotSuper(aSTree2);
                if (string2 != null) {
                    bl2 = true;
                    ctClass = MemberResolver.getSuperInterface(this.thisClass, string2);
                    if (this.inStaticMethod || method != null && method.isStatic()) {
                        bl = true;
                    } else {
                        n2 = this.bytecode.currentPc();
                        this.bytecode.addAload(0);
                    }
                } else {
                    if (aSTree2 instanceof Keyword && ((Keyword)aSTree2).get() == 336) {
                        bl2 = true;
                    }
                    try {
                        aSTree2.accept(this);
                    }
                    catch (NoFieldException noFieldException) {
                        NoFieldException noFieldException2 = noFieldException;
                        if (noFieldException.getExpr() != aSTree2) {
                            throw noFieldException2;
                        }
                        this.exprType = 307;
                        this.arrayDim = 0;
                        this.className = noFieldException2.getField();
                        bl = true;
                    }
                    if (this.arrayDim > 0) {
                        ctClass = this.resolver.lookupClass("java.lang.Object", true);
                    } else if (this.exprType == 307) {
                        ctClass = this.resolver.lookupClassByJvmName(this.className);
                    } else {
                        MemberCodeGen.badMethod();
                    }
                }
            } else {
                MemberCodeGen.badMethod();
            }
        } else {
            MemberCodeGen.fatal();
        }
        this.atMethodCallCore(ctClass, string, aSTList, bl, bl2, n2, method);
    }

    private static void badMethod() throws CompileError {
        throw new CompileError("bad method");
    }

    public void atMethodCallCore(CtClass targetClass, String mname, ASTList args, boolean isStatic, boolean isSpecial, int aload0pos, MemberResolver.Method found) throws CompileError {
        int n2 = this.getMethodArgsLength(args);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        String[] stringArray = new String[n2];
        if (!isStatic && found != null && found.isStatic()) {
            this.bytecode.addOpcode(87);
            isStatic = true;
        }
        this.bytecode.getStackDepth();
        this.atMethodArgs(args, nArray, nArray2, stringArray);
        if (found == null) {
            found = this.resolver.lookupMethod(targetClass, this.thisClass, this.thisMethod, mname, nArray, nArray2, stringArray);
        }
        if (found == null) {
            String string = mname.equals("<init>") ? "constructor not found" : "Method " + mname + " not found in " + targetClass.getName();
            throw new CompileError(string);
        }
        this.atMethodCallCore2(targetClass, mname, isStatic, isSpecial, aload0pos, found);
    }

    private void atMethodCallCore2(CtClass targetClass, String mname, boolean isStatic, boolean isSpecial, int aload0pos, MemberResolver.Method found) throws CompileError {
        CtClass ctClass = found.declaring;
        MethodInfo methodInfo = found.info;
        String string = methodInfo.getDescriptor();
        int n2 = methodInfo.getAccessFlags();
        if (mname.equals("<init>")) {
            isSpecial = true;
            if (ctClass != targetClass) {
                throw new CompileError("no such constructor: " + targetClass.getName());
            }
            if (ctClass != this.thisClass && AccessFlag.isPrivate(n2)) {
                boolean bl = false;
                if (ctClass.getClassFile().getMajorVersion() >= 55) {
                    try {
                        CtClass[] ctClassArray = ctClass.getNestedClasses();
                        for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
                            if (this.thisClass != ctClassArray[i2]) continue;
                            bl = true;
                            break;
                        }
                    }
                    catch (NotFoundException notFoundException) {}
                }
                if (!bl) {
                    string = this.getAccessibleConstructor(string, ctClass, methodInfo);
                    this.bytecode.addOpcode(1);
                }
            }
        } else if (AccessFlag.isPrivate(n2)) {
            if (ctClass == this.thisClass) {
                isSpecial = true;
            } else {
                isSpecial = false;
                isStatic = true;
                String string2 = string;
                if ((n2 & 8) == 0) {
                    string = Descriptor.insertParameter(ctClass.getName(), string2);
                }
                n2 = AccessFlag.setPackage(n2) | 8;
                mname = this.getAccessiblePrivate(mname, string2, string, methodInfo, ctClass);
            }
        }
        boolean bl = false;
        if ((n2 & 8) != 0) {
            if (!isStatic) {
                isStatic = true;
                if (aload0pos >= 0) {
                    this.bytecode.write(aload0pos, 0);
                } else {
                    bl = true;
                }
            }
            this.bytecode.addInvokestatic(ctClass, mname, string);
        } else if (isSpecial) {
            this.bytecode.addInvokespecial(targetClass, mname, string);
        } else {
            if (!Modifier.isPublic(ctClass.getModifiers()) || ctClass.isInterface() != targetClass.isInterface()) {
                ctClass = targetClass;
            }
            if (ctClass.isInterface()) {
                int n3 = Descriptor.paramSize(string) + 1;
                this.bytecode.addInvokeinterface(ctClass, mname, string, n3);
            } else {
                if (isStatic) {
                    throw new CompileError(mname + " is not static");
                }
                this.bytecode.addInvokevirtual(ctClass, mname, string);
            }
        }
        this.setReturnType(string, isStatic, bl);
    }

    protected String getAccessiblePrivate(String methodName, String desc, String newDesc, MethodInfo minfo, CtClass declClass) throws CompileError {
        AccessorMaker accessorMaker;
        if (this.isEnclosing(declClass, this.thisClass) && (accessorMaker = declClass.getAccessorMaker()) != null) {
            return accessorMaker.getMethodAccessor(methodName, desc, newDesc, minfo);
        }
        throw new CompileError("Method " + methodName + " is private");
    }

    protected String getAccessibleConstructor(String desc, CtClass declClass, MethodInfo minfo) throws CompileError {
        AccessorMaker accessorMaker;
        if (this.isEnclosing(declClass, this.thisClass) && (accessorMaker = declClass.getAccessorMaker()) != null) {
            return accessorMaker.getConstructor(declClass, desc, minfo);
        }
        throw new CompileError("the called constructor is private in " + declClass.getName());
    }

    private boolean isEnclosing(CtClass outer, CtClass inner) {
        try {
            while (inner != null) {
                if ((inner = inner.getDeclaringClass()) != outer) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {}
        return false;
    }

    public int getMethodArgsLength(ASTList args) {
        return ASTList.length(args);
    }

    public void atMethodArgs(ASTList args, int[] types, int[] dims, String[] cnames) throws CompileError {
        int n2 = 0;
        while (args != null) {
            ASTree aSTree = args.head();
            aSTree.accept(this);
            types[n2] = this.exprType;
            dims[n2] = this.arrayDim;
            cnames[n2] = this.className;
            ++n2;
            args = args.tail();
        }
    }

    void setReturnType(String desc, boolean isStatic, boolean popTarget) throws CompileError {
        int n2;
        int n3 = desc.indexOf(41);
        if (n3 < 0) {
            MemberCodeGen.badMethod();
        }
        char c2 = desc.charAt(++n3);
        int n4 = 0;
        while (c2 == '[') {
            ++n4;
            c2 = desc.charAt(++n3);
        }
        this.arrayDim = n4;
        if (c2 == 'L') {
            n2 = desc.indexOf(59, n3 + 1);
            if (n2 < 0) {
                MemberCodeGen.badMethod();
            }
            this.exprType = 307;
            this.className = desc.substring(n3 + 1, n2);
        } else {
            this.exprType = MemberResolver.descToType(c2);
            this.className = null;
        }
        n2 = this.exprType;
        if (isStatic && popTarget) {
            if (MemberCodeGen.is2word(n2, n4)) {
                this.bytecode.addOpcode(93);
                this.bytecode.addOpcode(88);
                this.bytecode.addOpcode(87);
                return;
            }
            if (n2 == 344) {
                this.bytecode.addOpcode(87);
                return;
            }
            this.bytecode.addOpcode(95);
            this.bytecode.addOpcode(87);
        }
    }

    @Override
    protected void atFieldAssign(Expr expr, int op, ASTree left, ASTree right, boolean doDup) throws CompileError {
        int n2;
        CtField ctField = this.fieldAccess(left, false);
        boolean bl = this.resultStatic;
        if (op != 61 && !bl) {
            this.bytecode.addOpcode(89);
        }
        if (op == 61) {
            FieldInfo fieldInfo = ctField.getFieldInfo2();
            this.setFieldType(fieldInfo);
            AccessorMaker accessorMaker = this.isAccessibleField(ctField, fieldInfo);
            n2 = accessorMaker == null ? this.addFieldrefInfo(ctField, fieldInfo) : 0;
        } else {
            n2 = this.atFieldRead(ctField, bl);
        }
        int n3 = this.exprType;
        int n4 = this.arrayDim;
        String string = this.className;
        this.atAssignCore(expr, op, right, n3, n4, string);
        boolean bl2 = MemberCodeGen.is2word(n3, n4);
        if (doDup) {
            int n5 = bl ? (bl2 ? 92 : 89) : (bl2 ? 93 : 90);
            this.bytecode.addOpcode(n5);
        }
        this.atFieldAssignCore(ctField, bl, n2, bl2);
        this.exprType = n3;
        this.arrayDim = n4;
        this.className = string;
    }

    private void atFieldAssignCore(CtField f2, boolean is_static, int fi, boolean is2byte) throws CompileError {
        if (fi != 0) {
            if (is_static) {
                this.bytecode.add(179);
                this.bytecode.growStack(is2byte ? -2 : -1);
            } else {
                this.bytecode.add(181);
                this.bytecode.growStack(is2byte ? -3 : -2);
            }
            this.bytecode.addIndex(fi);
            return;
        }
        CtClass ctClass = f2.getDeclaringClass();
        AccessorMaker accessorMaker = ctClass.getAccessorMaker();
        FieldInfo fieldInfo = f2.getFieldInfo2();
        MethodInfo methodInfo = accessorMaker.getFieldSetter(fieldInfo, is_static);
        this.bytecode.addInvokestatic(ctClass, methodInfo.getName(), methodInfo.getDescriptor());
    }

    @Override
    public void atMember(Member mem) throws CompileError {
        this.atFieldRead(mem);
    }

    @Override
    protected void atFieldRead(ASTree expr) throws CompileError {
        CtField ctField = this.fieldAccess(expr, true);
        if (ctField == null) {
            this.atArrayLength(expr);
            return;
        }
        boolean bl = this.resultStatic;
        ASTree aSTree = TypeChecker.getConstantFieldValue(ctField);
        if (aSTree == null) {
            this.atFieldRead(ctField, bl);
            return;
        }
        aSTree.accept(this);
        this.setFieldType(ctField.getFieldInfo2());
    }

    private void atArrayLength(ASTree expr) throws CompileError {
        if (this.arrayDim == 0) {
            throw new CompileError(".length applied to a non array");
        }
        this.bytecode.addOpcode(190);
        this.exprType = 324;
        this.arrayDim = 0;
    }

    private int atFieldRead(CtField f2, boolean isStatic) throws CompileError {
        FieldInfo fieldInfo = f2.getFieldInfo2();
        boolean bl = this.setFieldType(fieldInfo);
        AccessorMaker accessorMaker = this.isAccessibleField(f2, fieldInfo);
        if (accessorMaker != null) {
            MethodInfo methodInfo = accessorMaker.getFieldGetter(fieldInfo, isStatic);
            this.bytecode.addInvokestatic(f2.getDeclaringClass(), methodInfo.getName(), methodInfo.getDescriptor());
            return 0;
        }
        int n2 = this.addFieldrefInfo(f2, fieldInfo);
        if (isStatic) {
            this.bytecode.add(178);
            this.bytecode.growStack(bl ? 2 : 1);
        } else {
            this.bytecode.add(180);
            this.bytecode.growStack(bl ? 1 : 0);
        }
        this.bytecode.addIndex(n2);
        return n2;
    }

    private AccessorMaker isAccessibleField(CtField f2, FieldInfo finfo) throws CompileError {
        if (AccessFlag.isPrivate(finfo.getAccessFlags()) && f2.getDeclaringClass() != this.thisClass) {
            AccessorMaker accessorMaker;
            CtClass ctClass = f2.getDeclaringClass();
            if (this.isEnclosing(ctClass, this.thisClass) && (accessorMaker = ctClass.getAccessorMaker()) != null) {
                return accessorMaker;
            }
            throw new CompileError("Field " + f2.getName() + " in " + ctClass.getName() + " is private.");
        }
        return null;
    }

    private boolean setFieldType(FieldInfo finfo) throws CompileError {
        String string = finfo.getDescriptor();
        int n2 = 0;
        int n3 = 0;
        char c2 = string.charAt(0);
        while (c2 == '[') {
            ++n3;
            c2 = string.charAt(++n2);
        }
        this.arrayDim = n3;
        this.exprType = MemberResolver.descToType(c2);
        this.className = c2 == 'L' ? string.substring(n2 + 1, string.indexOf(59, n2 + 1)) : null;
        boolean bl = n3 == 0 && (c2 == 'J' || c2 == 'D');
        return bl;
    }

    private int addFieldrefInfo(CtField f2, FieldInfo finfo) {
        ConstPool constPool = this.bytecode.getConstPool();
        String string = f2.getDeclaringClass().getName();
        int n2 = constPool.addClassInfo(string);
        String string2 = finfo.getName();
        String string3 = finfo.getDescriptor();
        return constPool.addFieldrefInfo(n2, string2, string3);
    }

    @Override
    protected void atClassObject2(String cname) throws CompileError {
        if (this.getMajorVersion() < 49) {
            super.atClassObject2(cname);
            return;
        }
        this.bytecode.addLdc(this.bytecode.getConstPool().addClassInfo(cname));
    }

    @Override
    protected void atFieldPlusPlus(int token, boolean isPost, ASTree oprand, Expr expr, boolean doDup) throws CompileError {
        CtField ctField = this.fieldAccess(oprand, false);
        boolean bl = this.resultStatic;
        if (!bl) {
            this.bytecode.addOpcode(89);
        }
        int n2 = this.atFieldRead(ctField, bl);
        int n3 = this.exprType;
        boolean bl2 = MemberCodeGen.is2word(n3, this.arrayDim);
        int n4 = bl ? (bl2 ? 92 : 89) : (bl2 ? 93 : 90);
        this.atPlusPlusCore(n4, doDup, token, isPost, expr);
        this.atFieldAssignCore(ctField, bl, n2, bl2);
    }

    protected CtField fieldAccess(ASTree expr, boolean acceptLength) throws CompileError {
        if (expr instanceof Member) {
            CtField ctField;
            String string = ((Member)expr).get();
            try {
                ctField = this.thisClass.getField(string);
            }
            catch (NotFoundException notFoundException) {
                throw new NoFieldException(string, expr);
            }
            boolean bl = Modifier.isStatic(ctField.getModifiers());
            if (!bl) {
                if (this.inStaticMethod) {
                    throw new CompileError("not available in a static method: " + string);
                }
                this.bytecode.addAload(0);
            }
            this.resultStatic = bl;
            return ctField;
        }
        if (expr instanceof Expr) {
            Expr expr2 = (Expr)expr;
            int n2 = expr2.getOperator();
            if (n2 == 35) {
                CtField ctField = this.resolver.lookupField(((Symbol)expr2.oprand1()).get(), (Symbol)expr2.oprand2());
                this.resultStatic = true;
                return ctField;
            }
            if (n2 == 46) {
                CtField ctField = null;
                try {
                    expr2.oprand1().accept(this);
                    if (this.exprType == 307 && this.arrayDim == 0) {
                        ctField = this.resolver.lookupFieldByJvmName(this.className, (Symbol)expr2.oprand2());
                    } else {
                        if (acceptLength && this.arrayDim > 0 && ((Symbol)expr2.oprand2()).get().equals("length")) {
                            return null;
                        }
                        MemberCodeGen.badLvalue();
                    }
                    boolean bl = Modifier.isStatic(ctField.getModifiers());
                    if (bl) {
                        this.bytecode.addOpcode(87);
                    }
                    this.resultStatic = bl;
                    return ctField;
                }
                catch (NoFieldException noFieldException) {
                    NoFieldException noFieldException2 = noFieldException;
                    if (noFieldException.getExpr() != expr2.oprand1()) {
                        throw noFieldException2;
                    }
                    Symbol symbol = (Symbol)expr2.oprand2();
                    String string = noFieldException2.getField();
                    ctField = this.resolver.lookupFieldByJvmName2(string, symbol, expr);
                    this.resultStatic = true;
                    return ctField;
                }
            }
            MemberCodeGen.badLvalue();
        } else {
            MemberCodeGen.badLvalue();
        }
        this.resultStatic = false;
        return null;
    }

    private static void badLvalue() throws CompileError {
        throw new CompileError("bad l-value");
    }

    public CtClass[] makeParamList(MethodDecl md) throws CompileError {
        CtClass[] ctClassArray;
        ASTList aSTList = md.getParams();
        if (aSTList == null) {
            ctClassArray = new CtClass[]{};
        } else {
            int n2 = 0;
            ctClassArray = new CtClass[aSTList.length()];
            while (aSTList != null) {
                ctClassArray[n2++] = this.resolver.lookupClass((Declarator)aSTList.head());
                aSTList = aSTList.tail();
            }
        }
        return ctClassArray;
    }

    public CtClass[] makeThrowsList(MethodDecl md) throws CompileError {
        ASTList aSTList = md.getThrows();
        if (aSTList == null) {
            return null;
        }
        int n2 = 0;
        CtClass[] ctClassArray = new CtClass[aSTList.length()];
        while (aSTList != null) {
            ctClassArray[n2++] = this.resolver.lookupClassByName((ASTList)aSTList.head());
            aSTList = aSTList.tail();
        }
        return ctClassArray;
    }

    @Override
    protected String resolveClassName(ASTList name) throws CompileError {
        return this.resolver.resolveClassName(name);
    }

    @Override
    protected String resolveClassName(String jvmName) throws CompileError {
        return this.resolver.resolveJvmClassName(jvmName);
    }

    static class JsrHook2
    extends CodeGen.ReturnHook {
        int var;
        int target;

        JsrHook2(CodeGen gen, int[] retTarget) {
            super(gen);
            this.target = retTarget[0];
            this.var = retTarget[1];
        }

        @Override
        protected boolean doit(Bytecode b2, int opcode) {
            switch (opcode) {
                case 177: {
                    break;
                }
                case 176: {
                    b2.addAstore(this.var);
                    break;
                }
                case 172: {
                    b2.addIstore(this.var);
                    break;
                }
                case 173: {
                    b2.addLstore(this.var);
                    break;
                }
                case 175: {
                    b2.addDstore(this.var);
                    break;
                }
                case 174: {
                    b2.addFstore(this.var);
                    break;
                }
                default: {
                    throw new RuntimeException("fatal");
                }
            }
            b2.addOpcode(167);
            b2.addIndex(this.target - b2.currentPc() + 3);
            return true;
        }
    }

    static class JsrHook
    extends CodeGen.ReturnHook {
        List<int[]> jsrList = new ArrayList<int[]>();
        CodeGen cgen;
        int var;

        JsrHook(CodeGen gen) {
            super(gen);
            this.cgen = gen;
            this.var = -1;
        }

        private int getVar(int size) {
            if (this.var < 0) {
                this.var = this.cgen.getMaxLocals();
                this.cgen.incMaxLocals(size);
            }
            return this.var;
        }

        private void jsrJmp(Bytecode b2) {
            b2.addOpcode(167);
            this.jsrList.add(new int[]{b2.currentPc(), this.var});
            b2.addIndex(0);
        }

        @Override
        protected boolean doit(Bytecode b2, int opcode) {
            switch (opcode) {
                case 177: {
                    this.jsrJmp(b2);
                    break;
                }
                case 176: {
                    b2.addAstore(this.getVar(1));
                    this.jsrJmp(b2);
                    b2.addAload(this.var);
                    break;
                }
                case 172: {
                    b2.addIstore(this.getVar(1));
                    this.jsrJmp(b2);
                    b2.addIload(this.var);
                    break;
                }
                case 173: {
                    b2.addLstore(this.getVar(2));
                    this.jsrJmp(b2);
                    b2.addLload(this.var);
                    break;
                }
                case 175: {
                    b2.addDstore(this.getVar(2));
                    this.jsrJmp(b2);
                    b2.addDload(this.var);
                    break;
                }
                case 174: {
                    b2.addFstore(this.getVar(1));
                    this.jsrJmp(b2);
                    b2.addFload(this.var);
                    break;
                }
                default: {
                    throw new RuntimeException("fatal");
                }
            }
            return false;
        }
    }
}

