/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.compiler;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.Modifier;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.compiler.CompileError;
import ai.h2o.javassist.compiler.NoFieldException;
import ai.h2o.javassist.compiler.TokenId;
import ai.h2o.javassist.compiler.ast.ASTList;
import ai.h2o.javassist.compiler.ast.ASTree;
import ai.h2o.javassist.compiler.ast.Declarator;
import ai.h2o.javassist.compiler.ast.Keyword;
import ai.h2o.javassist.compiler.ast.Symbol;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class MemberResolver
implements TokenId {
    private ClassPool classPool;
    private static final int YES = 0;
    private static final int NO = -1;
    private static final String INVALID = "<invalid>";
    private static Map<ClassPool, Reference<Map<String, String>>> invalidNamesMap = new WeakHashMap<ClassPool, Reference<Map<String, String>>>();
    private Map<String, String> invalidNames = null;

    public MemberResolver(ClassPool cp) {
        this.classPool = cp;
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    private static void fatal() throws CompileError {
        throw new CompileError("fatal");
    }

    public Method lookupMethod(CtClass clazz, CtClass currentClass, MethodInfo current, String methodName, int[] argTypes, int[] argDims, String[] argClassNames) throws CompileError {
        Method method;
        int n2;
        Method method2 = null;
        if (current != null && clazz == currentClass && current.getName().equals(methodName) && (n2 = this.compareSignature(current.getDescriptor(), argTypes, argDims, argClassNames)) != -1) {
            Method method3 = new Method(clazz, current, n2);
            if (n2 == 0) {
                return method3;
            }
            method2 = method3;
        }
        if ((method = this.lookupMethod(clazz, methodName, argTypes, argDims, argClassNames, method2 != null)) != null) {
            return method;
        }
        return method2;
    }

    private Method lookupMethod(CtClass clazz, String methodName, int[] argTypes, int[] argDims, String[] argClassNames, boolean onlyExact) throws CompileError {
        Method method = null;
        ClassFile classFile = clazz.getClassFile2();
        if (classFile != null) {
            List<MethodInfo> list = classFile.getMethods();
            for (MethodInfo object2 : list) {
                int n2;
                if (!object2.getName().equals(methodName) || (object2.getAccessFlags() & 0x40) != 0 || (n2 = this.compareSignature(object2.getDescriptor(), argTypes, argDims, argClassNames)) == -1) continue;
                Method method2 = new Method(clazz, object2, n2);
                if (n2 == 0) {
                    return method2;
                }
                if (method != null && method.notmatch <= n2) continue;
                method = method2;
            }
        }
        if (onlyExact) {
            method = null;
        } else if (method != null) {
            return method;
        }
        int n3 = clazz.getModifiers();
        boolean bl = Modifier.isInterface(n3);
        try {
            Method method3;
            CtClass ctClass;
            if (!bl && (ctClass = clazz.getSuperclass()) != null && (method3 = this.lookupMethod(ctClass, methodName, argTypes, argDims, argClassNames, onlyExact)) != null) {
                return method3;
            }
        }
        catch (NotFoundException notFoundException) {}
        try {
            Method method4;
            CtClass[] ctClassArray;
            Object object = ctClassArray = clazz.getInterfaces();
            int n4 = ctClassArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                CtClass ctClass = object[i2];
                Method method5 = this.lookupMethod(ctClass, methodName, argTypes, argDims, argClassNames, onlyExact);
                if (method5 == null) continue;
                return method5;
            }
            if (bl && (object = clazz.getSuperclass()) != null && (method4 = this.lookupMethod((CtClass)object, methodName, argTypes, argDims, argClassNames, onlyExact)) != null) {
                return method4;
            }
        }
        catch (NotFoundException notFoundException) {}
        return method;
    }

    private int compareSignature(String desc, int[] argTypes, int[] argDims, String[] argClassNames) throws CompileError {
        int n2 = 0;
        int n3 = 1;
        int n4 = argTypes.length;
        if (n4 != Descriptor.numOfParameters(desc)) {
            return -1;
        }
        int n5 = desc.length();
        int n6 = 0;
        while (n3 < n5) {
            int n7;
            char c2;
            if ((c2 = desc.charAt(n3++)) == ')') {
                if (n6 == n4) {
                    return n2;
                }
                return -1;
            }
            if (n6 >= n4) {
                return -1;
            }
            int n8 = 0;
            while (c2 == '[') {
                ++n8;
                c2 = desc.charAt(n3++);
            }
            if (argTypes[n6] == 412) {
                if (n8 == 0 && c2 != 'L') {
                    return -1;
                }
                if (c2 == 'L') {
                    n3 = desc.indexOf(59, n3) + 1;
                }
            } else if (argDims[n6] != n8) {
                if (n8 != 0 || c2 != 'L' || !desc.startsWith("java/lang/Object;", n3)) {
                    return -1;
                }
                n3 = desc.indexOf(59, n3) + 1;
                ++n2;
                if (n3 <= 0) {
                    return -1;
                }
            } else if (c2 == 'L') {
                block24: {
                    n7 = desc.indexOf(59, n3);
                    if (n7 < 0 || argTypes[n6] != 307) {
                        return -1;
                    }
                    String string = desc.substring(n3, n7);
                    if (!string.equals(argClassNames[n6])) {
                        CtClass ctClass = this.lookupClassByJvmName(argClassNames[n6]);
                        try {
                            if (ctClass.subtypeOf(this.lookupClassByJvmName(string))) {
                                ++n2;
                                break block24;
                            }
                            return -1;
                        }
                        catch (NotFoundException notFoundException) {
                            ++n2;
                        }
                    }
                }
                n3 = n7 + 1;
            } else {
                int n9;
                n7 = MemberResolver.descToType(c2);
                if (n7 != (n9 = argTypes[n6])) {
                    if (n7 == 324 && (n9 == 334 || n9 == 303 || n9 == 306)) {
                        ++n2;
                    } else {
                        return -1;
                    }
                }
            }
            ++n6;
        }
        return -1;
    }

    public CtField lookupFieldByJvmName2(String jvmClassName, Symbol fieldSym, ASTree expr) throws NoFieldException {
        CtClass ctClass;
        String string = fieldSym.get();
        try {
            ctClass = this.lookupClass(MemberResolver.jvmToJavaName(jvmClassName), true);
        }
        catch (CompileError compileError) {
            throw new NoFieldException(jvmClassName + "/" + string, expr);
        }
        try {
            return ctClass.getField(string);
        }
        catch (NotFoundException notFoundException) {
            jvmClassName = MemberResolver.javaToJvmName(ctClass.getName());
            throw new NoFieldException(jvmClassName + "$" + string, expr);
        }
    }

    public CtField lookupFieldByJvmName(String jvmClassName, Symbol fieldName) throws CompileError {
        return this.lookupField(MemberResolver.jvmToJavaName(jvmClassName), fieldName);
    }

    public CtField lookupField(String className, Symbol fieldName) throws CompileError {
        CtClass ctClass = this.lookupClass(className, false);
        try {
            return ctClass.getField(fieldName.get());
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError("no such field: " + fieldName.get());
        }
    }

    public CtClass lookupClassByName(ASTList name) throws CompileError {
        return this.lookupClass(Declarator.astToClassName(name, '.'), false);
    }

    public CtClass lookupClassByJvmName(String jvmName) throws CompileError {
        return this.lookupClass(MemberResolver.jvmToJavaName(jvmName), false);
    }

    public CtClass lookupClass(Declarator decl) throws CompileError {
        return this.lookupClass(decl.getType(), decl.getArrayDim(), decl.getClassName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CtClass lookupClass(int type, int dim, String classname) throws CompileError {
        String cname;
        if (type == 307) {
            CtClass ctClass = this.lookupClassByJvmName(classname);
            if (dim <= 0) return ctClass;
            cname = ctClass.getName();
        } else {
            cname = MemberResolver.getTypeName(type);
        }
        while (dim-- > 0) {
            cname = cname + "[]";
        }
        return this.lookupClass(cname, false);
    }

    static String getTypeName(int type) throws CompileError {
        String string = "";
        switch (type) {
            case 301: {
                string = "boolean";
                break;
            }
            case 306: {
                string = "char";
                break;
            }
            case 303: {
                string = "byte";
                break;
            }
            case 334: {
                string = "short";
                break;
            }
            case 324: {
                string = "int";
                break;
            }
            case 326: {
                string = "long";
                break;
            }
            case 317: {
                string = "float";
                break;
            }
            case 312: {
                string = "double";
                break;
            }
            case 344: {
                string = "void";
                break;
            }
            default: {
                MemberResolver.fatal();
            }
        }
        return string;
    }

    public CtClass lookupClass(String name, boolean notCheckInner) throws CompileError {
        CtClass ctClass;
        Map<String, String> map = this.getInvalidNames();
        String string = map.get(name);
        if (string == INVALID) {
            throw new CompileError("no such class: " + name);
        }
        if (string != null) {
            try {
                return this.classPool.get(string);
            }
            catch (NotFoundException notFoundException) {}
        }
        try {
            ctClass = this.lookupClass0(name, notCheckInner);
        }
        catch (NotFoundException notFoundException) {
            ctClass = this.searchImports(name);
        }
        map.put(name, ctClass.getName());
        return ctClass;
    }

    public static int getInvalidMapSize() {
        return invalidNamesMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> getInvalidNames() {
        Map<String, String> map = this.invalidNames;
        if (map != null) return map;
        Class<MemberResolver> clazz = MemberResolver.class;
        synchronized (MemberResolver.class) {
            Reference<Map<String, String>> reference = invalidNamesMap.get(this.classPool);
            if (reference != null) {
                map = reference.get();
            }
            if (map == null) {
                map = new Hashtable<String, String>();
                invalidNamesMap.put(this.classPool, new WeakReference<Map<String, String>>(map));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.invalidNames = map;
            return map;
        }
    }

    private CtClass searchImports(String orgName) throws CompileError {
        if (orgName.indexOf(46) < 0) {
            Iterator<String> iterator = this.classPool.getImportedPackages();
            while (iterator.hasNext()) {
                String string = iterator.next();
                String string2 = string.replaceAll("\\.$", "") + "." + orgName;
                try {
                    return this.classPool.get(string2);
                }
                catch (NotFoundException notFoundException) {
                    try {
                        if (!string.endsWith("." + orgName)) continue;
                        return this.classPool.get(string);
                    }
                    catch (NotFoundException notFoundException2) {
                    }
                }
            }
        }
        this.getInvalidNames().put(orgName, INVALID);
        throw new CompileError("no such class: " + orgName);
    }

    private CtClass lookupClass0(String classname, boolean notCheckInner) throws NotFoundException {
        CtClass ctClass = null;
        do {
            try {
                ctClass = this.classPool.get(classname);
            }
            catch (NotFoundException notFoundException) {
                int n2 = classname.lastIndexOf(46);
                if (notCheckInner || n2 < 0) {
                    throw notFoundException;
                }
                StringBuffer stringBuffer = new StringBuffer(classname);
                stringBuffer.setCharAt(n2, '$');
                classname = stringBuffer.toString();
            }
        } while (ctClass == null);
        return ctClass;
    }

    public String resolveClassName(ASTList name) throws CompileError {
        if (name == null) {
            return null;
        }
        return MemberResolver.javaToJvmName(this.lookupClassByName(name).getName());
    }

    public String resolveJvmClassName(String jvmName) throws CompileError {
        if (jvmName == null) {
            return null;
        }
        return MemberResolver.javaToJvmName(this.lookupClassByJvmName(jvmName).getName());
    }

    public static CtClass getSuperclass(CtClass c2) throws CompileError {
        try {
            CtClass ctClass = c2.getSuperclass();
            if (ctClass != null) {
                return ctClass;
            }
        }
        catch (NotFoundException notFoundException) {}
        throw new CompileError("cannot find the super class of " + c2.getName());
    }

    public static CtClass getSuperInterface(CtClass c2, String interfaceName) throws CompileError {
        try {
            CtClass[] ctClassArray = c2.getInterfaces();
            for (int i2 = 0; i2 < ctClassArray.length; ++i2) {
                if (!ctClassArray[i2].getName().equals(interfaceName)) continue;
                return ctClassArray[i2];
            }
        }
        catch (NotFoundException notFoundException) {}
        throw new CompileError("cannot find the super inetrface " + interfaceName + " of " + c2.getName());
    }

    public static String javaToJvmName(String classname) {
        return classname.replace('.', '/');
    }

    public static String jvmToJavaName(String classname) {
        return classname.replace('/', '.');
    }

    public static int descToType(char c2) throws CompileError {
        switch (c2) {
            case 'Z': {
                return 301;
            }
            case 'C': {
                return 306;
            }
            case 'B': {
                return 303;
            }
            case 'S': {
                return 334;
            }
            case 'I': {
                return 324;
            }
            case 'J': {
                return 326;
            }
            case 'F': {
                return 317;
            }
            case 'D': {
                return 312;
            }
            case 'V': {
                return 344;
            }
            case 'L': 
            case '[': {
                return 307;
            }
        }
        MemberResolver.fatal();
        return 344;
    }

    public static int getModifiers(ASTList mods) {
        int n2 = 0;
        while (mods != null) {
            Keyword keyword = (Keyword)mods.head();
            mods = mods.tail();
            switch (keyword.get()) {
                case 335: {
                    n2 |= 8;
                    break;
                }
                case 315: {
                    n2 |= 0x10;
                    break;
                }
                case 338: {
                    n2 |= 0x20;
                    break;
                }
                case 300: {
                    n2 |= 0x400;
                    break;
                }
                case 332: {
                    n2 |= 1;
                    break;
                }
                case 331: {
                    n2 |= 4;
                    break;
                }
                case 330: {
                    n2 |= 2;
                    break;
                }
                case 345: {
                    n2 |= 0x40;
                    break;
                }
                case 342: {
                    n2 |= 0x80;
                    break;
                }
                case 347: {
                    n2 |= 0x800;
                }
            }
        }
        return n2;
    }

    public static class Method {
        public CtClass declaring;
        public MethodInfo info;
        public int notmatch;

        public Method(CtClass c2, MethodInfo i2, int n2) {
            this.declaring = c2;
            this.info = i2;
            this.notmatch = n2;
        }

        public boolean isStatic() {
            int n2 = this.info.getAccessFlags();
            return (n2 & 8) != 0;
        }
    }
}

