/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.scopedpool;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.LoaderClassPath;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.scopedpool.ScopedClassPoolRepository;
import ai.h2o.javassist.scopedpool.SoftValueHashMap;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Map;

public class ScopedClassPool
extends ClassPool {
    protected ScopedClassPoolRepository repository;
    protected Reference<ClassLoader> classLoader;
    protected LoaderClassPath classPath;
    protected Map<String, CtClass> softcache = new SoftValueHashMap<String, CtClass>();
    boolean isBootstrapCl = true;

    protected ScopedClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        this(cl, src, repository, false);
    }

    protected ScopedClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean isTemp) {
        super(src);
        this.repository = repository;
        this.classLoader = new WeakReference<ClassLoader>(cl);
        if (cl != null) {
            this.classPath = new LoaderClassPath(cl);
            ScopedClassPool scopedClassPool = this;
            scopedClassPool.insertClassPath(scopedClassPool.classPath);
        }
        this.childFirstLookup = true;
        if (!isTemp && cl == null) {
            this.isBootstrapCl = true;
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader == null && !this.isBootstrapCl) {
            throw new IllegalStateException("ClassLoader has been garbage collected");
        }
        return classLoader;
    }

    protected ClassLoader getClassLoader0() {
        return this.classLoader.get();
    }

    public void close() {
        ScopedClassPool scopedClassPool = this;
        scopedClassPool.removeClassPath(scopedClassPool.classPath);
        this.classes.clear();
        this.softcache.clear();
    }

    public synchronized void flushClass(String classname) {
        this.classes.remove(classname);
        this.softcache.remove(classname);
    }

    public synchronized void soften(CtClass clazz) {
        if (this.repository.isPrune()) {
            clazz.prune();
        }
        this.classes.remove(clazz.getName());
        this.softcache.put(clazz.getName(), clazz);
    }

    public boolean isUnloadedClassLoader() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CtClass getCached(String classname) {
        Object object;
        CtClass ctClass = this.getCachedLocally(classname);
        if (ctClass != null) return ctClass;
        boolean bl = false;
        ClassLoader classLoader = this.getClassLoader0();
        if (classLoader != null) {
            int n2 = classname.lastIndexOf(36);
            object = n2 < 0 ? classname.replaceAll("[\\.]", "/") + ".class" : classname.substring(0, n2).replaceAll("[\\.]", "/") + classname.substring(n2) + ".class";
            boolean bl2 = bl = classLoader.getResource((String)object) != null;
        }
        if (bl) return ctClass;
        Map<ClassLoader, ScopedClassPool> map = this.repository.getRegisteredCLs();
        object = map;
        synchronized (map) {
            for (ScopedClassPool scopedClassPool : map.values()) {
                if (scopedClassPool.isUnloadedClassLoader()) {
                    this.repository.unregisterClassLoader(scopedClassPool.getClassLoader());
                    continue;
                }
                ctClass = scopedClassPool.getCachedLocally(classname);
                if (ctClass == null) continue;
                // ** MonitorExit[var6_7] (shouldn't be in output)
                return ctClass;
            }
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return ctClass;
        }
    }

    @Override
    protected void cacheCtClass(String classname, CtClass c2, boolean dynamic) {
        if (dynamic) {
            super.cacheCtClass(classname, c2, dynamic);
            return;
        }
        if (this.repository.isPrune()) {
            c2.prune();
        }
        this.softcache.put(classname, c2);
    }

    public void lockInCache(CtClass c2) {
        super.cacheCtClass(c2.getName(), c2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CtClass getCachedLocally(String classname) {
        CtClass ctClass = (CtClass)this.classes.get(classname);
        if (ctClass != null) {
            return ctClass;
        }
        Map<String, CtClass> map = this.softcache;
        synchronized (map) {
            return this.softcache.get(classname);
        }
    }

    public synchronized CtClass getLocally(String classname) throws NotFoundException {
        this.softcache.remove(classname);
        CtClass ctClass = (CtClass)this.classes.get(classname);
        if (ctClass == null) {
            ctClass = this.createCtClass(classname, true);
            if (ctClass == null) {
                throw new NotFoundException(classname);
            }
            super.cacheCtClass(classname, ctClass, false);
        }
        return ctClass;
    }

    @Override
    public Class<?> toClass(CtClass ct, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        this.lockInCache(ct);
        return super.toClass(ct, this.getClassLoader0(), domain);
    }

    static {
        ClassPool.doPruning = false;
        ClassPool.releaseUnmodifiedClassFile = false;
    }
}

