/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.scopedpool;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.LoaderClassPath;
import ai.h2o.javassist.scopedpool.ScopedClassPool;
import ai.h2o.javassist.scopedpool.ScopedClassPoolFactory;
import ai.h2o.javassist.scopedpool.ScopedClassPoolFactoryImpl;
import ai.h2o.javassist.scopedpool.ScopedClassPoolRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class ScopedClassPoolRepositoryImpl
implements ScopedClassPoolRepository {
    private static final ScopedClassPoolRepositoryImpl instance = new ScopedClassPoolRepositoryImpl();
    private boolean prune = true;
    boolean pruneWhenCached;
    protected Map<ClassLoader, ScopedClassPool> registeredCLs = Collections.synchronizedMap(new WeakHashMap());
    protected ClassPool classpool;
    protected ScopedClassPoolFactory factory = new ScopedClassPoolFactoryImpl();

    public static ScopedClassPoolRepository getInstance() {
        return instance;
    }

    private ScopedClassPoolRepositoryImpl() {
        this.classpool = ClassPool.getDefault();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.classpool.insertClassPath(new LoaderClassPath(classLoader));
    }

    @Override
    public boolean isPrune() {
        return this.prune;
    }

    @Override
    public void setPrune(boolean prune) {
        this.prune = prune;
    }

    @Override
    public ScopedClassPool createScopedClassPool(ClassLoader cl, ClassPool src) {
        return this.factory.create(cl, src, this);
    }

    @Override
    public ClassPool findClassPool(ClassLoader cl) {
        if (cl == null) {
            return this.registerClassLoader(ClassLoader.getSystemClassLoader());
        }
        return this.registerClassLoader(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassPool registerClassLoader(ClassLoader ucl) {
        Map<ClassLoader, ScopedClassPool> map = this.registeredCLs;
        synchronized (map) {
            if (this.registeredCLs.containsKey(ucl)) {
                return this.registeredCLs.get(ucl);
            }
            ScopedClassPool scopedClassPool = this.createScopedClassPool(ucl, this.classpool);
            this.registeredCLs.put(ucl, scopedClassPool);
            return scopedClassPool;
        }
    }

    @Override
    public Map<ClassLoader, ScopedClassPool> getRegisteredCLs() {
        this.clearUnregisteredClassLoaders();
        return this.registeredCLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearUnregisteredClassLoaders() {
        ArrayList<ClassLoader> arrayList = null;
        Map<ClassLoader, ScopedClassPool> map = this.registeredCLs;
        synchronized (map) {
            for (Map.Entry<ClassLoader, ScopedClassPool> entry : this.registeredCLs.entrySet()) {
                if (!entry.getValue().isUnloadedClassLoader()) continue;
                ClassLoader classLoader = entry.getValue().getClassLoader();
                if (classLoader != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<ClassLoader>();
                    }
                    arrayList.add(classLoader);
                }
                this.registeredCLs.remove(entry.getKey());
            }
            if (arrayList != null) {
                for (ClassLoader classLoader : arrayList) {
                    this.unregisterClassLoader(classLoader);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterClassLoader(ClassLoader cl) {
        Map<ClassLoader, ScopedClassPool> map = this.registeredCLs;
        synchronized (map) {
            ScopedClassPool scopedClassPool = this.registeredCLs.remove(cl);
            if (scopedClassPool != null) {
                scopedClassPool.close();
            }
            return;
        }
    }

    public void insertDelegate(ScopedClassPoolRepository delegate) {
    }

    @Override
    public void setClassPoolFactory(ScopedClassPoolFactory factory) {
        this.factory = factory;
    }

    @Override
    public ScopedClassPoolFactory getClassPoolFactory() {
        return this.factory;
    }
}

