/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api.backend;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.api.backend.ResourceInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirReaderBackend
implements ReaderBackend {
    private static final Logger log = LoggerFactory.getLogger(DirReaderBackend.class);
    private final File dir;
    private final ResourceInfo.Cache cache = new ResourceInfo.Cache();

    private DirReaderBackend(File dir) {
        this.dir = dir;
    }

    public static ReaderBackend open(File dir) throws IOException {
        log.info("Opening mojo directory: {}", (Object)dir);
        if (!dir.isDirectory()) {
            throw new FileNotFoundException(dir.getAbsolutePath());
        }
        return new DirReaderBackend(dir.getCanonicalFile());
    }

    @Override
    public ResourceInfo getResourceInfo(String resourceName) throws IOException {
        ResourceInfo resourceInfo = (ResourceInfo)this.cache.get(resourceName);
        if (resourceInfo == null) {
            File file = new File(this.dir, resourceName);
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            resourceInfo = new ResourceInfo(file.length(), "FILESIZE:" + file.length());
        }
        return resourceInfo;
    }

    @Override
    public InputStream getInputStream(String resourceName) throws FileNotFoundException {
        File file = new File(this.dir, resourceName);
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        return new FileInputStream(file);
    }

    @Override
    public boolean exists(String resourceName) {
        File file = new File(this.dir, resourceName);
        return file.isFile();
    }

    @Override
    public Collection<String> list() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.listFiles(arrayList, "", this.dir.listFiles());
        return arrayList;
    }

    private void listFiles(List<String> result, String prefix, File[] files) {
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        File[] fileArray = files;
        int n2 = files.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file = fileArray[i2];
            if (file.isFile()) {
                result.add(prefix + file.getName());
            } else if (!file.isDirectory()) continue;
            this.listFiles(result, prefix + file.getName() + "/", file.listFiles());
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.dir);
    }
}

