/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumnFactory;
import ai.h2o.mojos.runtime.utils.ClassLoaderUtils;
import java.util.ArrayList;
import java.util.ServiceLoader;

final class MojoColumnFactoryService {
    private final MojoColumnFactory mojoColumnFactory;
    private final RuntimeException error;

    public static MojoColumnFactoryService getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private MojoColumnFactoryService() {
        ServiceLoader<MojoColumnFactory> serviceLoader = ServiceLoader.load(MojoColumnFactory.class, ClassLoaderUtils.getPreferredSpiClassLoader(MojoColumnFactory.class));
        MojoColumnFactory[] mojoColumnFactoryArray = MojoColumnFactoryService.getAll(serviceLoader);
        if (mojoColumnFactoryArray.length == 0) {
            this.mojoColumnFactory = null;
            this.error = new RuntimeException("Cannot find MOJO column factory implementation! Check the classpath if it contains mojo2-runtime-impl!");
            return;
        }
        if (mojoColumnFactoryArray.length > 1) {
            this.mojoColumnFactory = null;
            this.error = new RuntimeException("Found multiple MOJO column factories implementation backends, but expected only one! Check the classpath if it contains mojo2-runtime-impl!");
            return;
        }
        this.error = null;
        this.mojoColumnFactory = mojoColumnFactoryArray[0];
    }

    public final MojoColumnFactory getMojoColumnFactory() {
        if (this.mojoColumnFactory != null) {
            return this.mojoColumnFactory;
        }
        throw this.error;
    }

    private static MojoColumnFactory[] getAll(ServiceLoader<MojoColumnFactory> loader) {
        ArrayList<MojoColumnFactory> arrayList = new ArrayList<MojoColumnFactory>();
        for (MojoColumnFactory mojoColumnFactory : loader) {
            arrayList.add(mojoColumnFactory);
        }
        return arrayList.toArray(new MojoColumnFactory[0]);
    }

    private static class InstanceHolder {
        private static MojoColumnFactoryService INSTANCE = new MojoColumnFactoryService();

        private InstanceHolder() {
        }
    }
}

