/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.transforms;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.AbstractMojoTransformBuilderFactory;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import java.util.Map;

public class YeoJohnsonTransformer
extends MojoTransform {
    public static final String PARAM_LAMBDA = "lambda";
    private final float lambda;

    YeoJohnsonTransformer(MojoFrameMeta meta, int[] iindices, int[] oindices, float lambda) {
        super(iindices, oindices);
        this.lambda = lambda;
    }

    @Override
    public void transform(MojoFrame frame) {
        double[] dArray = (double[])frame.getColumn(this.iindices[0]).getData();
        double[] dArray2 = (double[])frame.getColumn(this.oindices[0]).getData();
        int n2 = frame.getNrows();
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray2[i2] = this.powerTransform(dArray[i2]);
        }
    }

    private double powerTransform(double x2) {
        if (this.lambda != 0.0f && x2 >= 0.0) {
            return (Math.pow(x2 + 1.0, this.lambda) - 1.0) / (double)this.lambda;
        }
        if (this.lambda == 0.0f && x2 >= 0.0) {
            return Math.log(x2 + 1.0);
        }
        if (this.lambda != 2.0f && x2 < 0.0) {
            return -(Math.pow(-x2 + 1.0, 2.0f - this.lambda) - 1.0) / (double)(2.0f - this.lambda);
        }
        return -Math.log(-x2 + 1.0);
    }

    public static class Factory
    extends AbstractMojoTransformBuilderFactory {
        @Override
        protected Class<?> getTransformerClass() {
            return YeoJohnsonTransformer.class;
        }

        @Override
        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindices, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            Float f2 = (Float)params.get(YeoJohnsonTransformer.PARAM_LAMBDA);
            if (f2 == null) {
                throw this.wrongArgument("Transformer argument `lambda` is missing!");
            }
            if (iindices.length != 1) {
                throw this.wrongArgument("Transformer needs 1 input column, but " + iindices.length + " were given!");
            }
            return new YeoJohnsonTransformer(meta, iindices, oindices, f2.floatValue());
        }
    }
}

