/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.Consts;
import ai.h2o.mojos.runtime.utils.MojoDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class DateParser {
    private final DateTimeFormatter _dtf;
    static String[] USER_DEFINED_FORMATS = Consts.getSysProp("date.formats", "").split(",");
    public static final String[] SUPPORTED_FORMATS = new String[]{"M[M]/d[d]/yyyy[' ']['T'][' ']h[h]:mm:ss[' ']a", "M[M]/d[d]/yyyy[' ']['T'][' ']h[h]:mm:ss.SSS[' ']a", "M[M]/d[d]/yyyy[' ']['T'][' ']H[H]:mm:ss", "M[M]/d[d]/yyyy[' ']['T'][' ']H[H]:mm:ss.SSS", "M[M]/d[d]/yyyy", "M[M]-d[d]-yyyy[' ']['T'][' ']h[h]:mm:ss[' ']a", "M[M]-d[d]-yyyy[' ']['T'][' ']h[h]:mm:ss.SSS[' ']a", "M[M]-d[d]-yyyy[' ']['T'][' ']H[H]:mm:ss", "M[M]-d[d]-yyyy[' ']['T'][' ']H[H]:mm:ss.SSS", "M[M]-d[d]-yyyy", "d[d].M[M].yyyy[' ']['T'][' ']h[h]:mm:ss[' ']a", "d[d].M[M].yyyy[' ']['T'][' ']h[h]:mm:ss.SSS[' ']a", "d[d].M[M].yyyy[' ']['T'][' ']H[H]:mm:ss", "d[d].M[M].yyyy[' ']['T'][' ']H[H]:mm:ss.SSS", "d[d].M[M].yyyy", "yyyy/M[M]/d[d]' 'HH:mm:ss", "yyyy/M[M]/d[d]' 'HH:mm:ss.SSS", "yyyy/M[M]/d[d]", "yyyy-M[M]-d[d]' 'HH:mm:ss", "yyyy-M[M]-d[d]' 'HH:mm:ss.SSS", "yyyy-M[M]-d[d]'T'HH:mm:ss.SSSSSSSSS", "yyyyMMdd", "yyyy-M[M]-d[d]", "h[h]:mm:ss[' ']a", "h[h]:mm:ss.SSS[' ']a", "H[H]:mm:ss", "H[H]:mm:ss.SSS", "h[h]:mm[' ']a", "H[H]:mm"};
    public static DateTimeFormatter DTF;

    public DateParser(DateTimeParser dtp) {
        this(dtp, true);
    }

    public DateParser(DateTimeParser dtp, boolean useDefaultAsBackup) {
        if (useDefaultAsBackup) {
            this._dtf = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{dtp, DTF.getParser()}).toFormatter();
            return;
        }
        this._dtf = new DateTimeFormatter(null, dtp);
    }

    public MojoDateTime parse(String s2) {
        return MojoDateTime.create(this._dtf.withZone(MojoDateTime.TIMEZONE).parseDateTime(s2));
    }

    public MojoDateTime parseOrNull(String s2) {
        try {
            return this.parse(s2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    static DateTimeParser[] toFormatter(List<String> formats) {
        List<String> list = DateParser.expandFormats(formats);
        DateTimeParser[] dateTimeParserArray = new DateTimeParser[list.size()];
        int n2 = 0;
        for (String string : list) {
            dateTimeParserArray[n2++] = DateTimeFormat.forPattern(string).getParser();
        }
        return dateTimeParserArray;
    }

    static List<String> expandFormats(List<String> formats) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : formats) {
            DateParser.expandFormat(new StringBuilder(string), 0, arrayList);
        }
        return arrayList;
    }

    static void expandFormat(StringBuilder format, int startIdx, List<String> result) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        for (int i2 = startIdx; i2 < format.length(); ++i2) {
            char c2 = format.charAt(i2);
            switch (c2) {
                case '[': {
                    if (n2 < 0) {
                        n2 = i2;
                        stringBuilder.append(format, 0, i2);
                    }
                    ++n4;
                    break;
                }
                case ']': {
                    if (n2 >= 0) {
                        --n4;
                    }
                    if (n4 != 0) break;
                    n3 = i2;
                    string = format.substring(i2 + 1);
                }
            }
            if (n3 > 0) break;
        }
        if (n2 >= 0) {
            String[] stringArray;
            String[] stringArray2 = stringArray = format.substring(n2 + 1, n3).split(",");
            int n5 = stringArray.length;
            for (int i3 = 0; i3 < n5; ++i3) {
                String string2 = stringArray2[i3];
                DateParser.expandFormat(new StringBuilder(stringBuilder).append(string2).append(string), n2, result);
            }
            int n6 = n3;
            DateParser.expandFormat(format.delete(n2, n3 + 1), n6 - (n6 - n2), result);
            return;
        }
        if (format.length() > 0) {
            result.add(format.toString());
        }
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(SUPPORTED_FORMATS));
        arrayList.addAll(Arrays.asList(USER_DEFINED_FORMATS));
        DTF = new DateTimeFormatterBuilder().append(null, DateParser.toFormatter(arrayList)).toFormatter();
    }
}

