/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class BeanFieldDate<T>
extends AbstractBeanField<T> {
    private final String formatString;
    private final String locale;

    public BeanFieldDate(Field field, boolean required, String formatString, String locale, Locale errorLocale) {
        super(field, required, errorLocale);
        this.formatString = formatString;
        this.locale = locale;
    }

    private SimpleDateFormat getFormat() {
        SimpleDateFormat simpleDateFormat;
        if (StringUtils.isNotEmpty(this.locale)) {
            Locale locale = Locale.forLanguageTag(this.locale);
            simpleDateFormat = new SimpleDateFormat(this.formatString, locale);
        } else {
            simpleDateFormat = new SimpleDateFormat(this.formatString);
        }
        return simpleDateFormat;
    }

    private <U> U convertDate(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U u2;
        if (value instanceof String) {
            try {
                Date date = this.getFormat().parse((String)value);
                u2 = fieldType.getConstructor(Long.TYPE).newInstance(date.getTime());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | ParseException exception) {
                CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(value, fieldType);
                csvDataTypeMismatchException.initCause(exception);
                throw csvDataTypeMismatchException;
            }
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            u2 = fieldType.cast(this.getFormat().format((Date)value));
        } else {
            throw new CsvDataTypeMismatchException(value, fieldType, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvdate.not.date"));
        }
        return u2;
    }

    private <U> U convertCalendar(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U u2;
        if (value instanceof String) {
            Date date;
            try {
                date = this.getFormat().parse((String)value);
            }
            catch (ParseException parseException) {
                CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(value, fieldType);
                csvDataTypeMismatchException.initCause(parseException);
                throw csvDataTypeMismatchException;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            if (fieldType == XMLGregorianCalendar.class) {
                try {
                    u2 = fieldType.cast(DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar));
                }
                catch (DatatypeConfigurationException datatypeConfigurationException) {
                    CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("xmlgregoriancalendar.impossible"));
                    csvDataTypeMismatchException.initCause(datatypeConfigurationException);
                    throw csvDataTypeMismatchException;
                }
            } else {
                u2 = fieldType.cast(gregorianCalendar);
            }
        } else {
            Calendar calendar;
            if (value instanceof XMLGregorianCalendar) {
                calendar = ((XMLGregorianCalendar)value).toGregorianCalendar();
            } else if (value instanceof Calendar) {
                calendar = (Calendar)value;
            } else {
                throw new CsvDataTypeMismatchException(value, fieldType, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvdate.not.date"));
            }
            u2 = fieldType.cast(this.getFormat().format(calendar.getTime()));
        }
        return u2;
    }

    private <U> U convertCommon(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U u2;
        Class<Object> clazz;
        Class<Object> clazz2 = clazz = fieldType == String.class ? value.getClass() : fieldType;
        if (Date.class.isAssignableFrom(clazz)) {
            u2 = this.convertDate(value, fieldType);
        } else if (Calendar.class.isAssignableFrom(clazz) || XMLGregorianCalendar.class.isAssignableFrom(clazz)) {
            u2 = this.convertCalendar(value, fieldType);
        } else {
            throw new CsvDataTypeMismatchException(value, fieldType, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvdate.not.date"));
        }
        return u2;
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        return this.convertCommon(value, this.field.getType());
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        if (value == null) {
            return null;
        }
        return this.convertCommon(value, String.class);
    }
}

