/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.lang3.StringUtils;

public class BeanFieldPrimitiveTypes<T>
extends AbstractBeanField<T> {
    private final String locale;

    public BeanFieldPrimitiveTypes(Field field, boolean required, String locale, Locale errorLocale) {
        super(field, required, errorLocale);
        this.locale = locale;
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException {
        Object object = null;
        if (StringUtils.isNotBlank(value) || value != null && this.field.getType().equals(String.class)) {
            try {
                if (StringUtils.isEmpty(this.locale)) {
                    ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
                    convertUtilsBean.register(true, false, 0);
                    object = convertUtilsBean.convert(value, this.field.getType());
                } else {
                    LocaleConvertUtilsBean localeConvertUtilsBean = new LocaleConvertUtilsBean();
                    localeConvertUtilsBean.setDefaultLocale(new Locale(this.locale));
                    object = localeConvertUtilsBean.convert(value, this.field.getType());
                }
            }
            catch (ConversionException conversionException) {
                CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(value, this.field.getType(), String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("conversion.impossible"), value, this.field.getType().getCanonicalName()));
                csvDataTypeMismatchException.initCause(conversionException);
                throw csvDataTypeMismatchException;
            }
        }
        return object;
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String string = null;
        if (value != null) {
            try {
                if (StringUtils.isEmpty(this.locale)) {
                    ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
                    string = convertUtilsBean.convert(value);
                } else {
                    LocaleConvertUtilsBean localeConvertUtilsBean = new LocaleConvertUtilsBean();
                    localeConvertUtilsBean.setDefaultLocale(new Locale(this.locale));
                    string = localeConvertUtilsBean.convert(value);
                }
            }
            catch (ConversionException conversionException) {
                CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("field.not.primitive"));
                csvDataTypeMismatchException.initCause(conversionException);
                throw csvDataTypeMismatchException;
            }
        }
        return string;
    }
}

