/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldDate;
import com.opencsv.bean.BeanFieldPrimitiveTypes;
import com.opencsv.bean.CsvBindByPosition;
import com.opencsv.bean.CsvCustomBindByPosition;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.HeaderColumnNameMappingStrategy;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class ColumnPositionMappingStrategy<T>
extends HeaderColumnNameMappingStrategy<T> {
    private String[] columnMapping = new String[0];
    private boolean columnsExplicitlySet = false;

    @Override
    public void captureHeader(CSVReader reader) throws IOException {
    }

    @Override
    public String[] generateHeader() {
        return new String[0];
    }

    @Override
    public Integer getColumnIndex(String name) {
        return (Integer)this.indexLookup.get(name);
    }

    @Override
    public int findMaxFieldIndex() {
        if (this.columnMapping == null) {
            return -1;
        }
        return this.columnMapping.length - 1;
    }

    @Override
    public String getColumnName(int col) {
        if (col < this.columnMapping.length) {
            return this.columnMapping[col];
        }
        return null;
    }

    public String[] getColumnMapping() {
        return (String[])this.columnMapping.clone();
    }

    public void setColumnMapping(String ... columnMapping) {
        this.columnMapping = columnMapping != null ? (String[])columnMapping.clone() : new String[]{};
        this.resetIndexMap();
        ColumnPositionMappingStrategy columnPositionMappingStrategy = this;
        columnPositionMappingStrategy.createIndexLookup(columnPositionMappingStrategy.columnMapping);
        this.columnsExplicitlySet = true;
    }

    @Override
    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        super.setType(type);
        if (!this.columnsExplicitlySet) {
            TreeMap<Integer, BeanField> treeMap = new TreeMap<Integer, BeanField>();
            for (BeanField object : this.fieldMap.values()) {
                if (object.getField().getAnnotation(CsvCustomBindByPosition.class) != null) {
                    treeMap.put(object.getField().getAnnotation(CsvCustomBindByPosition.class).position(), object);
                    continue;
                }
                if (object.getField().getAnnotation(CsvBindByPosition.class) == null) continue;
                treeMap.put(object.getField().getAnnotation(CsvBindByPosition.class).position(), object);
            }
            if (!treeMap.isEmpty()) {
                this.columnMapping = new String[(Integer)treeMap.lastKey() + 1];
                for (Map.Entry entry : treeMap.entrySet()) {
                    this.columnMapping[((Integer)entry.getKey()).intValue()] = ((BeanField)entry.getValue()).getField().getName().toUpperCase().trim();
                }
                this.resetIndexMap();
                ColumnPositionMappingStrategy columnPositionMappingStrategy = this;
                columnPositionMappingStrategy.createIndexLookup(columnPositionMappingStrategy.columnMapping);
                return;
            }
            this.columnMapping = new String[0];
        }
    }

    @Override
    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new HashMap();
        ColumnPositionMappingStrategy columnPositionMappingStrategy = this;
        for (Field field : columnPositionMappingStrategy.loadFields(columnPositionMappingStrategy.getType())) {
            boolean bl;
            Object object;
            Annotation annotation;
            String string;
            if (field.isAnnotationPresent(CsvCustomBindByPosition.class)) {
                string = field.getName().toUpperCase().trim();
                annotation = field.getAnnotation(CsvCustomBindByPosition.class);
                object = annotation.converter();
                BeanField beanField = this.instantiateCustomConverter((Class<? extends AbstractBeanField>)object);
                beanField.setField(field);
                bl = annotation.required();
                beanField.setRequired(bl);
                this.fieldMap.put(string, beanField);
                continue;
            }
            annotation = field.getAnnotation(CsvBindByPosition.class);
            bl = annotation.required();
            string = field.getName().toUpperCase().trim();
            String string2 = annotation.locale();
            if (field.isAnnotationPresent(CsvDate.class)) {
                object = field.getAnnotation(CsvDate.class).value();
                this.fieldMap.put(string, new BeanFieldDate(field, bl, (String)object, string2, this.errorLocale));
                continue;
            }
            this.fieldMap.put(string, new BeanFieldPrimitiveTypes(field, bl, string2, this.errorLocale));
        }
    }

    @Override
    public void verifyLineLength(int numberOfFields) throws CsvRequiredFieldEmptyException {
        if (this.columnMapping != null) {
            StringBuilder stringBuilder = null;
            for (int i2 = numberOfFields; i2 < this.columnMapping.length; ++i2) {
                BeanField beanField = this.findField(i2);
                if (beanField == null || !beanField.isRequired()) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("multiple.required.field.empty"));
                }
                stringBuilder.append(' ');
                stringBuilder.append(beanField.getField().getName());
            }
            if (stringBuilder != null) {
                throw new CsvRequiredFieldEmptyException(this.type, stringBuilder.toString());
            }
        }
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : cls.getDeclaredFields()) {
            if (!field.isAnnotationPresent(CsvBindByPosition.class) && !field.isAnnotationPresent(CsvCustomBindByPosition.class)) continue;
            arrayList.add(field);
        }
        this.annotationDriven = !arrayList.isEmpty();
        return arrayList;
    }
}

