/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.customconverter;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.lang3.StringUtils;

public class ConvertGermanToBoolean<T>
extends AbstractBeanField<T> {
    protected static final String WAHR = "wahr";
    protected static final String FALSCH = "falsch";

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException {
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        String[] stringArray = new String[]{WAHR, "ja", "j", "1", "w"};
        String[] stringArray2 = new String[]{FALSCH, "nein", "n", "0", "f"};
        BooleanConverter booleanConverter = new BooleanConverter(stringArray, stringArray2);
        try {
            return booleanConverter.convert(Boolean.class, value.trim());
        }
        catch (ConversionException conversionException) {
            CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(value, this.field.getType(), ResourceBundle.getBundle("convertGermanToBoolean", this.errorLocale).getString("input.not.boolean"));
            csvDataTypeMismatchException.initCause(conversionException);
            throw csvDataTypeMismatchException;
        }
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        String string = "";
        try {
            if (value != null) {
                Boolean bl = (Boolean)value;
                string = bl != false ? WAHR : FALSCH;
            }
        }
        catch (ClassCastException classCastException) {
            CsvDataTypeMismatchException csvDataTypeMismatchException = new CsvDataTypeMismatchException(ResourceBundle.getBundle("convertGermanToBoolean", this.errorLocale).getString("field.not.boolean"));
            csvDataTypeMismatchException.initCause(classCastException);
            throw csvDataTypeMismatchException;
        }
        return string;
    }
}

