/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.ModelCategory;
import hex.genmodel.AbstractMojoWriter;
import hex.genmodel.MojoModel;
import hex.genmodel.descriptor.ModelDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class MojoPipelineWriter
extends AbstractMojoWriter {
    private Map<String, MojoModel> _models;
    private Map<String, String> _inputMapping;
    private String _mainModelAlias;

    MojoPipelineWriter(Map<String, MojoModel> models, Map<String, String> inputMapping, String mainModelAlias) {
        super(MojoPipelineWriter.makePipelineDescriptor(models, inputMapping, mainModelAlias));
        this._models = models;
        this._inputMapping = inputMapping;
        this._mainModelAlias = mainModelAlias;
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }

    @Override
    protected void writeModelData() throws IOException {
        this.writekv("submodel_count", this._models.size());
        int n2 = 0;
        for (Map.Entry<String, MojoModel> object : this._models.entrySet()) {
            this.writekv("submodel_key_" + n2, object.getKey());
            this.writekv("submodel_dir_" + n2, "models/" + object.getKey() + "/");
            ++n2;
        }
        this.writekv("generated_column_count", this._inputMapping.size());
        int n3 = 0;
        for (Map.Entry<String, String> entry : this._inputMapping.entrySet()) {
            String string = entry.getValue();
            String[] stringArray = string.split(":", 2);
            this.writekv("generated_column_name_" + n3, entry.getKey());
            this.writekv("generated_column_model_" + n3, stringArray[0]);
            this.writekv("generated_column_index_" + n3, Integer.valueOf(stringArray[1]));
            ++n3;
        }
        this.writekv("main_model", this._mainModelAlias);
    }

    private static MojoPipelineDescriptor makePipelineDescriptor(Map<String, MojoModel> models, Map<String, String> inputMapping, String mainModelAlias) {
        MojoModel mojoModel = models.get(mainModelAlias);
        if (mojoModel == null) {
            throw new IllegalArgumentException("Main model is missing. There is no model with alias '" + mainModelAlias + "'.");
        }
        LinkedHashMap<String, String[]> linkedHashMap = MojoPipelineWriter.deriveInputSchema(models, inputMapping, mojoModel);
        return new MojoPipelineDescriptor(linkedHashMap, mojoModel);
    }

    private static LinkedHashMap<String, String[]> deriveInputSchema(Map<String, MojoModel> allModels, Map<String, String> inputMapping, MojoModel finalModel) {
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        for (MojoModel object : allModels.values()) {
            if (object == finalModel) continue;
            for (int i2 = 0; i2 < object.nfeatures(); ++i2) {
                String string = object._names[i2];
                if (linkedHashMap.containsKey(string)) {
                    Object[] objectArray = linkedHashMap.get(string);
                    if (Arrays.equals(objectArray, object._domains[i2])) continue;
                    throw new IllegalStateException("Domains of column '" + string + "' differ.");
                }
                linkedHashMap.put(string, object._domains[i2]);
            }
        }
        for (int i3 = 0; i3 < finalModel._names.length; ++i3) {
            String string = finalModel._names[i3];
            if (inputMapping.containsKey(string)) continue;
            linkedHashMap.put(string, finalModel._domains[i3]);
        }
        return linkedHashMap;
    }

    private static class MojoPipelineDescriptor
    implements ModelDescriptor {
        private final MojoModel _finalModel;
        private final String[] _names;
        private final String[][] _domains;

        private MojoPipelineDescriptor(LinkedHashMap<String, String[]> schema, MojoModel finalModel) {
            this._finalModel = finalModel;
            this._names = new String[schema.size()];
            this._domains = new String[schema.size()][];
            int n2 = 0;
            for (Map.Entry<String, String[]> entry : schema.entrySet()) {
                this._names[n2] = entry.getKey();
                this._domains[n2] = entry.getValue();
                ++n2;
            }
        }

        @Override
        public String[][] scoringDomains() {
            return this._domains;
        }

        @Override
        public String projectVersion() {
            return this._finalModel._h2oVersion;
        }

        @Override
        public String algoName() {
            return "pipeline";
        }

        @Override
        public String algoFullName() {
            return "MOJO Pipeline";
        }

        @Override
        public String offsetColumn() {
            return this._finalModel._offsetColumn;
        }

        @Override
        public String weightsColumn() {
            return null;
        }

        @Override
        public String foldColumn() {
            return null;
        }

        @Override
        public ModelCategory getModelCategory() {
            return this._finalModel._category;
        }

        @Override
        public boolean isSupervised() {
            return this._finalModel.isSupervised();
        }

        @Override
        public int nfeatures() {
            if (this.isSupervised()) {
                return this.columnNames().length - 1;
            }
            return this.columnNames().length;
        }

        @Override
        public String[] features() {
            return Arrays.copyOf(this.columnNames(), this.nfeatures());
        }

        @Override
        public int nclasses() {
            return this._finalModel.nclasses();
        }

        @Override
        public String[] columnNames() {
            return this._names;
        }

        @Override
        public boolean balanceClasses() {
            return this._finalModel._balanceClasses;
        }

        @Override
        public double defaultThreshold() {
            return this._finalModel._defaultThreshold;
        }

        @Override
        public double[] priorClassDist() {
            return this._finalModel._priorClassDistrib;
        }

        @Override
        public double[] modelClassDist() {
            return this._finalModel._modelClassDistrib;
        }

        @Override
        public String uuid() {
            return this._finalModel._uuid;
        }

        @Override
        public String timestamp() {
            return String.valueOf(new Date().getTime());
        }

        @Override
        public String[] getOrigNames() {
            return null;
        }

        @Override
        public String[][] getOrigDomains() {
            return null;
        }
    }
}

