/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.ConverterFactoryProvidingModel;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.gam.GamRowToRawDataConverter;
import hex.genmodel.algos.gam.GamUtilsCubicRegression;
import hex.genmodel.algos.gam.GamUtilsThinPlateRegression;
import hex.genmodel.algos.gam.ISplines;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.RowToRawDataConverter;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.DistributionFamily;
import hex.genmodel.utils.LinkFunctionType;
import java.util.Map;

public abstract class GamMojoModelBase
extends MojoModel
implements ConverterFactoryProvidingModel,
Cloneable {
    public LinkFunctionType _link_function;
    boolean _useAllFactorLevels;
    int _cats;
    int[] _catNAFills;
    int[] _catOffsets;
    int _nums;
    int _numsCenter;
    double[] _numNAFillsCenter;
    boolean _meanImputation;
    double[] _beta_no_center;
    double[] _beta_center;
    double[][] _beta_multinomial;
    double[][] _beta_multinomial_no_center;
    double[][] _beta_multinomial_center;
    int[] _spline_orders;
    int[] _spline_orders_sorted;
    DistributionFamily _family;
    String[][] _gam_columns;
    String[][] _gam_columns_sorted;
    int[] _d;
    int[] _m;
    int[] _M;
    int[] _gamPredSize;
    int _num_gam_columns;
    int[] _bs;
    int[] _bs_sorted;
    int[] _num_knots;
    int[] _num_knots_sorted;
    int[] _num_knots_sorted_minus1;
    int[] _numBasisSize;
    int[] _num_knots_TP;
    double[][][] _knots;
    double[][][] _binvD;
    double[][][] _zTranspose;
    double[][][] _zTransposeCS;
    String[][] _gamColNames;
    String[][] _gamColNamesCenter;
    String[] _names_no_centering;
    int _totFeatureSize;
    int _betaSizePerClass;
    int _betaCenterSizePerClass;
    double _tweedieLinkPower;
    double[][] _hj;
    int _numExpandedGamCols;
    int _numExpandedGamColsCenter;
    int _lastClass;
    int[][][] _allPolyBasisList;
    int _numTPCol;
    int _numCSCol;
    int _numISCol;
    int[] _tpDistzCSSize;
    boolean[] _dEven;
    double[] _constantTerms;
    double[][] _gamColMeansRaw;
    double[][] _oneOGamColStd;
    boolean _standardize;
    ISplines[] _iSplineBasis;

    GamMojoModelBase(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        if (this._meanImputation) {
            this.imputeMissingWithMeans(row);
        }
        return this.gamScore0(row, preds);
    }

    void init() {
        int n2;
        int n3;
        this._num_knots_sorted_minus1 = new int[this._num_knots_sorted.length];
        for (n3 = 0; n3 < this._num_knots_sorted.length; ++n3) {
            this._num_knots_sorted_minus1[n3] = this._num_knots_sorted[n3] - 1;
        }
        if (this._numCSCol > 0) {
            this._hj = new double[this._numCSCol][];
            for (n3 = 0; n3 < this._numCSCol; ++n3) {
                this._hj[n3] = ArrayUtils.eleDiff(this._knots[n3][0]);
            }
        }
        if (this._numISCol > 0) {
            this._numBasisSize = new int[this._numISCol];
            this._iSplineBasis = new ISplines[this._numISCol];
            for (n3 = 0; n3 < this._numISCol; ++n3) {
                n2 = n3 + this._numCSCol;
                this._numBasisSize[n3] = this._num_knots_sorted[n2] + this._spline_orders_sorted[n2] - 2;
                this._iSplineBasis[n3] = new ISplines(this._spline_orders_sorted[n2], this._knots[n2][0]);
            }
        }
        if (this._numTPCol > 0) {
            this._tpDistzCSSize = new int[this._numTPCol];
            this._dEven = new boolean[this._numTPCol];
            this._constantTerms = new double[this._numTPCol];
            for (n3 = 0; n3 < this._numTPCol; ++n3) {
                n2 = n3 + this._numCSCol + this._numISCol;
                this._tpDistzCSSize[n3] = this._num_knots_sorted[n2] - this._M[n3];
                this._dEven[n3] = this._d[n2] % 2 == 0;
                this._constantTerms[n3] = GamUtilsThinPlateRegression.calTPConstantTerm(this._m[n3], this._d[n2], this._dEven[n3]);
            }
        }
        this._lastClass = this._nclasses - 1;
    }

    @Override
    public GenModel internal_threadSafeInstance() {
        try {
            GamMojoModelBase gamMojoModelBase = (GamMojoModelBase)this.clone();
            gamMojoModelBase.init();
            return gamMojoModelBase;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    abstract double[] gamScore0(double[] var1, double[] var2);

    private void imputeMissingWithMeans(double[] data) {
        int n2;
        for (n2 = 0; n2 < this._cats; ++n2) {
            if (!Double.isNaN(data[n2])) continue;
            data[n2] = this._catNAFills[n2];
        }
        for (n2 = 0; n2 < this._numsCenter; ++n2) {
            if (!Double.isNaN(data[n2 + this._cats])) continue;
            data[n2 + this._cats] = this._numNAFillsCenter[n2];
        }
    }

    double evalLink(double val) {
        switch (this._link_function) {
            case identity: {
                return GenModel.GLM_identityInv(val);
            }
            case logit: {
                return GenModel.GLM_logitInv(val);
            }
            case log: {
                return GenModel.GLM_logInv(val);
            }
            case inverse: {
                return GenModel.GLM_inverseInv(val);
            }
            case tweedie: {
                return GenModel.GLM_tweedieInv(val, this._tweedieLinkPower);
            }
        }
        throw new UnsupportedOperationException("Unexpected link function " + (Object)((Object)this._link_function));
    }

    int readCatVal(double data, int dataIndex) {
        int n2 = this._useAllFactorLevels ? (int)data : (int)data - 1;
        if (n2 < 0) {
            return -1;
        }
        return n2 += this._catOffsets[dataIndex];
    }

    double generateEta(double[] beta, double[] data) {
        int n2;
        int n3;
        double d2 = 0.0;
        int n4 = this._catOffsets.length - 1;
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.readCatVal(data[n3], n3);
            if (n2 >= this._catOffsets[n3 + 1] || n2 < 0) continue;
            d2 += beta[n2];
        }
        n3 = this._catOffsets[this._cats] - this._cats;
        n2 = beta.length - 1 - n3;
        for (int i2 = this._cats; i2 < n2; ++i2) {
            d2 += beta[n3 + i2] * data[i2];
        }
        return d2 += beta[beta.length - 1];
    }

    private boolean gamificationNeeded(double[] rawData, int gamColStart) {
        for (int i2 = gamColStart; i2 < rawData.length; ++i2) {
            if (Double.isNaN(rawData[i2])) continue;
            return false;
        }
        return true;
    }

    int addCSGamification(RowData rowData, int cind, int dataIndEnd, double[] dataWithGamifiedColumns) {
        Object v2 = rowData.get(this._gam_columns_sorted[cind][0]);
        if (v2 == null) {
            return dataIndEnd;
        }
        double d2 = v2 instanceof String ? Double.parseDouble((String)v2) : (Double)v2;
        double[] dArray = new double[this._num_knots_sorted[cind]];
        double[] dArray2 = new double[this._num_knots_sorted_minus1[cind]];
        GamUtilsCubicRegression.expandOneGamCol(d2, this._binvD[cind], dArray, this._hj[cind], this._knots[cind][0]);
        ArrayUtils.multArray(dArray, this._zTranspose[cind], dArray2);
        System.arraycopy(dArray2, 0, dataWithGamifiedColumns, dataIndEnd, this._num_knots_sorted_minus1[cind]);
        return dataIndEnd;
    }

    int addISGamification(RowData rowData, int cind, int csCounter, int dataIndEnd, double[] dataWithGamifiedColumns) {
        Object v2 = rowData.get(this._gam_columns_sorted[cind][0]);
        if (v2 == null) {
            return dataIndEnd;
        }
        double d2 = v2 instanceof String ? Double.parseDouble((String)v2) : (Double)v2;
        double[] dArray = new double[this._numBasisSize[csCounter]];
        this._iSplineBasis[csCounter].gamifyVal(dArray, d2);
        System.arraycopy(dArray, 0, dataWithGamifiedColumns, dataIndEnd, this._numBasisSize[csCounter]);
        return dataIndEnd;
    }

    double[] addExpandGamCols(double[] rawData, RowData rowData) {
        int n2 = this._nfeatures - this._numExpandedGamColsCenter;
        if (!this.gamificationNeeded(rawData, n2)) {
            return rawData;
        }
        double[] dArray = ArrayUtils.nanArray(this._nfeatures);
        System.arraycopy(rawData, 0, dArray, 0, n2);
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < this._num_gam_columns; ++i2) {
            if (this._bs_sorted[i2] == 0) {
                n2 = this.addCSGamification(rowData, i2, n2, dArray);
            } else if (this._bs_sorted[i2] == 1) {
                this.addTPGamification(rowData, i2, n3, n2, dArray);
                ++n3;
            } else if (this._bs_sorted[i2] == 2) {
                this.addISGamification(rowData, i2, n4, n2, dArray);
                ++n4;
            } else {
                throw new IllegalArgumentException("spline type not implemented!");
            }
            n2 += this._num_knots_sorted_minus1[i2];
        }
        return dArray;
    }

    int addTPGamification(RowData rowData, int cind, int tpCounter, int dataIndEnd, double[] dataWithGamifiedColumns) {
        String[] stringArray = this._gam_columns_sorted[cind];
        double[] dArray = this.grabPredictorVals(stringArray, rowData);
        if (dArray == null) {
            return dataIndEnd;
        }
        double[] dArray2 = new double[this._num_knots_sorted[cind]];
        GamUtilsThinPlateRegression.calculateDistance(dArray2, dArray, this._num_knots_sorted[cind], this._knots[cind], this._d[cind], this._m[tpCounter], this._dEven[tpCounter], this._constantTerms[tpCounter], this._oneOGamColStd[tpCounter], this._standardize);
        double[] dArray3 = new double[this._tpDistzCSSize[tpCounter]];
        ArrayUtils.multArray(dArray2, this._zTransposeCS[tpCounter], dArray3);
        double[] dArray4 = new double[this._M[tpCounter]];
        GamUtilsThinPlateRegression.calculatePolynomialBasis(dArray4, dArray, this._d[cind], this._M[tpCounter], this._allPolyBasisList[tpCounter], this._gamColMeansRaw[tpCounter], this._oneOGamColStd[tpCounter], this._standardize);
        double[] dArray5 = new double[this._num_knots_sorted[cind]];
        double[] dArray6 = new double[this._num_knots_sorted_minus1[cind]];
        System.arraycopy(dArray3, 0, dArray5, 0, dArray3.length);
        System.arraycopy(dArray4, 0, dArray5, dArray3.length, this._M[tpCounter]);
        ArrayUtils.multArray(dArray5, this._zTranspose[cind], dArray6);
        System.arraycopy(dArray6, 0, dataWithGamifiedColumns, dataIndEnd, dArray6.length);
        return dataIndEnd;
    }

    double[] grabPredictorVals(String[] gamCols, RowData rowData) {
        int n2 = gamCols.length;
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object v2 = rowData.get(gamCols[i2]);
            if (v2 == null) {
                return null;
            }
            dArray[i2] = v2 instanceof String ? Double.parseDouble((String)v2) : (Double)v2;
        }
        return dArray;
    }

    @Override
    public RowToRawDataConverter makeConverterFactory(Map<String, Integer> modelColumnNameToIndexMap, Map<Integer, CategoricalEncoder> domainMap, EasyPredictModelWrapper.ErrorConsumer errorConsumer, EasyPredictModelWrapper.Config config) {
        return new GamRowToRawDataConverter(this, modelColumnNameToIndexMap, domainMap, errorConsumer, config);
    }
}

