/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.algos.gam.GamUtilsISplines;
import java.io.Serializable;

public class NBSplinesTypeII
implements Serializable {
    public final int _order;
    private final int _nKnots;
    private final double[] _knots;
    public final int _totBasisFuncs;
    public final BSplineBasis[] _basisFuncs;

    public NBSplinesTypeII(int m2, double[] knots) {
        this._order = m2;
        this._nKnots = knots.length;
        this._totBasisFuncs = this._nKnots + this._order - 2;
        this._knots = GamUtilsISplines.fillKnots(knots, m2);
        this._basisFuncs = NBSplinesTypeII.genBasisFunctions(this._totBasisFuncs, this._order, this._knots);
    }

    private static BSplineBasis[] genBasisFunctions(int totBasisFuncs, int order, double[] knots) {
        BSplineBasis[] bSplineBasisArray = new BSplineBasis[totBasisFuncs];
        int n2 = 0;
        while (n2 < totBasisFuncs) {
            int n3 = n2++;
            bSplineBasisArray[n3] = NBSplinesTypeII.formOneBasisFunc(n3, order, knots);
        }
        return bSplineBasisArray;
    }

    private static BSplineBasis formOneBasisFunc(int knotIndex, int order, double[] knots) {
        if (order == 1) {
            return new BSplineBasis(knotIndex, order, knots);
        }
        BSplineBasis bSplineBasis = new BSplineBasis(knotIndex, order, knots);
        bSplineBasis._first = NBSplinesTypeII.formOneBasisFunc(knotIndex, order - 1, knots);
        bSplineBasis._second = NBSplinesTypeII.formOneBasisFunc(knotIndex + 1, order - 1, knots);
        return bSplineBasis;
    }

    public void gamify(double[] gamifiedValues, double value) {
        if (gamifiedValues == null) {
            gamifiedValues = new double[this._totBasisFuncs];
        }
        for (int i2 = 0; i2 < this._totBasisFuncs; ++i2) {
            gamifiedValues[i2] = BSplineBasis.evaluate(value, this._basisFuncs[i2]);
        }
    }

    public static class BSplineBasis
    implements Serializable {
        public double[] _knots;
        private double[] _numerator;
        private double[] _oneOverdenominator;
        private BSplineBasis _first = null;
        private BSplineBasis _second = null;

        public BSplineBasis(int index, int order, double[] knots) {
            this._knots = GamUtilsISplines.extractKnots(index, order, knots);
            int n2 = order + 1 - this._knots.length;
            if (n2 > 0) {
                double[] dArray = new double[knots.length + n2];
                System.arraycopy(this._knots, 0, dArray, 0, this._knots.length);
                double d2 = this._knots[this._knots.length - 1];
                for (int i2 = this._knots.length; i2 < dArray.length; ++i2) {
                    dArray[i2] = d2;
                }
                this._knots = dArray;
            }
            this._numerator = GamUtilsISplines.formNumerator(order, this._knots);
            this._oneOverdenominator = GamUtilsISplines.formDenominator(order, this._knots);
        }

        public static double evaluate(double value, BSplineBasis root) {
            if (value < root._knots[0] || value >= root._knots[root._knots.length - 1]) {
                return 0.0;
            }
            if (root._first != null) {
                return (value - root._numerator[0]) * root._oneOverdenominator[0] * BSplineBasis.evaluate(value, root._first) + (root._numerator[1] - value) * root._oneOverdenominator[1] * BSplineBasis.evaluate(value, root._second);
            }
            return 1.0;
        }
    }
}

