/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glrm;

import hex.genmodel.utils.ArrayUtils;

public enum GlrmLoss {
    Quadratic{

        @Override
        public final boolean isForNumeric() {
            return true;
        }

        @Override
        public final boolean isForCategorical() {
            return false;
        }

        @Override
        public final boolean isForBinary() {
            return false;
        }

        @Override
        public final double loss(double u2, double a2) {
            return (u2 - a2) * (u2 - a2);
        }

        @Override
        public final double lgrad(double u2, double a2) {
            return 2.0 * (u2 - a2);
        }

        @Override
        public final double impute(double u2) {
            return u2;
        }
    }
    ,
    Absolute{

        @Override
        public final boolean isForNumeric() {
            return true;
        }

        @Override
        public final boolean isForCategorical() {
            return false;
        }

        @Override
        public final boolean isForBinary() {
            return false;
        }

        @Override
        public final double loss(double u2, double a2) {
            return Math.abs(u2 - a2);
        }

        @Override
        public final double lgrad(double u2, double a2) {
            return Math.signum(u2 - a2);
        }

        @Override
        public final double impute(double u2) {
            return u2;
        }
    }
    ,
    Huber{

        @Override
        public final boolean isForNumeric() {
            return true;
        }

        @Override
        public final boolean isForCategorical() {
            return false;
        }

        @Override
        public final boolean isForBinary() {
            return false;
        }

        @Override
        public final double loss(double u2, double a2) {
            double d2;
            double d3 = u2 - a2;
            if (d2 > 1.0) {
                return d3 - 0.5;
            }
            if (d3 < -1.0) {
                return -d3 - 0.5;
            }
            return d3 * 0.5 * d3;
        }

        @Override
        public final double lgrad(double u2, double a2) {
            double d2;
            double d3 = u2 - a2;
            if (d2 > 1.0) {
                return 1.0;
            }
            if (d3 < -1.0) {
                return -1.0;
            }
            return d3;
        }

        @Override
        public final double impute(double u2) {
            return u2;
        }
    }
    ,
    Poisson{

        @Override
        public final boolean isForNumeric() {
            return true;
        }

        @Override
        public final boolean isForCategorical() {
            return false;
        }

        @Override
        public final boolean isForBinary() {
            return false;
        }

        @Override
        public final double loss(double u2, double a2) {
            double d2;
            assert (a2 >= 0.0) : "Poisson loss L(u,a) requires variable a >= 0";
            double d3 = Math.exp(u2);
            if (a2 == 0.0) {
                d2 = 0.0;
            } else {
                double d4 = a2;
                d2 = -a2 * u2 + d4 * Math.log(d4) - a2;
            }
            return d3 + d2;
        }

        @Override
        public final double lgrad(double u2, double a2) {
            assert (a2 >= 0.0) : "Poisson loss L(u,a) requires variable a >= 0";
            return Math.exp(u2) - a2;
        }

        @Override
        public final double impute(double u2) {
            return Math.exp(u2);
        }
    }
    ,
    Periodic{
        private double f;
        private int period;

        @Override
        public final boolean isForNumeric() {
            return true;
        }

        @Override
        public final boolean isForCategorical() {
            return false;
        }

        @Override
        public final boolean isForBinary() {
            return false;
        }

        @Override
        public final double loss(double u2, double a2) {
            return 1.0 - Math.cos((u2 - a2) * this.f);
        }

        @Override
        public final double lgrad(double u2, double a2) {
            return this.f * Math.sin((u2 - a2) * this.f);
        }

        @Override
        public final double impute(double u2) {
            return u2;
        }

        @Override
        public final void setParameters(int period) {
            this.period = period;
            this.f = Math.PI * 2 / (double)period;
        }

        public final String toString() {
            return "Periodic(" + this.period + ")";
        }
    }
    ,
    Logistic{

        @Override
        public final boolean isForNumeric() {
            return false;
        }

        @Override
        public final boolean isForCategorical() {
            return false;
        }

        @Override
        public final boolean isForBinary() {
            return true;
        }

        @Override
        public final double loss(double u2, double a2) {
            assert (a2 == 0.0 || a2 == 1.0) : "Logistic loss should be applied to binary features only";
            return Math.log(1.0 + Math.exp((1.0 - a2 * 2.0) * u2));
        }

        @Override
        public final double lgrad(double u2, double a2) {
            double d2 = 1.0 - a2 * 2.0;
            return d2 / (1.0 + Math.exp(-d2 * u2));
        }

        @Override
        public final double impute(double u2) {
            if (u2 > 0.0) {
                return 1.0;
            }
            return 0.0;
        }
    }
    ,
    Hinge{

        @Override
        public final boolean isForNumeric() {
            return false;
        }

        @Override
        public final boolean isForCategorical() {
            return false;
        }

        @Override
        public final boolean isForBinary() {
            return true;
        }

        @Override
        public final double loss(double u2, double a2) {
            assert (a2 == 0.0 || a2 == 1.0) : "Hinge loss should be applied to binary variables only";
            return Math.max(1.0 + (1.0 - a2 * 2.0) * u2, 0.0);
        }

        @Override
        public final double lgrad(double u2, double a2) {
            double d2 = 1.0 - a2 * 2.0;
            if (1.0 + d2 * u2 > 0.0) {
                return d2;
            }
            return 0.0;
        }

        @Override
        public final double impute(double u2) {
            if (u2 > 0.0) {
                return 1.0;
            }
            return 0.0;
        }
    }
    ,
    Categorical{

        @Override
        public final boolean isForNumeric() {
            return false;
        }

        @Override
        public final boolean isForCategorical() {
            return true;
        }

        @Override
        public final boolean isForBinary() {
            return false;
        }

        @Override
        public final double mloss(double[] u2, int a2) {
            return this.mloss(u2, a2, u2.length);
        }

        @Override
        public final double mloss(double[] u2, int a2, int u_len) {
            if (a2 < 0 || a2 >= u_len) {
                throw new IndexOutOfBoundsException("a must be between 0 and " + (u_len - 1));
            }
            double d2 = 0.0;
            for (int i2 = 0; i2 < u_len; ++i2) {
                d2 += Math.max(1.0 + u2[i2], 0.0);
            }
            return d2 += Math.max(1.0 - u2[a2], 0.0) - Math.max(1.0 + u2[a2], 0.0);
        }

        @Override
        public final double[] mlgrad(double[] u2, int a2) {
            double[] dArray = new double[u2.length];
            return this.mlgrad(u2, a2, dArray, u2.length);
        }

        @Override
        public final double[] mlgrad(double[] u2, int a2, double[] grad, int u_len) {
            if (a2 < 0 || a2 >= u_len) {
                throw new IndexOutOfBoundsException("a must be between 0 and " + (u_len - 1));
            }
            for (int i2 = 0; i2 < u_len; ++i2) {
                grad[i2] = 1.0 + u2[i2] > 0.0 ? 1.0 : 0.0;
            }
            grad[a2] = 1.0 - u2[a2] > 0.0 ? -1.0 : 0.0;
            return grad;
        }

        @Override
        public final int mimpute(double[] u2) {
            return ArrayUtils.maxIndex(u2);
        }
    }
    ,
    Ordinal{

        @Override
        public final boolean isForNumeric() {
            return false;
        }

        @Override
        public final boolean isForCategorical() {
            return true;
        }

        @Override
        public final boolean isForBinary() {
            return false;
        }

        @Override
        public final double mloss(double[] u2, int a2) {
            return this.mloss(u2, a2, u2.length);
        }

        @Override
        public final double mloss(double[] u2, int a2, int u_len) {
            if (a2 < 0 || a2 >= u_len) {
                throw new IndexOutOfBoundsException("a must be between 0 and " + (u_len - 1));
            }
            double d2 = 0.0;
            for (int i2 = 0; i2 < u_len - 1; ++i2) {
                d2 += a2 > i2 ? Math.max(1.0 - u2[i2], 0.0) : 1.0;
            }
            return d2;
        }

        @Override
        public final double[] mlgrad(double[] u2, int a2) {
            double[] dArray = new double[u2.length];
            return this.mlgrad(u2, a2, dArray, u2.length);
        }

        @Override
        public final double[] mlgrad(double[] u2, int a2, double[] grad, int u_len) {
            if (a2 < 0 || a2 >= u_len) {
                throw new IndexOutOfBoundsException("a must be between 0 and " + (u_len - 1));
            }
            for (int i2 = 0; i2 < u_len - 1; ++i2) {
                grad[i2] = a2 > i2 && 1.0 - u2[i2] > 0.0 ? -1.0 : 0.0;
            }
            return grad;
        }

        @Override
        public final int mimpute(double[] u2) {
            double d2;
            double d3 = d2 = (double)(u2.length - 1);
            int n2 = 0;
            for (int i2 = 1; i2 < u2.length; ++i2) {
                double d4;
                d2 -= Math.min(1.0, u2[i2 - 1]);
                if (!(d4 < d3)) continue;
                d3 = d2;
                n2 = i2;
            }
            return n2;
        }
    };


    public abstract boolean isForNumeric();

    public abstract boolean isForCategorical();

    public abstract boolean isForBinary();

    public double loss(double u2, double a2) {
        throw new UnsupportedOperationException();
    }

    public double lgrad(double u2, double a2) {
        throw new UnsupportedOperationException();
    }

    public double impute(double u2) {
        throw new UnsupportedOperationException();
    }

    public double mloss(double[] u2, int a2) {
        throw new UnsupportedOperationException();
    }

    public double mloss(double[] u2, int a2, int u_len) {
        throw new UnsupportedOperationException();
    }

    public double[] mlgrad(double[] u2, int a2) {
        throw new UnsupportedOperationException();
    }

    public double[] mlgrad(double[] u2, int a2, double[] prod, int u_len) {
        throw new UnsupportedOperationException();
    }

    public int mimpute(double[] u2) {
        throw new UnsupportedOperationException();
    }

    public void setParameters(int p2) {
        throw new UnsupportedOperationException();
    }
}

