/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.isofor;

import hex.genmodel.algos.tree.SharedTreeMojoModel;

public final class IsolationForestMojoModel
extends SharedTreeMojoModel {
    int _min_path_length;
    int _max_path_length;
    boolean _outputAnomalyFlag;

    public IsolationForestMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public final double[] score0(double[] row, double[] preds) {
        return this.score0(row, 0.0, preds);
    }

    @Override
    public final double[] score0(double[] row, double offset, double[] preds) {
        super.scoreAllTrees(row, preds);
        return this.unifyPreds(row, offset, preds);
    }

    @Override
    public final double[] unifyPreds(double[] row, double offset, double[] preds) {
        double d2;
        double d3 = 0.0;
        if (this._ntree_groups > 0 && preds.length > 1) {
            d3 = preds[0] / (double)this._ntree_groups;
        }
        double d4 = d2 = this._max_path_length > this._min_path_length ? ((double)this._max_path_length - preds[0]) / (double)(this._max_path_length - this._min_path_length) : 1.0;
        if (this._outputAnomalyFlag) {
            preds[0] = d2 > this._defaultThreshold ? 1.0 : 0.0;
            preds[1] = d2;
            preds[2] = d3;
        } else {
            preds[0] = d2;
            preds[1] = d3;
        }
        return preds;
    }

    @Override
    public final double getInitF() {
        return 0.0;
    }

    @Override
    public final int getPredsSize() {
        if (this._outputAnomalyFlag) {
            return 3;
        }
        return 2;
    }

    @Override
    public final String[] getOutputNames() {
        if (this._outputAnomalyFlag) {
            return new String[]{"predict", "score", "mean_length"};
        }
        return new String[]{"predict", "mean_length"};
    }
}

