/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.b.a.d;
import com.b.a.e;
import com.b.a.g;
import com.b.a.j;
import com.b.a.l;
import com.b.a.m;
import com.b.a.o;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.attributes.SerializedName;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.parameters.ColumnSpecifier;
import hex.genmodel.attributes.parameters.KeyValue;
import hex.genmodel.attributes.parameters.ParameterKey;
import hex.genmodel.attributes.parameters.StringPair;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.logging.Logger;
import water.logging.LoggerFactory;

public class ModelJsonReader {
    private static final Logger LOG = LoggerFactory.getLogger(ModelJsonReader.class);
    public static final String MODEL_DETAILS_FILE = "experimental/modelDetails.json";
    private static final Pattern ARRAY_PATTERN = Pattern.compile("\\[\\]");
    private static final Pattern JSON_PATH_PATTERN = Pattern.compile("\\.|\\[|\\]");

    public static m parseModelJson(MojoReaderBackend mojoReaderBackend) {
        m m2;
        block12: {
            BufferedReader bufferedReader = mojoReaderBackend.getTextFile(MODEL_DETAILS_FILE);
            Throwable throwable = null;
            try {
                d d2 = new e().b();
                m2 = d2.a((Reader)bufferedReader, m.class);
                if (bufferedReader == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (bufferedReader != null) {
                            if (throwable != null) {
                                try {
                                    bufferedReader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                bufferedReader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            }
            bufferedReader.close();
        }
        return m2;
    }

    public static Table[] readTableArray(m modelJson, String tablePath) {
        j j2;
        Objects.requireNonNull(modelJson);
        j j3 = j2 = ModelJsonReader.findInJson(modelJson, tablePath);
        if (j2 instanceof l) {
            return null;
        }
        g g2 = j2.j();
        Table[] tableArray = new Table[g2.a()];
        for (int i2 = 0; i2 < g2.a(); ++i2) {
            Table table;
            tableArray[i2] = table = ModelJsonReader.readTableJson(g2.a(i2).i());
        }
        return tableArray;
    }

    private static Table readTableJson(m tableJson) {
        int n2 = tableJson.a("rowcount").g();
        g g2 = ModelJsonReader.findInJson(tableJson, "columns").j();
        int n3 = g2.a();
        String[] stringArray = new String[n3];
        Table.ColumnType[] columnTypeArray = new Table.ColumnType[n3];
        String[] stringArray2 = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            m m2 = g2.a(i2).i();
            stringArray[i2] = m2.a("description").c();
            columnTypeArray[i2] = Table.ColumnType.extractType(m2.a("type").c());
            stringArray2[i2] = m2.a("format").c();
        }
        g g3 = ModelJsonReader.findInJson(tableJson, "data").j();
        Object[][] objectArray = new Object[n3][n2];
        for (int i3 = 0; i3 < n3; ++i3) {
            g g4 = g3.a(i3).j();
            block9: for (int i4 = 0; i4 < n2; ++i4) {
                j j2;
                j j3 = g4.a(i4);
                if (j3 == null || !((j2 = j3) instanceof o)) {
                    objectArray[i3][i4] = null;
                    continue;
                }
                o o2 = j3.k();
                switch (columnTypeArray[i3]) {
                    case LONG: {
                        if (o2.l()) {
                            objectArray[i3][i4] = o2.f();
                            continue block9;
                        }
                        objectArray[i3][i4] = null;
                        continue block9;
                    }
                    case DOUBLE: {
                        j2 = o2;
                        if (!(j2 instanceof l)) {
                            objectArray[i3][i4] = o2.d();
                            continue block9;
                        }
                        objectArray[i3][i4] = null;
                        continue block9;
                    }
                    case FLOAT: {
                        j2 = o2;
                        objectArray[i3][i4] = !(j2 instanceof l) ? Float.valueOf(o2.e()) : null;
                    }
                    case INT: {
                        objectArray[i3][i4] = o2.l() ? Integer.valueOf(o2.g()) : null;
                    }
                    case STRING: {
                        objectArray[i3][i4] = o2.c();
                    }
                }
            }
        }
        return new Table(tableJson.a("name").c(), tableJson.a("description").c(), new String[n2], stringArray, columnTypeArray, null, stringArray2, objectArray);
    }

    public static Table readTable(m modelJson, String tablePath) {
        j j2;
        Objects.requireNonNull(modelJson);
        j j3 = j2 = ModelJsonReader.findInJson(modelJson, tablePath);
        if (j2 instanceof l) {
            LOG.debug(String.format("Table '%s' doesn't exist in MojoModel dump.", tablePath));
            return null;
        }
        return ModelJsonReader.readTableJson(j2.i());
    }

    public static <T> void fillObjects(List<T> objects, g from) {
        for (int i2 = 0; i2 < from.a(); ++i2) {
            j j2 = from.a(i2);
            ModelJsonReader.fillObject(objects.get(i2), j2, "");
        }
    }

    public static void fillObject(Object object, j from, String elementPath) {
        j j2;
        Objects.requireNonNull(object);
        Objects.requireNonNull(elementPath);
        j j3 = j2 = ModelJsonReader.findInJson(from, elementPath);
        if (j2 instanceof l) {
            LOG.warn(String.format("Element '%s' not found in JSON. Skipping. Object '%s' is not populated by values.", elementPath, object.getClass().getName()));
            return;
        }
        m m2 = j2.i();
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            Object object2;
            Field field = fieldArray[i2];
            if (Modifier.isTransient(field.getModifiers())) continue;
            Class<Object> clazz2 = field.getType();
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            Object object3 = serializedName == null ? (((String)(object2 = field.getName())).charAt(0) == '_' ? ((String)object2).substring(1) : object2) : serializedName.value();
            try {
                j j4;
                field.setAccessible(true);
                assert (field.isAccessible());
                object2 = null;
                if (clazz2.isAssignableFrom(Object.class)) {
                    j4 = m2.a((String)object3);
                    if (j4 != null) {
                        j j5;
                        j3 = j5 = m2.a("type");
                        TypeHint typeHint = !(j5 instanceof l) ? TypeHint.fromStringIgnoreCase(j5.c()) : null;
                        object2 = ModelJsonReader.convertBasedOnJsonType(j4, typeHint);
                    }
                } else if (clazz2.isAssignableFrom(Double.TYPE) || clazz2.isAssignableFrom(Double.class)) {
                    j4 = m2.a((String)object3);
                    if (j4 != null && !((j3 = j4) instanceof l)) {
                        object2 = j4.d();
                    }
                } else if (clazz2.isAssignableFrom(Integer.TYPE) || clazz2.isAssignableFrom(Integer.class)) {
                    j4 = m2.a((String)object3);
                    if (j4 != null && !((j3 = j4) instanceof l)) {
                        object2 = j4.g();
                    }
                } else if (clazz2.isAssignableFrom(Long.TYPE) || clazz2.isAssignableFrom(Long.class)) {
                    j4 = m2.a((String)object3);
                    if (j4 != null && !((j3 = j4) instanceof l)) {
                        object2 = j4.f();
                    }
                } else if (clazz2.isAssignableFrom(String.class)) {
                    j4 = m2.a((String)object3);
                    if (j4 != null && !((j3 = j4) instanceof l)) {
                        object2 = j4.c();
                    }
                } else if (clazz2.isAssignableFrom(Table.class) && (j4 = m2.a((String)object3)) != null && !((j3 = j4) instanceof l)) {
                    object2 = ModelJsonReader.readTable(j4.i(), serializedName != null ? serializedName.insideElementPath() : "");
                }
                if (object2 == null) continue;
                field.set(object, object2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println(String.format("Field '%s' could not be accessed. Ignoring.", object3));
                continue;
            }
            catch (ClassCastException | UnsupportedOperationException runtimeException) {
                System.err.println(String.format("Field '%s' could not be casted to '%s'. Ignoring.", object3, clazz2.toString()));
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Object convertBasedOnJsonType(j convertFrom, TypeHint typeHint) {
        void var2_30;
        j j2 = convertFrom;
        if (!(j2 instanceof l)) {
            j2 = convertFrom;
            if (j2 instanceof g) {
                g g2 = convertFrom.j();
                if (typeHint != null) {
                    switch (typeHint) {
                        case OBJECT_ARR: {
                            Object[] objectArray = new Object[g2.a()];
                            int n2 = 0;
                            while (true) {
                                j j3;
                                if (n2 >= g2.a()) {
                                    Object[] objectArray2 = objectArray;
                                    return var2_30;
                                }
                                j2 = j3 = g2.a(n2);
                                objectArray[n2] = j3 instanceof o ? ModelJsonReader.convertBasedOnJsonType(j3, null) : ModelJsonReader.convertJsonObject(j3.i());
                                ++n2;
                            }
                        }
                        case DOUBLE_ARR: {
                            double[] dArray = new double[g2.a()];
                            int n3 = 0;
                            while (true) {
                                if (n3 >= g2.a()) {
                                    double[] dArray2 = dArray;
                                    return var2_30;
                                }
                                dArray[n3] = g2.a(n3).d();
                                ++n3;
                            }
                        }
                        case FLOAT_ARR: {
                            double[] dArray = new double[g2.a()];
                            int n4 = 0;
                            while (true) {
                                if (n4 >= g2.a()) {
                                    double[] dArray3 = dArray;
                                    return var2_30;
                                }
                                dArray[n4] = g2.a(n4).d();
                                ++n4;
                            }
                        }
                        case STRING_ARR: {
                            String[] stringArray = new String[g2.a()];
                            int n5 = 0;
                            while (true) {
                                if (n5 >= g2.a()) {
                                    String[] stringArray2 = stringArray;
                                    return var2_30;
                                }
                                stringArray[n5] = g2.a(n5).c();
                                ++n5;
                            }
                        }
                        case STRING_ARR_ARR: {
                            String[][] stringArrayArray = new String[g2.a()][];
                            int n6 = 0;
                            while (true) {
                                if (n6 >= g2.a()) {
                                    String[][] stringArrayArray2 = stringArrayArray;
                                    return var2_30;
                                }
                                g g3 = g2.a(n6).j();
                                stringArrayArray[n6] = new String[g3.a()];
                                for (int i2 = 0; i2 < g3.a(); ++i2) {
                                    stringArrayArray[n6][i2] = g3.a(i2).c();
                                }
                                ++n6;
                            }
                        }
                        case INT_ARR: {
                            int[] nArray = new int[g2.a()];
                            int n7 = 0;
                            while (true) {
                                if (n7 >= g2.a()) {
                                    int[] nArray2 = nArray;
                                    return var2_30;
                                }
                                nArray[n7] = g2.a(n7).g();
                                ++n7;
                            }
                        }
                        case LONG_ARR: {
                            long[] lArray = new long[g2.a()];
                            int n8 = 0;
                            while (true) {
                                if (n8 >= g2.a()) {
                                    long[] lArray2 = lArray;
                                    return var2_30;
                                }
                                lArray[n8] = g2.a(n8).f();
                                ++n8;
                            }
                        }
                    }
                }
                Object var2_18 = null;
                return var2_30;
            }
            j2 = convertFrom;
            if (j2 instanceof o) {
                o o2 = convertFrom.k();
                if (o2.a()) {
                    Boolean bl = o2.h();
                    return var2_30;
                }
                if (o2.m()) {
                    String string = o2.c();
                    return var2_30;
                }
                if (!o2.l()) return var2_30;
                if (typeHint == null) {
                    Double d2 = o2.d();
                    return var2_30;
                }
                switch (typeHint) {
                    case INT: {
                        Integer n9 = o2.g();
                        return var2_30;
                    }
                    case FLOAT: {
                        Float f2 = Float.valueOf(o2.e());
                        return var2_30;
                    }
                    case DOUBLE: {
                        Double d3 = o2.d();
                        return var2_30;
                    }
                    case LONG: {
                        Long l2 = o2.f();
                        return var2_30;
                    }
                }
                Double d4 = o2.d();
                return var2_30;
            }
            j2 = convertFrom;
            if (j2 instanceof m) {
                Object object = ModelJsonReader.convertJsonObject(convertFrom.i());
                return var2_30;
            }
        }
        Object var2_29 = null;
        return var2_30;
    }

    private static Object convertJsonObject(m convertFrom) {
        j j2;
        j j3 = convertFrom.a("__meta");
        if (j3 == null || (j2 = j3) instanceof l) {
            return null;
        }
        String string = ModelJsonReader.findInJson(j3, "schema_name").c();
        if ("FrameKeyV3".equals(string) || "ModelKeyV3".equals(string)) {
            String string2 = convertFrom.a("name").c();
            String string3 = convertFrom.a("type").c();
            ParameterKey.Type type = ModelJsonReader.convertKeyType(string3);
            String string4 = convertFrom.a("URL").c();
            return new ParameterKey(string2, type, string4);
        }
        if ("ColSpecifierV3".equals(string)) {
            j j4;
            String string5 = convertFrom.a("column_name").c();
            j2 = j4 = convertFrom.a("is_member_of_frames");
            String[] stringArray = j4 instanceof g ? ModelJsonReader.convertStringJsonArray(convertFrom.a("is_member_of_frames").j()) : null;
            return new ColumnSpecifier(string5, stringArray);
        }
        if ("KeyValueV3".equals(string)) {
            return new KeyValue(convertFrom.a("key").c(), convertFrom.a("value").d());
        }
        if ("StringPairV3".equals(string)) {
            return new StringPair(convertFrom.a("a").c(), convertFrom.a("b").c());
        }
        LOG.error(String.format("Error reading MOJO JSON: Object not supported: \n %s ", convertFrom.toString()));
        return null;
    }

    private static String[] convertStringJsonArray(g jsonArray) {
        Objects.requireNonNull(jsonArray);
        j j2 = jsonArray;
        if (j2 instanceof l) {
            return null;
        }
        String[] stringArray = new String[jsonArray.a()];
        for (int i2 = 0; i2 < jsonArray.a(); ++i2) {
            j j3 = jsonArray.a(i2);
            j2 = j3;
            if (j3 instanceof l) continue;
            stringArray[i2] = jsonArray.a(i2).c();
        }
        return stringArray;
    }

    private static final ParameterKey.Type convertKeyType(String type) {
        if ("Key<Frame>".equals(type)) {
            return ParameterKey.Type.FRAME;
        }
        if ("Key<Model>".equals(type)) {
            return ParameterKey.Type.MODEL;
        }
        return ParameterKey.Type.GENERIC;
    }

    protected static j findInJson(j jsonElement, String jsonPath) {
        String[] stringArray = JSON_PATH_PATTERN.split(jsonPath);
        j j2 = jsonElement;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray2[i2];
            if ((string = string.trim()).isEmpty()) continue;
            if (j2 == null) break;
            j j3 = j2;
            if (j3 instanceof m) {
                j2 = ((m)j2).a(string);
                continue;
            }
            j3 = j2;
            if (!(j3 instanceof g)) break;
            int n3 = Integer.valueOf(string) - 1;
            j2 = ((g)j2).a(n3);
        }
        if (j2 == null) {
            return l.a;
        }
        return j2;
    }

    public static boolean elementExists(j jsonElement, String jsonPath) {
        j j2 = ModelJsonReader.findInJson(jsonElement, jsonPath);
        boolean bl = j2 instanceof l;
        return !bl;
    }

    private static enum TypeHint {
        INT,
        FLOAT,
        DOUBLE,
        LONG,
        DOUBLE_ARR,
        FLOAT_ARR,
        STRING_ARR,
        STRING_ARR_ARR,
        INT_ARR,
        LONG_ARR,
        OBJECT_ARR;


        private static TypeHint fromStringIgnoreCase(String from) {
            Matcher matcher = ARRAY_PATTERN.matcher(from);
            boolean bl = matcher.find();
            String string = matcher.replaceAll("_ARR");
            try {
                return TypeHint.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (bl) {
                    return OBJECT_ARR;
                }
                return null;
            }
        }
    }
}

