/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.easy.CategoricalEncoder;
import java.util.HashMap;
import java.util.Map;

public class OneHotEncoder
implements CategoricalEncoder {
    private final String columnName;
    private final int targetIndex;
    private final Map<String, Integer> domainMap;

    OneHotEncoder(String columnName, int targetIndex, String[] domainValues) {
        this.columnName = columnName;
        this.targetIndex = targetIndex;
        this.domainMap = new HashMap<String, Integer>(domainValues.length);
        for (int i2 = 0; i2 < domainValues.length; ++i2) {
            this.domainMap.put(domainValues[i2], i2);
        }
    }

    @Override
    public boolean encodeCatValue(String levelName, double[] rawData) {
        Integer n2 = this.domainMap.get(levelName);
        if (n2 == null) {
            return false;
        }
        this.makeHot(n2, rawData);
        return true;
    }

    @Override
    public void encodeNA(double[] rawData) {
        OneHotEncoder oneHotEncoder = this;
        oneHotEncoder.makeHot(oneHotEncoder.domainMap.size(), rawData);
    }

    private void makeHot(int index, double[] rawData) {
        for (int i2 = 0; i2 < this.domainMap.size() + 1; ++i2) {
            rawData[this.targetIndex + i2] = index == i2 ? 1.0 : 0.0;
        }
    }

    public String toString() {
        return "OneHotEncoder{columnName='" + this.columnName + '\'' + ", targetIndex=" + this.targetIndex + ", domainMap=" + this.domainMap + '}';
    }
}

