/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.GenModel;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.exception.PredictNumberFormatException;
import hex.genmodel.easy.exception.PredictUnknownCategoricalLevelException;
import hex.genmodel.easy.exception.PredictUnknownTypeException;
import java.io.Serializable;
import java.util.Map;

public class RowToRawDataConverter
implements Serializable {
    private final Map<String, Integer> _modelColumnNameToIndexMap;
    private final Map<Integer, CategoricalEncoder> _domainMap;
    private final EasyPredictModelWrapper.ErrorConsumer _errorConsumer;
    private final boolean _convertUnknownCategoricalLevelsToNa;
    private final boolean _convertInvalidNumbersToNa;

    public RowToRawDataConverter(GenModel m2, Map<String, Integer> modelColumnNameToIndexMap, Map<Integer, CategoricalEncoder> domainMap, EasyPredictModelWrapper.ErrorConsumer errorConsumer, EasyPredictModelWrapper.Config config) {
        this._modelColumnNameToIndexMap = modelColumnNameToIndexMap;
        this._domainMap = domainMap;
        this._errorConsumer = errorConsumer;
        this._convertUnknownCategoricalLevelsToNa = config.getConvertUnknownCategoricalLevelsToNa();
        this._convertInvalidNumbersToNa = config.getConvertInvalidNumbersToNa();
    }

    public double[] convert(RowData data, double[] rawData) throws PredictException {
        for (String string : data.keySet()) {
            Object v2;
            Integer n2 = this._modelColumnNameToIndexMap.get(string);
            if (n2 == null || n2 >= rawData.length || !this.convertValue(string, v2 = data.get(string), this._domainMap.get(n2), n2, rawData)) continue;
            return rawData;
        }
        return rawData;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean convertValue(String columnName, Object o, CategoricalEncoder catEncoder, int targetIndex, double[] rawData) throws PredictException {
        if (catEncoder == null) {
            var6_6 = NaN;
            if (o instanceof String) {
                var8_8 = ((String)o).trim();
                try {
                    var6_6 = Double.parseDouble(var8_8);
                }
                catch (NumberFormatException var9_9) {
                    if (this._convertInvalidNumbersToNa) ** GOTO lbl13
                    throw new PredictNumberFormatException("Unable to parse value: " + var8_8 + ", from column: " + columnName + ", as Double; " + var9_9.getMessage());
                }
            } else {
                if (!(o instanceof Double)) throw new PredictUnknownTypeException("Unexpected object type " + o.getClass().getName() + " for numeric column " + columnName);
                var6_6 = (Double)o;
            }
lbl13:
            // 3 sources

            if (Double.isNaN(var6_6)) {
                this._errorConsumer.dataTransformError(columnName, o, "Given non-categorical value is unparseable, treating as NaN.");
            }
            rawData[targetIndex] = var6_6;
            return false;
        }
        if (!(o instanceof String)) ** GOTO lbl26
        var6_7 = (String)o;
        if (catEncoder.encodeCatValue(var6_7, rawData)) return false;
        if (this._convertUnknownCategoricalLevelsToNa) {
            catEncoder.encodeNA(rawData);
            this._errorConsumer.unseenCategorical(columnName, o, "Previously unseen categorical level detected, marking as NaN.");
            return false;
        } else {
            this._errorConsumer.dataTransformError(columnName, o, "Unknown categorical level detected.");
            throw new PredictUnknownCategoricalLevelException("Unknown categorical level (" + columnName + "," + var6_7 + ")", columnName, var6_7);
lbl26:
            // 1 sources

            if (o instanceof Double && Double.isNaN((Double)o)) {
                this._errorConsumer.dataTransformError(columnName, o, "Missing factor value detected, setting to NaN");
                catEncoder.encodeNA(rawData);
                return false;
            } else {
                this._errorConsumer.dataTransformError(columnName, o, "Unknown categorical variable type.");
                throw new PredictUnknownTypeException("Unexpected object type " + o.getClass().getName() + " for categorical column " + columnName);
            }
        }
    }

    EasyPredictModelWrapper.ErrorConsumer getErrorConsumer() {
        return this._errorConsumer;
    }
}

