/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy.error;

import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class CountingErrorConsumer
extends EasyPredictModelWrapper.ErrorConsumer {
    private Map<String, AtomicLong> dataTransformationErrorsCountPerColumn;
    private Map<String, AtomicLong> unknownCategoricalsPerColumn;
    private Map<String, ConcurrentMap<Object, AtomicLong>> unseenCategoricalsCollector;
    private final boolean collectUnseenCategoricals;
    private static final Config DEFAULT_CONFIG = new Config();

    public CountingErrorConsumer(GenModel model) {
        this(model, DEFAULT_CONFIG);
    }

    public CountingErrorConsumer(GenModel model, Config config) {
        this.collectUnseenCategoricals = config.isCollectUnseenCategoricals();
        this.initializeDataTransformationErrorsCount(model);
        this.initializeUnknownCategoricals(model);
    }

    private void initializeDataTransformationErrorsCount(GenModel model) {
        String string = model.isSupervised() ? model.getResponseName() : null;
        this.dataTransformationErrorsCountPerColumn = new ConcurrentHashMap<String, AtomicLong>();
        for (String string2 : model.getNames()) {
            if (model.isSupervised() && string2.equals(string)) continue;
            this.dataTransformationErrorsCountPerColumn.put(string2, new AtomicLong());
        }
        this.dataTransformationErrorsCountPerColumn = Collections.unmodifiableMap(this.dataTransformationErrorsCountPerColumn);
    }

    private void initializeUnknownCategoricals(GenModel model) {
        this.unknownCategoricalsPerColumn = new ConcurrentHashMap<String, AtomicLong>();
        this.unseenCategoricalsCollector = new ConcurrentHashMap<String, ConcurrentMap<Object, AtomicLong>>();
        for (int i2 = 0; i2 < model.getNumCols(); ++i2) {
            String[] stringArray = model.getDomainValues(i2);
            if (stringArray == null) continue;
            this.unknownCategoricalsPerColumn.put(model.getNames()[i2], new AtomicLong());
            if (!this.collectUnseenCategoricals) continue;
            this.unseenCategoricalsCollector.put(model.getNames()[i2], new ConcurrentHashMap());
        }
        this.unknownCategoricalsPerColumn = Collections.unmodifiableMap(this.unknownCategoricalsPerColumn);
    }

    @Override
    public void dataTransformError(String columnName, Object value, String message) {
        this.dataTransformationErrorsCountPerColumn.get(columnName).incrementAndGet();
    }

    @Override
    public void unseenCategorical(String columnName, Object value, String message) {
        this.unknownCategoricalsPerColumn.get(columnName).incrementAndGet();
        if (this.collectUnseenCategoricals) {
            ConcurrentMap<Object, AtomicLong> concurrentMap = this.unseenCategoricalsCollector.get(columnName);
            assert (concurrentMap != null);
            AtomicLong atomicLong = (AtomicLong)concurrentMap.get(value);
            if (atomicLong != null) {
                atomicLong.incrementAndGet();
                return;
            }
            atomicLong = concurrentMap.putIfAbsent(value, new AtomicLong(1L));
            if (atomicLong != null) {
                atomicLong.incrementAndGet();
            }
        }
    }

    public long getTotalUnknownCategoricalLevelsSeen() {
        long l2 = 0L;
        for (AtomicLong atomicLong : this.unknownCategoricalsPerColumn.values()) {
            l2 += atomicLong.get();
        }
        return l2;
    }

    public Map<String, AtomicLong> getUnknownCategoricalsPerColumn() {
        return this.unknownCategoricalsPerColumn;
    }

    public Map<Object, AtomicLong> getUnseenCategoricals(String column) {
        if (!this.collectUnseenCategoricals) {
            throw new IllegalStateException("Unseen categorical values collection was not enabled.");
        }
        return this.unseenCategoricalsCollector.get(column);
    }

    public Map<String, AtomicLong> getDataTransformationErrorsCountPerColumn() {
        return this.dataTransformationErrorsCountPerColumn;
    }

    public long getDataTransformationErrorsCount() {
        long l2 = 0L;
        for (AtomicLong atomicLong : this.dataTransformationErrorsCountPerColumn.values()) {
            l2 += atomicLong.get();
        }
        return l2;
    }

    public static class Config {
        private boolean collectUnseenCategoricals;

        public boolean isCollectUnseenCategoricals() {
            return this.collectUnseenCategoricals;
        }

        public void setCollectUnseenCategoricals(boolean collectUnseenCategoricals) {
            this.collectUnseenCategoricals = collectUnseenCategoricals;
        }
    }
}

