/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import a.a.a.a.b;
import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.glrm.GlrmMojoModel;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.prediction.AbstractPrediction;
import hex.genmodel.easy.prediction.AnomalyDetectionPrediction;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import hex.genmodel.easy.prediction.ClusteringModelPrediction;
import hex.genmodel.easy.prediction.CoxPHModelPrediction;
import hex.genmodel.easy.prediction.DimReductionModelPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.easy.prediction.OrdinalModelPrediction;
import hex.genmodel.easy.prediction.RegressionModelPrediction;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class PredictCsv {
    private final String inputCSVFileName;
    private final String outputCSVFileName;
    private final boolean useDecimalOutput;
    private final char separator;
    private final boolean setInvNumNA;
    private final boolean getTreePath;
    private final boolean predictContributions;
    private final boolean returnGLRMReconstruct;
    private final int glrmIterNumber;
    private final boolean outputHeader;
    private EasyPredictModelWrapper modelWrapper;

    private PredictCsv(String inputCSVFileName, String outputCSVFileName, boolean useDecimalOutput, char separator, boolean setInvNumNA, boolean getTreePath, boolean predictContributions, boolean returnGLRMReconstruct, int glrmIterNumber, boolean outputHeader) {
        this.inputCSVFileName = inputCSVFileName;
        this.outputCSVFileName = outputCSVFileName;
        this.useDecimalOutput = useDecimalOutput;
        this.separator = separator;
        this.setInvNumNA = setInvNumNA;
        this.getTreePath = getTreePath;
        this.predictContributions = predictContributions;
        this.returnGLRMReconstruct = returnGLRMReconstruct;
        this.glrmIterNumber = glrmIterNumber;
        this.outputHeader = outputHeader;
    }

    public static void main(String[] args) {
        PredictCsvCollection predictCsvCollection = PredictCsv.buildPredictCsv(args);
        PredictCsv predictCsv = predictCsvCollection.main;
        try {
            predictCsv.run();
        }
        catch (Exception exception) {
            System.out.println("Predict error: " + exception.getMessage());
            System.out.println();
            exception.printStackTrace();
            System.exit(1);
        }
        if (predictCsvCollection.concurrent.length > 0) {
            try {
                int n2;
                ExecutorService executorService = Executors.newFixedThreadPool(predictCsvCollection.concurrent.length);
                ArrayList<PredictCsvCallable> arrayList = new ArrayList<PredictCsvCallable>(predictCsvCollection.concurrent.length);
                for (n2 = 0; n2 < predictCsvCollection.concurrent.length; ++n2) {
                    arrayList.add(new PredictCsvCallable(predictCsvCollection.concurrent[n2]));
                }
                n2 = 0;
                for (Future future : executorService.invokeAll(arrayList)) {
                    Exception exception = (Exception)future.get();
                    if (exception == null) continue;
                    exception.printStackTrace();
                    ++n2;
                }
                if (n2 > 0) {
                    throw new Exception("Some predictors failed (#failed=" + n2 + ")");
                }
            }
            catch (Exception exception) {
                System.out.println("Concurrent predict error: " + exception.getMessage());
                System.out.println();
                exception.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }

    public static PredictCsv make(String[] args, GenModel model) {
        PredictCsvCollection predictCsvCollection = PredictCsv.buildPredictCsv(args);
        if (predictCsvCollection.concurrent.length != 0) {
            throw new UnsupportedOperationException("Predicting with concurrent predictors is not supported in programmatic mode.");
        }
        PredictCsv predictCsv = predictCsvCollection.main;
        if (model != null) {
            try {
                predictCsv.setModelWrapper(model);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return predictCsv;
    }

    private static RowData formatDataRow(String[] splitLine, String[] inputColumnNames) {
        RowData rowData = new RowData();
        int n2 = Math.min(inputColumnNames.length, splitLine.length);
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            String string2 = inputColumnNames[i2];
            switch (string = splitLine[i2]) {
                case "": 
                case "NA": 
                case "N/A": 
                case "-": {
                    continue block9;
                }
                default: {
                    rowData.put(string2, string);
                }
            }
        }
        return rowData;
    }

    private String myDoubleToString(double d2) {
        if (Double.isNaN(d2)) {
            return "NA";
        }
        if (this.useDecimalOutput) {
            return Double.toString(d2);
        }
        return Double.toHexString(d2);
    }

    private void writeTreePathNames(BufferedWriter output) throws Exception {
        String[] stringArray = ((SharedTreeMojoModel)this.modelWrapper.m).getDecisionPathNames();
        this.writeColumnNames(output, stringArray);
    }

    private void writeContributionNames(BufferedWriter output) throws Exception {
        this.writeColumnNames(output, this.modelWrapper.getContributionNames());
    }

    private void writeColumnNames(BufferedWriter output, String[] columnNames) throws Exception {
        int n2 = columnNames.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            output.write(columnNames[i2]);
            output.write(",");
        }
        output.write(columnNames[n2]);
    }

    public void run() throws Exception {
        int n2;
        String[] stringArray;
        ModelCategory modelCategory = this.modelWrapper.getModelCategory();
        b b2 = new b(new FileReader(this.inputCSVFileName), this.separator);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.outputCSVFileName));
        if (this.outputHeader) {
            switch (modelCategory) {
                case Binomial: 
                case Multinomial: 
                case Regression: {
                    if (this.getTreePath) {
                        this.writeTreePathNames(bufferedWriter);
                        break;
                    }
                    if (this.predictContributions) {
                        this.writeContributionNames(bufferedWriter);
                        break;
                    }
                    PredictCsv predictCsv = this;
                    predictCsv.writeHeader(predictCsv.modelWrapper.m.getOutputNames(), bufferedWriter);
                    break;
                }
                case DimReduction: {
                    if (this.returnGLRMReconstruct) {
                        stringArray = this.modelWrapper.m.getNames();
                        n2 = ((GlrmMojoModel)this.modelWrapper.m)._permutation.length;
                        int n3 = n2 - 1;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            bufferedWriter.write("reconstr_" + stringArray[i2]);
                            if (i2 >= n3) continue;
                            bufferedWriter.write(44);
                        }
                        break;
                    }
                    PredictCsv predictCsv = this;
                    predictCsv.writeHeader(predictCsv.modelWrapper.m.getOutputNames(), bufferedWriter);
                    break;
                }
                default: {
                    PredictCsv predictCsv = this;
                    predictCsv.writeHeader(predictCsv.modelWrapper.m.getOutputNames(), bufferedWriter);
                }
            }
            bufferedWriter.write("\n");
        }
        n2 = 1;
        try {
            String[] stringArray2 = b2.a();
            if (stringArray2 != null) {
                stringArray = stringArray2;
                this.checkMissingColumns(stringArray);
            } else {
                throw new Exception("Input dataset file is empty!");
            }
            while ((stringArray2 = b2.a()) != null) {
                RowData rowData = PredictCsv.formatDataRow(stringArray2, stringArray);
                String string = this.modelWrapper.m.getOffsetName();
                double d2 = string == null ? 0.0 : Double.parseDouble((String)rowData.get(string));
                switch (modelCategory) {
                    case AutoEncoder: {
                        AbstractPrediction abstractPrediction = this.modelWrapper.predictAutoEncoder(rowData);
                        for (int i3 = 0; i3 < abstractPrediction.reconstructed.length; ++i3) {
                            bufferedWriter.write(this.myDoubleToString(abstractPrediction.reconstructed[i3]));
                            if (i3 >= abstractPrediction.reconstructed.length) continue;
                            bufferedWriter.write(44);
                        }
                        break;
                    }
                    case Binomial: {
                        AbstractPrediction abstractPrediction = this.modelWrapper.predictBinomial(rowData, d2);
                        if (this.getTreePath) {
                            this.writeTreePaths(((BinomialModelPrediction)abstractPrediction).leafNodeAssignments, bufferedWriter);
                            break;
                        }
                        if (this.predictContributions) {
                            this.writeContributions(((BinomialModelPrediction)abstractPrediction).contributions, bufferedWriter);
                            break;
                        }
                        bufferedWriter.write(((BinomialModelPrediction)abstractPrediction).label);
                        bufferedWriter.write(",");
                        for (int i4 = 0; i4 < ((BinomialModelPrediction)abstractPrediction).classProbabilities.length; ++i4) {
                            if (i4 > 0) {
                                bufferedWriter.write(",");
                            }
                            bufferedWriter.write(this.myDoubleToString(((BinomialModelPrediction)abstractPrediction).classProbabilities[i4]));
                        }
                        break;
                    }
                    case Multinomial: {
                        AbstractPrediction abstractPrediction = this.modelWrapper.predictMultinomial(rowData);
                        if (this.getTreePath) {
                            this.writeTreePaths(((MultinomialModelPrediction)abstractPrediction).leafNodeAssignments, bufferedWriter);
                            break;
                        }
                        bufferedWriter.write(((MultinomialModelPrediction)abstractPrediction).label);
                        bufferedWriter.write(",");
                        for (int i5 = 0; i5 < ((MultinomialModelPrediction)abstractPrediction).classProbabilities.length; ++i5) {
                            if (i5 > 0) {
                                bufferedWriter.write(",");
                            }
                            bufferedWriter.write(this.myDoubleToString(((MultinomialModelPrediction)abstractPrediction).classProbabilities[i5]));
                        }
                        break;
                    }
                    case Ordinal: {
                        AbstractPrediction abstractPrediction = this.modelWrapper.predictOrdinal(rowData, d2);
                        bufferedWriter.write(((OrdinalModelPrediction)abstractPrediction).label);
                        bufferedWriter.write(",");
                        for (int i6 = 0; i6 < ((OrdinalModelPrediction)abstractPrediction).classProbabilities.length; ++i6) {
                            if (i6 > 0) {
                                bufferedWriter.write(",");
                            }
                            bufferedWriter.write(this.myDoubleToString(((OrdinalModelPrediction)abstractPrediction).classProbabilities[i6]));
                        }
                        break;
                    }
                    case Clustering: {
                        AbstractPrediction abstractPrediction = this.modelWrapper.predictClustering(rowData);
                        bufferedWriter.write(this.myDoubleToString(((ClusteringModelPrediction)abstractPrediction).cluster));
                        break;
                    }
                    case Regression: {
                        AbstractPrediction abstractPrediction = this.modelWrapper.predictRegression(rowData, d2);
                        if (this.getTreePath) {
                            this.writeTreePaths(((RegressionModelPrediction)abstractPrediction).leafNodeAssignments, bufferedWriter);
                            break;
                        }
                        if (this.predictContributions) {
                            this.writeContributions(((RegressionModelPrediction)abstractPrediction).contributions, bufferedWriter);
                            break;
                        }
                        bufferedWriter.write(this.myDoubleToString(((RegressionModelPrediction)abstractPrediction).value));
                        break;
                    }
                    case CoxPH: {
                        AbstractPrediction abstractPrediction = this.modelWrapper.predictCoxPH(rowData, d2);
                        bufferedWriter.write(this.myDoubleToString(((CoxPHModelPrediction)abstractPrediction).value));
                        break;
                    }
                    case DimReduction: {
                        AbstractPrediction abstractPrediction = this.modelWrapper.predictDimReduction(rowData);
                        double[] dArray = this.returnGLRMReconstruct ? ((DimReductionModelPrediction)abstractPrediction).reconstructed : ((DimReductionModelPrediction)abstractPrediction).dimensions;
                        int n4 = dArray.length - 1;
                        for (int i7 = 0; i7 < dArray.length; ++i7) {
                            bufferedWriter.write(this.myDoubleToString(dArray[i7]));
                            if (i7 >= n4) continue;
                            bufferedWriter.write(44);
                        }
                        break;
                    }
                    case AnomalyDetection: {
                        int n4;
                        AbstractPrediction abstractPrediction = this.modelWrapper.predictAnomalyDetection(rowData);
                        double[] dArray = ((AnomalyDetectionPrediction)abstractPrediction).toPreds();
                        for (n4 = 0; n4 < dArray.length - 1; ++n4) {
                            bufferedWriter.write(this.myDoubleToString(dArray[n4]));
                            bufferedWriter.write(44);
                        }
                        bufferedWriter.write(this.myDoubleToString(dArray[dArray.length - 1]));
                        break;
                    }
                    default: {
                        throw new Exception("Unknown model category " + (Object)((Object)modelCategory));
                    }
                }
                bufferedWriter.write("\n");
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            throw new Exception("Prediction failed on line " + n2, exception);
        }
        finally {
            bufferedWriter.close();
            b2.close();
        }
    }

    private void writeHeader(String[] colNames, BufferedWriter output) throws Exception {
        output.write(colNames[0]);
        for (int i2 = 1; i2 < colNames.length; ++i2) {
            output.write(",");
            output.write(colNames[i2]);
        }
    }

    private void writeTreePaths(String[] treePaths, BufferedWriter output) throws Exception {
        int n2 = treePaths.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            output.write(treePaths[i2]);
            output.write(",");
        }
        output.write(treePaths[n2]);
    }

    private void writeContributions(float[] contributions, BufferedWriter output) throws Exception {
        for (int i2 = 0; i2 < contributions.length; ++i2) {
            if (i2 > 0) {
                output.write(",");
            }
            output.write(this.myDoubleToString(contributions[i2]));
        }
    }

    private void setModelWrapper(GenModel genModel) throws IOException {
        EasyPredictModelWrapper.Config config = new EasyPredictModelWrapper.Config().setModel(genModel).setConvertUnknownCategoricalLevelsToNa(true).setConvertInvalidNumbersToNa(this.setInvNumNA);
        if (this.getTreePath) {
            config.setEnableLeafAssignment(true);
        }
        if (this.predictContributions) {
            config.setEnableContributions(true);
        }
        if (this.returnGLRMReconstruct) {
            config.setEnableGLRMReconstrut(true);
        }
        if (this.glrmIterNumber > 0) {
            config.setGLRMIterNumber(this.glrmIterNumber);
        }
        this.setModelWrapper(new EasyPredictModelWrapper(config));
    }

    private void setModelWrapper(EasyPredictModelWrapper modelWrapper) {
        this.modelWrapper = modelWrapper;
    }

    private static void usage() {
        System.out.println();
        System.out.println("Usage:  java [...java args...] hex.genmodel.tools.PredictCsv --mojo mojoName");
        System.out.println("             --pojo pojoName --input inputFile --output outputFile --separator sepStr --decimal --setConvertInvalidNum");
        System.out.println();
        System.out.println("     --mojo    Name of the zip file containing model's MOJO.");
        System.out.println("     --pojo    Name of the java class containing the model's POJO. Either this ");
        System.out.println("               parameter or --model must be specified.");
        System.out.println("     --input   text file containing the test data set to score.");
        System.out.println("     --output  Name of the output CSV file with computed predictions.");
        System.out.println("     --separator Separator to be used in input file containing test data set.");
        System.out.println("     --decimal Use decimal numbers in the output (default is to use hexademical).");
        System.out.println("     --setConvertInvalidNum Will call .setConvertInvalidNumbersToNa(true) when loading models.");
        System.out.println("     --leafNodeAssignment will show the leaf node assignment for tree based models instead of prediction results");
        System.out.println("     --predictContributions will output prediction contributions (Shapley values) for tree based models instead of regular model predictions");
        System.out.println("     --glrmReconstruct will return the reconstructed dataset for GLRM mojo instead of X factor derived from the dataset.");
        System.out.println("     --glrmIterNumber integer indicating number of iterations to go through when constructing X factor derived from the dataset.");
        System.out.println("     --testConcurrent integer (for testing) number of concurrent threads that will be making predictions.");
        System.out.println();
        System.exit(1);
    }

    private void checkMissingColumns(String[] parsedColumnNamesArr) {
        String[] stringArray = this.modelWrapper.m._names;
        HashSet hashSet = new HashSet(parsedColumnNamesArr.length);
        Collections.addAll(hashSet, parsedColumnNamesArr);
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = object[i2];
            if (!hashSet.contains(string) && !string.equals(this.modelWrapper.m._responseColumn)) {
                arrayList.add(string);
                continue;
            }
            hashSet.remove(string);
        }
        if (arrayList.size() > 0) {
            object = new StringBuilder("There were ");
            ((StringBuilder)object).append(arrayList.size());
            ((StringBuilder)object).append(" missing columns found in the input data set: {");
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                ((StringBuilder)object).append((String)arrayList.get(n2));
                if (n2 == arrayList.size() - 1) continue;
                ((StringBuilder)object).append(",");
            }
            ((StringBuilder)object).append('}');
            System.out.println(object);
        }
        if (hashSet.size() > 0) {
            object = new StringBuilder("Detected ");
            ((StringBuilder)object).append(hashSet.size());
            ((StringBuilder)object).append(" unused columns in the input data set: {");
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((StringBuilder)object).append((String)iterator.next());
                if (!iterator.hasNext()) continue;
                ((StringBuilder)object).append(",");
            }
            ((StringBuilder)object).append('}');
            System.out.println(object);
        }
    }

    private static PredictCsvCollection buildPredictCsv(String[] args) {
        try {
            GenModel genModel;
            PredictCsvBuilder predictCsvBuilder = new PredictCsvBuilder();
            predictCsvBuilder.parseArgs(args);
            switch (predictCsvBuilder.loadType) {
                case -1: {
                    genModel = null;
                    break;
                }
                case 0: {
                    genModel = PredictCsv.loadPojo(predictCsvBuilder.pojoMojoModelNames);
                    break;
                }
                case 1: {
                    genModel = PredictCsv.loadMojo(predictCsvBuilder.pojoMojoModelNames);
                    break;
                }
                case 2: {
                    genModel = PredictCsv.loadModel(predictCsvBuilder.pojoMojoModelNames);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value of loadType = " + predictCsvBuilder.loadType);
                }
            }
            PredictCsv predictCsv = predictCsvBuilder.newPredictCsv();
            if (genModel != null) {
                predictCsv.setModelWrapper(genModel);
            }
            PredictCsv[] predictCsvArray = new PredictCsv[predictCsvBuilder.testConcurrent];
            for (int i2 = 0; i2 < predictCsvArray.length; ++i2) {
                PredictCsv predictCsv2 = predictCsvBuilder.newConcurrentPredictCsv(i2);
                predictCsv2.setModelWrapper(predictCsv.modelWrapper);
                predictCsvArray[i2] = predictCsv2;
            }
            return new PredictCsvCollection(predictCsv, predictCsvArray);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            PredictCsv.usage();
            throw new IllegalStateException("Should not be reachable");
        }
    }

    private static GenModel loadPojo(String className) throws Exception {
        return (GenModel)Class.forName(className).newInstance();
    }

    private static GenModel loadMojo(String modelName) throws IOException {
        return MojoModel.load(modelName);
    }

    private static GenModel loadModel(String modelName) throws Exception {
        try {
            return PredictCsv.loadMojo(modelName);
        }
        catch (IOException iOException) {
            return PredictCsv.loadPojo(modelName);
        }
    }

    private static class PredictCsvCallable
    implements Callable<Exception> {
        private final PredictCsv predictCsv;

        private PredictCsvCallable(PredictCsv predictCsv) {
            this.predictCsv = predictCsv;
        }

        @Override
        public Exception call() throws Exception {
            try {
                this.predictCsv.run();
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                return exception;
            }
            return null;
        }
    }

    private static class PredictCsvBuilder {
        private String inputCSVFileName;
        private String outputCSVFileName;
        private boolean useDecimalOutput;
        private char separator = (char)44;
        private boolean setInvNumNA;
        private boolean getTreePath;
        private boolean predictContributions;
        private boolean returnGLRMReconstruct;
        private int glrmIterNumber = -1;
        private boolean outputHeader = true;
        private int loadType = 0;
        private String pojoMojoModelNames = "";
        private int testConcurrent = 0;

        private PredictCsvBuilder() {
        }

        private PredictCsv newPredictCsv() {
            return new PredictCsv(this.inputCSVFileName, this.outputCSVFileName, this.useDecimalOutput, this.separator, this.setInvNumNA, this.getTreePath, this.predictContributions, this.returnGLRMReconstruct, this.glrmIterNumber, this.outputHeader);
        }

        private PredictCsv newConcurrentPredictCsv(int id) {
            return new PredictCsv(this.inputCSVFileName, this.outputCSVFileName + "." + id, this.useDecimalOutput, this.separator, this.setInvNumNA, this.getTreePath, this.predictContributions, this.returnGLRMReconstruct, this.glrmIterNumber, this.outputHeader);
        }

        private void parseArgs(String[] args) {
            block22: for (int i2 = 0; i2 < args.length; ++i2) {
                String string = args[i2];
                if (string.equals("--header")) continue;
                if (string.equals("--decimal")) {
                    this.useDecimalOutput = true;
                    continue;
                }
                if (string.equals("--glrmReconstruct")) {
                    this.returnGLRMReconstruct = true;
                    continue;
                }
                if (string.equals("--setConvertInvalidNum")) {
                    this.setInvNumNA = true;
                    continue;
                }
                if (string.equals("--leafNodeAssignment")) {
                    this.getTreePath = true;
                    continue;
                }
                if (string.equals("--predictContributions")) {
                    this.predictContributions = true;
                    continue;
                }
                if (string.equals("--embedded")) {
                    this.loadType = -1;
                    continue;
                }
                if (++i2 >= args.length) {
                    PredictCsv.usage();
                }
                String string2 = args[i2];
                switch (string) {
                    case "--model": {
                        this.pojoMojoModelNames = string2;
                        this.loadType = 2;
                        continue block22;
                    }
                    case "--mojo": {
                        this.pojoMojoModelNames = string2;
                        this.loadType = 1;
                        continue block22;
                    }
                    case "--pojo": {
                        this.pojoMojoModelNames = string2;
                        this.loadType = 0;
                        continue block22;
                    }
                    case "--input": {
                        this.inputCSVFileName = string2;
                        continue block22;
                    }
                    case "--output": {
                        this.outputCSVFileName = string2;
                        continue block22;
                    }
                    case "--separator": {
                        String string3 = string2;
                        this.separator = string3.charAt(string3.length() - 1);
                        continue block22;
                    }
                    case "--glrmIterNumber": {
                        this.glrmIterNumber = Integer.parseInt(string2);
                        continue block22;
                    }
                    case "--testConcurrent": {
                        this.testConcurrent = Integer.parseInt(string2);
                        continue block22;
                    }
                    case "--outputHeader": {
                        this.outputHeader = Boolean.parseBoolean(string2);
                        continue block22;
                    }
                    default: {
                        System.out.println("ERROR: Unknown command line argument: " + string);
                        PredictCsv.usage();
                    }
                }
            }
        }
    }

    private static class PredictCsvCollection {
        private final PredictCsv main;
        private final PredictCsv[] concurrent;

        private PredictCsvCollection(PredictCsv main, PredictCsv[] concurrent) {
            this.main = main;
            this.concurrent = concurrent;
        }
    }
}

