/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtils {
    private static boolean loggedAccessibleWarning = false;
    private static boolean CACHE_METHODS = true;
    private static final Class<?>[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map<MethodDescriptor, Reference<Method>> cache = Collections.synchronizedMap(new WeakHashMap());

    public static synchronized void setCacheMethods(boolean cacheMethods) {
        CACHE_METHODS = cacheMethods;
        if (!CACHE_METHODS) {
            MethodUtils.clearCache();
        }
    }

    public static synchronized int clearCache() {
        int n2 = cache.size();
        cache.clear();
        return n2;
    }

    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = MethodUtils.toArray(arg);
        return MethodUtils.invokeMethod(object, methodName, objectArray);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int n2 = args.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = args[i2].getClass();
        }
        return MethodUtils.invokeMethod(object, methodName, args, classArray);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = MethodUtils.toArray(arg);
        return MethodUtils.invokeExactMethod(object, methodName, objectArray);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int n2 = args.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = args[i2].getClass();
        }
        return MethodUtils.invokeExactMethod(object, methodName, args, classArray);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactStaticMethod(Class<?> objectClass, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if ((method = MethodUtils.getAccessibleMethod(objectClass, methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + objectClass.getName());
        }
        return method.invoke(null, args);
    }

    public static Object invokeStaticMethod(Class<?> objectClass, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = MethodUtils.toArray(arg);
        return MethodUtils.invokeStaticMethod(objectClass, methodName, objectArray);
    }

    public static Object invokeStaticMethod(Class<?> objectClass, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int n2 = args.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = args[i2].getClass();
        }
        return MethodUtils.invokeStaticMethod(objectClass, methodName, args, classArray);
    }

    public static Object invokeStaticMethod(Class<?> objectClass, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(objectClass, methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + objectClass.getName());
        }
        return method.invoke(null, args);
    }

    public static Object invokeExactStaticMethod(Class<?> objectClass, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = MethodUtils.toArray(arg);
        return MethodUtils.invokeExactStaticMethod(objectClass, methodName, objectArray);
    }

    public static Object invokeExactStaticMethod(Class<?> objectClass, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        int n2 = args.length;
        Class[] classArray = new Class[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classArray[i2] = args[i2].getClass();
        }
        return MethodUtils.invokeExactStaticMethod(objectClass, methodName, args, classArray);
    }

    private static Object[] toArray(Object arg) {
        Object[] objectArray = null;
        if (arg != null) {
            objectArray = new Object[]{arg};
        }
        return objectArray;
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?> parameterType) {
        Class[] classArray = new Class[]{parameterType};
        return MethodUtils.getAccessibleMethod(clazz, methodName, classArray);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        try {
            MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, methodName, parameterTypes, true);
            Method method = MethodUtils.getCachedMethod(methodDescriptor);
            if (method != null) {
                return method;
            }
            Class<?> clazz2 = clazz;
            method = MethodUtils.getAccessibleMethod(clazz2, clazz2.getMethod(methodName, parameterTypes));
            MethodUtils.cacheMethod(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        return MethodUtils.getAccessibleMethod(method.getDeclaringClass(), method);
    }

    public static Method getAccessibleMethod(Class<?> clazz, Method method) {
        Class<?>[] classArray;
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        boolean bl = true;
        if (clazz == null) {
            clazz = method.getDeclaringClass();
        } else {
            bl = clazz.equals(method.getDeclaringClass());
            if (!method.getDeclaringClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(clazz.getName() + " is not assignable from " + method.getDeclaringClass().getName());
            }
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            if (!bl && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                MethodUtils.setMethodAccessible(method);
            }
            return method;
        }
        String string = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string, classArray = method.getParameterTypes())) == null) {
            method = MethodUtils.getAccessibleMethodFromSuperclass(clazz, string, classArray);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (!Modifier.isPublic(clazz2.getModifiers())) continue;
            try {
                return clazz2.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (!Modifier.isPublic(classArray[i2].getModifiers())) continue;
                try {
                    method = classArray[i2].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method != null) {
                    return method;
                }
                method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray[i2], methodName, parameterTypes);
                if (method == null) continue;
                return method;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        Log log = LogFactory.getLog(MethodUtils.class);
        if (log.isTraceEnabled()) {
            log.trace("Matching name=" + methodName + " on " + clazz);
        }
        MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, methodName, parameterTypes, false);
        try {
            Method method = MethodUtils.getCachedMethod(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = clazz.getMethod(methodName, parameterTypes);
            if (log.isTraceEnabled()) {
                log.trace("Found straight match: " + method);
                log.trace("isPublic:" + Modifier.isPublic(method.getModifiers()));
            }
            MethodUtils.setMethodAccessible(method);
            MethodUtils.cacheMethod(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            int n2 = parameterTypes.length;
            Method method = null;
            Method[] methodArray = clazz.getMethods();
            float f2 = Float.MAX_VALUE;
            Method[] methodArray2 = methodArray;
            int n3 = methodArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Class<?>[] classArray;
                int n4;
                Method method2 = methodArray2[i2];
                if (!method2.getName().equals(methodName)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Found matching name:");
                    log.trace(method2);
                }
                if ((n4 = (classArray = method2.getParameterTypes()).length) != n2) continue;
                boolean bl = true;
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (log.isTraceEnabled()) {
                        log.trace("Param=" + parameterTypes[i3].getName());
                        log.trace("Method=" + classArray[i3].getName());
                    }
                    if (MethodUtils.isAssignmentCompatible(classArray[i3], parameterTypes[i3])) continue;
                    if (log.isTraceEnabled()) {
                        log.trace(classArray[i3] + " is not assignable from " + parameterTypes[i3]);
                    }
                    bl = false;
                    break;
                }
                if (!bl) continue;
                Method method3 = MethodUtils.getAccessibleMethod(clazz, method2);
                if (method3 != null) {
                    float f3;
                    if (log.isTraceEnabled()) {
                        log.trace(method3 + " accessible version of " + method2);
                    }
                    MethodUtils.setMethodAccessible(method3);
                    float f4 = MethodUtils.getTotalTransformationCost(parameterTypes, method3.getParameterTypes());
                    if (f3 < f2) {
                        method = method3;
                        f2 = f4;
                    }
                }
                log.trace("Couldn't find accessible method.");
            }
            if (method != null) {
                MethodUtils.cacheMethod(methodDescriptor, method);
            } else {
                log.trace("No match found.");
            }
            return method;
        }
    }

    private static void setMethodAccessible(Method method) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return;
        }
        catch (SecurityException securityException) {
            Log log = LogFactory.getLog(MethodUtils.class);
            if (!loggedAccessibleWarning) {
                boolean bl = false;
                try {
                    String string = System.getProperty("java.specification.version");
                    if (string.charAt(0) == '1' && (string.charAt(2) == '0' || string.charAt(2) == '1' || string.charAt(2) == '2' || string.charAt(2) == '3')) {
                        bl = true;
                    }
                }
                catch (SecurityException securityException2) {
                    bl = true;
                }
                if (bl) {
                    log.warn("Current Security Manager restricts use of workarounds for reflection bugs  in pre-1.4 JVMs.");
                }
                loggedAccessibleWarning = true;
            }
            log.debug("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", securityException);
            return;
        }
    }

    private static float getTotalTransformationCost(Class<?>[] srcArgs, Class<?>[] destArgs) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < srcArgs.length; ++i2) {
            Class<?> clazz = srcArgs[i2];
            Class<?> clazz2 = destArgs[i2];
            f2 += MethodUtils.getObjectTransformationCost(clazz, clazz2);
        }
        return f2;
    }

    private static float getObjectTransformationCost(Class<?> srcClass, Class<?> destClass) {
        float f2 = 0.0f;
        while (srcClass != null && !destClass.equals(srcClass)) {
            Class<?> clazz;
            if (destClass.isPrimitive() && (clazz = MethodUtils.getPrimitiveWrapper(destClass)) != null && clazz.equals(srcClass)) {
                f2 += 0.25f;
                break;
            }
            if (destClass.isInterface() && MethodUtils.isAssignmentCompatible(destClass, srcClass)) {
                f2 += 0.25f;
                break;
            }
            f2 += 1.0f;
            srcClass = srcClass.getSuperclass();
        }
        if (srcClass == null) {
            f2 += 1.5f;
        }
        return f2;
    }

    public static final boolean isAssignmentCompatible(Class<?> parameterType, Class<?> parameterization) {
        Class<?> clazz;
        if (parameterType.isAssignableFrom(parameterization)) {
            return true;
        }
        if (parameterType.isPrimitive() && (clazz = MethodUtils.getPrimitiveWrapper(parameterType)) != null) {
            return clazz.equals(parameterization);
        }
        return false;
    }

    public static Class<?> getPrimitiveWrapper(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        return null;
    }

    public static Class<?> getPrimitiveType(Class<?> wrapperType) {
        if (Boolean.class.equals(wrapperType)) {
            return Boolean.TYPE;
        }
        if (Float.class.equals(wrapperType)) {
            return Float.TYPE;
        }
        if (Long.class.equals(wrapperType)) {
            return Long.TYPE;
        }
        if (Integer.class.equals(wrapperType)) {
            return Integer.TYPE;
        }
        if (Short.class.equals(wrapperType)) {
            return Short.TYPE;
        }
        if (Byte.class.equals(wrapperType)) {
            return Byte.TYPE;
        }
        if (Double.class.equals(wrapperType)) {
            return Double.TYPE;
        }
        if (Character.class.equals(wrapperType)) {
            return Character.TYPE;
        }
        Log log = LogFactory.getLog(MethodUtils.class);
        if (log.isDebugEnabled()) {
            log.debug("Not a known primitive wrapper class: " + wrapperType);
        }
        return null;
    }

    public static Class<?> toNonPrimitiveClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            Class<?> clazz2 = MethodUtils.getPrimitiveWrapper(clazz);
            if (clazz2 != null) {
                return clazz2;
            }
            return clazz;
        }
        return clazz;
    }

    private static Method getCachedMethod(MethodDescriptor md) {
        Reference<Method> reference;
        if (CACHE_METHODS && (reference = cache.get(md)) != null) {
            return reference.get();
        }
        return null;
    }

    private static void cacheMethod(MethodDescriptor md, Method method) {
        if (CACHE_METHODS && method != null) {
            cache.put(md, new WeakReference<Method>(method));
        }
    }

    private static class MethodDescriptor {
        private final Class<?> cls;
        private final String methodName;
        private final Class<?>[] paramTypes;
        private final boolean exact;
        private final int hashCode;

        public MethodDescriptor(Class<?> cls, String methodName, Class<?>[] paramTypes, boolean exact) {
            if (cls == null) {
                throw new IllegalArgumentException("Class cannot be null");
            }
            if (methodName == null) {
                throw new IllegalArgumentException("Method Name cannot be null");
            }
            if (paramTypes == null) {
                paramTypes = EMPTY_CLASS_PARAMETERS;
            }
            this.cls = cls;
            this.methodName = methodName;
            this.paramTypes = paramTypes;
            this.exact = exact;
            this.hashCode = methodName.length();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)obj;
            return this.exact == methodDescriptor.exact && this.methodName.equals(methodDescriptor.methodName) && this.cls.equals(methodDescriptor.cls) && Arrays.equals(this.paramTypes, methodDescriptor.paramTypes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

