/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.beanutils.BeanIntrospectionData;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.DefaultBeanIntrospector;
import org.apache.commons.beanutils.DefaultIntrospectionContext;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.SuppressPropertiesBeanIntrospector;
import org.apache.commons.beanutils.WeakFastHashMap;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUtilsBean {
    private Resolver resolver = new DefaultResolver();
    private WeakFastHashMap<Class<?>, BeanIntrospectionData> descriptorsCache = null;
    private WeakFastHashMap<Class<?>, FastHashMap> mappedDescriptorsCache = null;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Log log = LogFactory.getLog(PropertyUtils.class);
    private final List<BeanIntrospector> introspectors;

    protected static PropertyUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getPropertyUtils();
    }

    public PropertyUtilsBean() {
        this.descriptorsCache = new WeakFastHashMap();
        this.descriptorsCache.setFast(true);
        this.mappedDescriptorsCache = new WeakFastHashMap();
        this.mappedDescriptorsCache.setFast(true);
        this.introspectors = new CopyOnWriteArrayList<BeanIntrospector>();
        this.resetBeanIntrospectors();
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        if (resolver == null) {
            this.resolver = new DefaultResolver();
            return;
        }
        this.resolver = resolver;
    }

    public final void resetBeanIntrospectors() {
        this.introspectors.clear();
        this.introspectors.add(DefaultBeanIntrospector.INSTANCE);
        this.introspectors.add(SuppressPropertiesBeanIntrospector.SUPPRESS_CLASS);
    }

    public void addBeanIntrospector(BeanIntrospector introspector) {
        if (introspector == null) {
            throw new IllegalArgumentException("BeanIntrospector must not be null!");
        }
        this.introspectors.add(introspector);
    }

    public boolean removeBeanIntrospector(BeanIntrospector introspector) {
        return this.introspectors.remove(introspector);
    }

    public void clearDescriptors() {
        this.descriptorsCache.clear();
        this.mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor[] propertyDescriptorArray;
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray;
            DynaProperty[] dynaPropertyArray2 = dynaPropertyArray = ((DynaBean)orig).getDynaClass().getDynaProperties();
            int n2 = dynaPropertyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                DynaProperty dynaProperty = dynaPropertyArray2[i2];
                String string = dynaProperty.getName();
                if (!this.isReadable(orig, string) || !this.isWriteable(dest, string)) continue;
                try {
                    Object object = ((DynaBean)orig).get(string);
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(string, object);
                        continue;
                    }
                    this.setSimpleProperty(dest, string, object);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + string + "' on class '" + dest.getClass() + "'", noSuchMethodException);
                }
            }
            return;
        }
        if (orig instanceof Map) {
            for (Map.Entry entry : ((Map)orig).entrySet()) {
                String string = (String)entry.getKey();
                if (!this.isWriteable(dest, string)) continue;
                try {
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(string, entry.getValue());
                        continue;
                    }
                    this.setSimpleProperty(dest, string, entry.getValue());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Error writing to '" + string + "' on class '" + dest.getClass() + "'", noSuchMethodException);
                }
            }
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray = this.getPropertyDescriptors(orig);
        int n3 = propertyDescriptorArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[i3];
            String string = propertyDescriptor.getName();
            if (!this.isReadable(orig, string) || !this.isWriteable(dest, string)) continue;
            try {
                Object object = this.getSimpleProperty(orig, string);
                if (dest instanceof DynaBean) {
                    ((DynaBean)dest).set(string, object);
                    continue;
                }
                this.setSimpleProperty(dest, string, object);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Error writing to '" + string + "' on class '" + dest.getClass() + "'", noSuchMethodException);
            }
        }
    }

    public Map<String, Object> describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (bean instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray;
            DynaProperty[] dynaPropertyArray2 = dynaPropertyArray = ((DynaBean)bean).getDynaClass().getDynaProperties();
            int n2 = dynaPropertyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                DynaProperty dynaProperty = dynaPropertyArray2[i2];
                String string = dynaProperty.getName();
                hashMap.put(string, this.getProperty(bean, string));
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray;
            PropertyDescriptor[] propertyDescriptorArray2 = propertyDescriptorArray = this.getPropertyDescriptors(bean);
            int n3 = propertyDescriptorArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray2[i3];
                String string = propertyDescriptor.getName();
                if (propertyDescriptor.getReadMethod() == null) continue;
                hashMap.put(string, this.getProperty(bean, string));
            }
        }
        return hashMap;
    }

    public Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int n2;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        try {
            n2 = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "' " + illegalArgumentException.getMessage());
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getIndexedProperty(bean, name, n2);
    }

    public Object getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            if (bean.getClass().isArray()) {
                return Array.get(bean, index);
            }
            if (bean instanceof List) {
                return ((List)bean).get(index);
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            return ((DynaBean)bean).get(name, index);
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(bean, name);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod();
            method = MethodUtils.getAccessibleMethod(bean.getClass(), method);
            if (method != null) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = index;
                try {
                    return this.invokeMethod(method, bean, objectArray2);
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    if (invocationTargetException.getTargetException() instanceof IndexOutOfBoundsException) {
                        throw (IndexOutOfBoundsException)invocationTargetException2.getTargetException();
                    }
                    throw invocationTargetException2;
                }
            }
        }
        if ((method = this.getReadMethod(bean.getClass(), propertyDescriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean.getClass() + "'");
        }
        Object object = this.invokeMethod(method, bean, EMPTY_OBJECT_ARRAY);
        if (!object.getClass().isArray()) {
            if (!(object instanceof List)) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
            }
            return ((List)object).get(index);
        }
        try {
            return Array.get(object, index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Size: " + Array.getLength(object) + " for property '" + name + "'");
        }
    }

    public Object getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String string;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        try {
            string = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "' " + illegalArgumentException.getMessage());
        }
        if (string == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getMappedProperty(bean, name, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class " + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (dynaProperty != null) return ((DynaBean)bean).get(name, key);
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean.getClass() + "'");
        }
        Object object = null;
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(bean, name);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean.getClass() + "'");
        }
        if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            Method method = ((MappedPropertyDescriptor)propertyDescriptor).getMappedReadMethod();
            method = MethodUtils.getAccessibleMethod(bean.getClass(), method);
            if (method == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = key;
            return this.invokeMethod(method, bean, objectArray2);
        }
        Method method = this.getReadMethod(bean.getClass(), propertyDescriptor);
        if (method == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
        Object object2 = this.invokeMethod(method, bean, EMPTY_OBJECT_ARRAY);
        if (!(object2 instanceof Map)) return object;
        return ((Map)object2).get(key);
    }

    @Deprecated
    public FastHashMap getMappedPropertyDescriptors(Class<?> beanClass) {
        if (beanClass == null) {
            return null;
        }
        return this.mappedDescriptorsCache.get(beanClass);
    }

    @Deprecated
    public FastHashMap getMappedPropertyDescriptors(Object bean) {
        if (bean == null) {
            return null;
        }
        return this.getMappedPropertyDescriptors(bean.getClass());
    }

    public Object getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String string = this.resolver.next(name);
            Object object = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, string) : (this.resolver.isMapped(string) ? this.getMappedProperty(bean, string) : (this.resolver.isIndexed(string) ? this.getIndexedProperty(bean, string) : this.getSimpleProperty(bean, string)));
            if (object == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            bean = object;
            name = this.resolver.remove(name);
        }
        bean = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, name) : (this.resolver.isMapped(name) ? this.getMappedProperty(bean, name) : (this.resolver.isIndexed(name) ? this.getIndexedProperty(bean, name) : this.getSimpleProperty(bean, name)));
        return bean;
    }

    protected Object getPropertyOfMapBean(Map<?, ?> bean, String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String string;
        if (this.resolver.isMapped(propertyName) && ((string = this.resolver.getProperty(propertyName)) == null || string.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        return bean.get(propertyName);
    }

    public Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name);
    }

    public PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object;
        Object object2;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            object2 = this.resolver.next(name);
            object = this.getProperty(bean, (String)object2);
            if (object == null) {
                throw new NestedNullException("Null property value for '" + (String)object2 + "' on bean class '" + bean.getClass() + "'");
            }
            bean = object;
            name = this.resolver.remove(name);
        }
        if ((name = this.resolver.getProperty(name)) == null) {
            return null;
        }
        object2 = this.getIntrospectionData(bean.getClass());
        object = ((BeanIntrospectionData)object2).getDescriptor(name);
        if (object != null) {
            return object;
        }
        FastHashMap fastHashMap = this.getMappedPropertyDescriptors(bean);
        if (fastHashMap == null) {
            fastHashMap = new FastHashMap();
            fastHashMap.setFast(true);
            this.mappedDescriptorsCache.put(bean.getClass(), fastHashMap);
        }
        if ((object = (PropertyDescriptor)fastHashMap.get(name)) == null) {
            try {
                object = new MappedPropertyDescriptor(name, bean.getClass());
            }
            catch (IntrospectionException introspectionException) {}
            if (object != null) {
                fastHashMap.put(name, object);
            }
        }
        return object;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class<?> beanClass) {
        return this.getIntrospectionData(beanClass).getDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return this.getPropertyDescriptors(bean.getClass());
    }

    public Class<?> getPropertyEditorClass(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(bean, name);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getPropertyEditorClass();
        }
        return null;
    }

    public Class<?> getPropertyType(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> clazz;
        Object object;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            object = this.resolver.next(name);
            clazz = this.getProperty(bean, (String)object);
            if (clazz == null) {
                throw new NestedNullException("Null property value for '" + (String)object + "' on bean class '" + bean.getClass() + "'");
            }
            bean = clazz;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean instanceof DynaBean) {
            object = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (object == null) {
                return null;
            }
            clazz = ((DynaProperty)object).getType();
            if (clazz == null) {
                return null;
            }
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
            return clazz;
        }
        object = this.getPropertyDescriptor(bean, name);
        if (object == null) {
            return null;
        }
        if (object instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)object).getIndexedPropertyType();
        }
        if (object instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)object).getMappedPropertyType();
        }
        return ((PropertyDescriptor)object).getPropertyType();
    }

    public Method getReadMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getReadMethod());
    }

    Method getReadMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getReadMethod());
    }

    public Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            return ((DynaBean)bean).get(name);
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(bean, name);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method method = this.getReadMethod(bean.getClass(), propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method in class '" + bean.getClass() + "'");
        }
        Object object = this.invokeMethod(method, bean, EMPTY_OBJECT_ARRAY);
        return object;
    }

    public Method getWriteMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getWriteMethod());
    }

    public Method getWriteMethod(Class<?> clazz, PropertyDescriptor descriptor) {
        BeanIntrospectionData beanIntrospectionData = this.getIntrospectionData(clazz);
        return MethodUtils.getAccessibleMethod(clazz, beanIntrospectionData.getWriteMethod(clazz, descriptor));
    }

    public boolean isReadable(Object bean, String name) {
        Object object;
        Object object2;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            object2 = this.resolver.next(name);
            try {
                object = this.getProperty(bean, (String)object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
            if (object == null) {
                throw new NestedNullException("Null property value for '" + (String)object2 + "' on bean class '" + bean.getClass() + "'");
            }
            bean = object;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean instanceof WrapDynaBean) {
            bean = ((WrapDynaBean)bean).getInstance();
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            object2 = this.getPropertyDescriptor(bean, name);
            if (object2 != null) {
                object = this.getReadMethod(bean.getClass(), (PropertyDescriptor)object2);
                if (object == null) {
                    if (object2 instanceof IndexedPropertyDescriptor) {
                        object = ((IndexedPropertyDescriptor)object2).getIndexedReadMethod();
                    } else if (object2 instanceof MappedPropertyDescriptor) {
                        object = ((MappedPropertyDescriptor)object2).getMappedReadMethod();
                    }
                    object = MethodUtils.getAccessibleMethod(bean.getClass(), (Method)object);
                }
                return object != null;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public boolean isWriteable(Object bean, String name) {
        Object object;
        Object object2;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            object2 = this.resolver.next(name);
            try {
                object = this.getProperty(bean, (String)object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
            if (object == null) {
                throw new NestedNullException("Null property value for '" + (String)object2 + "' on bean class '" + bean.getClass() + "'");
            }
            bean = object;
            name = this.resolver.remove(name);
        }
        name = this.resolver.getProperty(name);
        if (bean instanceof WrapDynaBean) {
            bean = ((WrapDynaBean)bean).getInstance();
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            object2 = this.getPropertyDescriptor(bean, name);
            if (object2 != null) {
                object = this.getWriteMethod(bean.getClass(), (PropertyDescriptor)object2);
                if (object == null) {
                    if (object2 instanceof IndexedPropertyDescriptor) {
                        object = ((IndexedPropertyDescriptor)object2).getIndexedWriteMethod();
                    } else if (object2 instanceof MappedPropertyDescriptor) {
                        object = ((MappedPropertyDescriptor)object2).getMappedWriteMethod();
                    }
                    object = MethodUtils.getAccessibleMethod(bean.getClass(), (Method)object);
                }
                return object != null;
            }
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public void setIndexedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        int n2;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        try {
            n2 = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setIndexedProperty(bean, name, n2, value);
    }

    public void setIndexedProperty(Object bean, String name, int index, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            if (bean.getClass().isArray()) {
                Array.set(bean, index, value);
                return;
            }
            if (bean instanceof List) {
                List<Object> list = PropertyUtilsBean.toObjectList(bean);
                list.set(index, value);
                return;
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            ((DynaBean)bean).set(name, index, value);
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(bean, name);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            method = ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod();
            method = MethodUtils.getAccessibleMethod(bean.getClass(), method);
            if (method != null) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = index;
                objectArray2[1] = value;
                try {
                    if (this.log.isTraceEnabled()) {
                        String string = value == null ? "<null>" : value.getClass().getName();
                        this.log.trace("setSimpleProperty: Invoking method " + method + " with index=" + index + ", value=" + value + " (class " + string + ")");
                    }
                    this.invokeMethod(method, bean, objectArray2);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    if (invocationTargetException.getTargetException() instanceof IndexOutOfBoundsException) {
                        throw (IndexOutOfBoundsException)invocationTargetException2.getTargetException();
                    }
                    throw invocationTargetException2;
                }
            }
        }
        if ((method = this.getReadMethod(bean.getClass(), propertyDescriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean.getClass() + "'");
        }
        Object object = this.invokeMethod(method, bean, EMPTY_OBJECT_ARRAY);
        if (!object.getClass().isArray()) {
            if (object instanceof List) {
                List<Object> list = PropertyUtilsBean.toObjectList(object);
                list.set(index, value);
                return;
            }
            throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
        }
        Array.set(object, index, value);
    }

    public void setMappedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String string;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        try {
            string = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (string == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setMappedProperty(bean, name, string, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMappedProperty(Object bean, String name, String key, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] objectArray;
        Method method;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            ((DynaBean)bean).set(name, key, value);
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(bean, name);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (propertyDescriptor instanceof MappedPropertyDescriptor) {
            method = ((MappedPropertyDescriptor)propertyDescriptor).getMappedWriteMethod();
            method = MethodUtils.getAccessibleMethod(bean.getClass(), method);
            if (method == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped setter methodon bean class '" + bean.getClass() + "'");
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = key;
            objectArray[1] = value;
            if (this.log.isTraceEnabled()) {
                String string = value == null ? "<null>" : value.getClass().getName();
                this.log.trace("setSimpleProperty: Invoking method " + method + " with key=" + key + ", value=" + value + " (class " + string + ")");
            }
        } else {
            Method method2 = this.getReadMethod(bean.getClass(), propertyDescriptor);
            if (method2 == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            Object object = this.invokeMethod(method2, bean, EMPTY_OBJECT_ARRAY);
            if (!(object instanceof Map)) return;
            Map<String, Object> map = PropertyUtilsBean.toPropertyMap(object);
            map.put(key, value);
            return;
        }
        this.invokeMethod(method, bean, objectArray);
    }

    public void setNestedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        while (this.resolver.hasNested(name)) {
            String string = this.resolver.next(name);
            Object object = bean instanceof Map ? this.getPropertyOfMapBean((Map)bean, string) : (this.resolver.isMapped(string) ? this.getMappedProperty(bean, string) : (this.resolver.isIndexed(string) ? this.getIndexedProperty(bean, string) : this.getSimpleProperty(bean, string)));
            if (object == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            bean = object;
            name = this.resolver.remove(name);
        }
        if (bean instanceof Map) {
            this.setPropertyOfMapBean(PropertyUtilsBean.toPropertyMap(bean), name, value);
            return;
        }
        if (this.resolver.isMapped(name)) {
            this.setMappedProperty(bean, name, value);
            return;
        }
        if (this.resolver.isIndexed(name)) {
            this.setIndexedProperty(bean, name, value);
            return;
        }
        this.setSimpleProperty(bean, name, value);
    }

    protected void setPropertyOfMapBean(Map<String, Object> bean, String propertyName, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String string;
        if (this.resolver.isMapped(propertyName) && ((string = this.resolver.getProperty(propertyName)) == null || string.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        bean.put(propertyName, value);
    }

    public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setNestedProperty(bean, name, value);
    }

    public void setSimpleProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty dynaProperty = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (dynaProperty == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            ((DynaBean)bean).set(name, value);
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(bean, name);
        if (propertyDescriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method method = this.getWriteMethod(bean.getClass(), propertyDescriptor);
        if (method == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method in class '" + bean.getClass() + "'");
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = value;
        if (this.log.isTraceEnabled()) {
            String string = value == null ? "<null>" : value.getClass().getName();
            this.log.trace("setSimpleProperty: Invoking method " + method + " with value " + value + " (class " + string + ")");
        }
        this.invokeMethod(method, bean, objectArray2);
    }

    private Object invokeMethod(Method method, Object bean, Object[] values) throws IllegalAccessException, InvocationTargetException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified - this should have been checked before reaching this method");
        }
        try {
            return method.invoke(bean, values);
        }
        catch (NullPointerException nullPointerException) {
            IllegalArgumentException illegalArgumentException;
            String string = "";
            if (values != null) {
                for (int i2 = 0; i2 < values.length; ++i2) {
                    if (i2 > 0) {
                        string = string + ", ";
                    }
                    string = values[i2] == null ? string + "<null>" : string + values[i2].getClass().getName();
                }
            }
            String string2 = "";
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray != null) {
                for (int i3 = 0; i3 < classArray.length; ++i3) {
                    if (i3 > 0) {
                        string2 = string2 + ", ";
                    }
                    string2 = string2 + classArray[i3].getName();
                }
            }
            if (!BeanUtils.initCause(illegalArgumentException = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + nullPointerException.getMessage() + " - had objects of type \"" + string + "\" but expected signature \"" + string2 + "\""), nullPointerException)) {
                this.log.error("Method invocation failed", nullPointerException);
            }
            throw illegalArgumentException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalArgumentException illegalArgumentException2;
            String string = "";
            if (values != null) {
                for (int i4 = 0; i4 < values.length; ++i4) {
                    if (i4 > 0) {
                        string = string + ", ";
                    }
                    string = values[i4] == null ? string + "<null>" : string + values[i4].getClass().getName();
                }
            }
            String string3 = "";
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray != null) {
                for (int i5 = 0; i5 < classArray.length; ++i5) {
                    if (i5 > 0) {
                        string3 = string3 + ", ";
                    }
                    string3 = string3 + classArray[i5].getName();
                }
            }
            if (!BeanUtils.initCause(illegalArgumentException2 = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + illegalArgumentException.getMessage() + " - had objects of type \"" + string + "\" but expected signature \"" + string3 + "\""), illegalArgumentException)) {
                this.log.error("Method invocation failed", illegalArgumentException);
            }
            throw illegalArgumentException2;
        }
    }

    private BeanIntrospectionData getIntrospectionData(Class<?> beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        BeanIntrospectionData beanIntrospectionData = this.descriptorsCache.get(beanClass);
        if (beanIntrospectionData == null) {
            beanIntrospectionData = this.fetchIntrospectionData(beanClass);
            this.descriptorsCache.put(beanClass, beanIntrospectionData);
        }
        return beanIntrospectionData;
    }

    private BeanIntrospectionData fetchIntrospectionData(Class<?> beanClass) {
        DefaultIntrospectionContext defaultIntrospectionContext = new DefaultIntrospectionContext(beanClass);
        for (BeanIntrospector beanIntrospector : this.introspectors) {
            try {
                beanIntrospector.introspect(defaultIntrospectionContext);
            }
            catch (IntrospectionException introspectionException) {
                this.log.error("Exception during introspection", introspectionException);
            }
        }
        return new BeanIntrospectionData(defaultIntrospectionContext.getPropertyDescriptors());
    }

    private static List<Object> toObjectList(Object obj) {
        List list = (List)obj;
        return list;
    }

    private static Map<String, Object> toPropertyMap(Object obj) {
        Map map = (Map)obj;
        return map;
    }
}

