/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

public abstract class DateTimeConverter
extends AbstractConverter {
    private String[] patterns;
    private String displayPatterns;
    private Locale locale;
    private TimeZone timeZone;
    private boolean useLocaleFormat;

    public DateTimeConverter() {
    }

    public DateTimeConverter(Object defaultValue) {
        super(defaultValue);
    }

    public void setUseLocaleFormat(boolean useLocaleFormat) {
        this.useLocaleFormat = useLocaleFormat;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setUseLocaleFormat(true);
    }

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
        if (patterns != null && patterns.length > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < patterns.length; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(patterns[i2]);
            }
            this.displayPatterns = stringBuilder.toString();
        }
        this.setUseLocaleFormat(true);
    }

    @Override
    protected String convertToString(Object value) throws Throwable {
        String string;
        Date date = null;
        if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof Calendar) {
            date = ((Calendar)value).getTime();
        } else if (value instanceof Long) {
            date = new Date((Long)value);
        }
        if (this.useLocaleFormat && date != null) {
            DateFormat dateFormat;
            if (this.patterns != null && this.patterns.length > 0) {
                DateTimeConverter dateTimeConverter = this;
                dateFormat = dateTimeConverter.getFormat(dateTimeConverter.patterns[0]);
            } else {
                DateTimeConverter dateTimeConverter = this;
                dateFormat = dateTimeConverter.getFormat(dateTimeConverter.locale, this.timeZone);
            }
            this.logFormat("Formatting", dateFormat);
            string = dateFormat.format(date);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted  to String using format '" + string + "'");
            }
        } else {
            string = value.toString();
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted  to String using toString() '" + string + "'");
            }
        }
        return string;
    }

    @Override
    protected <T> T convertToType(Class<T> targetType, Object value) throws Exception {
        Class<?> clazz = value.getClass();
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            long l2 = timestamp.getTime() / 1000L * 1000L;
            return this.toDate(targetType, l2 += (long)(timestamp.getNanos() / 1000000));
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return this.toDate(targetType, date.getTime());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        if (value instanceof Long) {
            Long l3 = (Long)value;
            return this.toDate(targetType, l3);
        }
        String string = value.toString().trim();
        if (string.length() == 0) {
            return this.handleMissing(targetType);
        }
        if (this.useLocaleFormat) {
            Calendar calendar;
            if (this.patterns != null && this.patterns.length > 0) {
                calendar = this.parse(clazz, targetType, string);
            } else {
                DateTimeConverter dateTimeConverter = this;
                DateFormat dateFormat = dateTimeConverter.getFormat(dateTimeConverter.locale, this.timeZone);
                calendar = this.parse(clazz, targetType, string, dateFormat);
            }
            if (Calendar.class.isAssignableFrom(targetType)) {
                return targetType.cast(calendar);
            }
            return this.toDate(targetType, calendar.getTime().getTime());
        }
        return this.toDate(targetType, string);
    }

    private <T> T toDate(Class<T> type, long value) {
        if (type.equals(Date.class)) {
            return type.cast(new Date(value));
        }
        if (type.equals(java.sql.Date.class)) {
            return type.cast(new java.sql.Date(value));
        }
        if (type.equals(Time.class)) {
            return type.cast(new Time(value));
        }
        if (type.equals(Timestamp.class)) {
            return type.cast(new Timestamp(value));
        }
        if (type.equals(Calendar.class)) {
            Calendar calendar = this.locale == null && this.timeZone == null ? Calendar.getInstance() : (this.locale == null ? Calendar.getInstance(this.timeZone) : (this.timeZone == null ? Calendar.getInstance(this.locale) : Calendar.getInstance(this.timeZone, this.locale)));
            calendar.setTime(new Date(value));
            calendar.setLenient(false);
            return type.cast(calendar);
        }
        DateTimeConverter dateTimeConverter = this;
        String string = dateTimeConverter.toString(dateTimeConverter.getClass()) + " cannot handle conversion to '" + this.toString(type) + "'";
        if (this.log().isWarnEnabled()) {
            this.log().warn("    " + string);
        }
        throw new ConversionException(string);
    }

    private <T> T toDate(Class<T> type, String value) {
        if (type.equals(java.sql.Date.class)) {
            try {
                return type.cast(java.sql.Date.valueOf(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd] to create a java.sql.Date");
            }
        }
        if (type.equals(Time.class)) {
            try {
                return type.cast(Time.valueOf(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConversionException("String must be in JDBC format [HH:mm:ss] to create a java.sql.Time");
            }
        }
        if (type.equals(Timestamp.class)) {
            try {
                return type.cast(Timestamp.valueOf(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConversionException("String must be in JDBC format [yyyy-MM-dd HH:mm:ss.fffffffff] to create a java.sql.Timestamp");
            }
        }
        DateTimeConverter dateTimeConverter = this;
        String string = dateTimeConverter.toString(dateTimeConverter.getClass()) + " does not support default String to '" + this.toString(type) + "' conversion.";
        if (this.log().isWarnEnabled()) {
            this.log().warn("    " + string);
            this.log().warn("    (N.B. Re-configure Converter or use alternative implementation)");
        }
        throw new ConversionException(string);
    }

    protected DateFormat getFormat(Locale locale, TimeZone timeZone) {
        DateFormat format = locale == null ? DateFormat.getDateInstance(3) : DateFormat.getDateInstance(3, locale);
        if (timeZone != null) {
            format.setTimeZone(timeZone);
        }
        return format;
    }

    private DateFormat getFormat(String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        if (this.timeZone != null) {
            simpleDateFormat.setTimeZone(this.timeZone);
        }
        return simpleDateFormat;
    }

    private Calendar parse(Class<?> sourceType, Class<?> targetType, String value) throws Exception {
        Exception exception = null;
        String[] stringArray = this.patterns;
        int n2 = this.patterns.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            try {
                DateFormat dateFormat = this.getFormat(string);
                Calendar calendar = this.parse(sourceType, targetType, value, dateFormat);
                return calendar;
            }
            catch (Exception exception2) {
                if (exception != null) continue;
                exception = exception2;
                continue;
            }
        }
        if (this.patterns.length > 1) {
            throw new ConversionException("Error converting '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "' using  patterns '" + this.displayPatterns + "'");
        }
        throw exception;
    }

    private Calendar parse(Class<?> sourceType, Class<?> targetType, String value, DateFormat format) {
        this.logFormat("Parsing", format);
        format.setLenient(false);
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = format.parse(value, parsePosition);
        if (parsePosition.getErrorIndex() >= 0 || parsePosition.getIndex() != value.length() || date == null) {
            String string = "Error converting '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
            if (format instanceof SimpleDateFormat) {
                string = string + " using pattern '" + ((SimpleDateFormat)format).toPattern() + "'";
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("    " + string);
            }
            throw new ConversionException(string);
        }
        Calendar calendar = format.getCalendar();
        return calendar;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        DateTimeConverter dateTimeConverter = this;
        stringBuilder.append(dateTimeConverter.toString(dateTimeConverter.getClass()));
        stringBuilder.append("[UseDefault=");
        stringBuilder.append(this.isUseDefault());
        stringBuilder.append(", UseLocaleFormat=");
        stringBuilder.append(this.useLocaleFormat);
        if (this.displayPatterns != null) {
            stringBuilder.append(", Patterns={");
            stringBuilder.append(this.displayPatterns);
            stringBuilder.append('}');
        }
        if (this.locale != null) {
            stringBuilder.append(", Locale=");
            stringBuilder.append(this.locale);
        }
        if (this.timeZone != null) {
            stringBuilder.append(", TimeZone=");
            stringBuilder.append(this.timeZone);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void logFormat(String action, DateFormat format) {
        if (this.log().isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(45);
            stringBuilder.append("    ");
            stringBuilder.append(action);
            stringBuilder.append(" with Format");
            if (format instanceof SimpleDateFormat) {
                stringBuilder.append("[");
                stringBuilder.append(((SimpleDateFormat)format).toPattern());
                stringBuilder.append("]");
            }
            stringBuilder.append(" for ");
            if (this.locale == null) {
                stringBuilder.append("default locale");
            } else {
                stringBuilder.append("locale[");
                stringBuilder.append(this.locale);
                stringBuilder.append("]");
            }
            if (this.timeZone != null) {
                stringBuilder.append(", TimeZone[");
                stringBuilder.append(this.timeZone);
                stringBuilder.append("]");
            }
            this.log().debug(stringBuilder.toString());
        }
    }
}

