/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleBeanUtilsBean
extends BeanUtilsBean {
    private static final ContextClassLoaderLocal<LocaleBeanUtilsBean> LOCALE_BEANS_BY_CLASSLOADER = new ContextClassLoaderLocal<LocaleBeanUtilsBean>(){

        @Override
        protected final LocaleBeanUtilsBean initialValue() {
            return new LocaleBeanUtilsBean();
        }
    };
    private final Log log = LogFactory.getLog(LocaleBeanUtilsBean.class);
    private final LocaleConvertUtilsBean localeConvertUtils;

    public static LocaleBeanUtilsBean getLocaleBeanUtilsInstance() {
        return LOCALE_BEANS_BY_CLASSLOADER.get();
    }

    public static void setInstance(LocaleBeanUtilsBean newInstance) {
        LOCALE_BEANS_BY_CLASSLOADER.set(newInstance);
    }

    public LocaleBeanUtilsBean() {
        this.localeConvertUtils = new LocaleConvertUtilsBean();
    }

    public LocaleBeanUtilsBean(LocaleConvertUtilsBean localeConvertUtils, ConvertUtilsBean convertUtilsBean, PropertyUtilsBean propertyUtilsBean) {
        super(convertUtilsBean, propertyUtilsBean);
        this.localeConvertUtils = localeConvertUtils;
    }

    public LocaleBeanUtilsBean(LocaleConvertUtilsBean localeConvertUtils) {
        this.localeConvertUtils = localeConvertUtils;
    }

    public LocaleConvertUtilsBean getLocaleConvertUtils() {
        return this.localeConvertUtils;
    }

    public Locale getDefaultLocale() {
        return this.getLocaleConvertUtils().getDefaultLocale();
    }

    public void setDefaultLocale(Locale locale) {
        this.getLocaleConvertUtils().setDefaultLocale(locale);
    }

    public boolean getApplyLocalized() {
        return this.getLocaleConvertUtils().getApplyLocalized();
    }

    public void setApplyLocalized(boolean newApplyLocalized) {
        this.getLocaleConvertUtils().setApplyLocalized(newApplyLocalized);
    }

    public String getIndexedProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getIndexedProperty(bean, name);
        return this.getLocaleConvertUtils().convert(object, pattern);
    }

    @Override
    public String getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getIndexedProperty(bean, name, null);
    }

    public String getIndexedProperty(Object bean, String name, int index, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getIndexedProperty(bean, name, index);
        return this.getLocaleConvertUtils().convert(object, pattern);
    }

    @Override
    public String getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getIndexedProperty(bean, name, index, null);
    }

    public String getSimpleProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getSimpleProperty(bean, name);
        return this.getLocaleConvertUtils().convert(object, pattern);
    }

    @Override
    public String getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getSimpleProperty(bean, name, null);
    }

    public String getMappedProperty(Object bean, String name, String key, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getMappedProperty(bean, name, key);
        return this.getLocaleConvertUtils().convert(object, pattern);
    }

    @Override
    public String getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getMappedProperty(bean, name, key, null);
    }

    public String getMappedPropertyLocale(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getMappedProperty(bean, name);
        return this.getLocaleConvertUtils().convert(object, pattern);
    }

    @Override
    public String getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getMappedPropertyLocale(bean, name, null);
    }

    public String getNestedProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = this.getPropertyUtils().getNestedProperty(bean, name);
        return this.getLocaleConvertUtils().convert(object, pattern);
    }

    @Override
    public String getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name, null);
    }

    public String getProperty(Object bean, String name, String pattern) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name, pattern);
    }

    @Override
    public String getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name);
    }

    @Override
    public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        this.setProperty(bean, name, value, null);
    }

    public void setProperty(Object bean, String name, Object value, String pattern) throws IllegalAccessException, InvocationTargetException {
        String[] stringArray;
        Object object;
        if (this.log.isTraceEnabled()) {
            object = new StringBuilder("  setProperty(");
            ((StringBuilder)object).append(bean);
            ((StringBuilder)object).append(", ");
            ((StringBuilder)object).append(name);
            ((StringBuilder)object).append(", ");
            if (value == null) {
                ((StringBuilder)object).append("<NULL>");
            } else if (value instanceof String) {
                ((StringBuilder)object).append((String)value);
            } else if (value instanceof String[]) {
                stringArray = (String[])value;
                ((StringBuilder)object).append('[');
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (i2 > 0) {
                        ((StringBuilder)object).append(',');
                    }
                    ((StringBuilder)object).append(stringArray[i2]);
                }
                ((StringBuilder)object).append(']');
            } else {
                ((StringBuilder)object).append(value.toString());
            }
            ((StringBuilder)object).append(')');
            this.log.trace(((StringBuilder)object).toString());
        }
        object = bean;
        stringArray = this.getPropertyUtils().getResolver();
        while (stringArray.hasNested(name)) {
            try {
                object = this.getPropertyUtils().getProperty(object, stringArray.next(name));
                name = stringArray.remove(name);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + object);
            this.log.trace("    Target name = " + name);
        }
        String string = stringArray.getProperty(name);
        int n2 = stringArray.getIndex(name);
        String string2 = stringArray.getKey(name);
        Class<?> clazz = this.definePropertyType(object, name, string);
        if (clazz != null) {
            Object object2 = this.convert(clazz, n2, value, pattern);
            this.invokeSetter(object, string, string2, n2, object2);
        }
    }

    protected Class<?> definePropertyType(Object target, String name, String propName) throws IllegalAccessException, InvocationTargetException {
        Class<?> type;
        if (target instanceof DynaBean) {
            DynaClass dynaClass = ((DynaBean)target).getDynaClass();
            DynaProperty dynaProperty = dynaClass.getDynaProperty(propName);
            if (dynaProperty == null) {
                return null;
            }
            type = dynaProperty.getType();
        } else {
            PropertyDescriptor propertyDescriptor;
            try {
                propertyDescriptor = this.getPropertyUtils().getPropertyDescriptor(target, name);
                if (propertyDescriptor == null) {
                    return null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
            type = propertyDescriptor instanceof MappedPropertyDescriptor ? ((MappedPropertyDescriptor)propertyDescriptor).getMappedPropertyType() : (propertyDescriptor instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)propertyDescriptor).getIndexedPropertyType() : propertyDescriptor.getPropertyType());
        }
        return type;
    }

    protected Object convert(Class<?> type, int index, Object value, String pattern) {
        Object object;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Converting value '" + value + "' to type:" + type);
        }
        if (type.isArray() && index < 0) {
            if (value instanceof String) {
                String[] stringArray = new String[1];
                String[] stringArray2 = stringArray;
                stringArray[0] = (String)value;
                object = this.getLocaleConvertUtils().convert(stringArray2, type, pattern);
            } else {
                object = value instanceof String[] ? this.getLocaleConvertUtils().convert((String[])value, type, pattern) : value;
            }
        } else {
            object = type.isArray() ? (value instanceof String ? this.getLocaleConvertUtils().convert((String)value, type.getComponentType(), pattern) : (value instanceof String[] ? this.getLocaleConvertUtils().convert(((String[])value)[0], type.getComponentType(), pattern) : value)) : (value instanceof String ? this.getLocaleConvertUtils().convert((String)value, type, pattern) : (value instanceof String[] ? this.getLocaleConvertUtils().convert(((String[])value)[0], type, pattern) : value));
        }
        return object;
    }

    protected Object convert(Class<?> type, int index, Object value) {
        Object newValue;
        if (type.isArray() && index < 0) {
            if (value instanceof String) {
                String[] stringArray = new String[1];
                String[] stringArray2 = stringArray;
                stringArray[0] = (String)value;
                newValue = ConvertUtils.convert(stringArray2, type);
            } else {
                newValue = value instanceof String[] ? ConvertUtils.convert((String[])value, type) : value;
            }
        } else {
            newValue = type.isArray() ? (value instanceof String ? ConvertUtils.convert((String)value, type.getComponentType()) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type.getComponentType()) : value)) : (value instanceof String ? ConvertUtils.convert((String)value, type) : (value instanceof String[] ? ConvertUtils.convert(((String[])value)[0], type) : value));
        }
        return newValue;
    }

    protected void invokeSetter(Object target, String propName, String key, int index, Object newValue) throws IllegalAccessException, InvocationTargetException {
        block4: {
            try {
                if (index >= 0) {
                    this.getPropertyUtils().setIndexedProperty(target, propName, index, newValue);
                    break block4;
                }
                if (key != null) {
                    this.getPropertyUtils().setMappedProperty(target, propName, key, newValue);
                    break block4;
                }
                this.getPropertyUtils().setProperty(target, propName, newValue);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvocationTargetException(noSuchMethodException, "Cannot set " + propName);
            }
        }
    }

    @Deprecated
    protected Descriptor calculate(Object bean, String name) throws IllegalAccessException, InvocationTargetException {
        Object object = bean;
        Resolver resolver = this.getPropertyUtils().getResolver();
        while (resolver.hasNested(name)) {
            try {
                object = this.getPropertyUtils().getProperty(object, resolver.next(name));
                name = resolver.remove(name);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    Target bean = " + object);
            this.log.trace("    Target name = " + name);
        }
        String string = resolver.getProperty(name);
        int n2 = resolver.getIndex(name);
        String string2 = resolver.getKey(name);
        return new Descriptor(object, name, string, string2, n2);
    }

    @Deprecated
    protected class Descriptor {
        private int index = -1;
        private String name;
        private String propName;
        private String key;
        private Object target;

        public Descriptor(Object target, String name, String propName, String key, int index) {
            this.setTarget(target);
            this.setName(name);
            this.setPropName(propName);
            this.setKey(key);
            this.setIndex(index);
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPropName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }
    }
}

