/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.PriorityQueue;

public final class BinaryHeap
extends AbstractCollection
implements Buffer,
PriorityQueue {
    private static final int DEFAULT_CAPACITY = 13;
    int m_size;
    Object[] m_elements;
    boolean m_isMinHeap;
    Comparator m_comparator;

    public BinaryHeap() {
        this(13, true);
    }

    public BinaryHeap(Comparator comparator) {
        this();
        this.m_comparator = comparator;
    }

    public BinaryHeap(int capacity) {
        this(capacity, true);
    }

    public BinaryHeap(int capacity, Comparator comparator) {
        this(capacity);
        this.m_comparator = comparator;
    }

    public BinaryHeap(boolean isMinHeap) {
        this(13, isMinHeap);
    }

    public BinaryHeap(boolean isMinHeap, Comparator comparator) {
        this(isMinHeap);
        this.m_comparator = comparator;
    }

    public BinaryHeap(int capacity, boolean isMinHeap) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.m_isMinHeap = isMinHeap;
        this.m_elements = new Object[capacity + 1];
    }

    public BinaryHeap(int capacity, boolean isMinHeap, Comparator comparator) {
        this(capacity, isMinHeap);
        this.m_comparator = comparator;
    }

    public final void clear() {
        this.m_elements = new Object[this.m_elements.length];
        this.m_size = 0;
    }

    public final boolean isEmpty() {
        return this.m_size == 0;
    }

    public final boolean isFull() {
        return this.m_elements.length == this.m_size + 1;
    }

    public final void insert(Object element) {
        if (this.isFull()) {
            this.grow();
        }
        if (this.m_isMinHeap) {
            this.percolateUpMinHeap(element);
            return;
        }
        this.percolateUpMaxHeap(element);
    }

    public final Object peek() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.m_elements[1];
    }

    public final Object pop() throws NoSuchElementException {
        Object object = this.peek();
        this.m_elements[1] = this.m_elements[this.m_size--];
        this.m_elements[this.m_size + 1] = null;
        if (this.m_size != 0) {
            if (this.m_isMinHeap) {
                this.percolateDownMinHeap(1);
            } else {
                this.percolateDownMaxHeap(1);
            }
        }
        return object;
    }

    protected final void percolateDownMinHeap(int index) {
        Object object = this.m_elements[index];
        int n2 = index;
        while (n2 << 1 <= this.m_size) {
            int n3 = n2 << 1;
            if (n3 != this.m_size) {
                BinaryHeap binaryHeap = this;
                if (binaryHeap.compare(binaryHeap.m_elements[n3 + 1], this.m_elements[n3]) < 0) {
                    ++n3;
                }
            }
            BinaryHeap binaryHeap = this;
            if (binaryHeap.compare(binaryHeap.m_elements[n3], object) >= 0) break;
            this.m_elements[n2] = this.m_elements[n3];
            n2 = n3;
        }
        this.m_elements[n2] = object;
    }

    protected final void percolateDownMaxHeap(int index) {
        Object object = this.m_elements[index];
        int n2 = index;
        while (n2 << 1 <= this.m_size) {
            int n3 = n2 << 1;
            if (n3 != this.m_size) {
                BinaryHeap binaryHeap = this;
                if (binaryHeap.compare(binaryHeap.m_elements[n3 + 1], this.m_elements[n3]) > 0) {
                    ++n3;
                }
            }
            BinaryHeap binaryHeap = this;
            if (binaryHeap.compare(binaryHeap.m_elements[n3], object) <= 0) break;
            this.m_elements[n2] = this.m_elements[n3];
            n2 = n3;
        }
        this.m_elements[n2] = object;
    }

    protected final void percolateUpMinHeap(int index) {
        int n2 = index;
        Object object = this.m_elements[index];
        while (n2 > 1 && this.compare(object, this.m_elements[n2 / 2]) < 0) {
            int n3 = n2 / 2;
            this.m_elements[n2] = this.m_elements[n3];
            n2 = n3;
        }
        this.m_elements[n2] = object;
    }

    protected final void percolateUpMinHeap(Object element) {
        this.m_elements[++this.m_size] = element;
        BinaryHeap binaryHeap = this;
        binaryHeap.percolateUpMinHeap(binaryHeap.m_size);
    }

    protected final void percolateUpMaxHeap(int index) {
        int n2 = index;
        Object object = this.m_elements[index];
        while (n2 > 1 && this.compare(object, this.m_elements[n2 / 2]) > 0) {
            int n3 = n2 / 2;
            this.m_elements[n2] = this.m_elements[n3];
            n2 = n3;
        }
        this.m_elements[n2] = object;
    }

    protected final void percolateUpMaxHeap(Object element) {
        this.m_elements[++this.m_size] = element;
        BinaryHeap binaryHeap = this;
        binaryHeap.percolateUpMaxHeap(binaryHeap.m_size);
    }

    private int compare(Object a2, Object b2) {
        if (this.m_comparator != null) {
            return this.m_comparator.compare(a2, b2);
        }
        return ((Comparable)a2).compareTo(b2);
    }

    protected final void grow() {
        Object[] objectArray = new Object[this.m_elements.length << 1];
        System.arraycopy(this.m_elements, 0, objectArray, 0, this.m_elements.length);
        this.m_elements = objectArray;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        for (int i2 = 1; i2 < this.m_size + 1; ++i2) {
            if (i2 != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.m_elements[i2]);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public final Iterator iterator() {
        return new Iterator(this){
            private int index;
            private int lastReturnedIndex;
            private final BinaryHeap this$0;
            {
                this.this$0 = binaryHeap;
                this.index = 1;
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                return this.index <= this.this$0.m_size;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index++;
                return this.this$0.m_elements[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                this.this$0.m_elements[this.lastReturnedIndex] = this.this$0.m_elements[this.this$0.m_size];
                this.this$0.m_elements[this.this$0.m_size] = null;
                --this.this$0.m_size;
                if (this.this$0.m_size != 0 && this.lastReturnedIndex <= this.this$0.m_size) {
                    int n2 = 0;
                    if (this.lastReturnedIndex > 1) {
                        n2 = BinaryHeap.access$000(this.this$0, this.this$0.m_elements[this.lastReturnedIndex], this.this$0.m_elements[this.lastReturnedIndex / 2]);
                    }
                    if (this.this$0.m_isMinHeap) {
                        if (this.lastReturnedIndex > 1 && n2 < 0) {
                            this.this$0.percolateUpMinHeap(this.lastReturnedIndex);
                        } else {
                            this.this$0.percolateDownMinHeap(this.lastReturnedIndex);
                        }
                    } else if (this.lastReturnedIndex > 1 && n2 > 0) {
                        this.this$0.percolateUpMaxHeap(this.lastReturnedIndex);
                    } else {
                        this.this$0.percolateDownMaxHeap(this.lastReturnedIndex);
                    }
                }
                --this.index;
                this.lastReturnedIndex = -1;
            }
        };
    }

    public final boolean add(Object object) {
        this.insert(object);
        return true;
    }

    public final Object get() {
        try {
            return this.peek();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new BufferUnderflowException();
        }
    }

    public final Object remove() {
        try {
            return this.pop();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new BufferUnderflowException();
        }
    }

    public final int size() {
        return this.m_size;
    }

    static int access$000(BinaryHeap x0, Object x1, Object x2) {
        return x0.compare(x1, x2);
    }
}

