/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.PredicatedCollection;
import org.apache.commons.collections.collection.SynchronizedCollection;
import org.apache.commons.collections.collection.TransformedCollection;
import org.apache.commons.collections.collection.TypedCollection;
import org.apache.commons.collections.collection.UnmodifiableBoundedCollection;
import org.apache.commons.collections.collection.UnmodifiableCollection;

public class CollectionUtils {
    private static Integer INTEGER_ONE = 1;
    public static final Collection EMPTY_COLLECTION = UnmodifiableCollection.decorate(new ArrayList());

    public static Collection union(Collection a2, Collection b2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(a2);
        Map map2 = CollectionUtils.getCardinalityMap(b2);
        HashSet hashSet = new HashSet(a2);
        hashSet.addAll(b2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = Math.max(CollectionUtils.getFreq(e2, map), CollectionUtils.getFreq(e2, map2));
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    public static Collection intersection(Collection a2, Collection b2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(a2);
        Map map2 = CollectionUtils.getCardinalityMap(b2);
        HashSet hashSet = new HashSet(a2);
        hashSet.addAll(b2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = Math.min(CollectionUtils.getFreq(e2, map), CollectionUtils.getFreq(e2, map2));
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    public static Collection disjunction(Collection a2, Collection b2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(a2);
        Map map2 = CollectionUtils.getCardinalityMap(b2);
        HashSet hashSet = new HashSet(a2);
        hashSet.addAll(b2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = Math.max(CollectionUtils.getFreq(e2, map), CollectionUtils.getFreq(e2, map2)) - Math.min(CollectionUtils.getFreq(e2, map), CollectionUtils.getFreq(e2, map2));
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    public static Collection subtract(Collection a2, Collection b2) {
        ArrayList arrayList = new ArrayList(a2);
        Iterator iterator = b2.iterator();
        while (iterator.hasNext()) {
            arrayList.remove(iterator.next());
        }
        return arrayList;
    }

    public static boolean containsAny(Collection coll1, Collection coll2) {
        if (coll1.size() < coll2.size()) {
            Iterator iterator = coll1.iterator();
            while (iterator.hasNext()) {
                if (!coll2.contains(iterator.next())) continue;
                return true;
            }
        } else {
            Iterator iterator = coll2.iterator();
            while (iterator.hasNext()) {
                if (!coll1.contains(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Map getCardinalityMap(Collection coll) {
        HashMap hashMap = new HashMap();
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Integer n2 = (Integer)hashMap.get(e2);
            if (n2 == null) {
                hashMap.put(e2, INTEGER_ONE);
                continue;
            }
            hashMap.put(e2, new Integer(n2 + 1));
        }
        return hashMap;
    }

    public static boolean isSubCollection(Collection a2, Collection b2) {
        Map map = CollectionUtils.getCardinalityMap(a2);
        Map map2 = CollectionUtils.getCardinalityMap(b2);
        Iterator iterator = a2.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (CollectionUtils.getFreq(e2, map) <= CollectionUtils.getFreq(e2, map2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProperSubCollection(Collection a2, Collection b2) {
        return a2.size() < b2.size() && CollectionUtils.isSubCollection(a2, b2);
    }

    public static boolean isEqualCollection(Collection a2, Collection b2) {
        if (a2.size() != b2.size()) {
            return false;
        }
        Map map = CollectionUtils.getCardinalityMap(a2);
        Map map2 = CollectionUtils.getCardinalityMap(b2);
        if (map.size() != map2.size()) {
            return false;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            if (CollectionUtils.getFreq(k2, map) == CollectionUtils.getFreq(k2, map2)) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(Object obj, Collection coll) {
        if (coll instanceof Set) {
            if (coll.contains(obj)) {
                return 1;
            }
            return 0;
        }
        if (coll instanceof Bag) {
            return ((Bag)coll).getCount(obj);
        }
        int n2 = 0;
        if (obj == null) {
            Iterator iterator = coll.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                ++n2;
            }
        } else {
            Iterator iterator = coll.iterator();
            while (iterator.hasNext()) {
                if (!obj.equals(iterator.next())) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static Object find(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!predicate.evaluate(e2)) continue;
                return e2;
            }
        }
        return null;
    }

    public static void forAllDo(Collection collection, Closure closure) {
        if (collection != null && closure != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                closure.execute(iterator.next());
            }
        }
    }

    public static void filter(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (predicate.evaluate(iterator.next())) continue;
                iterator.remove();
            }
        }
    }

    public static void transform(Collection collection, Transformer transformer) {
        if (collection != null && transformer != null) {
            if (collection instanceof List) {
                List list = (List)collection;
                ListIterator<Object> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    listIterator.set(transformer.transform(listIterator.next()));
                }
                return;
            }
            Collection collection2 = CollectionUtils.collect(collection, transformer);
            collection.clear();
            collection.addAll(collection2);
        }
    }

    public static int countMatches(Collection inputCollection, Predicate predicate) {
        int n2 = 0;
        if (inputCollection != null && predicate != null) {
            Iterator iterator = inputCollection.iterator();
            while (iterator.hasNext()) {
                if (!predicate.evaluate(iterator.next())) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static boolean exists(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!predicate.evaluate(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection select(Collection inputCollection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(inputCollection.size());
        CollectionUtils.select(inputCollection, predicate, arrayList);
        return arrayList;
    }

    public static void select(Collection inputCollection, Predicate predicate, Collection outputCollection) {
        if (inputCollection != null && predicate != null) {
            Iterator iterator = inputCollection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!predicate.evaluate(e2)) continue;
                outputCollection.add(e2);
            }
        }
    }

    public static Collection selectRejected(Collection inputCollection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(inputCollection.size());
        CollectionUtils.selectRejected(inputCollection, predicate, arrayList);
        return arrayList;
    }

    public static void selectRejected(Collection inputCollection, Predicate predicate, Collection outputCollection) {
        if (inputCollection != null && predicate != null) {
            Iterator iterator = inputCollection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (predicate.evaluate(e2)) continue;
                outputCollection.add(e2);
            }
        }
    }

    public static Collection collect(Collection inputCollection, Transformer transformer) {
        ArrayList arrayList = new ArrayList(inputCollection.size());
        CollectionUtils.collect(inputCollection, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Iterator inputIterator, Transformer transformer) {
        ArrayList arrayList = new ArrayList();
        CollectionUtils.collect(inputIterator, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Collection inputCollection, Transformer transformer, Collection outputCollection) {
        if (inputCollection != null) {
            return CollectionUtils.collect(inputCollection.iterator(), transformer, outputCollection);
        }
        return outputCollection;
    }

    public static Collection collect(Iterator inputIterator, Transformer transformer, Collection outputCollection) {
        if (inputIterator != null && transformer != null) {
            while (inputIterator.hasNext()) {
                Object e2 = inputIterator.next();
                Object object = transformer.transform(e2);
                outputCollection.add(object);
            }
        }
        return outputCollection;
    }

    public static boolean addIgnoreNull(Collection collection, Object object) {
        if (object == null) {
            return false;
        }
        return collection.add(object);
    }

    public static void addAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static void addAll(Collection collection, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static void addAll(Collection collection, Object[] elements) {
        int n2 = elements.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            collection.add(elements[i2]);
        }
    }

    public static Object index(Object obj, int idx) {
        return CollectionUtils.index(obj, (Object)idx);
    }

    public static Object index(Object obj, Object index) {
        Map map;
        if (obj instanceof Map && (map = (Map)obj).containsKey(index)) {
            return map.get(index);
        }
        int n2 = -1;
        if (index instanceof Integer) {
            n2 = (Integer)index;
        }
        if (n2 < 0) {
            return obj;
        }
        if (obj instanceof Map) {
            Map map2 = (Map)obj;
            Iterator iterator = map2.keySet().iterator();
            return CollectionUtils.index(iterator, n2);
        }
        if (obj instanceof List) {
            return ((List)obj).get(n2);
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj)[n2];
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                if (--n2 == -1) {
                    return enumeration.nextElement();
                }
                enumeration.nextElement();
            }
        } else {
            if (obj instanceof Iterator) {
                return CollectionUtils.index((Iterator)obj, n2);
            }
            if (obj instanceof Collection) {
                Iterator iterator = ((Collection)obj).iterator();
                return CollectionUtils.index(iterator, n2);
            }
        }
        return obj;
    }

    private static Object index(Iterator iterator, int idx) {
        while (iterator.hasNext()) {
            if (--idx == -1) {
                return iterator.next();
            }
            iterator.next();
        }
        return iterator;
    }

    public static Object get(Object object, int index) {
        Object object2;
        while (true) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
            }
            if (object instanceof Map) {
                object2 = (Map)((Object)object);
                Iterator iterator = object2.entrySet().iterator();
                object = iterator;
                continue;
            }
            if (object instanceof List) {
                return ((List)((Object)object)).get(index);
            }
            if (object instanceof Object[]) {
                return ((Object[])object)[index];
            }
            if (object instanceof Iterator) {
                object2 = object;
                while (object2.hasNext()) {
                    if (--index == -1) {
                        return object2.next();
                    }
                    object2.next();
                }
                throw new IndexOutOfBoundsException("Entry does not exist: " + index);
            }
            if (!(object instanceof Collection)) break;
            object2 = ((Collection)((Object)object)).iterator();
            object = object2;
        }
        if (object instanceof Enumeration) {
            object2 = (Enumeration)((Object)object);
            while (object2.hasMoreElements()) {
                if (--index == -1) {
                    return object2.nextElement();
                }
                object2.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, index);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static int size(Object object) {
        int n2 = 0;
        if (object instanceof Map) {
            n2 = ((Map)object).size();
        } else if (object instanceof Collection) {
            n2 = ((Collection)object).size();
        } else if (object instanceof Object[]) {
            n2 = ((Object[])object).length;
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                ++n2;
                iterator.next();
            }
        } else if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                ++n2;
                enumeration.nextElement();
            }
        } else {
            if (object == null) {
                throw new IllegalArgumentException("Unsupported object type: null");
            }
            try {
                n2 = Array.getLength(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
            }
        }
        return n2;
    }

    public static boolean sizeIsEmpty(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Iterator) {
            return !((Iterator)object).hasNext();
        }
        if (object instanceof Enumeration) {
            return !((Enumeration)object).hasMoreElements();
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.getLength(object) == 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static void reverseArray(Object[] array) {
        int n2 = 0;
        for (int i2 = array.length - 1; i2 > n2; --i2, ++n2) {
            Object object = array[i2];
            array[i2] = array[n2];
            array[n2] = object;
        }
    }

    private static final int getFreq(Object obj, Map freqMap) {
        Integer n2 = (Integer)freqMap.get(obj);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    public static boolean isFull(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (coll instanceof BoundedCollection) {
            return ((BoundedCollection)coll).isFull();
        }
        try {
            BoundedCollection boundedCollection = UnmodifiableBoundedCollection.decorateUsing(coll);
            return boundedCollection.isFull();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static int maxSize(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (coll instanceof BoundedCollection) {
            return ((BoundedCollection)coll).maxSize();
        }
        try {
            BoundedCollection boundedCollection = UnmodifiableBoundedCollection.decorateUsing(coll);
            return boundedCollection.maxSize();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    public static Collection retainAll(Collection collection, Collection retain) {
        return ListUtils.retainAll(collection, retain);
    }

    public static Collection removeAll(Collection collection, Collection remove) {
        return ListUtils.removeAll(collection, remove);
    }

    public static Collection synchronizedCollection(Collection collection) {
        return SynchronizedCollection.decorate(collection);
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return UnmodifiableCollection.decorate(collection);
    }

    public static Collection predicatedCollection(Collection collection, Predicate predicate) {
        return PredicatedCollection.decorate(collection, predicate);
    }

    public static Collection typedCollection(Collection collection, Class type) {
        return TypedCollection.decorate(collection, type);
    }

    public static Collection transformedCollection(Collection collection, Transformer transformer) {
        return TransformedCollection.decorate(collection, transformer);
    }
}

