/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CursorableSubList;

public class CursorableLinkedList
implements Serializable,
List {
    private static final long serialVersionUID = 8836393098519411393L;
    protected transient int _size = 0;
    protected transient Listable _head = new Listable(null, null, null);
    protected transient int _modCount = 0;
    protected transient List _cursors = new ArrayList();

    public boolean add(Object o2) {
        CursorableLinkedList cursorableLinkedList = this;
        cursorableLinkedList.insertListable(cursorableLinkedList._head.prev(), null, o2);
        return true;
    }

    public void add(int index, Object element) {
        if (index == this._size) {
            this.add(element);
            return;
        }
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " < 0 or " + String.valueOf(index) + " > " + this._size);
        }
        Listable listable = this.isEmpty() ? null : this.getListableAt(index);
        Listable listable2 = listable == null ? null : listable.prev();
        this.insertListable(listable2, listable, element);
    }

    public boolean addAll(Collection c2) {
        if (c2.isEmpty()) {
            return false;
        }
        Iterator iterator = c2.iterator();
        while (iterator.hasNext()) {
            CursorableLinkedList cursorableLinkedList = this;
            cursorableLinkedList.insertListable(cursorableLinkedList._head.prev(), null, iterator.next());
        }
        return true;
    }

    public boolean addAll(int index, Collection c2) {
        if (c2.isEmpty()) {
            return false;
        }
        if (this._size == index || this._size == 0) {
            return this.addAll(c2);
        }
        Listable listable = this.getListableAt(index);
        Listable listable2 = listable == null ? null : listable.prev();
        Iterator iterator = c2.iterator();
        while (iterator.hasNext()) {
            listable2 = this.insertListable(listable2, listable, iterator.next());
        }
        return true;
    }

    public boolean addFirst(Object o2) {
        this.insertListable(null, this._head.next(), o2);
        return true;
    }

    public boolean addLast(Object o2) {
        CursorableLinkedList cursorableLinkedList = this;
        cursorableLinkedList.insertListable(cursorableLinkedList._head.prev(), null, o2);
        return true;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean contains(Object o2) {
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            if (o2 == null && null == listable.value() || o2 != null && o2.equals(listable.value())) {
                return true;
            }
            listable2 = listable;
            listable = listable2.next();
        }
        return false;
    }

    public boolean containsAll(Collection c2) {
        Iterator iterator = c2.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Cursor cursor() {
        return new Cursor(this, 0);
    }

    public Cursor cursor(int i2) {
        return new Cursor(this, i2);
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        ListIterator listIterator = ((List)o2).listIterator();
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            if (!listIterator.hasNext() || (null == listable.value() ? null != listIterator.next() : !listable.value().equals(listIterator.next()))) {
                return false;
            }
            listable2 = listable;
            listable = listable2.next();
        }
        return !listIterator.hasNext();
    }

    public Object get(int index) {
        return this.getListableAt(index).value();
    }

    public Object getFirst() {
        try {
            return this._head.next().value();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException();
        }
    }

    public Object getLast() {
        try {
            return this._head.prev().value();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException();
        }
    }

    public int hashCode() {
        int n2 = 1;
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            n2 = n2 * 31 + (null == listable.value() ? 0 : listable.value().hashCode());
            listable2 = listable;
            listable = listable2.next();
        }
        return n2;
    }

    public int indexOf(Object o2) {
        int n2 = 0;
        if (o2 == null) {
            Listable listable = this._head.next();
            Listable listable2 = null;
            while (listable != null && listable2 != this._head.prev()) {
                if (null == listable.value()) {
                    return n2;
                }
                ++n2;
                listable2 = listable;
                listable = listable2.next();
            }
        } else {
            Listable listable = this._head.next();
            Listable listable3 = null;
            while (listable != null && listable3 != this._head.prev()) {
                if (o2.equals(listable.value())) {
                    return n2;
                }
                ++n2;
                listable3 = listable;
                listable = listable3.next();
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public int lastIndexOf(Object o2) {
        int n2 = this._size - 1;
        if (o2 == null) {
            Listable listable = this._head.prev();
            Listable listable2 = null;
            while (listable != null && listable2 != this._head.next()) {
                if (null == listable.value()) {
                    return n2;
                }
                --n2;
                listable2 = listable;
                listable = listable2.prev();
            }
        } else {
            Listable listable = this._head.prev();
            Listable listable3 = null;
            while (listable != null && listable3 != this._head.next()) {
                if (o2.equals(listable.value())) {
                    return n2;
                }
                --n2;
                listable3 = listable;
                listable = listable3.prev();
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException(index + " < 0 or > " + this._size);
        }
        return new ListIter(this, index);
    }

    public boolean remove(Object o2) {
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            if (o2 == null && null == listable.value()) {
                this.removeListable(listable);
                return true;
            }
            if (o2 != null && o2.equals(listable.value())) {
                this.removeListable(listable);
                return true;
            }
            listable2 = listable;
            listable = listable2.next();
        }
        return false;
    }

    public Object remove(int index) {
        Listable listable = this.getListableAt(index);
        Object object = listable.value();
        this.removeListable(listable);
        return object;
    }

    public boolean removeAll(Collection c2) {
        if (0 == c2.size() || this._size == 0) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!c2.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public Object removeFirst() {
        if (this._head.next() != null) {
            Object object = this._head.next().value();
            CursorableLinkedList cursorableLinkedList = this;
            cursorableLinkedList.removeListable(cursorableLinkedList._head.next());
            return object;
        }
        throw new NoSuchElementException();
    }

    public Object removeLast() {
        if (this._head.prev() != null) {
            Object object = this._head.prev().value();
            CursorableLinkedList cursorableLinkedList = this;
            cursorableLinkedList.removeListable(cursorableLinkedList._head.prev());
            return object;
        }
        throw new NoSuchElementException();
    }

    public boolean retainAll(Collection c2) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (c2.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public Object set(int index, Object element) {
        Listable listable = this.getListableAt(index);
        Object object = listable.setValue(element);
        this.broadcastListableChanged(listable);
        return object;
    }

    public int size() {
        return this._size;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        int n2 = 0;
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            objectArray[n2++] = listable.value();
            listable2 = listable;
            listable = listable2.next();
        }
        return objectArray;
    }

    public Object[] toArray(Object[] a2) {
        if (a2.length < this._size) {
            a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this._size);
        }
        int n2 = 0;
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            a2[n2++] = listable.value();
            listable2 = listable;
            listable = listable2.next();
        }
        if (a2.length > this._size) {
            a2[this._size] = null;
        }
        return a2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Listable listable = this._head.next();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            if (this._head.next() != listable) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(listable.value());
            listable2 = listable;
            listable = listable2.next();
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public List subList(int i2, int j2) {
        if (i2 < 0 || j2 > this._size || i2 > j2) {
            throw new IndexOutOfBoundsException();
        }
        if (i2 == 0 && j2 == this._size) {
            return this;
        }
        return new CursorableSubList(this, i2, j2);
    }

    protected Listable insertListable(Listable before, Listable after, Object value) {
        ++this._modCount;
        ++this._size;
        Listable listable = new Listable(before, after, value);
        if (before != null) {
            before.setNext(listable);
        } else {
            this._head.setNext(listable);
        }
        if (after != null) {
            after.setPrev(listable);
        } else {
            this._head.setPrev(listable);
        }
        this.broadcastListableInserted(listable);
        return listable;
    }

    protected void removeListable(Listable elt) {
        ++this._modCount;
        --this._size;
        if (this._head.next() == elt) {
            this._head.setNext(elt.next());
        }
        if (null != elt.next()) {
            elt.next().setPrev(elt.prev());
        }
        if (this._head.prev() == elt) {
            this._head.setPrev(elt.prev());
        }
        if (null != elt.prev()) {
            elt.prev().setNext(elt.next());
        }
        this.broadcastListableRemoved(elt);
    }

    protected Listable getListableAt(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " < 0 or " + String.valueOf(index) + " >= " + this._size);
        }
        if (index <= this._size / 2) {
            Listable listable = this._head.next();
            for (int i2 = 0; i2 < index; ++i2) {
                listable = listable.next();
            }
            return listable;
        }
        Listable listable = this._head.prev();
        for (int i3 = this._size - 1; i3 > index; --i3) {
            listable = listable.prev();
        }
        return listable;
    }

    protected void registerCursor(Cursor cur) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
        this._cursors.add(new WeakReference<Cursor>(cur));
    }

    protected void unregisterCursor(Cursor cur) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            if (cursor != cur) continue;
            weakReference.clear();
            iterator.remove();
            return;
        }
    }

    protected void invalidateCursors() {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor != null) {
                cursor.invalidate();
                weakReference.clear();
            }
            iterator.remove();
        }
    }

    protected void broadcastListableChanged(Listable elt) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.listableChanged(elt);
        }
    }

    protected void broadcastListableRemoved(Listable elt) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.listableRemoved(elt);
        }
    }

    protected void broadcastListableInserted(Listable elt) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.listableInserted(elt);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._size);
        for (Listable listable = this._head.next(); listable != null; listable = listable.next()) {
            out.writeObject(listable.value());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._size = 0;
        this._modCount = 0;
        this._cursors = new ArrayList();
        this._head = new Listable(null, null, null);
        int n2 = in.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add(in.readObject());
        }
    }

    public class Cursor
    extends ListIter
    implements ListIterator {
        boolean _valid;
        private final CursorableLinkedList this$0;

        Cursor(CursorableLinkedList cursorableLinkedList, int index) {
            super(cursorableLinkedList, index);
            this.this$0 = cursorableLinkedList;
            this._valid = false;
            this._valid = true;
            cursorableLinkedList.registerCursor(this);
        }

        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        public void add(Object o2) {
            this.checkForComod();
            Listable listable = this.this$0.insertListable(this._cur.prev(), this._cur.next(), o2);
            this._cur.setPrev(listable);
            this._cur.setNext(listable.next());
            this._lastReturned = null;
            ++this._nextIndex;
            ++this._expectedModCount;
        }

        protected void listableRemoved(Listable elt) {
            if (null == this.this$0._head.prev()) {
                this._cur.setNext(null);
            } else if (this._cur.next() == elt) {
                this._cur.setNext(elt.next());
            }
            if (null == this.this$0._head.next()) {
                this._cur.setPrev(null);
            } else if (this._cur.prev() == elt) {
                this._cur.setPrev(elt.prev());
            }
            if (this._lastReturned == elt) {
                this._lastReturned = null;
            }
        }

        protected void listableInserted(Listable elt) {
            if (null == this._cur.next() && null == this._cur.prev()) {
                this._cur.setNext(elt);
            } else if (this._cur.prev() == elt.prev()) {
                this._cur.setNext(elt);
            }
            if (this._cur.next() == elt.next()) {
                this._cur.setPrev(elt);
            }
            if (this._lastReturned == elt) {
                this._lastReturned = null;
            }
        }

        protected void listableChanged(Listable elt) {
            if (this._lastReturned == elt) {
                this._lastReturned = null;
            }
        }

        protected void checkForComod() {
            if (!this._valid) {
                throw new ConcurrentModificationException();
            }
        }

        protected void invalidate() {
            this._valid = false;
        }

        public void close() {
            if (this._valid) {
                this._valid = false;
                this.this$0.unregisterCursor(this);
            }
        }
    }

    class ListIter
    implements ListIterator {
        Listable _cur;
        Listable _lastReturned;
        int _expectedModCount;
        int _nextIndex;
        private final CursorableLinkedList this$0;

        ListIter(CursorableLinkedList cursorableLinkedList, int index) {
            this.this$0 = cursorableLinkedList;
            this._cur = null;
            this._lastReturned = null;
            this._expectedModCount = this.this$0._modCount;
            this._nextIndex = 0;
            if (index == 0) {
                this._cur = new Listable(null, cursorableLinkedList._head.next(), null);
                this._nextIndex = 0;
                return;
            }
            if (index == cursorableLinkedList._size) {
                this._cur = new Listable(cursorableLinkedList._head.prev(), null, null);
                this._nextIndex = cursorableLinkedList._size;
                return;
            }
            Listable listable = cursorableLinkedList.getListableAt(index);
            this._cur = new Listable(listable.prev(), listable, null);
            this._nextIndex = index;
        }

        public Object previous() {
            this.checkForComod();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object object = this._cur.prev().value();
            this._lastReturned = this._cur.prev();
            this._cur.setNext(this._cur.prev());
            this._cur.setPrev(this._cur.prev().prev());
            --this._nextIndex;
            return object;
        }

        public boolean hasNext() {
            this.checkForComod();
            return null != this._cur.next() && this._cur.prev() != this.this$0._head.prev();
        }

        public Object next() {
            this.checkForComod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this._cur.next().value();
            this._lastReturned = this._cur.next();
            this._cur.setPrev(this._cur.next());
            this._cur.setNext(this._cur.next().next());
            ++this._nextIndex;
            return object;
        }

        public int previousIndex() {
            this.checkForComod();
            if (!this.hasPrevious()) {
                return -1;
            }
            return this._nextIndex - 1;
        }

        public boolean hasPrevious() {
            this.checkForComod();
            return null != this._cur.prev() && this._cur.next() != this.this$0._head.next();
        }

        public void set(Object o2) {
            this.checkForComod();
            try {
                this._lastReturned.setValue(o2);
                return;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalStateException();
            }
        }

        public int nextIndex() {
            this.checkForComod();
            if (!this.hasNext()) {
                return this.this$0.size();
            }
            return this._nextIndex;
        }

        public void remove() {
            this.checkForComod();
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            this._cur.setNext(this._lastReturned == this.this$0._head.prev() ? null : this._lastReturned.next());
            this._cur.setPrev(this._lastReturned == this.this$0._head.next() ? null : this._lastReturned.prev());
            this.this$0.removeListable(this._lastReturned);
            this._lastReturned = null;
            --this._nextIndex;
            ++this._expectedModCount;
        }

        public void add(Object o2) {
            this.checkForComod();
            this._cur.setPrev(this.this$0.insertListable(this._cur.prev(), this._cur.next(), o2));
            this._lastReturned = null;
            ++this._nextIndex;
            ++this._expectedModCount;
        }

        protected void checkForComod() {
            if (this._expectedModCount != this.this$0._modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static class Listable
    implements Serializable {
        private Listable _prev = null;
        private Listable _next = null;
        private Object _val = null;

        Listable(Listable prev, Listable next, Object val) {
            this._prev = prev;
            this._next = next;
            this._val = val;
        }

        Listable next() {
            return this._next;
        }

        Listable prev() {
            return this._prev;
        }

        Object value() {
            return this._val;
        }

        void setNext(Listable next) {
            this._next = next;
        }

        void setPrev(Listable prev) {
            this._prev = prev;
        }

        Object setValue(Object val) {
            Object object = this._val;
            this._val = val;
            return object;
        }
    }
}

