/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastArrayList
extends ArrayList {
    protected ArrayList list = null;
    protected boolean fast = false;

    public FastArrayList() {
        this.list = new ArrayList();
    }

    public FastArrayList(int capacity) {
        this.list = new ArrayList(capacity);
    }

    public FastArrayList(Collection collection) {
        this.list = new ArrayList(collection);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object element) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.add(element);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.add(index, element);
                this.list = arrayList;
            }
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                this.list.add(index, element);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(index, collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.addAll(index, collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.clear();
                this.list = arrayList;
            }
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                this.list.clear();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        FastArrayList fastArrayList;
        if (this.fast) {
            fastArrayList = new FastArrayList((Collection)this.list);
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                fastArrayList = new FastArrayList((Collection)this.list);
            }
        }
        fastArrayList.setFast(this.getFast());
        return fastArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object element) {
        if (this.fast) {
            return this.list.contains(element);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.contains(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        if (this.fast) {
            return this.list.containsAll(collection);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.containsAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int capacity) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.ensureCapacity(capacity);
                this.list = arrayList;
            }
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                this.list.ensureCapacity(capacity);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        List list = (List)o2;
        if (this.fast) {
            ListIterator listIterator = this.list.listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                Object e2 = listIterator.next();
                Object e3 = listIterator2.next();
                if (e2 != null ? e2.equals(e3) : e3 == null) continue;
                return false;
            }
            return !listIterator.hasNext() && !listIterator2.hasNext();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ListIterator listIterator = this.list.listIterator();
            ListIterator listIterator3 = list.listIterator();
            while (listIterator.hasNext() && listIterator3.hasNext()) {
                Object e4 = listIterator.next();
                Object e5 = listIterator3.next();
                if (e4 != null ? e4.equals(e5) : e5 == null) continue;
                return false;
            }
            return !listIterator.hasNext() && !listIterator3.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        if (this.fast) {
            return this.list.get(index);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.fast) {
            int n2 = 1;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                n2 = n2 * 31 + (e2 == null ? 0 : e2.hashCode());
            }
            return n2;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n3 = 1;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                n3 = n3 * 31 + (e3 == null ? 0 : e3.hashCode());
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object element) {
        if (this.fast) {
            return this.list.indexOf(element);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.indexOf(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this.fast) {
            return this.list.isEmpty();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.isEmpty();
        }
    }

    public Iterator iterator() {
        if (this.fast) {
            return new ListIter(this, 0);
        }
        return this.list.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object element) {
        if (this.fast) {
            return this.list.lastIndexOf(element);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.lastIndexOf(element);
        }
    }

    public ListIterator listIterator() {
        if (this.fast) {
            return new ListIter(this, 0);
        }
        return this.list.listIterator();
    }

    public ListIterator listIterator(int index) {
        if (this.fast) {
            return new ListIter(this, index);
        }
        return this.list.listIterator(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                Object e2 = arrayList.remove(index);
                this.list = arrayList;
                return e2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object element) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.remove(element);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.removeAll(collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.removeAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.retainAll(collection);
                this.list = arrayList;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.retainAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        if (this.fast) {
            return this.list.set(index, element);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.fast) {
            return this.list.size();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.size();
        }
    }

    public List subList(int fromIndex, int toIndex) {
        if (this.fast) {
            return new SubList(this, fromIndex, toIndex);
        }
        return this.list.subList(fromIndex, toIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        if (this.fast) {
            return this.list.toArray();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] array) {
        if (this.fast) {
            return this.list.toArray(array);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            return this.list.toArray(array);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FastArrayList[");
        stringBuffer.append(this.list.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.trimToSize();
                this.list = arrayList;
            }
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                this.list.trimToSize();
                return;
            }
        }
    }

    private class ListIter
    implements ListIterator {
        private List expected;
        private ListIterator iter;
        private int lastReturnedIndex;
        private final FastArrayList this$0;

        public ListIter(FastArrayList fastArrayList, int i2) {
            this.this$0 = fastArrayList;
            this.lastReturnedIndex = -1;
            this.expected = fastArrayList.list;
            this.iter = this.get().listIterator(i2);
        }

        private void checkMod() {
            if (this.this$0.list != this.expected) {
                throw new ConcurrentModificationException();
            }
        }

        List get() {
            return this.expected;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            this.lastReturnedIndex = this.iter.nextIndex();
            return this.iter.next();
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        public Object previous() {
            this.lastReturnedIndex = this.iter.previousIndex();
            return this.iter.previous();
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().remove(this.lastReturnedIndex);
            this.expected = this.this$0.list;
            this.iter = this.get().listIterator(this.lastReturnedIndex);
            this.lastReturnedIndex = -1;
        }

        public void set(Object o2) {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().set(this.lastReturnedIndex, o2);
            this.expected = this.this$0.list;
            this.iter = this.get().listIterator(this.previousIndex() + 1);
        }

        public void add(Object o2) {
            this.checkMod();
            int n2 = this.nextIndex();
            this.get().add(n2, o2);
            this.expected = this.this$0.list;
            this.iter = this.get().listIterator(n2 + 1);
            this.lastReturnedIndex = -1;
        }
    }

    private class SubList
    implements List {
        private int first;
        private int last;
        private List expected;
        private final FastArrayList this$0;

        public SubList(FastArrayList fastArrayList, int first, int last) {
            this.this$0 = fastArrayList;
            this.first = first;
            this.last = last;
            this.expected = fastArrayList.list;
        }

        private List get(List l2) {
            if (this.this$0.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return l2.subList(this.first, this.last);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    this.get(arrayList).clear();
                    this.last = this.first;
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                }
            } else {
                ArrayList arrayList = this.this$0.list;
                synchronized (arrayList) {
                    SubList subList = this;
                    subList.get(subList.expected).clear();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    boolean bl = this.get(arrayList).remove(o2);
                    if (bl) {
                        --this.last;
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).remove(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection o2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    List list = this.get(arrayList);
                    boolean bl = list.removeAll(o2);
                    if (bl) {
                        this.last = this.first + list.size();
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).removeAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection o2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    List list = this.get(arrayList);
                    boolean bl = list.retainAll(o2);
                    if (bl) {
                        this.last = this.first + list.size();
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).retainAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).size();
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).isEmpty();
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o2) {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).contains(o2);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).contains(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsAll(Collection o2) {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).containsAll(o2);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).containsAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] o2) {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).toArray(o2);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).toArray(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray() {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).toArray();
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).equals(o2);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).equals(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).hashCode();
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Object o2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    boolean bl = this.get(arrayList).add(o2);
                    if (bl) {
                        ++this.last;
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).add(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(Collection o2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    boolean bl = this.get(arrayList).addAll(o2);
                    if (bl) {
                        this.last += o2.size();
                    }
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).addAll(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int i2, Object o2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    this.get(arrayList).add(i2, o2);
                    ++this.last;
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                }
            } else {
                ArrayList arrayList = this.this$0.list;
                synchronized (arrayList) {
                    SubList subList = this;
                    subList.get(subList.expected).add(i2, o2);
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int i2, Collection o2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    boolean bl = this.get(arrayList).addAll(i2, o2);
                    this.this$0.list = arrayList;
                    if (bl) {
                        this.last += o2.size();
                    }
                    this.expected = arrayList;
                    return bl;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).addAll(i2, o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int i2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    Object e2 = this.get(arrayList).remove(i2);
                    --this.last;
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    return e2;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).remove(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int i2, Object a2) {
            if (this.this$0.fast) {
                FastArrayList fastArrayList = this.this$0;
                synchronized (fastArrayList) {
                    ArrayList arrayList = (ArrayList)this.this$0.list.clone();
                    Object object = this.get(arrayList).set(i2, a2);
                    this.this$0.list = arrayList;
                    this.expected = arrayList;
                    return object;
                }
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).set(i2, a2);
            }
        }

        public Iterator iterator() {
            return new SubListIter(this, 0);
        }

        public ListIterator listIterator() {
            return new SubListIter(this, 0);
        }

        public ListIterator listIterator(int i2) {
            return new SubListIter(this, i2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int i2) {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).get(i2);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).get(i2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int indexOf(Object o2) {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).indexOf(o2);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).indexOf(o2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int lastIndexOf(Object o2) {
            if (this.this$0.fast) {
                SubList subList = this;
                return subList.get(subList.expected).lastIndexOf(o2);
            }
            ArrayList arrayList = this.this$0.list;
            synchronized (arrayList) {
                SubList subList = this;
                return subList.get(subList.expected).lastIndexOf(o2);
            }
        }

        public List subList(int f2, int l2) {
            if (this.this$0.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return new SubList(this.this$0, this.first + f2, f2 + l2);
        }

        static FastArrayList access$000(SubList x0) {
            return x0.this$0;
        }

        static List access$100(SubList x0, List x1) {
            return x0.get(x1);
        }

        static int access$210(SubList x0) {
            return x0.last--;
        }

        static int access$208(SubList x0) {
            return x0.last++;
        }

        private class SubListIter
        implements ListIterator {
            private List expected;
            private ListIterator iter;
            private int lastReturnedIndex;
            private final SubList this$1;

            public SubListIter(SubList subList, int i2) {
                this.this$1 = subList;
                this.lastReturnedIndex = -1;
                this.expected = SubList.access$000((SubList)subList).list;
                this.iter = SubList.access$100(subList, this.expected).listIterator(i2);
            }

            private void checkMod() {
                if (SubList.access$000((SubList)this.this$1).list != this.expected) {
                    throw new ConcurrentModificationException();
                }
            }

            List get() {
                return SubList.access$100(this.this$1, this.expected);
            }

            public boolean hasNext() {
                this.checkMod();
                return this.iter.hasNext();
            }

            public Object next() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.nextIndex();
                return this.iter.next();
            }

            public boolean hasPrevious() {
                this.checkMod();
                return this.iter.hasPrevious();
            }

            public Object previous() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.previousIndex();
                return this.iter.previous();
            }

            public int previousIndex() {
                this.checkMod();
                return this.iter.previousIndex();
            }

            public int nextIndex() {
                this.checkMod();
                return this.iter.nextIndex();
            }

            public void remove() {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().remove(this.lastReturnedIndex);
                SubList.access$210(this.this$1);
                this.expected = SubList.access$000((SubList)this.this$1).list;
                this.iter = this.get().listIterator(this.lastReturnedIndex);
                this.lastReturnedIndex = -1;
            }

            public void set(Object o2) {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().set(this.lastReturnedIndex, o2);
                this.expected = SubList.access$000((SubList)this.this$1).list;
                this.iter = this.get().listIterator(this.previousIndex() + 1);
            }

            public void add(Object o2) {
                this.checkMod();
                int n2 = this.nextIndex();
                this.get().add(n2, o2);
                SubList.access$208(this.this$1);
                this.expected = SubList.access$000((SubList)this.this$1).list;
                this.iter = this.get().listIterator(n2 + 1);
                this.lastReturnedIndex = -1;
            }
        }
    }
}

