/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.iterators.EmptyIterator;

public class MultiHashMap
extends HashMap
implements MultiMap {
    private transient Collection values = null;
    private static final long serialVersionUID = 1943563828307035349L;

    public MultiHashMap() {
    }

    public MultiHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public MultiHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public MultiHashMap(Map mapToCopy) {
        super((int)((float)mapToCopy.size() * 1.4f));
        this.putAll(mapToCopy);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        String string = "1.2";
        try {
            string = System.getProperty("java.version");
        }
        catch (SecurityException securityException) {}
        if (string.startsWith("1.2") || string.startsWith("1.3")) {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                super.put(entry.getKey(), ((Collection)entry.getValue()).iterator().next());
            }
        }
    }

    public int totalSize() {
        int n2 = 0;
        Collection collection = super.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Collection collection2 = (Collection)iterator.next();
            n2 += collection2.size();
        }
        return n2;
    }

    public Collection getCollection(Object key) {
        return (Collection)this.get(key);
    }

    public int size(Object key) {
        Collection collection = this.getCollection(key);
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public Iterator iterator(Object key) {
        Collection collection = this.getCollection(key);
        if (collection == null) {
            return EmptyIterator.INSTANCE;
        }
        return collection.iterator();
    }

    public Object put(Object key, Object value) {
        boolean bl;
        Collection collection = this.getCollection(key);
        if (collection == null) {
            collection = this.createCollection(null);
            super.put(key, collection);
        }
        if (bl = collection.add(value)) {
            return value;
        }
        return null;
    }

    public void putAll(Map map) {
        if (map instanceof MultiMap) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Collection collection = (Collection)entry.getValue();
                this.putAll(entry.getKey(), collection);
            }
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean putAll(Object key, Collection values) {
        if (values == null || values.size() == 0) {
            return false;
        }
        Collection collection = this.getCollection(key);
        if (collection == null) {
            collection = this.createCollection(values);
            if (collection.size() == 0) {
                return false;
            }
            super.put(key, collection);
            return true;
        }
        return collection.addAll(values);
    }

    public boolean containsValue(Object value) {
        Set set = super.entrySet();
        if (set == null) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Collection collection = (Collection)entry.getValue();
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object key, Object value) {
        Collection collection = this.getCollection(key);
        if (collection == null) {
            return false;
        }
        return collection.contains(value);
    }

    public Object remove(Object key, Object item) {
        Collection collection = this.getCollection(key);
        if (collection == null) {
            return null;
        }
        boolean bl = collection.remove(item);
        if (!bl) {
            return null;
        }
        if (collection.isEmpty()) {
            this.remove(key);
        }
        return item;
    }

    public void clear() {
        Set set = super.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Collection collection = (Collection)entry.getValue();
            collection.clear();
        }
        super.clear();
    }

    public Collection values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values(this, null);
        return this.values;
    }

    Iterator superValuesIterator() {
        return super.values().iterator();
    }

    public Object clone() {
        MultiHashMap multiHashMap = (MultiHashMap)super.clone();
        Iterator iterator = multiHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Collection collection = (Collection)entry.getValue();
            Collection collection2 = this.createCollection(collection);
            entry.setValue(collection2);
        }
        return multiHashMap;
    }

    protected Collection createCollection(Collection coll) {
        if (coll == null) {
            return new ArrayList();
        }
        return new ArrayList(coll);
    }

    static class 1 {
    }

    private class ValueIterator
    implements Iterator {
        private Iterator backedIterator;
        private Iterator tempIterator;
        private final MultiHashMap this$0;

        private ValueIterator(MultiHashMap multiHashMap) {
            this.this$0 = multiHashMap;
            this.backedIterator = multiHashMap.superValuesIterator();
        }

        private boolean searchNextIterator() {
            while (this.tempIterator == null || !this.tempIterator.hasNext()) {
                if (!this.backedIterator.hasNext()) {
                    return false;
                }
                this.tempIterator = ((Collection)this.backedIterator.next()).iterator();
            }
            return true;
        }

        public boolean hasNext() {
            return this.searchNextIterator();
        }

        public Object next() {
            if (!this.searchNextIterator()) {
                throw new NoSuchElementException();
            }
            return this.tempIterator.next();
        }

        public void remove() {
            if (this.tempIterator == null) {
                throw new IllegalStateException();
            }
            this.tempIterator.remove();
        }

        ValueIterator(MultiHashMap x0, 1 x1) {
            this(x0);
        }
    }

    private class Values
    extends AbstractCollection {
        private final MultiHashMap this$0;

        private Values(MultiHashMap multiHashMap) {
            this.this$0 = multiHashMap;
        }

        public Iterator iterator() {
            return new ValueIterator(this.this$0, null);
        }

        public int size() {
            int n2 = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n2;
            }
            return n2;
        }

        public void clear() {
            this.this$0.clear();
        }

        Values(MultiHashMap x0, 1 x1) {
            this(x0);
        }
    }
}

