/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.bag;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.bag.HashBag;
import org.apache.commons.collections.set.UnmodifiableSet;

public abstract class AbstractMapBag
implements Bag {
    private transient Map map;
    private int size;
    private transient int modCount;
    private transient Set uniqueSet;

    protected AbstractMapBag() {
    }

    protected AbstractMapBag(Map map) {
        this.map = map;
    }

    protected Map getMap() {
        return this.map;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int getCount(Object object) {
        MutableInteger mutableInteger = (MutableInteger)this.map.get(object);
        if (mutableInteger != null) {
            return mutableInteger.value;
        }
        return 0;
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public boolean containsAll(Collection coll) {
        if (coll instanceof Bag) {
            return this.containsAll((Bag)coll);
        }
        return this.containsAll(new HashBag(coll));
    }

    boolean containsAll(Bag other) {
        boolean bl = true;
        Iterator iterator = other.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            boolean bl2 = this.getCount(e2) >= other.getCount(e2);
            bl = bl && bl2;
        }
        return bl;
    }

    public Iterator iterator() {
        return new BagIterator(this);
    }

    public boolean add(Object object) {
        return this.add(object, 1);
    }

    public boolean add(Object object, int nCopies) {
        ++this.modCount;
        if (nCopies > 0) {
            MutableInteger mutableInteger = (MutableInteger)this.map.get(object);
            this.size += nCopies;
            if (mutableInteger == null) {
                this.map.put(object, new MutableInteger(nCopies));
                return true;
            }
            mutableInteger.value += nCopies;
            return false;
        }
        return false;
    }

    public boolean addAll(Collection coll) {
        boolean bl = false;
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = this.add(iterator.next());
            bl = bl || bl2;
        }
        return bl;
    }

    public void clear() {
        ++this.modCount;
        this.map.clear();
        this.size = 0;
    }

    public boolean remove(Object object) {
        MutableInteger mutableInteger = (MutableInteger)this.map.get(object);
        if (mutableInteger == null) {
            return false;
        }
        ++this.modCount;
        this.map.remove(object);
        this.size -= mutableInteger.value;
        return true;
    }

    public boolean remove(Object object, int nCopies) {
        MutableInteger mutableInteger = (MutableInteger)this.map.get(object);
        if (mutableInteger == null) {
            return false;
        }
        if (nCopies <= 0) {
            return false;
        }
        ++this.modCount;
        if (nCopies < mutableInteger.value) {
            mutableInteger.value -= nCopies;
            this.size -= nCopies;
        } else {
            this.map.remove(object);
            this.size -= mutableInteger.value;
        }
        return true;
    }

    public boolean removeAll(Collection coll) {
        boolean bl = false;
        if (coll != null) {
            Iterator iterator = coll.iterator();
            while (iterator.hasNext()) {
                boolean bl2 = this.remove(iterator.next(), 1);
                bl = bl || bl2;
            }
        }
        return bl;
    }

    public boolean retainAll(Collection coll) {
        if (coll instanceof Bag) {
            return this.retainAll((Bag)coll);
        }
        return this.retainAll(new HashBag(coll));
    }

    boolean retainAll(Bag other) {
        boolean bl = false;
        HashBag hashBag = new HashBag();
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = this.getCount(e2);
            int n3 = other.getCount(e2);
            if (n3 > 0 && n3 <= n2) {
                hashBag.add(e2, n2 - n3);
                continue;
            }
            hashBag.add(e2, n2);
        }
        if (!hashBag.isEmpty()) {
            bl = this.removeAll((Collection)hashBag);
        }
        return bl;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n2 = 0;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            for (int i2 = this.getCount(k2); i2 > 0; --i2) {
                objectArray[n2++] = k2;
            }
        }
        return objectArray;
    }

    public Object[] toArray(Object[] array) {
        int n2 = this.size();
        if (array.length < n2) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n2);
        }
        int n3 = 0;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            for (int i2 = this.getCount(k2); i2 > 0; --i2) {
                array[n3++] = k2;
            }
        }
        if (array.length > n2) {
            array[n2] = null;
        }
        return array;
    }

    public Set uniqueSet() {
        if (this.uniqueSet == null) {
            this.uniqueSet = UnmodifiableSet.decorate(this.map.keySet());
        }
        return this.uniqueSet;
    }

    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.map.size());
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            out.writeObject(entry.getKey());
            out.writeInt(((MutableInteger)entry.getValue()).value);
        }
    }

    protected void doReadObject(Map map, ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.map = map;
        int n2 = in.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = in.readObject();
            int n3 = in.readInt();
            map.put(object, new MutableInteger(n3));
            this.size += n3;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Bag)) {
            return false;
        }
        Bag bag = (Bag)object;
        if (bag.size() != this.size()) {
            return false;
        }
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            if (bag.getCount(k2) == this.getCount(k2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k2 = entry.getKey();
            MutableInteger mutableInteger = (MutableInteger)entry.getValue();
            n2 += (k2 == null ? 0 : k2.hashCode()) ^ mutableInteger.value;
        }
        return n2;
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = this.getCount(e2);
            stringBuffer.append(n2);
            stringBuffer.append(':');
            stringBuffer.append(e2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static Map access$000(AbstractMapBag x0) {
        return x0.map;
    }

    static int access$100(AbstractMapBag x0) {
        return x0.modCount;
    }

    static int access$210(AbstractMapBag x0) {
        return x0.size--;
    }

    protected static class MutableInteger {
        protected int value;

        MutableInteger(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MutableInteger)) {
                return false;
            }
            return ((MutableInteger)obj).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }
    }

    static class BagIterator
    implements Iterator {
        private AbstractMapBag parent;
        private Iterator entryIterator;
        private Map.Entry current;
        private int itemCount;
        private final int mods;
        private boolean canRemove;

        public BagIterator(AbstractMapBag parent) {
            this.parent = parent;
            this.entryIterator = AbstractMapBag.access$000(parent).entrySet().iterator();
            this.current = null;
            this.mods = AbstractMapBag.access$100(parent);
            this.canRemove = false;
        }

        public boolean hasNext() {
            return this.itemCount > 0 || this.entryIterator.hasNext();
        }

        public Object next() {
            if (AbstractMapBag.access$100(this.parent) != this.mods) {
                throw new ConcurrentModificationException();
            }
            if (this.itemCount == 0) {
                this.current = (Map.Entry)this.entryIterator.next();
                this.itemCount = ((MutableInteger)this.current.getValue()).value;
            }
            this.canRemove = true;
            --this.itemCount;
            return this.current.getKey();
        }

        public void remove() {
            if (AbstractMapBag.access$100(this.parent) != this.mods) {
                throw new ConcurrentModificationException();
            }
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            MutableInteger mutableInteger = (MutableInteger)this.current.getValue();
            if (mutableInteger.value > 1) {
                --mutableInteger.value;
            } else {
                this.entryIterator.remove();
            }
            AbstractMapBag.access$210(this.parent);
            this.canRemove = false;
        }
    }
}

