/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;

public class PriorityBuffer
extends AbstractCollection
implements Serializable,
Buffer {
    private static final long serialVersionUID = 6891186490470027896L;
    private static final int DEFAULT_CAPACITY = 13;
    protected Object[] elements;
    protected int size;
    protected boolean ascendingOrder;
    protected Comparator comparator;

    public PriorityBuffer() {
        this(13, true, null);
    }

    public PriorityBuffer(Comparator comparator) {
        this(13, true, comparator);
    }

    public PriorityBuffer(boolean ascendingOrder) {
        this(13, ascendingOrder, null);
    }

    public PriorityBuffer(boolean ascendingOrder, Comparator comparator) {
        this(13, ascendingOrder, comparator);
    }

    public PriorityBuffer(int capacity) {
        this(capacity, true, null);
    }

    public PriorityBuffer(int capacity, Comparator comparator) {
        this(capacity, true, comparator);
    }

    public PriorityBuffer(int capacity, boolean ascendingOrder) {
        this(capacity, ascendingOrder, null);
    }

    public PriorityBuffer(int capacity, boolean ascendingOrder, Comparator comparator) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("invalid capacity");
        }
        this.ascendingOrder = ascendingOrder;
        this.elements = new Object[capacity + 1];
        this.comparator = comparator;
    }

    public boolean isAscendingOrder() {
        return this.ascendingOrder;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.elements = new Object[this.elements.length];
        this.size = 0;
    }

    public boolean add(Object element) {
        if (this.isAtCapacity()) {
            this.grow();
        }
        if (this.ascendingOrder) {
            this.percolateUpMinHeap(element);
        } else {
            this.percolateUpMaxHeap(element);
        }
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException();
        }
        return this.elements[1];
    }

    public Object remove() {
        Object object = this.get();
        this.elements[1] = this.elements[this.size--];
        this.elements[this.size + 1] = null;
        if (this.size != 0) {
            if (this.ascendingOrder) {
                this.percolateDownMinHeap(1);
            } else {
                this.percolateDownMaxHeap(1);
            }
        }
        return object;
    }

    protected boolean isAtCapacity() {
        return this.elements.length == this.size + 1;
    }

    protected void percolateDownMinHeap(int index) {
        Object object = this.elements[index];
        int n2 = index;
        while (n2 << 1 <= this.size) {
            int n3 = n2 << 1;
            if (n3 != this.size) {
                PriorityBuffer priorityBuffer = this;
                if (priorityBuffer.compare(priorityBuffer.elements[n3 + 1], this.elements[n3]) < 0) {
                    ++n3;
                }
            }
            PriorityBuffer priorityBuffer = this;
            if (priorityBuffer.compare(priorityBuffer.elements[n3], object) >= 0) break;
            this.elements[n2] = this.elements[n3];
            n2 = n3;
        }
        this.elements[n2] = object;
    }

    protected void percolateDownMaxHeap(int index) {
        Object object = this.elements[index];
        int n2 = index;
        while (n2 << 1 <= this.size) {
            int n3 = n2 << 1;
            if (n3 != this.size) {
                PriorityBuffer priorityBuffer = this;
                if (priorityBuffer.compare(priorityBuffer.elements[n3 + 1], this.elements[n3]) > 0) {
                    ++n3;
                }
            }
            PriorityBuffer priorityBuffer = this;
            if (priorityBuffer.compare(priorityBuffer.elements[n3], object) <= 0) break;
            this.elements[n2] = this.elements[n3];
            n2 = n3;
        }
        this.elements[n2] = object;
    }

    protected void percolateUpMinHeap(int index) {
        int n2 = index;
        Object object = this.elements[index];
        while (n2 > 1 && this.compare(object, this.elements[n2 / 2]) < 0) {
            int n3 = n2 / 2;
            this.elements[n2] = this.elements[n3];
            n2 = n3;
        }
        this.elements[n2] = object;
    }

    protected void percolateUpMinHeap(Object element) {
        this.elements[++this.size] = element;
        PriorityBuffer priorityBuffer = this;
        priorityBuffer.percolateUpMinHeap(priorityBuffer.size);
    }

    protected void percolateUpMaxHeap(int index) {
        int n2 = index;
        Object object = this.elements[index];
        while (n2 > 1 && this.compare(object, this.elements[n2 / 2]) > 0) {
            int n3 = n2 / 2;
            this.elements[n2] = this.elements[n3];
            n2 = n3;
        }
        this.elements[n2] = object;
    }

    protected void percolateUpMaxHeap(Object element) {
        this.elements[++this.size] = element;
        PriorityBuffer priorityBuffer = this;
        priorityBuffer.percolateUpMaxHeap(priorityBuffer.size);
    }

    protected int compare(Object a2, Object b2) {
        if (this.comparator != null) {
            return this.comparator.compare(a2, b2);
        }
        return ((Comparable)a2).compareTo(b2);
    }

    protected void grow() {
        Object[] objectArray = new Object[this.elements.length << 1];
        System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
        this.elements = objectArray;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private int index;
            private int lastReturnedIndex;
            private final PriorityBuffer this$0;
            {
                this.this$0 = priorityBuffer;
                this.index = 1;
                this.lastReturnedIndex = -1;
            }

            public boolean hasNext() {
                return this.index <= this.this$0.size;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturnedIndex = this.index++;
                return this.this$0.elements[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                this.this$0.elements[this.lastReturnedIndex] = this.this$0.elements[this.this$0.size];
                this.this$0.elements[this.this$0.size] = null;
                --this.this$0.size;
                if (this.this$0.size != 0 && this.lastReturnedIndex <= this.this$0.size) {
                    int n2 = 0;
                    if (this.lastReturnedIndex > 1) {
                        n2 = this.this$0.compare(this.this$0.elements[this.lastReturnedIndex], this.this$0.elements[this.lastReturnedIndex / 2]);
                    }
                    if (this.this$0.ascendingOrder) {
                        if (this.lastReturnedIndex > 1 && n2 < 0) {
                            this.this$0.percolateUpMinHeap(this.lastReturnedIndex);
                        } else {
                            this.this$0.percolateDownMinHeap(this.lastReturnedIndex);
                        }
                    } else if (this.lastReturnedIndex > 1 && n2 > 0) {
                        this.this$0.percolateUpMaxHeap(this.lastReturnedIndex);
                    } else {
                        this.this$0.percolateDownMaxHeap(this.lastReturnedIndex);
                    }
                }
                --this.index;
                this.lastReturnedIndex = -1;
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        for (int i2 = 1; i2 < this.size + 1; ++i2) {
            if (i2 != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i2]);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

