/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.functors;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.FunctorUtils;
import org.apache.commons.collections.functors.PredicateDecorator;
import org.apache.commons.collections.functors.TruePredicate;

public final class NonePredicate
implements Serializable,
Predicate,
PredicateDecorator {
    private static final long serialVersionUID = 2007613066565892961L;
    private final Predicate[] iPredicates;

    public static Predicate getInstance(Predicate[] predicates) {
        FunctorUtils.validate(predicates);
        if (predicates.length == 0) {
            return TruePredicate.INSTANCE;
        }
        predicates = FunctorUtils.copy(predicates);
        return new NonePredicate(predicates);
    }

    public static Predicate getInstance(Collection predicates) {
        Predicate[] predicateArray = FunctorUtils.validate(predicates);
        if (predicateArray.length == 0) {
            return TruePredicate.INSTANCE;
        }
        return new NonePredicate(predicateArray);
    }

    public NonePredicate(Predicate[] predicates) {
        this.iPredicates = predicates;
    }

    public final boolean evaluate(Object object) {
        for (int i2 = 0; i2 < this.iPredicates.length; ++i2) {
            if (!this.iPredicates[i2].evaluate(object)) continue;
            return false;
        }
        return true;
    }

    public final Predicate[] getPredicates() {
        return this.iPredicates;
    }
}

