/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.list.UnmodifiableList;

public class CollatingIterator
implements Iterator {
    private Comparator comparator = null;
    private ArrayList iterators = null;
    private ArrayList values = null;
    private BitSet valueSet = null;
    private int lastReturned = -1;

    public CollatingIterator() {
        this(null, 2);
    }

    public CollatingIterator(Comparator comp) {
        this(comp, 2);
    }

    public CollatingIterator(Comparator comp, int initIterCapacity) {
        this.iterators = new ArrayList(initIterCapacity);
        this.setComparator(comp);
    }

    public CollatingIterator(Comparator comp, Iterator a2, Iterator b2) {
        this(comp, 2);
        this.addIterator(a2);
        this.addIterator(b2);
    }

    public CollatingIterator(Comparator comp, Iterator[] iterators) {
        this(comp, iterators.length);
        for (int i2 = 0; i2 < iterators.length; ++i2) {
            this.addIterator(iterators[i2]);
        }
    }

    public CollatingIterator(Comparator comp, Collection iterators) {
        this(comp, iterators.size());
        Iterator iterator = iterators.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = (Iterator)iterator.next();
            this.addIterator(iterator2);
        }
    }

    public void addIterator(Iterator iterator) {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.add(iterator);
    }

    public void setIterator(int index, Iterator iterator) {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.set(index, iterator);
    }

    public List getIterators() {
        return UnmodifiableList.decorate(this.iterators);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comp) {
        this.checkNotStarted();
        this.comparator = comp;
    }

    public boolean hasNext() {
        block3: {
            block2: {
                this.start();
                CollatingIterator collatingIterator = this;
                if (collatingIterator.anyValueSet(collatingIterator.valueSet)) break block2;
                CollatingIterator collatingIterator2 = this;
                if (!collatingIterator2.anyHasNext(collatingIterator2.iterators)) break block3;
            }
            return true;
        }
        return false;
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int n2 = this.least();
        if (n2 == -1) {
            throw new NoSuchElementException();
        }
        Object e2 = this.values.get(n2);
        this.clear(n2);
        this.lastReturned = n2;
        return e2;
    }

    public void remove() {
        if (this.lastReturned == -1) {
            throw new IllegalStateException("No value can be removed at present");
        }
        Iterator iterator = (Iterator)this.iterators.get(this.lastReturned);
        iterator.remove();
    }

    private void start() {
        if (this.values == null) {
            this.values = new ArrayList(this.iterators.size());
            this.valueSet = new BitSet(this.iterators.size());
            for (int i2 = 0; i2 < this.iterators.size(); ++i2) {
                this.values.add(null);
                this.valueSet.clear(i2);
            }
        }
    }

    private boolean set(int i2) {
        Iterator iterator = (Iterator)this.iterators.get(i2);
        if (iterator.hasNext()) {
            this.values.set(i2, iterator.next());
            this.valueSet.set(i2);
            return true;
        }
        this.values.set(i2, null);
        this.valueSet.clear(i2);
        return false;
    }

    private void clear(int i2) {
        this.values.set(i2, null);
        this.valueSet.clear(i2);
    }

    private void checkNotStarted() throws IllegalStateException {
        if (this.values != null) {
            throw new IllegalStateException("Can't do that after next or hasNext has been called.");
        }
    }

    private int least() {
        int n2 = -1;
        Object t2 = null;
        for (int i2 = 0; i2 < this.values.size(); ++i2) {
            if (!this.valueSet.get(i2)) {
                this.set(i2);
            }
            if (!this.valueSet.get(i2)) continue;
            if (n2 == -1) {
                n2 = i2;
                t2 = this.values.get(i2);
                continue;
            }
            Object e2 = this.values.get(i2);
            if (this.comparator.compare(e2, t2) >= 0) continue;
            t2 = e2;
            n2 = i2;
        }
        return n2;
    }

    private boolean anyValueSet(BitSet set) {
        for (int i2 = 0; i2 < set.size(); ++i2) {
            if (!set.get(i2)) continue;
            return true;
        }
        return false;
    }

    private boolean anyHasNext(ArrayList iters) {
        for (int i2 = 0; i2 < iters.size(); ++i2) {
            Iterator iterator = (Iterator)iters.get(i2);
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }
}

