/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.iterators.AbstractListIteratorDecorator;
import org.apache.commons.collections.list.AbstractSerializableListDecorator;
import org.apache.commons.collections.set.UnmodifiableSet;

public class SetUniqueList
extends AbstractSerializableListDecorator {
    private static final long serialVersionUID = 7196982186153478694L;
    protected final Set set;
    static Class class$java$util$HashSet;

    public static SetUniqueList decorate(List list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (list.isEmpty()) {
            return new SetUniqueList(list, new HashSet());
        }
        ArrayList arrayList = new ArrayList(list);
        list.clear();
        SetUniqueList setUniqueList = new SetUniqueList(list, new HashSet());
        setUniqueList.addAll((Collection)arrayList);
        return setUniqueList;
    }

    protected SetUniqueList(List list, Set set) {
        super(list);
        if (set == null) {
            throw new IllegalArgumentException("Set must not be null");
        }
        this.set = set;
    }

    public Set asSet() {
        return UnmodifiableSet.decorate(this.set);
    }

    public boolean add(Object object) {
        int n2 = this.size();
        SetUniqueList setUniqueList = this;
        setUniqueList.add(setUniqueList.size(), object);
        return n2 != this.size();
    }

    public void add(int index, Object object) {
        if (!this.set.contains(object)) {
            super.add(index, object);
            this.set.add(object);
        }
    }

    public boolean addAll(Collection coll) {
        SetUniqueList setUniqueList = this;
        return setUniqueList.addAll(setUniqueList.size(), coll);
    }

    public boolean addAll(int index, Collection coll) {
        int n2 = this.size();
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            int n3 = this.size();
            this.add(index, iterator.next());
            if (n3 == this.size()) continue;
            ++index;
        }
        return n2 != this.size();
    }

    public Object set(int index, Object object) {
        int n2 = this.indexOf(object);
        Object object2 = super.set(index, object);
        if (n2 != -1 && n2 != index) {
            super.remove(n2);
        }
        this.set.remove(object2);
        this.set.add(object);
        return object2;
    }

    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        this.set.remove(object);
        return bl;
    }

    public Object remove(int index) {
        Object object = super.remove(index);
        this.set.remove(object);
        return object;
    }

    public boolean removeAll(Collection coll) {
        boolean bl = super.removeAll(coll);
        this.set.removeAll(coll);
        return bl;
    }

    public boolean retainAll(Collection coll) {
        boolean bl = super.retainAll(coll);
        this.set.retainAll(coll);
        return bl;
    }

    public void clear() {
        super.clear();
        this.set.clear();
    }

    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    public boolean containsAll(Collection coll) {
        return this.set.containsAll(coll);
    }

    public Iterator iterator() {
        return new SetListIterator(super.iterator(), this.set);
    }

    public ListIterator listIterator() {
        return new SetListListIterator(super.listIterator(), this.set);
    }

    public ListIterator listIterator(int index) {
        return new SetListListIterator(super.listIterator(index), this.set);
    }

    public List subList(int fromIndex, int toIndex) {
        List list = super.subList(fromIndex, toIndex);
        SetUniqueList setUniqueList = this;
        Set set = setUniqueList.createSetBasedOnList(setUniqueList.set, list);
        return new SetUniqueList(list, set);
    }

    protected Set createSetBasedOnList(Set set, List list) {
        Set subSet;
        if (set.getClass().equals(class$java$util$HashSet == null ? (class$java$util$HashSet = SetUniqueList.class$("java.util.HashSet")) : class$java$util$HashSet)) {
            subSet = new HashSet();
        } else {
            try {
                subSet = (Set)set.getClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                subSet = new HashSet();
            }
            catch (IllegalAccessException illegalAccessException) {
                subSet = new HashSet();
            }
        }
        subSet.addAll(list);
        return subSet;
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SetListListIterator
    extends AbstractListIteratorDecorator {
        protected final Set set;
        protected Object last = null;

        protected SetListListIterator(ListIterator it, Set set) {
            super(it);
            this.set = set;
        }

        public Object next() {
            this.last = super.next();
            return this.last;
        }

        public Object previous() {
            this.last = super.previous();
            return this.last;
        }

        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }

        public void add(Object object) {
            if (!this.set.contains(object)) {
                super.add(object);
                this.set.add(object);
            }
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("ListIterator does not support set");
        }
    }

    static class SetListIterator
    extends AbstractIteratorDecorator {
        protected final Set set;
        protected Object last = null;

        protected SetListIterator(Iterator it, Set set) {
            super(it);
            this.set = set;
        }

        public Object next() {
            this.last = super.next();
            return this.last;
        }

        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }
    }
}

