/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.OrderedIterator;

public class TreeList
extends AbstractList {
    private AVLNode root;
    private int size;

    public TreeList() {
    }

    public TreeList(Collection coll) {
        this.addAll(coll);
    }

    public Object get(int index) {
        this.checkInterval(index, 0, this.size() - 1);
        return this.root.get(index).getValue();
    }

    public int size() {
        return this.size;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int fromIndex) {
        this.checkInterval(fromIndex, 0, this.size());
        return new TreeListIterator(this, fromIndex);
    }

    public int indexOf(Object object) {
        if (this.root == null) {
            return -1;
        }
        return this.root.indexOf(object, AVLNode.access$000(this.root));
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        if (this.root != null) {
            this.root.toArray(objectArray, AVLNode.access$000(this.root));
        }
        return objectArray;
    }

    public void add(int index, Object obj) {
        ++this.modCount;
        this.checkInterval(index, 0, this.size());
        this.root = this.root == null ? new AVLNode(index, obj, null, null, null) : this.root.insert(index, obj);
        ++this.size;
    }

    public Object set(int index, Object obj) {
        this.checkInterval(index, 0, this.size() - 1);
        AVLNode aVLNode = this.root.get(index);
        Object object = AVLNode.access$200(aVLNode);
        aVLNode.setValue(obj);
        return object;
    }

    public Object remove(int index) {
        ++this.modCount;
        this.checkInterval(index, 0, this.size() - 1);
        Object object = this.get(index);
        this.root = this.root.remove(index);
        --this.size;
        return object;
    }

    public void clear() {
        ++this.modCount;
        this.root = null;
        this.size = 0;
    }

    private void checkInterval(int index, int startIndex, int endIndex) {
        if (index < startIndex || index > endIndex) {
            throw new IndexOutOfBoundsException("Invalid index:" + index + ", size=" + this.size());
        }
    }

    static int access$300(TreeList x0) {
        return x0.modCount;
    }

    static AVLNode access$400(TreeList x0) {
        return x0.root;
    }

    static int access$500(TreeList x0) {
        return x0.modCount;
    }

    static class 1 {
    }

    static class TreeListIterator
    implements ListIterator,
    OrderedIterator {
        protected final TreeList parent;
        protected AVLNode next;
        protected int nextIndex;
        protected AVLNode current;
        protected int currentIndex;
        protected int expectedModCount;

        protected TreeListIterator(TreeList parent, int fromIndex) throws IndexOutOfBoundsException {
            this.parent = parent;
            this.expectedModCount = TreeList.access$300(parent);
            this.next = TreeList.access$400(parent) == null ? null : TreeList.access$400(parent).get(fromIndex);
            this.nextIndex = fromIndex;
            this.currentIndex = -1;
        }

        protected void checkModCount() {
            if (TreeList.access$500(this.parent) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            return this.nextIndex < this.parent.size();
        }

        public Object next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index " + this.nextIndex + ".");
            }
            if (this.next == null) {
                this.next = TreeList.access$400(this.parent).get(this.nextIndex);
            }
            Object object = this.next.getValue();
            this.current = this.next;
            this.currentIndex = this.nextIndex++;
            this.next = this.next.next();
            return object;
        }

        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        public Object previous() {
            this.checkModCount();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("Already at start of list.");
            }
            this.next = this.next == null ? TreeList.access$400(this.parent).get(this.nextIndex - 1) : this.next.previous();
            Object object = this.next.getValue();
            this.current = this.next;
            this.currentIndex = --this.nextIndex;
            return object;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        public void remove() {
            this.checkModCount();
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            this.parent.remove(this.currentIndex);
            if (this.nextIndex != this.currentIndex) {
                --this.nextIndex;
            }
            this.next = null;
            this.current = null;
            this.currentIndex = -1;
            ++this.expectedModCount;
        }

        public void set(Object obj) {
            this.checkModCount();
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue(obj);
        }

        public void add(Object obj) {
            this.checkModCount();
            this.parent.add(this.nextIndex, obj);
            this.current = null;
            this.currentIndex = -1;
            ++this.nextIndex;
            ++this.expectedModCount;
        }
    }

    static class AVLNode {
        private AVLNode left;
        private boolean leftIsPrevious;
        private AVLNode right;
        private boolean rightIsNext;
        private int height;
        private int relativePosition;
        private Object value;

        private AVLNode(int relativePosition, Object obj, AVLNode rightFollower, AVLNode leftFollower) {
            this.relativePosition = relativePosition;
            this.value = obj;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        Object getValue() {
            return this.value;
        }

        void setValue(Object obj) {
            this.value = obj;
        }

        AVLNode get(int index) {
            int n2 = index - this.relativePosition;
            if (n2 == 0) {
                return this;
            }
            AVLNode aVLNode = n2 < 0 ? this.getLeftSubTree() : this.getRightSubTree();
            if (aVLNode == null) {
                return null;
            }
            return aVLNode.get(n2);
        }

        int indexOf(Object object, int index) {
            int n2;
            if (this.getLeftSubTree() != null && (n2 = this.left.indexOf(object, index + this.left.relativePosition)) != -1) {
                return n2;
            }
            if (this.value == null ? this.value == object : this.value.equals(object)) {
                return index;
            }
            if (this.getRightSubTree() != null) {
                return this.right.indexOf(object, index + this.right.relativePosition);
            }
            return -1;
        }

        void toArray(Object[] array, int index) {
            array[index] = this.value;
            if (this.getLeftSubTree() != null) {
                this.left.toArray(array, index + this.left.relativePosition);
            }
            if (this.getRightSubTree() != null) {
                this.right.toArray(array, index + this.right.relativePosition);
            }
        }

        AVLNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        AVLNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        AVLNode insert(int index, Object obj) {
            int n2 = index - this.relativePosition;
            if (n2 <= 0) {
                return this.insertOnLeft(n2, obj);
            }
            return this.insertOnRight(n2, obj);
        }

        private AVLNode insertOnLeft(int indexRelativeToMe, Object obj) {
            if (this.getLeftSubTree() == null) {
                AVLNode aVLNode = this;
                this.setLeft(new AVLNode(-1, obj, aVLNode, aVLNode.left), null);
            } else {
                AVLNode aVLNode = this;
                aVLNode.setLeft(aVLNode.left.insert(indexRelativeToMe, obj), null);
            }
            if (this.relativePosition >= 0) {
                ++this.relativePosition;
            }
            AVLNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private AVLNode insertOnRight(int indexRelativeToMe, Object obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new AVLNode(1, obj, this.right, this), null);
            } else {
                AVLNode aVLNode = this;
                aVLNode.setRight(aVLNode.right.insert(indexRelativeToMe, obj), null);
            }
            if (this.relativePosition < 0) {
                --this.relativePosition;
            }
            AVLNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private AVLNode getLeftSubTree() {
            if (this.leftIsPrevious) {
                return null;
            }
            return this.left;
        }

        private AVLNode getRightSubTree() {
            if (this.rightIsNext) {
                return null;
            }
            return this.right;
        }

        private AVLNode max() {
            while (aVLNode.getRightSubTree() != null) {
                AVLNode aVLNode = aVLNode.right;
            }
            return aVLNode;
        }

        private AVLNode min() {
            while (aVLNode.getLeftSubTree() != null) {
                AVLNode aVLNode = aVLNode.left;
            }
            return aVLNode;
        }

        AVLNode remove(int index) {
            int n2 = index - this.relativePosition;
            if (n2 == 0) {
                return this.removeSelf();
            }
            if (n2 > 0) {
                AVLNode aVLNode = this;
                aVLNode.setRight(aVLNode.right.remove(n2), this.right.right);
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                AVLNode aVLNode = this;
                aVLNode.setLeft(aVLNode.left.remove(n2), this.left.left);
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            AVLNode aVLNode = this;
            aVLNode.setRight(aVLNode.right.removeMax(), this.right.right);
            if (this.relativePosition < 0) {
                ++this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode removeMin() {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            AVLNode aVLNode = this;
            aVLNode.setLeft(aVLNode.left.removeMin(), this.left.left);
            if (this.relativePosition > 0) {
                --this.relativePosition;
            }
            this.recalcHeight();
            return this.balance();
        }

        private AVLNode removeSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                if (this.relativePosition > 0) {
                    this.left.relativePosition = this.left.relativePosition + (this.relativePosition + (this.relativePosition > 0 ? 0 : 1));
                }
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                this.right.relativePosition = this.right.relativePosition + (this.relativePosition - (this.relativePosition < 0 ? 0 : 1));
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                AVLNode aVLNode = this.right.min();
                this.value = aVLNode.value;
                if (this.leftIsPrevious) {
                    this.left = aVLNode.left;
                }
                this.right = this.right.removeMin();
                if (this.relativePosition < 0) {
                    ++this.relativePosition;
                }
            } else {
                AVLNode aVLNode = this.left.max();
                this.value = aVLNode.value;
                if (this.rightIsNext) {
                    this.right = aVLNode.right;
                }
                AVLNode aVLNode2 = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = aVLNode2;
                    this.leftIsPrevious = true;
                }
                if (this.relativePosition > 0) {
                    --this.relativePosition;
                }
            }
            this.recalcHeight();
            return this;
        }

        private AVLNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        AVLNode aVLNode = this;
                        aVLNode.setLeft(aVLNode.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        AVLNode aVLNode = this;
                        aVLNode.setRight(aVLNode.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(AVLNode node) {
            if (node == null) {
                return 0;
            }
            return node.relativePosition;
        }

        private int setOffset(AVLNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int n2 = this.getOffset(node);
            node.relativePosition = newOffest;
            return n2;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(AVLNode node) {
            if (node == null) {
                return -1;
            }
            return node.height;
        }

        private int heightRightMinusLeft() {
            AVLNode aVLNode = this;
            AVLNode aVLNode2 = this;
            return aVLNode.getHeight(aVLNode.getRightSubTree()) - aVLNode2.getHeight(aVLNode2.getLeftSubTree());
        }

        private AVLNode rotateLeft() {
            AVLNode aVLNode = this.right;
            AVLNode aVLNode2 = this.getRightSubTree().getLeftSubTree();
            int n2 = this.relativePosition + this.getOffset(aVLNode);
            int n3 = -aVLNode.relativePosition;
            int n4 = this.getOffset(aVLNode) + this.getOffset(aVLNode2);
            this.setRight(aVLNode2, aVLNode);
            aVLNode.setLeft(this, null);
            this.setOffset(aVLNode, n2);
            AVLNode aVLNode3 = this;
            aVLNode3.setOffset(aVLNode3, n3);
            this.setOffset(aVLNode2, n4);
            return aVLNode;
        }

        private AVLNode rotateRight() {
            AVLNode aVLNode = this.left;
            AVLNode aVLNode2 = this.getLeftSubTree().getRightSubTree();
            int n2 = this.relativePosition + this.getOffset(aVLNode);
            int n3 = -aVLNode.relativePosition;
            int n4 = this.getOffset(aVLNode) + this.getOffset(aVLNode2);
            this.setLeft(aVLNode2, aVLNode);
            aVLNode.setRight(this, null);
            this.setOffset(aVLNode, n2);
            AVLNode aVLNode3 = this;
            aVLNode3.setOffset(aVLNode3, n3);
            this.setOffset(aVLNode2, n4);
            return aVLNode;
        }

        private void setLeft(AVLNode node, AVLNode previous) {
            this.leftIsPrevious = node == null;
            this.left = this.leftIsPrevious ? previous : node;
            this.recalcHeight();
        }

        private void setRight(AVLNode node, AVLNode next) {
            this.rightIsNext = node == null;
            this.right = this.rightIsNext ? next : node;
            this.recalcHeight();
        }

        public String toString() {
            return "AVLNode(" + this.relativePosition + "," + (this.left != null) + "," + this.value + "," + (this.getRightSubTree() != null) + ", faedelung " + this.rightIsNext + " )";
        }

        static int access$000(AVLNode x0) {
            return x0.relativePosition;
        }

        AVLNode(int x0, Object x1, AVLNode x2, AVLNode x3, 1 x4) {
            this(x0, x1, x2, x3);
        }

        static Object access$200(AVLNode x0) {
            return x0.value;
        }
    }
}

