/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;
import org.apache.commons.collections.map.AbstractHashedMap;

public abstract class AbstractReferenceMap
extends AbstractHashedMap {
    public static final int HARD = 0;
    public static final int SOFT = 1;
    public static final int WEAK = 2;
    protected int keyType;
    protected int valueType;
    protected boolean purgeValues;
    private transient ReferenceQueue queue;

    protected AbstractReferenceMap() {
    }

    protected AbstractReferenceMap(int keyType, int valueType, int capacity, float loadFactor, boolean purgeValues) {
        super(capacity, loadFactor);
        AbstractReferenceMap.verify("keyType", keyType);
        AbstractReferenceMap.verify("valueType", valueType);
        this.keyType = keyType;
        this.valueType = valueType;
        this.purgeValues = purgeValues;
    }

    protected void init() {
        this.queue = new ReferenceQueue();
    }

    private static void verify(String name, int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException(name + " must be HARD, SOFT, WEAK.");
        }
    }

    public int size() {
        this.purgeBeforeRead();
        return super.size();
    }

    public boolean isEmpty() {
        this.purgeBeforeRead();
        return super.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.purgeBeforeRead();
        AbstractHashedMap.HashEntry hashEntry = this.getEntry(key);
        if (hashEntry == null) {
            return false;
        }
        return hashEntry.getValue() != null;
    }

    public boolean containsValue(Object value) {
        this.purgeBeforeRead();
        if (value == null) {
            return false;
        }
        return super.containsValue(value);
    }

    public Object get(Object key) {
        this.purgeBeforeRead();
        AbstractHashedMap.HashEntry hashEntry = this.getEntry(key);
        if (hashEntry == null) {
            return null;
        }
        return hashEntry.getValue();
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("null keys not allowed");
        }
        if (value == null) {
            throw new NullPointerException("null values not allowed");
        }
        this.purgeBeforeWrite();
        return super.put(key, value);
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        this.purgeBeforeWrite();
        return super.remove(key);
    }

    public void clear() {
        super.clear();
        while (this.queue.poll() != null) {
        }
    }

    public MapIterator mapIterator() {
        return new ReferenceMapIterator(this);
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ReferenceEntrySet(this);
        }
        return this.entrySet;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new ReferenceKeySet(this);
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new ReferenceValues(this);
        }
        return this.values;
    }

    protected void purgeBeforeRead() {
        this.purge();
    }

    protected void purgeBeforeWrite() {
        this.purge();
    }

    protected void purge() {
        Reference reference = this.queue.poll();
        while (reference != null) {
            this.purge(reference);
            reference = this.queue.poll();
        }
    }

    protected void purge(Reference ref) {
        int n2 = ref.hashCode();
        int n3 = this.hashIndex(n2, this.data.length);
        AbstractHashedMap.HashEntry hashEntry = null;
        AbstractHashedMap.HashEntry hashEntry2 = this.data[n3];
        while (hashEntry2 != null) {
            if (((ReferenceEntry)hashEntry2).purge(ref)) {
                if (hashEntry == null) {
                    this.data[n3] = hashEntry2.next;
                } else {
                    hashEntry.next = hashEntry2.next;
                }
                --this.size;
                return;
            }
            hashEntry = hashEntry2;
            hashEntry2 = hashEntry2.next;
        }
    }

    protected AbstractHashedMap.HashEntry getEntry(Object key) {
        if (key == null) {
            return null;
        }
        return super.getEntry(key);
    }

    protected int hashEntry(Object key, Object value) {
        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
    }

    protected boolean isEqualKey(Object key1, Object key2) {
        Object object = key2 = this.keyType > 0 ? ((Reference)key2).get() : key2;
        return key1 == key2 || key1.equals(key2);
    }

    protected AbstractHashedMap.HashEntry createEntry(AbstractHashedMap.HashEntry next, int hashCode, Object key, Object value) {
        return new ReferenceEntry(this, next, hashCode, key, value);
    }

    protected Iterator createEntrySetIterator() {
        return new ReferenceEntrySetIterator(this);
    }

    protected Iterator createKeySetIterator() {
        return new ReferenceKeySetIterator(this);
    }

    protected Iterator createValuesIterator() {
        return new ReferenceValuesIterator(this);
    }

    protected void doWriteObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.keyType);
        out.writeInt(this.valueType);
        out.writeBoolean(this.purgeValues);
        out.writeFloat(this.loadFactor);
        out.writeInt(this.data.length);
        MapIterator mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            out.writeObject(mapIterator.next());
            out.writeObject(mapIterator.getValue());
        }
        out.writeObject(null);
    }

    protected void doReadObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object;
        this.keyType = in.readInt();
        this.valueType = in.readInt();
        this.purgeValues = in.readBoolean();
        this.loadFactor = in.readFloat();
        int n2 = in.readInt();
        this.init();
        this.data = new AbstractHashedMap.HashEntry[n2];
        while ((object = in.readObject()) != null) {
            Object object2 = in.readObject();
            this.put(object, object2);
        }
        this.threshold = this.calculateThreshold(this.data.length, this.loadFactor);
    }

    static ReferenceQueue access$000(AbstractReferenceMap x0) {
        return x0.queue;
    }

    static class WeakRef
    extends WeakReference {
        private int hash;

        public WeakRef(int hash, Object r2, ReferenceQueue q2) {
            super(r2, q2);
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class SoftRef
    extends SoftReference {
        private int hash;

        public SoftRef(int hash, Object r2, ReferenceQueue q2) {
            super(r2, q2);
            this.hash = hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    static class ReferenceMapIterator
    extends ReferenceEntrySetIterator
    implements MapIterator {
        protected ReferenceMapIterator(AbstractReferenceMap parent) {
            super(parent);
        }

        public Object next() {
            return this.nextEntry().getKey();
        }

        public Object getKey() {
            ReferenceEntry referenceEntry = this.currentEntry();
            if (referenceEntry == null) {
                throw new IllegalStateException("getKey() can only be called after next() and before remove()");
            }
            return ((AbstractHashedMap.HashEntry)referenceEntry).getKey();
        }

        public Object getValue() {
            ReferenceEntry referenceEntry = this.currentEntry();
            if (referenceEntry == null) {
                throw new IllegalStateException("getValue() can only be called after next() and before remove()");
            }
            return ((AbstractHashedMap.HashEntry)referenceEntry).getValue();
        }

        public Object setValue(Object value) {
            ReferenceEntry referenceEntry = this.currentEntry();
            if (referenceEntry == null) {
                throw new IllegalStateException("setValue() can only be called after next() and before remove()");
            }
            return ((AbstractHashedMap.HashEntry)referenceEntry).setValue(value);
        }
    }

    static class ReferenceValuesIterator
    extends ReferenceEntrySetIterator {
        ReferenceValuesIterator(AbstractReferenceMap parent) {
            super(parent);
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    static class ReferenceKeySetIterator
    extends ReferenceEntrySetIterator {
        ReferenceKeySetIterator(AbstractReferenceMap parent) {
            super(parent);
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    static class ReferenceEntrySetIterator
    implements Iterator {
        final AbstractReferenceMap parent;
        int index;
        ReferenceEntry entry;
        ReferenceEntry previous;
        Object nextKey;
        Object nextValue;
        Object currentKey;
        Object currentValue;
        int expectedModCount;

        public ReferenceEntrySetIterator(AbstractReferenceMap parent) {
            this.parent = parent;
            this.index = parent.size() != 0 ? parent.data.length : 0;
            this.expectedModCount = parent.modCount;
        }

        public boolean hasNext() {
            this.checkMod();
            while (this.nextNull()) {
                ReferenceEntry referenceEntry = this.entry;
                int n2 = this.index;
                while (referenceEntry == null && n2 > 0) {
                    referenceEntry = (ReferenceEntry)this.parent.data[--n2];
                }
                this.entry = referenceEntry;
                this.index = n2;
                if (referenceEntry == null) {
                    this.currentKey = null;
                    this.currentValue = null;
                    return false;
                }
                this.nextKey = referenceEntry.getKey();
                this.nextValue = referenceEntry.getValue();
                if (!this.nextNull()) continue;
                this.entry = this.entry.next();
            }
            return true;
        }

        private void checkMod() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private boolean nextNull() {
            return this.nextKey == null || this.nextValue == null;
        }

        protected ReferenceEntry nextEntry() {
            this.checkMod();
            if (this.nextNull() && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.previous = this.entry;
            this.entry = this.entry.next();
            this.currentKey = this.nextKey;
            this.currentValue = this.nextValue;
            this.nextKey = null;
            this.nextValue = null;
            return this.previous;
        }

        protected ReferenceEntry currentEntry() {
            this.checkMod();
            return this.previous;
        }

        public Object next() {
            return this.nextEntry();
        }

        public void remove() {
            this.checkMod();
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.parent.remove(this.currentKey);
            this.previous = null;
            this.currentKey = null;
            this.currentValue = null;
            this.expectedModCount = this.parent.modCount;
        }
    }

    protected static class ReferenceEntry
    extends AbstractHashedMap.HashEntry {
        protected final AbstractReferenceMap parent;

        public ReferenceEntry(AbstractReferenceMap parent, AbstractHashedMap.HashEntry next, int hashCode, Object key, Object value) {
            super(next, hashCode, null, null);
            this.parent = parent;
            this.key = this.toReference(parent.keyType, key, hashCode);
            this.value = this.toReference(parent.valueType, value, hashCode);
        }

        public Object getKey() {
            if (this.parent.keyType > 0) {
                return ((Reference)this.key).get();
            }
            return this.key;
        }

        public Object getValue() {
            if (this.parent.valueType > 0) {
                return ((Reference)this.value).get();
            }
            return this.value;
        }

        public Object setValue(Object obj) {
            Object object = this.getValue();
            if (this.parent.valueType > 0) {
                ((Reference)this.value).clear();
            }
            this.value = this.toReference(this.parent.valueType, obj, this.hashCode);
            return object;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object k2 = entry.getKey();
            Object v2 = entry.getValue();
            if (k2 == null || v2 == null) {
                return false;
            }
            return this.parent.isEqualKey(k2, this.key) && this.parent.isEqualValue(v2, this.getValue());
        }

        public int hashCode() {
            return this.parent.hashEntry(this.getKey(), this.getValue());
        }

        protected Object toReference(int type, Object referent, int hash) {
            switch (type) {
                case 0: {
                    return referent;
                }
                case 1: {
                    return new SoftRef(hash, referent, AbstractReferenceMap.access$000(this.parent));
                }
                case 2: {
                    return new WeakRef(hash, referent, AbstractReferenceMap.access$000(this.parent));
                }
            }
            throw new Error();
        }

        boolean purge(Reference ref) {
            boolean bl = this.parent.keyType > 0 && this.key == ref;
            if (bl = bl || this.parent.valueType > 0 && this.value == ref) {
                if (this.parent.keyType > 0) {
                    ((Reference)this.key).clear();
                }
                if (this.parent.valueType > 0) {
                    ((Reference)this.value).clear();
                } else if (this.parent.purgeValues) {
                    this.value = null;
                }
            }
            return bl;
        }

        protected ReferenceEntry next() {
            return (ReferenceEntry)this.next;
        }
    }

    static class ReferenceValues
    extends AbstractHashedMap.Values {
        protected ReferenceValues(AbstractHashedMap parent) {
            super(parent);
        }

        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        public Object[] toArray(Object[] arr) {
            ArrayList arrayList = new ArrayList(this.parent.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(arr);
        }
    }

    static class ReferenceKeySet
    extends AbstractHashedMap.KeySet {
        protected ReferenceKeySet(AbstractHashedMap parent) {
            super(parent);
        }

        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        public Object[] toArray(Object[] arr) {
            ArrayList arrayList = new ArrayList(this.parent.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(arr);
        }
    }

    static class ReferenceEntrySet
    extends AbstractHashedMap.EntrySet {
        protected ReferenceEntrySet(AbstractHashedMap parent) {
            super(parent);
        }

        public Object[] toArray() {
            return this.toArray(new Object[0]);
        }

        public Object[] toArray(Object[] arr) {
            ArrayList<DefaultMapEntry> arrayList = new ArrayList<DefaultMapEntry>();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                arrayList.add(new DefaultMapEntry(entry.getKey(), entry.getValue()));
            }
            return arrayList.toArray(arr);
        }
    }
}

